// ==UserScript==
// @name         緑っぽい画像一覧拡張
// @namespace    http://tampermonkey.net/
// @version      0.19
// @description
// @match        https://*.2chan.net/b/res/*.htm
// @match        https://*.ftbucket.info/*/index.htm
// @match        https://futabaforest.net/b/res/*.htm
// @match        https://tsumanne.net/si/data/*/*/*/*/
// @match        https://kako.futakuro.com/futa/img_b/*/
// @require      https://cdn.jsdelivr.net/npm/@fancyapps/ui@5/dist/fancybox/fancybox.umd.min.js
// @resource    fancyboxCSS https://cdn.jsdelivr.net/npm/@fancyapps/ui@5/dist/fancybox/fancybox.min.css
// @grant        GM_getResourceText
// ==/UserScript==

/*

画像クリックしたら出る奴の説明
 上部ツールバー：画像数　　拡大 縮小 縦横合わせ 右回転 左右反転 フルスク 閉じる
 ※↑のボタンは画像にだけ有効、スレ内ファイルが動画1つだけだとは閉じる以外のボタンは出ない
 閉じるボタン以外だと背景クリックか画像を上下ドラッグでも閉じる
 大きい画像はクリックで全体⇔原寸表示
 小さい画像に横/縦に合わせるはマウス動かしたら戻る
 マウスホイールでスライド送り
 画像を別タブで開きたい時は右クリから別タブで開くかリンク元画像をホイールクリック
 無操作だとツールバーとマウスカーソルが消える

*/

if (!/^404\s(File\s)?Not\sFound$/.test(document.title)) {
    (function() {
        /*
        　設定
        */
        //動画の音量（1が最大）
        const VIDEO_VOLUME = 0.1;
        //動画をループさせる
        const VIDEO_LOOP = true;
        //アイドル状態になったらマウスカーソルを消すか
        const HIDE_CURSOL = true;
        //スライドを閉じたら表示してた画像のレスに飛ぶかどうか
        const JUMP_TO_RES = true;
        //↑が有効な場合に一覧を出してたら表示してた画像を何行目にして戻るか
        const RETURN_ROW = 1;
        //一覧でだけfancyboxを使う
        const LIST_USE_FANCYBOX = false;
        /*
        　設定ここまで
        */

        //////////////////////

        addCSS();
        fancyboxSetup();

        //////////////////////


        function addCSS() {
            //css埋め込み
            const styleEl = document.createElement("style");
            styleEl.textContent = GM_getResourceText("fancyboxCSS");
            document.body.after(styleEl);

            const styleEl2 = document.createElement("style");
            styleEl2.textContent = `
/*　スライド　*/
.fancybox__container {
    z-index: 2100000000;
}
.fancybox__caption {
    max-width:800px;
}
/* スライドのキャプション中あぷ文字色 */
.fancybox__caption > .upgaG {
    color : #888;
}
/* スライドのキャプション中リンクの文字色 */
.fancybox__caption a:link {
    color : #0077ff;
}
.fancybox__caption a:visited {
    color : #0077ff;
}
.fancybox__caption a:hover {
    color : #ffaa00;
}
/* ボタンを横に並べる */
.fancybox__toolbar__column.is-right {
    display: flex;
    flex-direction: column-reverse;
    align-content: flex-end;
    flex-wrap: wrap;
    /* ↓1列に並べるボタン数 x 46px */
    height: 184px;
}`;
            styleEl.after(styleEl2);
        }

        //fancyboxの設定
        function fancyboxSetup(){
            //携帯端末か
            const mobile = /Mobile/i.test(navigator.userAgent) ? true : false;
            //ブラウザバックを使ったか
            let bBack = false;

            //イベント登録用
            const backToThread = () => {
                bBack = true;
                Fancybox.close();
            };

            //一覧巻き込まない用
            const divEl = document.createElement("div");
            divEl.id = "closing";
            divEl.classList.add("content");
            divEl.style.opacity = 0;

            //オプション
            let options = {
                l10n: {
                    ZOOMIN:"ちょい拡大",
                    ZOOMOUT:"ちょい縮小",
                    ROTATECCW:"反時計回りに回転",
                    ROTATECW:"時計回りに回転",
                    FLIPX:"左右反転",
                    FLIPY:"上下反転",
                    CLOSE:"閉じる",
                    NEXT:"次",
                    PREV:"前",
                    ERROR:"エラー",
                    IMAGE_ERROR:"画像がないってさ",
                    DOWNLOAD:"ダウンロード",
                    FITX: "横に合わせる",
                    FITY: "縦に合わせる",
                    TOGGLE_FULLSCREEN:"フルスクリーン切替",
                },
                //hideScrollbar: false,
                idle: 1000,
                placeFocusBack: JUMP_TO_RES,
                wheel: "slide",
                caption: (fancybox, slide) => { //キャプション
                    //背景暗いから引用レスのコントラストを上げる
                    let resRepl = slide.res?.replace(/#789922/g, "#8bb127") ?? "";
                    if(slide.res) {
                        //今表示してるあぷファイルをキャプションで色分け
                        if(/fu?\d{6,}\.[a-z4]{3,4}/.test(slide.src) && /fu?\d{6,}\.[a-z4]{3,4}/.test(slide.res) ) { //あぷファイルか
                            //表示してるファイル名
                            const fileName = slide.src.match(/fu?\d{6,}\.[a-z4]{3,4}/)[0];
                            //置換前のレス
                            const nowCaption = slide.res;
                            //置換
                            resRepl = resRepl
                            //表示してるファイルを強調
                                .replace("<font color=#ff3300>" + fileName + "\(これ\)</font>","<font color=#ffaa00>" + fileName + "</font>")
                            //リンク色がスライドだと暗いので明るく
                                .replace("<font color=#0000ee>" + fileName + "</font>","<font color=#ffaa00>" + fileName + "</font>")
                            //単発で表示してるファイル
                                .replace("<font class=upgaS>" + fileName + "</font>","<font color=#ffaa00>" + fileName + "</font>");

                            //本文か画像付きレス内のあぷファイル名を単発スライドのリンクにする
                            if (location.hostname.includes("ftbucket")) { //バケツはバケツのファイルにリンク
                                resRepl = resRepl.replace(/<font\sclass=upgaS>(fu?\d{6,}\.[a-z4]{3,4})<\/font>/g,"<a data-list href=" + location.href.match(/^.+(?=index.htm)/)[0] + "other/$1 target=_blank data-res='" + nowCaption + "'>$1</a>");
                            } else if (location.hostname.includes("tsumanne")) { //「」ッチーは「」ッチーのファイルにリンク
                                resRepl = resRepl.replace(/<font\sclass=upgaS>(fu\d{6,}\.[a-z4]{3,4})<\/font>/g,"<a data-list href=" + location.href + "$1 target=_blank data-res='" + nowCaption + "'>$1</a>")
                                //f○○○○ならあぷにリンク
                                    .replace(/<font\sclass=upgaS>(f\d{6,}\.[a-z4]{3,4})<\/font>/g,"<a data-list href=https://dec.2chan.net/up/src/$1 target=_blank data-res='" + nowCaption + "'>$1</a>");
                            } else {
                                resRepl = resRepl.replace(/<font\sclass=upgaS>(fu?\d{6,}\.[a-z4]{3,4})<\/font>/g,"<a data-list href=https://dec.2chan.net/up2/src/$1 target=_blank data-res='" + nowCaption + "'>$1</a>")
                                    .replace(/up2(?=\/src\/f\d)/g,"up"); //↑でf○○○○ならURLを修正
                            }
                        }
                    }
                    return resRepl //置換したのを返す
                },
                Carousel: {
                    infinite: false, //最後の画像→先頭の画像にループしない
                },
                closeExisting: true,
                groupAttr: "data-list",
                Html: {
                    //動画のテンプレ
                    //ループするかは設定で、コントロールパネルあり、事前読込みしない
                    videoTpl: `<video class="fancybox__html5video" ${VIDEO_LOOP ? "loop" : ""} playsinline controls preload="none"><source src="{{src}}" type="{{format}}" />ブラウザが対応してないってさ</video>`,
                },
                Images: {
                    zoom: false,
                    Panzoom: {
                        panMode: "mousemove",
                        mouseMoveFactor: 2.0, //拡大した時にマウスをウインドウ内で中心からどれだけ動かしたら画像端が表示されるか(2.0で半分？)
                        mouseMoveFriction: 0.1, //マウスを動かした時にどれだけ機敏に動くか
                    }
                },
                Thumbs: false,
                Toolbar: {
                    enabled: true,
                    items: {
                        blank: { //位置調整用の空欄
                            tpl: '<div style="height:46px;"></div>',
                        },
                    },
                    display: {
                        left: [
                            "infobar",
                        ],
                        middle: [
                        ],
                        right: [
                            //上のCSSで左下→右上にボタンが並ぶ
                            // "blank",
                            "zoomIn",
                            "fitX",
                            "rotateCW",
                            "fullscreen",
                            "zoomOut",
                            "fitY",
                            "flipX",
                            "close",
                        ],
                    },
                },
                on: {
                    init: (fancybox) => { //初期化中に何かする時用
                        //赤福の操作パネルを隠す
                        if(document.querySelector(".futaba_lightbox_image_list_container") &&
                           document.querySelector("#akahuku_thread_operator")) {
                            document.querySelector("#akahuku_thread_operator").style.display = "none";
                        }
                        //ふたクロのレスポップアップを消す
                        if(document.querySelector("#respopup_area > div")) document.querySelector("#respopup_area").innerHTML = "";

                        //スクロールバーが出てたら小さい一覧をずらす
                        if(document.documentElement.scrollHeight > window.innerHeight) {
                            //スクロールバー幅
                            const scrollbar = window.innerWidth - document.documentElement.clientWidth;
                            //小さい一覧を開いてたら
                            if(!/Mobile/i.test(navigator.userAgent) && document.querySelector(".futaba_lightbox_image_list_overlay.small")) {
                                document.querySelector(".futaba_lightbox_image_list_overlay.small").style.marginRight = scrollbar + "px";
                            }
                        }
                        if(mobile) { //携帯端末か
                            //戻る履歴に空を追加
                            history.pushState(null, null);
                            //履歴操作にイベント登録
                            window.addEventListener("popstate", backToThread);
                        }
                    },
                    loading: (fancybox,slide) => { //スライドの読込中に何かする時用
                    },
                    loaded: (fancybox,slide) => { //スライドの読込後に何かする時用
                    },
                    reveal: (fancybox,slide) => { //スライドの表示準備が出来たら何かする時用
                        //動画はこのタイミングから
                        if (slide.type == "html5video") {
                            //動画の音量調節
                            for (const video of document.querySelectorAll("video.fancybox__html5video")) {
                                video.volume = VIDEO_VOLUME;
                            }
                        }
                    },
                    done: (fancybox, slide) => { //スライドの表示後に何かする時用
                    },
                    setIdle: (fancybox, slide) => { //アイドル状態になったら何かする時用
                        //マウスカーソルを消すか
                        if(HIDE_CURSOL) {
                            //各位置でマウスカーソル消す
                            document.querySelector(".is-selected").style.cursor = "none";
                            if(document.querySelector(".is-selected img, .is-selected video")) document.querySelector(".is-selected img, .is-selected video").style.cursor = "none";
                            if(document.querySelector(".is-selected .fancybox__caption")) document.querySelector(".is-selected .fancybox__caption").style.cursor = "none";
                            //各ボタン
                            for(const el of document.querySelectorAll(".f-button")) {
                                //マウスカーソル消す
                                el.style.cursor = "none";
                            }
                        }
                    },
                    endIdle: (fancybox, slide) => { //アイドル状態が終わったら何かする時用
                        //マウスカーソルを消すか
                        if(HIDE_CURSOL) {
                            //各位置でマウスカーソル戻す
                            document.querySelector(".is-selected").style.cursor = "";
                            if(document.querySelector(".is-selected img, .is-selected video")) document.querySelector(".is-selected img, .is-selected video").style.cursor = "";
                            if(document.querySelector(".is-selected .fancybox__caption")) document.querySelector(".is-selected .fancybox__caption").style.cursor = "";
                            //各ボタン
                            for(const el of document.querySelectorAll(".f-button")) {
                                //マウスカーソル戻す
                                el.style.cursor = "";
                            }
                        }
                    },
                    close: (fancybox, PointerEvent) => { //スライドを閉じる時に何かする時用
                        if(mobile) { //携帯端末か
                            //履歴操作のイベント削除
                            window.removeEventListener("popstate", backToThread);
                            //ブラウザバック以外で閉じたら戻る履歴が溜まらないよう「戻る」をする(進む履歴が残る)
                            if(!bBack) {
                                document.body.append(divEl);
                                history.back();
                                setTimeout(() => {
                                    document.querySelector("#closing").remove();
                                }, 50);
                            }
                            else bBack = false;
                        }

                        //見てたスライド
                        const slide = fancybox.getSlide();
                        // console.log(slide);

                        //スライドを閉じたら表示してた画像のレスに飛ぶ設定で一覧を開いてる時に拡大画像から戻った時の位置調整
                        if(document.querySelector(".futaba_lightbox_image_list_container") && JUMP_TO_RES && slide.list == "ichiran") {
                            //スクロールイベントで行数計算する為に頭に飛ばす
                            document.querySelector(".futaba_lightbox_image_list_container").scrollTop = 0;
                            //スクロール位置(画像の一覧での行数-戻る行の設定x一枠の高さ)
                            const tabunLine = document.querySelector(".futaba_lightbox_image_list_container > a").clientHeight *
                                  (Math.trunc(slide.i / document.querySelector(".futaba_lightbox_image_list_container").dataset.kosuu) - (RETURN_ROW - 1))
                            //飛ぶ
                            document.querySelector(".futaba_lightbox_image_list_container").scrollTop = tabunLine;
                            //飛んだ後に行数計算が別のとこでされてるはず
                        }
                        //すぐ画像消す
                        setTimeout(()=>{
                            if(document.querySelector(".fancybox__content")) document.querySelector(".fancybox__content").remove();
                            document.body.classList.remove("hide-scrollbar");
                            //小さい一覧を開いてたらずらしたのを戻す
                            if(!/Mobile/i.test(navigator.userAgent) && document.querySelector(".futaba_lightbox_image_list_overlay.small")) {
                                document.querySelector(".futaba_lightbox_image_list_overlay.small").style.marginRight = "";
                            }
                        },100);
                    },
                    destroy: (fancybox) => { //スライドを閉じた後に何かする時用
                        //赤福の操作パネルを戻す
                        if(document.querySelector(".futaba_lightbox_image_list_container") &&
                           document.querySelector("#akahuku_thread_operator")) {
                            document.querySelector("#akahuku_thread_operator").style.display = "block";
                        }
                    },
                },
            }

            if(LIST_USE_FANCYBOX) { //一覧でだけFancyboxを使うか
                //一覧の画像だけグループ
                Fancybox.bind('[data-list="ichiran"]:not([id^="akahuku"])', options);
            } else {
                //単品、キャプションのあぷファイル
                Fancybox.bind('[data-list]', options);
                //赤福固定サムネ
                Fancybox.bind('[id^="akahuku"][data-list]', options);
                //赤福の固定サムネ以外の画像をグループにする
                //スレと一覧は分ける
                Fancybox.bind('[data-list="thread"]:not([id^="akahuku"])', options);
                Fancybox.bind('[data-list="ichiran"]:not([id^="akahuku"])', options);
                //削除された
                Fancybox.bind('[data-list="kieta"]:not([id^="akahuku"])', options);
            }
        }

        //動画をクリックするとその場で開くのを止めたい
        if (location.hostname.includes("2chan.net") || location.hostname.includes("kako.futakuro.com")) {
            const stopPropagation = (event) => {
                if (event.target.closest("a") && /webm|mp4/.test(event.target.parentNode.href)) {
                    event.stopPropagation();
                }
            };
            document.body.addEventListener("click", stopPropagation);
            document.body.addEventListener("touchstart", stopPropagation);
            document.body.addEventListener("pointerdown", stopPropagation);
        }
    })();
}