// ==UserScript==
// @name         緑っぽい画像一覧
// @namespace    http://tampermonkey.net/
// @version      0.200
// @description  スレに「としあき(仮) 出張版」っぽい画像一覧ボタンを追加する
// @author
// @match        https://*.2chan.net/b/res/*.htm
// @match        https://*.ftbucket.info/*/index.htm
// @match        https://futabaforest.net/b/res/*.htm
// @match        https://tsumanne.net/si/data/*/*/*/*/
// @match        https://kako.futakuro.com/futa/img_b/*/
// @grant        GM_download
// ==/UserScript==

/*
改変元
futaba lightbox
copyright (c) 2015 himuro-majika
Released under the MIT license
https://spdx.org/licenses/MIT.html
https://greasyfork.org/ja/scripts/435787-futaba-lightbox
*/

if(!/^404\s(File\s)?Not\sFound$/.test(document.title)) {
    (function() {
        /*
        　一覧ボタンの設定
        */

        //ふたばでの画像一覧ボタンの位置(ふたクロに被った時や好みで変える)
        //縦の位置、上から○○ピクセル
        const ichiranPosY = -1;
        //横の位置、左から○○ピクセル
        const ichiranPosX = 200;

        //ふたクロがスマホモード時の画像一覧ボタンの位置
        //縦の位置、上から○○ピクセル(メニューバーと被るので30以上で)
        const mobilePosY = 95;
        //横の位置、右から○○ピクセル
        const mobilePosX = 0;

        //一覧ボタンクリックでどちらを開くか(選ばなかった方は右クリで開く)
        //0(大きいの)　1(小さいの)
        const LIST_SIZE = 0;

        //一覧ボタンに画像数を表示する
        const SHOW_IMAGE_COUNT = true;

        //一覧を見てる位置から開くいまココボタンを追加する(スクロールできる数になったら表示される)
        const SHOW_KOKOBTN = true;

        /*
        　一覧の設定
        */

        //一覧で一行に並べる画像の数
        const IMAGE_NUM = 5;

        //小さい一覧で一行に並べる画像の数
        const IMAGE_NUM_S = 3;

        //小さい一覧の割合(%)
        const SMALL_LIST_SCALE = 40;

        //一覧の空白部分をクリックしたら一覧を閉じる
        const CLOSE_LIST_CLICK = true;

        //一覧に保存ボタンを表示する
        const USE_DLBTN = false;

        //一覧にレスに飛ぶボタンを表示する
        const USE_JUMPBTN = true;

        //一覧に除外ボタンを表示する
        const USE_EXCLBTN = true;

        //一覧にレスを表示する
        const ADD_RES_LIST = true;

        //一覧でレスをポップアップする
        const POP_UP_RES = true;

        //一覧に隔離レスの画像を表示しない(レスとあぷファイル)
        const HIDE_ISOLATION_RES = true;

        //一覧に削除レスの画像を表示しない(あぷファイル)
        const HIDE_DELETED_RES = true;

        //非IDスレでIDが付いたレスの画像を加工する
        const DECORATE_ID_RES = true;

        //他の拡張やスクリプトでの変化を監視する(ふたクロの削除反映とNG機能等)
        const OBSERVE_OTHER_CHANGES = true;

        //一覧開いてたら同期で削除された画像にマークを付ける
        const MARK_HIDE_IMAGE = true;

        //一覧をマウスホイールで区切り良くスクロールする
        const USE_WHEEL_LIST = true;

        //一覧にスレ落ちと1000レス到達を表示する
        const SHOW_THREAD_DOWN = true;

        //ふたクロでNG判定されたレスの画像をNG機能をオフにしても表示しない
        const NG_ALWAYS_HIDDEN = false;

        /*
        　あぷファイルの設定
        */

        //一覧にあぷファイルもまとめる(画像の後に追加)
        const ADD_UPFILE_LIST = true;

        //↑の画像とあぷファイルをレス順にソート
        const SORT_UPFILE_LIST = true;

        //あぷファイルの代用アイコンをリンク先の画像に差し替える
        const LOAD_UPFILE_LIST = true;

        //縦横最大このサイズ相当のサムネにする(大きくすると綺麗になるけどメモリ増)
        const THUMBNAIL_SIZE_EQ= 200;

        //動画も差し替える
        //動画の一部だけ受け取る仕組みを使うけどFirefoxや動画の作りによっては丸々受け取るので転送量に注意
        //環境や動画によっては間に合わず失敗する
        const LOAD_UPFILE_VIDEO = true;

        //動画の0秒を読込んでサムネ化するまで待つ時間(ミリ秒)
        //サムネ化で空欄が多かったら数値を300→600→1000と上げて試す
        const WAIT_THUMBNAIL_MAKE = 300;

        //差し替えて描写したサムネを一時的に覚えておく
        //一覧ボタンを中クリで忘れる
        //動画に付くマークがサムネ再描写のボタンになる
        const REM_THUMB_TEMP = true;

        //読込みの応答を待つ時間(ミリ秒)
        //この時間エラーにもならずに無反応なら読込みを飛ばす
        const LOAD_WAIT_TIME = 10000;

        //差し替えた動画にマークを付ける
        const MARK_VIDEO_UPFILE = true;

        //差し替えたgifにマークを付ける
        const MARK_GIF_UPFILE = true;

        //1レス内のあぷファイル数がこの数以上なら羅列荒らし判定
        const UP_IGNORE_NUM = 15;

        //差し替えに失敗したあぷファイルを次に一覧を開いた時に追加しない
        //失敗記録はスレッド毎、リロードか一覧ボタンを中クリでリセット
        const OMIT_ERROR_UPFILE = true;

        /*
        　その他の設定
        */

        //(ダウンロードフォルダ内の)保存フォルダ
        //サブフォルダに保存する場合は\\で繋げる（例 "kokoni\\hozon"）
        //※ 泥スマホだとファイル名の頭に足される(iOS未確認)
        let folder = "";

        //↑ファイル名に板名を付ける
        const ADD_BOARD_NAME = true;

        /*
        　設定ここまで
        */


        //画像一覧の一枠の高さ
        let aHeight;
        //小さい一覧の一枠の高さ
        let aHeightS;
        //画像一覧の現スクロール行
        let scrollLine;
        //画像一覧が開かれてるか
        let openList = false;
        //小さい一覧が開かれるか
        let smallList = LIST_SIZE ? true : false;
        //いまココボタンの画像必要数
        let needImg;
        //ページの高さ保存用
        let bodyHeight;
        //ふたクロ使用中か
        let useFutakuro;
        //属性付けたあぷファイル名があるレス
        let upInBq;
        //タグを一度でも追加したか
        let addedTag = false;
        //IDスレか
        let idThread = /id表示/i.test(document.querySelector(".cnm, .cnw, .c9-3")?.innerHTML) ?? false;
        //スレ落ちたか
        let threadDown = false;
        //1000レス行ったか
        let res1000 = [...document.querySelectorAll("td.rts")].filter(el => !el.closest("#respopup_area")).length >= 1000 ? true : false;
        //携帯端末か
        const mobile = /Mobile/i.test(navigator.userAgent) ? true : false;
        //一覧(大)の高さ割合(%)
        const listHeight = mobile ? 80 : 85;
        //ふたクロのスマホモードの変化確認用
        let widthCheck = window.innerWidth;
        //スクロールバー幅
        let scrollbar;
        //細いスクロールバー幅
        let thinSb;
        //ページの拡大率
        let zoom = window.devicePixelRatio;
        //エラーだったあぷファイル
        let upErrFiles = new Set();
        //無応答だったあぷファイル
        let upWaitedFiles = new Set();
        //あぷファイルの差し替え中か
        let upReplacing = false;
        //手動で除外したファイル
        let exclFiles = new Set();
        //手動で除外したあぷファイル
        let exclUpFiles = new Set();
        //一覧出してブラウザバックを使ったか
        let bBack = false;


        //ふたクロの邪魔しないようずらして動かす(ログサイトではすぐ動かす)
        location.hostname.includes("2chan.net") ? setTimeout(start, 3000) : start();


        function start() {
            setScrollbarSize();
            addAttrReady();
            addCSS();
            yattaka();
        }

        //ブラウザで違うスクロールバー幅を取得
        function setScrollbarSize() {
            const divEl = document.createElement("div");
            divEl.style.overflow = "scroll";
            divEl.style.width = "100px";
            divEl.style.height = "100px";
            divEl.style.position = "absolute";
            divEl.style.visibility = "hidden";

            document.body.append(divEl);

            //スクロールバー幅
            scrollbar = divEl.offsetWidth - divEl.clientWidth;
            //うまく取得出来なかったら余裕持った値を入れておく
            if(!mobile && scrollbar <= 0) scrollbar = 20;
            // console.log("スクロールバー幅：", scrollbar);

            //スクロールバーを細くする
            divEl.style.scrollbarWidth = "thin";
            //細いスクロールバー幅
            thinSb = divEl.offsetWidth - divEl.clientWidth;
            //うまく取得出来なかったら余裕持った値を入れておく
            if(!mobile && thinSb <= 0) thinSb = 15;
            //CSS変数を更新
            document.documentElement.style.setProperty("--thinSb", `${thinSb}px`);
            // console.log("細いスクロールバー幅：", thinSb);

            document.body.removeChild(divEl);
        }

        // 初めてスレ内の画像レスにデータ属性を付加する
        function addAttrReady() {
            // 赤福が有効だったら固定サムネの属性変える
            setTimeout(() => {
                //固定サムネを一覧に含まないようにデータ属性変更
                if(document.querySelector("#akahuku_thumbnail") && document.querySelector("#akahuku_throp_thumbnail_button")) {
                    document.querySelector("#akahuku_throp_thumbnail_button").setAttribute("data-list", "");
                }
            }, 5000);

            if(ADD_UPFILE_LIST) addAttrResBq();
            addAttrFirst();
            if(location.hostname.includes("2chan.net")) observeInserted(); //ふたばでだけ続きを読むで挿入される要素を監視

            //画像付きレスに属性付け
            function addAttrFirst() {
                const imgA = Array.from(document.querySelectorAll(".thre a > img, #res_body a > img"), el => el.parentElement).filter(el => !el.closest("#respopup_area, .akahuku_preview_container, td.qt, .previewArea, blockquote"));
                if(imgA.length) addAttr(imgA);
            }

            //あぷファイル込みのレスにタグ追加
            function addAttrResBq() {
                const resBq = [...document.querySelectorAll(".thre blockquote, #res_body blockquote")].filter(el => !el.closest("#respopup_area, td.qt, .previewArea"));
                addAttrUp(resBq);
            }

            // 続きを読むで挿入される要素を監視
            function observeInserted() {
                //見守る
                let wait1000res;
                const observer = new MutationObserver((mutations) => {
                    // console.log(mutations);
                    for(const mutation of mutations) {
                        // console.log(mutation);
                        for(const node of mutation.addedNodes) {
                            //追加･削除されたのは要素か
                            if(node.nodeType === 1) {
                                //画像付きレス
                                if(node.querySelector("td > a > img")) {
                                    const aImg = Array.from(node.querySelectorAll("td > a > img"), el => el.parentElement).filter(el => !el.closest("#respopup_area, .akahuku_preview_container, div.qtd"));
                                    //属性を付ける
                                    // console.log("レス監視から");
                                    if(aImg.length) addAttr(aImg, "監視");
                                }
                                //あぷを一覧に含める設定か
                                if(ADD_UPFILE_LIST && node.querySelector("blockquote")) {
                                    // console.log(node.querySelectorAll("blockquote"));
                                    //引用されてないあぷファイル名があるか
                                    const bq = [...node.querySelectorAll("blockquote")].filter(el => /(?<!>(.(?!\\n))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.innerText));
                                    // console.log("あぷ監視から");
                                    if(bq.length) addAttrUp(bq, "監視");
                                }
                            }
                        }
                    }
                    //重複回避
                    clearTimeout(wait1000res);
                    wait1000res = setTimeout(() => {
                        //1000レス行ったか確認
                        if([...document.querySelectorAll("td.rts")].filter(el => !el.closest("#respopup_area")).length >= 1000) {
                            console.info("1000レス行った(レス監視)");
                            //1000レス行った
                            res1000 = true;
                            //一覧開いてたら表示
                            if(SHOW_THREAD_DOWN && openList) showThreadDown();
                            //監視おわり
                            observer.disconnect();
                            futakuroObserver.disconnect();
                            futakuroRespopObserver.disconnect();
                            akahukuObserver.disconnect();
                        }
                    }, 1000);

                    //スクロールバーの状態チェック
                    if(openList && !smallList) sbCheck();
                });

                //他の拡張やスクリプトでの変化を監視
                let changeCheck;
                const otherChangesObserver = new MutationObserver((mutations) => {
                    for(const mutation of mutations) {
                        if(mutation.type == "childList") {
                            for(const node of mutation.addedNodes) {
                                //追加･削除されたのは要素か
                                if(node.nodeType === 1) {
                                    //ふたクロのレス削除同期用
                                    if(node.closest("table") && node.querySelector("blockquote") && /"#ff0000">(削除依頼|書き込み|スレッド)/i.test(node.querySelector("blockquote").innerHTML)) {
                                        // console.log([node]);
                                        setTimeout(() => {
                                            node.closest("table").classList.add("deleted");
                                        }, 100);
                                    }
                                }
                            }
                        }

                        //クラスの変化
                        if(mutation.type == "attributes" && mutation.attributeName == "class") {
                            //削除隔離レス
                            if(mutation.target.classList.contains("deleted")) {
                                if((HIDE_ISOLATION_RES || HIDE_DELETED_RES) && MARK_HIDE_IMAGE && mutation.target.querySelector("blockquote") && openList) {
                                    //一覧の画像にマーク付け
                                    deletedImageListView(mutation.target);
                                }

                                // console.log("削除されたレス", mutation.target.querySelector(".cno").textContent);
                                //一覧に隔離レスを表示しない設定かつ消されても画像があったら隔離レス
                                if(HIDE_ISOLATION_RES && mutation.target.querySelector("td > a > img")) {
                                    const imgA = [mutation.target.querySelector("td > a > img").parentElement].filter(el => !el.closest("#respopup_area"));
                                    if(imgA.length) {
                                        //属性削除
                                        removeAttr(imgA);
                                    }
                                }
                                //一覧に隔離レスを表示しない設定かつあぷファイル込みのレスか
                                if(ADD_UPFILE_LIST && (HIDE_ISOLATION_RES || HIDE_DELETED_RES) && mutation.target.querySelector("td > blockquote")) {
                                    const bq = [mutation.target.querySelector("blockquote")].filter(el => /(?<!>(.(?!\\n))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.innerText));
                                    if(bq.length) {
                                        //属性削除
                                        removeAttr(bq);
                                    }
                                }
                            }

                            //NGオンオフ
                            //レス番
                            const resNo = mutation.target.querySelector(".cno")?.textContent;
                            if(resNo) {
                                //NG判定ではなくレスに属性があったら削除
                                if(!mutation.target.classList.contains("ng_hidden") && mutation.target.querySelector("[data-ng]")) mutation.target.querySelector("[data-ng]").removeAttribute("data-ng");

                                if(openList) { //一覧開いてたら
                                    //一覧にある同じレス番のaタグ
                                    for(const el of document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-no="${resNo}"]`)) {
                                        //NG判定されて一覧の方にクラスがなかったらクラス追加
                                        if(mutation.target.classList.contains("ng_hidden") && !el.classList.contains("ng_hidden")) el.classList.add("ng_hidden");
                                        //NG判定ではなく一覧の方にクラスがあったらクラス削除
                                        if(!mutation.target.classList.contains("ng_hidden") && el.classList.contains("ng_hidden")) el.classList.remove("ng_hidden");
                                    }
                                }
                            }
                            //重複回避
                            clearTimeout(changeCheck);
                            changeCheck = setTimeout(() => {
                                //NG解除した時用
                                addedAttrCheck();
                                //一覧ボタンに反映
                                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                                if(SHOW_KOKOBTN) ichiranCheckPoint();
                            }, 1000);
                        }
                    }
                });

                //ふたクロの情報監視
                const obsFutakuro = (mutations) => {
                    for(const mutation of mutations) {
                        for(const node of mutation.addedNodes) {
                            if(node?.id === "thread_down" && node?.textContent.includes("スレッドが落ちました")) {
                                console.info("スレ落ちた");
                                //スレ落ち
                                threadDown = true;
                                //一覧開いてたら表示
                                if(SHOW_THREAD_DOWN && openList) showThreadDown();
                                //監視止める
                                observer.disconnect();
                                futakuroObserver.disconnect();
                                futakuroRespopObserver.disconnect();
                            }
                            //下部バー
                            if(node?.parentNode.id === "fvw_mes" && node?.textContent.includes("スレッドが落ちました") ) {
                                console.info("スレ落ちた");
                                //スレ落ち
                                threadDown = true;
                                //一覧開いてたら表示
                                if(SHOW_THREAD_DOWN && openList) showThreadDown();
                                //監視止める
                                observer.disconnect();
                                futakuroObserver.disconnect();
                                futakuroRespopObserver.disconnect();
                            }
                        }
                    }
                };

                //ふたクロのレスポップアップの監視
                const obsFutakuroRespop = (mutations) => {
                    //画像付きか
                    if(document.querySelector("#respopup_area > .fvw_respop a > img")) {
                        //属性を付ける
                        addAttr([document.querySelector("#respopup_area > .fvw_respop a > img").parentElement], "レスポップ");
                    }
                };

                //ふたクロのNGオンオフの監視
                const obsFutakuroNgStyle = (mutations) => {
                    setTimeout(() => {
                        if(openList) { //一覧開いてたら
                            //何番目の画像か属性付け直し
                            document.querySelectorAll(`.futaba_lightbox_image_list_container > a${document.querySelector("#ng-style > style") ? ":not(.ng_hidden)" : ""}`).forEach((el, index) => {
                                el.setAttribute('data-i', index);
                            });
                        }
                        //画像数の更新
                        if(SHOW_IMAGE_COUNT) ichiranImageCount();
                        if(SHOW_KOKOBTN) ichiranCheckPoint();
                    }, 100);
                };

                //赤福の情報監視
                const obsAkahuku = (mutations) => {
                    for(const mutation of mutations) {
                        for(const node of mutation.addedNodes) {
                            if(/Not\sFound|No\sFuture/.test(node?.textContent)) {
                                console.info("スレ落ちた");
                                //スレ落ち
                                threadDown = true;
                                //一覧開いてたら表示
                                if(SHOW_THREAD_DOWN && openList) showThreadDown();
                                //監視止める
                                observer.disconnect();
                                akahukuObserver.disconnect();
                            }
                        }
                    }
                };

                //赤福の「mhtで保存」横に出る情報を監視して追加したものを消す
                //保存に割り込む形だから消すのが間に合わない場合あり(要再保存)
                const obsAkahukuMht = new MutationObserver(mutations => {
                    for(const mutation of mutations) {
                        for(const node of mutation.addedNodes) {
                            if(node.nodeType === 3) {
                                //保存が始まったら
                                if(node.textContent == "保存中...") {
                                    //各タグに付けた属性を消す
                                    removeAttr(document.querySelectorAll("a[data-checked], [data-upf] blockquote"), "checked");
                                    //一覧ボタン削除
                                    document.querySelector(".ichiran")?.remove();
                                    //一覧閉じる
                                    closeImageListView();
                                }
                                //終わったら
                                if(/成功|中断|失敗|error/.test(node.textContent)) {
                                    setTimeout(() => {
                                        //aタグ再収集
                                        const imgA = Array.from(document.querySelectorAll(".thre a > img"), el => el.parentElement).filter(el => !el.closest("#respopup_area, .akahuku_preview_container, .previewArea, blockquote"));
                                        //属性付け
                                        addAttr(imgA);
                                        //あぷファイルを一覧に含めるか
                                        if(ADD_UPFILE_LIST) {
                                            const resBq = document.querySelectorAll(".thre blockquote");
                                            //属性付け
                                            addAttrUp(resBq);
                                        }
                                        yattaka();
                                    }, 1000);
                                }
                            }
                        }
                    }
                });


                //追加されるレスを監視
                const target = document.querySelector(".thre");
                if(!res1000) observer.observe(target, {childList: true});

                //別の拡張やスクリプトでの変化を監視するか
                if(OBSERVE_OTHER_CHANGES) otherChangesObserver.observe(target, {childList: true, attributes: true, subtree: true});

                //ふたクロの情報設定
                const futakuroObserver = new MutationObserver(obsFutakuro);
                //ふたクロのレスポップアップ
                const futakuroRespopObserver = new MutationObserver(obsFutakuroRespop);
                //ふたクロのNGオンオフ
                const futakuroNgStyleObserver = new MutationObserver(obsFutakuroNgStyle);
                //赤福の情報設定
                const akahukuObserver = new MutationObserver(obsAkahuku);

                //拡張機能があるか確認
                let checkCount = 0;
                const extensionCheck = setInterval(() => {
                    checkCount ++;
                    //ふたクロだった
                    if(document.querySelector("div#res_menu")) {
                        clearInterval(extensionCheck); //確認おわり
                        useFutakuro = true;
                        futakuroObserver.disconnect(); //重複対策でまず止める
                        futakuroRespopObserver.disconnect(); //重複対策でまず止める
                        futakuroNgStyleObserver.disconnect(); //重複対策でまず止める
                        if(!res1000) {
                            console.info("ふたクロのスレ落ち情報を監視中");
                            futakuroObserver.observe(document.querySelector("div#res_menu"), {childList: true, subtree: true}); //変化の監視
                            futakuroRespopObserver.observe(document.querySelector("div#respopup_area"), {childList: true}); //変化の監視
                            futakuroNgStyleObserver.observe(document.querySelector("#ng-style"), {childList: true}); //変化の監視
                        }
                        //スマホモード時の調整
                        if(mobile && window.getComputedStyle(document.querySelector(".thre td.rts")).display === "none") {
                            //css埋め込み
                            const styleEl = document.createElement("style");
                            styleEl.id = "ichiranFutakuroSmode";
                            styleEl.textContent = `.futaba_lightbox_image_list_container > a > span.res {line-height: 1.3rem!important;}
                            .futaba_lightbox_image_list_container > a > span.res > svg {margin-top: 3px!important;}
                            .vmark.normal {top: calc(-21px ${ADD_RES_LIST ? "- 1.3rem / 2" : ""} + var(--viewlistW)/2)!important;}
                            .vmark.small {top: calc(-21px ${ADD_RES_LIST ? "- 1.3rem / 2" : ""} + var(--sViewlistW)/2)!important;}`;
                            document.querySelector("#ichiranCSS").after(styleEl);
                        }
                    }
                    //赤福だった
                    if(document.querySelector("span#akahuku_reload_status")) {
                        clearInterval(extensionCheck); //確認おわり
                        akahukuObserver.disconnect(); //重複対策でまず止める
                        obsAkahukuMht.disconnect(); //重複対策でまず止める
                        if(!res1000) {
                            console.info("赤福のスレ落ち情報を監視中");
                            akahukuObserver.observe(document.querySelector("span#akahuku_reload_status"), {childList: true}); //変化の監視
                        }
                        if(document.querySelector("a#akahuku_savemht_button")) {
                            //ページ下部の[mhtで保存]横に出る情報の監視始め
                            obsAkahukuMht.observe(document.querySelector("#akahuku_savemht_progress"), {childList: true});
                        }
                    }
                    //見つからない場合15秒後に止める
                    if(checkCount > 14) clearInterval(extensionCheck);
                }, 1000);
            }
        }

        // 画像付きレスにデータ属性を付加
        function addAttr(array, obs) {
            //加工
            for(const el of array) {
                //二度づけしない
                if(el.dataset.checked) continue;
                //確認した
                el.setAttribute("data-checked", "");

                //レス番
                const dataNo = el.parentElement.querySelector("span.cno, span.n").textContent || "";

                //レスポップアップに使うレスのコピー
                let dataRes = (el.parentElement.querySelector("blockquote").innerHTML === "") ? "[空レス]" : el.parentElement.querySelector("blockquote").innerHTML ?? "[空レス]";
                // console.log("置換前", dataRes);

                //削除画像を表示しない設定なら処理を飛ばす
                if(HIDE_ISOLATION_RES && dataRes.includes('"#ff0000">削除依頼')) {
                    continue;
                }
                if(HIDE_DELETED_RES && dataRes.includes('"#ff0000">スレッド')) {
                    continue;
                }
                //レスポップアップ用に置換
                dataRes = dataRes.replace(/<span\sclass="qbtn".+?">(.*?)<\/span>/g, "$1") //フォレストの引用レス表示用のタグ
                    .replace(/\sclass="bns-line-element[^>]+/g, "") //拡張機能「ビーニードルC」の追加クラス
                // .replace(/\t\[<a.+?>link<\/a>\]<br>/g, "") //URLに付くlink
                    .replace(/(?<!<(a|font)[^>]+?)'/g, "&apos;") //タグ壊れ予防、aタグとfontタグ外の ' を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<(a|font)[^>]+?)"/g, "&quot;") //タグ壊れ予防、aタグとfontタグ外の " を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<a[^>]+?):/g, "&colon;") //タグ壊れ予防、aタグ外の：を文字参照に置換(IDへの画像レスでなんか壊れてた)
                    .replace(/<a[^>]+>(fu?\d{6,}\.[a-z4]{3,4})<\/a>/g, "$1") //あぷへのリンク
                    .replace(/f(u?\d{6,}\.)/g, "&#102;$1") //タグ壊れ予防、あぷファイル名のfを文字参照に置換(ファイル名に反応してリンク足されて壊れる)
                    .replace(/<input.+?>/g, "") //展開タグ
                    .replace(/<span.+?>\[見る\]<\/span>/g, "") //同上(バケツ)
                    .replace(/<small[^>]+akahuku.+?<\/small>/g, "") //同上(赤福)
                    .replace(/<span>(<br>)?<img.+?>(<br>)?<\/span>/g, "") //ふたクロのあぷファイル展開済みタグ
                    .replace(/<details[^>]+previewArea[^>]+>.+?<\/details>/g, "") //ユーザースクリプト「いろいろ自動読み込み [仮]」の追加タグ
                    .replace(/<div[^>]+preview-imageWrap.+?<\/div>(<p.+?<\/p>)?<\/div>/gs, "") //ユーザースクリプト「futaba-image-preview」の追加タグ
                    .replace(/(?:<span[^>]*>)+([\s\S]*?)(?:<\/span>)+/g, "$1") //拡張機能「ビーニードルC」の残り
                ;
                // console.log("置換後", dataRes);

                //動画なら一覧での識別用に拡張子をコピー
                const dataExt = /\.(gif|mp4|webm)$/.test(el.href) ? el.href.match(/(?<=\.)(gif|mp4|webm)$/)[0] : ""

                //属性の設定
                if(obs === "レスポップ") {
                    el.setAttribute("data-list", "respop");
                } else {
                    el.setAttribute("data-list", "thread");
                }
                el.setAttribute("data-no", dataNo);
                el.setAttribute("data-res", dataRes);
                if(dataExt) el.setAttribute("data-ext", dataExt);
                if(DECORATE_ID_RES && !idThread) { //非IDスレでID付いた画像を加工する設定か
                    if(el.parentElement.querySelector(".cnw")?.textContent.includes("ID:") || el.parentElement.querySelector(".c9-3")?.nextSibling.textContent.includes("ID:")) {
                        el.setAttribute("data-id", "");
                    }
                }
                // console.log("画像付きレスに属性付け", el.dataset.no);

                //あぷファイル名があったらデータ属性付きのリンク作る
                if(/&#102;u?\d{6,}\.(?!txt)/.test(el.dataset.res)) {
                    const upgaRes = el.dataset.res.replace(/(&#102;u?\d{6,}\.(?!txt)[a-z4]{3,4})/g, "<font class=upgaS>$1</font>");
                    el.setAttribute("data-res", el.dataset.res
                                    //ファイル名にリンクを付ける
                                    .replace(/(&#102;u?\d{6,}\.(?!txt)[a-z4]{3,4})/g, `<a data-list href=https://dec.2chan.net/up2/src/$1 target=_blank data-res='${upgaRes}'>$1</a>`)
                                    //↑あぷはURLを修正
                                    .replace(/up2(?=\/src\/&#102;\d)/g, "up")
                                   );
                    if(location.hostname.includes("ftbucket")) { //バケツならサイトのファイルにリンク置換
                        el.setAttribute("data-res", el.dataset.res
                                        .replace(/https:\/\/dec\.2chan\.net\/up2?\/src\//g, "other/")
                                       );
                    }
                    if(location.hostname.includes("tsumanne")) { //「」ッチーならサイトのファイルにリンク置換
                        el.setAttribute("data-res", el.dataset.res
                                        .replace(/https:\/\/dec\.2chan\.net\/up2\/src\//g, "") //あぷ小だけ
                                       );
                    }
                }
                // console.log("置換後", el.dataset.res);

                //モバイル版フォレストの動画リンクをデスクトップ版に
                if(mobile && location.hostname.includes("forest")) {
                    el.href = el.href.replace("res/video.htm?v=..%2F..%2Fb%2Fsrc%2F", "src/");
                }
            }
            //監視から来たら実行
            if(obs === "監視") {
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                if(SHOW_KOKOBTN) ichiranCheckPoint();
                if(openList) addImageListView(array); //一覧を開いてたら継ぎ足す
            }
        }

        // あぷファイル込みのレスにタグ追加
        function addAttrUp(array, obs) {
            for(const el of array) {
                //二度づけしない
                if(el.closest("[data-upf]:not(.thre)")) continue;

                //あぷファイル名込みのレスか「」ッチーで展開してるあぷファイルがあるか
                if((el.textContent && /(?<!>(.(?!\\n))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.innerText)) ||
                   (location.hostname.includes("tsumanne") && el.querySelector("a > img") && [...el.querySelectorAll("a > img")].some(el => /fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.src)))) {
                    //一覧にまとめる用に先祖タグに属性付け
                    //ふたクロの同期機能で消されないとこに付けたい
                    if(el.parentElement.className == "thre") el.parentElement.setAttribute("data-upf", ""); //素の本文
                    if(el.parentElement.id == "master") { //ふたクロ本文
                        if(el.closest(".thre[data-upf]")) el.closest(".thre[data-upf]").removeAttribute("data-upf"); //素の本文で付けたのは消す
                        el.parentElement.setAttribute("data-upf", "");
                    }
                    if(el.parentElement.id == "r0") el.parentElement.setAttribute("data-upf", ""); //フォレスト本文
                    if(el.parentElement.tagName == "TD") el.closest("table").setAttribute("data-upf", ""); //レス

                    if(SHOW_KOKOBTN && obs) ichiranCheckPointEl([el]);
                    //一度でも追加した
                    addedTag = true;
                }
            }
            //属性付けたあぷファイル名があるレス
            upInBq = [...document.querySelectorAll(".thre[data-upf] > blockquote, .thre  [data-upf] blockquote, #res_body [data-upf] blockquote")].filter(el => !el.closest("#respopup_area, td.qt, .previewArea"));

            //監視から来たら実行
            if(obs) {
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                //あぷファイルを含める設定で一覧開いてたら加える
                if(ADD_UPFILE_LIST && openList) editImageListView();
            }
        }

        //データ属性やらを消す
        function removeAttr(array, checked) {
            for(const el of array) {
                if(checked) el.removeAttribute("data-checked");
                el.removeAttribute("data-list");
                el.removeAttribute("data-id");
                el.removeAttribute("data-no");
                el.removeAttribute("data-res");
                el.removeAttribute("data-ext");
                el.removeAttribute("data-y");
                el.removeAttribute("data-ng");
                //あぷファイル
                if(el.closest("[data-upf]")) {
                    el.closest("[data-upf]").removeAttribute("data-upf");

                    upInBq = [...document.querySelectorAll(".thre[data-upf] > blockquote, .thre [data-upf] blockquote, #res_body [data-upf] blockquote")].filter(el => !el.closest("#respopup_area, td.qt, .previewArea"));
                }
            }
        }

        //あぷファイル込みのレスに追加した属性が消えてないか確認
        function addedAttrCheck() {
            //画像付きレスで巻き込まれてたら
            if([...document.querySelectorAll(".thre a:not([data-checked]) > img")].filter(el => !el.closest(`${HIDE_ISOLATION_RES ? ".deleted," : ""}#respopup_area, td.qt, .previewArea`)).length) {
                // console.log("消えたデータ属性再追加");
                //データ属性付け
                const imgA = Array.from(document.querySelectorAll(".thre a:not([data-checked]) > img"), el => el.parentElement).filter(el => !el.closest(`${HIDE_ISOLATION_RES ? ".deleted," : ""}#respopup_area, td.qt, .previewArea`));
                if(imgA.length) addAttr(imgA);
            }

            // console.log("あぷファイル名込みのレスに追加したタグ数：%d\t現在：%d", upInBq.length, [...document.querySelectorAll("[data-upf] > blockquote, .thre [data-upf] blockquote")].length);

            //追加したタグが減ってたら再追加
            if(addedTag && upInBq.length > [...document.querySelectorAll(".thre[data-upf] > blockquote, .thre [data-upf] blockquote")].length) {
                // console.log("消えたタグ再追加");
                const resBq = document.querySelectorAll(".thre blockquote");
                addAttrUp(resBq);

                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                if(SHOW_KOKOBTN) ichiranCheckPoint();
            }
        }

        //一覧の一枠の高さ計算
        function calcAheight() {
            //ページの拡大率が変わってたらスクロールバー幅の更新
            if(zoom != window.devicePixelRatio) {
                zoom = window.devicePixelRatio;
                setScrollbarSize();
            }

            //横幅
            //位置調整とスクロールバー幅と遊びを引いて並べる画像数で割ったのを小数点第一位で切捨て
            const aWidth = Math.floor(((window.innerWidth - 4 - thinSb - 1) / IMAGE_NUM) * 10) / 10;
            //小
            const aWidthS = Math.floor(((window.innerWidth * (SMALL_LIST_SCALE / 100) - 4 - thinSb - 1) / IMAGE_NUM_S) * 10) / 10;

            //画像サイズ
            //横幅から枠の隙間分引く
            const iSize = aWidth - 4;
            //小
            const iSizeS = aWidthS - 4;

            //高さ
            if(ADD_RES_LIST) { //枠にレスを足すか
                //横幅を少数四捨五入してレス表示枠の高さを足す
                aHeight = Math.round(aWidth + parseFloat(window.getComputedStyle(document.body).fontSize) * 1.5 );
                //小
                aHeightS = Math.round(aWidthS + parseFloat(window.getComputedStyle(document.body).fontSize) * 1.5 );
            } else {
                //横幅を少数四捨五入
                aHeight = Math.round(aWidth);
                //小
                aHeightS = Math.round(aWidthS);
            }

            //CSS変数を更新
            document.documentElement.style.setProperty("--viewlistW", `${aWidth}px`);
            document.documentElement.style.setProperty("--viewlistH", `${aHeight}px`);
            document.documentElement.style.setProperty("--viewlistI", `${iSize}px`);
            document.documentElement.style.setProperty("--sViewlistW", `${aWidthS}px`);
            document.documentElement.style.setProperty("--sViewlistH", `${aHeightS}px`);
            document.documentElement.style.setProperty("--sViewlistI", `${iSizeS}px`);
            document.documentElement.style.setProperty("--viewlistBar", `${aWidth * IMAGE_NUM + 4}px`);
            document.documentElement.style.setProperty("--sViewlistBar", `${aWidthS * IMAGE_NUM_S + 4}px`);
        }

        //一覧出してる時のスクロールバーの状態チェック
        function sbCheck() {
            //スクロールバーが出てきたらbodyのスタイル変更
            if(document.documentElement.scrollHeight > window.innerHeight) {
                //スクロールバーが非表示じゃないなら
                if(window.getComputedStyle(document.body).overflowY !== "hidden") {
                    document.body.style.overflow = "hidden"; //スクロールバーを消す
                    if(!mobile) { //携帯端末じゃなかったら
                        document.body.style.paddingRight = scrollbar + "px";
                    }
                }
            } else if(window.getComputedStyle(document.body).overflowY === "hidden") { //スクロールバーが非表示なら
                //bodyのスタイル戻す
                document.body.style.overflow = "";
                document.body.style.paddingRight = "";
            }
        }

        //canvasタグにアニメーションの1フレームだけ描写
        function canvasDrawImage(canvasEl, el, ins = false) {
            //アス比
            let imageAR;
            if(el.naturalWidth) {
                imageAR = el.naturalWidth / el.naturalHeight;
            } else {
                imageAR = el.videoWidth / el.videoHeight;
            }
            //アス比でサイズ決め
            let imageW;
            let imageH;
            if(imageAR >= 1) { //横長か
                imageW = THUMBNAIL_SIZE_EQ;
                imageH = Math.round(THUMBNAIL_SIZE_EQ / imageAR * 100) / 100;
            } else {
                imageW = Math.round(THUMBNAIL_SIZE_EQ * imageAR * 100) / 100;
                imageH = THUMBNAIL_SIZE_EQ;
            }

            //canvasサイズを画像に合わせる
            canvasEl.setAttribute("width", imageW);
            canvasEl.setAttribute("height", imageH);
            //canvasの2Dコンテキスト取得
            const ctx = canvasEl.getContext("2d");
            //縮小に補正
            ctx.imageSmoothingEnabled = true;
            ctx.imageSmoothingQuality = "medium";
            //canvasに描写
            ctx.drawImage(el, 0, 0, imageW, imageH);

            //動画の保険から来たら
            if(ins) {
                //動画を止めて空にしてリセット
                el.pause();
                el.removeAttribute("src");
                el.load();
            }
        }

        // CSSを設定
        function addCSS() {
            //諸々の調整
            const sonotaCSS = `
/*　変数　*/
/*
--thinSb         細いスクロールバー幅
--viewlistW     一枠の幅
--viewlistH     一枠の高さ
--viewlistI      一枠の画像サイズ
--sViewlistW  小さい一枠の幅
--sViewlistH 小さい一枠の高さ
--sViewlistI    小さい一枠の画像サイズ
*/
:hover {
    outline : 0!important;
}
/* 回転用 */
@keyframes rotate {
    from {
        transform: rotate(0deg);
    }
    to {
        transform: rotate(360deg);
    }
}
/* 除外用 */
@keyframes exclusion {
    from {
        transform: rotate(0deg);
        scale: 0.5;
        opacity: 1;
    }
    to {
        transform: rotate(360deg);
        scale: 0;
        opacity: 0;
    }
}${SHOW_KOKOBTN ? `
/* 一覧表示 */
.ichiran {
    top: ${mobile ? mobilePosY : ichiranPosY}px;
    ${mobile ? `right: ${mobilePosX}` : `left: ${ichiranPosX}`}px;
    display: flex;
    position: fixed;
    width: ${SHOW_IMAGE_COUNT ? 130 : 100}px;
    height: 30px;
    user-select: none;
    border: 1px solid #888;
    box-shadow: #0006 0px 0px 5px;
}
/* 一覧表示ボタン */
.ichiranopn {
    width: ${SHOW_IMAGE_COUNT ? 90 : 70}px;
    font-size: 12px;
    color: #000;
    background: linear-gradient(#FFF, #EEE);
    align-content: center;
    text-align: center;
    line-height: 0.9em;
    cursor: pointer;
    user-select: none;
}
.ichiranopn:hover {
    background:  linear-gradient(#FFE, #FC9);
}
/* いまココボタン */
.ichirankoko {
    width: 49px;
    font-size: 11px;
    color: #000;
    background: linear-gradient(#FFF, #EEE);
    align-content: center;
    text-align: center;
    line-height: 0.9em;
    cursor: pointer;
    user-select: none;
    padding-top: 1px;
    border-left: 1px solid #888;
}
.ichirankoko:hover {
    background:  linear-gradient(#FFE, #FC9);
}` : `
/* 一覧表示ボタン */
.ichiran {
    top: ${mobile ? mobilePosY : ichiranPosY}px;
    ${mobile ? `right: ${mobilePosX}` : `left: ${ichiranPosX}`}px;
    position: fixed;
    width: ${SHOW_IMAGE_COUNT ? 90 : 70}px;
    height: 30px;
    font-size: 12px;
    color: #000;
    background: linear-gradient(#FFF, #EEE);
    align-content: center;
    text-align: center;
    cursor: pointer;
    user-select: none;
    border: 1px solid #888;
    box-shadow: #0006 0px 0px 5px;
}
.ichiran:hover {
    background:  linear-gradient(#FFE, #FC9);
}`}
/*　画像一覧　*/
/* 背景共通 */
.futaba_lightbox_image_list_overlay {
    position: fixed;
    top: 0;
    bottom: 0;
    right: 0;
    z-index: 2000000014;
}
/* 背景 */
.futaba_lightbox_image_list_overlay.normal {
    left: 0;
    background-color: #0008;
}
/* 背景(小) */
.futaba_lightbox_image_list_overlay.small {
    width: ${SMALL_LIST_SCALE}vw;
    float: right;
    background-color: #EA8A;
    padding-top: calc(1rem + 9px);
    margin-top: 30px;
    margin-bottom: 10vh;
    box-shadow: #0006 0px 0px 5px;
}
/* スレ落ちバー共通 */
.sureochi {
    width: 100%;
    background-color: #E04000;
    padding: 2px 0px;
    position: absolute;
    text-align: center;
    color: #FFF;
    font-weight: bold;
    line-height: 1rem;
    user-select: none;
}
/* スレ落ちバー */
.sureochi.normal {
${mobile ? "" : "    margin-top: calc(5% - 1rem - 4px);"}
}
/* スレ落ちバー(小) */
.sureochi.small {
    margin-top: calc(-1rem - 4px);
}
/* スレ落ちテキスト */
.sureochi.normal > span {
    display: block;
    width: var(--viewlistBar);
}
/* スレ落ちテキスト(小) */
.sureochi.small > span {
    display: block;
    width: var(--sViewlistBar);
}
/* 一覧共通 */
.futaba_lightbox_image_list_container {
    width: auto;
    overflow-y: scroll;
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    align-content: flex-start;
    padding-top: 4px;
    padding-left: 4px;
    background-color: #FFE;
    user-select: none;
    /* 細いスクロールバー */
    scrollbar-width: thin;
    scrollbar-color: #800000 #F0E0D6;
}
/* 一覧 */
.futaba_lightbox_image_list_container.normal {
    height: ${listHeight}%;
    margin-top: ${mobile ? "calc(1rem + 4px)" : "5%"};
}
/* 一覧(小) */
.futaba_lightbox_image_list_container.small {
    height: 90%;
}
.futaba_lightbox_image_list_container:focus {
    outline: none;
}
/* 一枠共通 */
.futaba_lightbox_image_list_container > a {
    position: relative;
    overflow: hidden;
    text-align-last: center;
    color: #800000;
    text-decoration: none;
}
.futaba_lightbox_image_list_container > a:focus {
    outline: none;
}
/* 一枠 */
.futaba_lightbox_image_list_container.normal > a {
    width: var(--viewlistW);
    height: var(--viewlistH);
}
/* 一枠(小) */
.futaba_lightbox_image_list_container.small > a {
    width: var(--sViewlistW);
    height: var(--sViewlistH);
}
/* 画像共通 */
.futaba_lightbox_image_list_container > a > img {
    background-color:#F0E0D6;
    object-fit: contain;
    margin: 0px;
    border-width: 0px!important;
}
/* 画像 */
.futaba_lightbox_image_list_container.normal > a > img {
    width: var(--viewlistI);
    height: var(--viewlistI);
}
/* 画像(小) */
.futaba_lightbox_image_list_container.small > a > img {
    width: var(--sViewlistI);
    height: var(--sViewlistI);
}
/* レス共通 */
.futaba_lightbox_image_list_container > a > span.res {
    display: block;
    font-size: 0.9rem;
    font-weight: 600;
    background-color: #EA8;
    min-width: 0px;
    line-height: 1.5rem;
    margin: 0px;
    padding: 0px;
    overflow: clip;
}
/* レス */
.futaba_lightbox_image_list_container.normal > a > span.res {
    max-width: var(--viewlistI);
    max-height: calc(var(--viewlistI) + 1.5rem);
}
/* レス(小) */
.futaba_lightbox_image_list_container.small > a > span.res {
    max-width: var(--sViewlistI);
    max-height: calc(var(--sViewlistI) + 1.5rem);
}
/* レスポップアップ共通 */
.futaba_lightbox_image_list_container > .tooltip {
    display: none;
    padding: 10px 20px;
    margin: 0px auto;
    background-color: #FFE;
    color: #800000;
    max-width: 800px;
    box-shadow: #0006 0px 0px 5px;
    word-wrap: break-word;
}
/* レスポップアップ */
.futaba_lightbox_image_list_container > .tooltip.normal {
    position: absolute;
}
/* レスポップアップ(小) */
.futaba_lightbox_image_list_container > .tooltip.small {
    position: fixed;
}
/* レスポップアップのあぷ文字色 */
.futaba_lightbox_image_list_container > .tooltip > .upgaG {
    color: #00E;
}
/* あぷ共通 */
.futaba_lightbox_image_list_container > a > span:not(.res) {
    background-color:#F0E0D6;
    display: block;
    float: left;
    margin:0px;
    border-width: 0px!important;
    align-content: center;
}
/* あぷ */
.futaba_lightbox_image_list_container.normal > a > span:not(.res) {
    width: var(--viewlistI);
    height: var(--viewlistI);
}
/* あぷ(小) */
.futaba_lightbox_image_list_container.small > a > span:not(.res) {
    width: var(--sViewlistI);
    height: var(--sViewlistI);
}
/* あぷ用レスアイコン */
.futaba_lightbox_image_list_container > a > span.res > svg {
    margin-top: 4px;
    margin-bottom: -2px;
    padding-right: 2px;
}
/* 差し替えサムネ */
.futaba_lightbox_image_list_container > a > span > canvas {
    width: 100%;
    height: 100%;
    object-fit: contain;
}
/* 差し替え動画サムネ準備アイコン入れ */
.futaba_lightbox_image_list_container > a > span.easelicon {
    position: absolute;
}
/* 差し替え動画サムネ準備アイコン */
.futaba_lightbox_image_list_container > a > span.easelicon > svg {
    opacity: 1;
    transition: opacity 1s ease;
}
.futaba_lightbox_image_list_container > a > span.easelicon > svg.hidden {
    opacity: 0;
}
/* 差し替え動画サムネ入れ */
.futaba_lightbox_image_list_container > a > span.video {
    background-color: #0000;
    position: relative;
}
/* 差し替え描写済みサムネ避難所 */
upthumb {
    display: none;
}
/* 追加ボタンの基準位置 */
.add {
    position:relative;
    line-height: 1;
}
/* 動画マーク共通 */
.vmark {
    cursor: pointer;
    width: 50px;
    max-width: 50px;
    height: 17px;
    margin: 0px;
    padding: 0px;
    position: absolute;
    left: -54px;
    background-color: #800000;
    color: #FFF;
    font-size: 12px;
    text-align: center;
}
/* 動画マーク */
.vmark.normal {
    /* レスを付けるかで位置を変える */
    top: calc(-21px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--viewlistW)/2);
}
/* 動画マーク(小) */
.vmark.small {
    /* レスを付けるかで位置を変える */
    top: calc(-21px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--sViewlistW)/2);
}
/* 追加ボタン共通 */
.tores, .DLB {
    cursor: pointer;
    position:absolute;
    width: 50px;
    height: 25px;
    align-items: center;
    align-content: center;
    padding-top: 3px;
    background-color: #FFF;
    border: 1px solid #666;
    color: #333;
    font-size: 13px;
    text-align: center;
    text-decoration: none;
    user-select: none;
    opacity: 0;
}
/* 追加ボタン */
.tores.normal, .DLB.normal {
    max-width: ${mobile ? 33 : 50}px;
    /* レスを付けるかで位置を変える */
    bottom: calc(${mobile ? "-30" : "-40"}px + var(--viewlistW)/2 ${ADD_RES_LIST ? " + 1.5rem / 2" : ""});
}
/* 追加ボタン(小) */
.tores.small, .DLB.small {
    max-width: ${mobile ? 33 : 40}px;
    /* レスを付けるかで位置を変える */
    bottom: calc(-30px + var(--sViewlistW)/2 ${ADD_RES_LIST ? " + 1.5rem / 2" : ""});
}
/* DLボタン */
.DLB.normal {
    left: calc(${mobile ? 0 : 9}px - var(--viewlistW));
}
/* DLボタン(小) */
.DLB.small {
    left: calc(0px - var(--sViewlistW));
}
/* レスに飛ぶボタン */
.tores.normal {
    /* 保存ボタンの有無で戻るボタンの位置を変える */
    left : ${mobile ? USE_DLBTN ? "calc(-33px - 2px - 4px)" : "calc(0px - var(--viewlistW))" : `calc(${USE_DLBTN ? "9px + 50px + 1px" : "9px"} - var(--viewlistW))`};
}
/* レスに飛ぶボタン(小) */
.tores.small {
    /* 保存ボタンの有無で戻るボタンの位置を変える */
    left : ${mobile ? USE_DLBTN ? "calc(-33px - 2px - 4px)" : "calc(0px - var(--sViewlistW))" : `calc(${USE_DLBTN ? "40px + 1px" : "0px"} - var(--sViewlistW))`};
}
/* 除外ボタン枠共通 */
.excl {
    cursor: pointer;
    position: absolute;
    max-width: none;
    opacity: ${mobile ? 1 : 0};
}
/* 除外ボタン枠 */
.excl.normal {
    width: ${mobile ? 16 : 24}px;
    height: ${mobile ? 16 : 24}px;
    left: calc(2px - var(--viewlistW));
    /* レスを付けるかで位置を変える */
    top: calc(${mobile ? -20 : -33}px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--viewlistW)/2);
}
/* 除外ボタン枠(小) */
.excl.small {
    width: ${mobile ? 12 : 20}px;
    height: ${mobile ? 12 : 20}px;
    left: calc(2px - var(--sViewlistW));
    /* レスを付けるかで位置を変える */
    top: calc(${mobile ? -16 : -29}px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--sViewlistW)/2);
}
/* 除外アイコン1 */
.excl > svg:first-child {
    display: block;
}
/* 除外アイコン2 */
.excl > svg:nth-child(2) {
    display: none;
}
/* 除外ボタンカバー共通 */
.excl > span {
    width: 100%;
    height: 100%;
    /*background-color: white;*/
    display: block;
}
/* 除外ボタンカバー */
.excl.normal> span {
    transform: translateY(${mobile ? -16 : -24}px);
}
/* 除外ボタンカバー(小) */
.excl.small> span {
    transform: translateY(${mobile ? -12 : -20}px);
}
/* IDマーク共通 */
.iddeta {
    background-color: #0A0;
    position: absolute;
    max-width: none;
    top: -1.5rem;
    font-weight: bold;
    color: #FFF;
    text-align: center;
    line-height: 1.5rem;
}
/* IDマーク */
.iddeta.normal {
    font-size: 1.2rem;
    width: var(--viewlistI);
    left: calc(-4px - var(--viewlistI));
}
/* IDマーク(小) */
.iddeta.small {
    font-size: 1.1rem;
    width: var(--sViewlistI);
    left: calc(-4px - var(--sViewlistI));
}
/* 削除されたマーク共通 */
.kieta {
    background-color: #0A0;
    position: absolute;
    max-width: none;
    top: -1.5rem;
    font-weight: bold;
    color: #FFF;
    text-align: center;
    line-height: 1.5rem;
}
/* 削除されたマーク */
.kieta.normal {
    font-size: 1.3rem;
    width: var(--viewlistI);
    left: calc(-4px - var(--viewlistI));
}
/* 削除されたマーク(小) */
.kieta.small {
    font-size: 1.2rem;
    width: var(--sViewlistI);
    left: calc(-4px - var(--sViewlistI));
}
${location.hostname.includes("ftbucket") ? `
/* バケツ用 */
.ichiran {
    top: -1px;
}` : ""}

${location.hostname.includes("forest") ? `
/* フォレスト用 */
.ichiran {
    top: -1px;
    ${mobile ? "right: 0" : "left: 320"}px
}
${mobile ? `/* レス */
.futaba_lightbox_image_list_container > a > span.res {
    line-height: 1.3rem;
}
.c9-5 {
max-width: 100%!important;
max-height: 100%!important;
}
.vmark.normal {
top: calc(-21px - 1.3rem / 2 + var(--viewlistW)/2);
.vmark.small {
top: calc(-21px - 1.3rem / 2 + var(--sViewlistW)/2);
}` : ""}` : ""}

${location.hostname.includes("tsumanne") ? `
/* 「」ッチー用 */
.ichiran {
    top: ${mobile ? 70 : -1}px;
    ${mobile ? "right: 0" : "left: 380"}px;
}
img {
max-width: 100%;
max-height: 100%;
}` : ""}
`;
            //css埋め込み
            const styleEl = document.createElement("style");
            styleEl.id = "ichiranCSS";
            styleEl.textContent = sonotaCSS;
            document.body.after(styleEl);
        }

        //一覧のイベント用この辺にまとめる
        //「動画ファイルをクリックするとその場で開くイベント止める」用
        const stopPropagation = (event) => {
            if (event.target.closest("a") && /webm|mp4/.test(event.target.parentNode.href)) {
                event.stopPropagation();
            }
        };

        //「ウインドウサイズが変わったら一覧も調整する」用
        const windowHaba = () => {
            //スクロールバーの状態チェック
            if(!smallList) sbCheck();

            const ichiran = document.querySelector(".futaba_lightbox_image_list_container");

            //スクロール位置の修正
            ichiran.scrollTop = smallList ? aHeightS * scrollLine : aHeight * scrollLine;

            //一覧レスの省略文字数を更新
            if(ADD_RES_LIST) omitRes();
        };

        //携帯端末の「戻る」で一覧を閉じる用
        const backToThread = (event) => {
            if(document.querySelector("div[class$='content']")) {
                return;
            } else {
                bBack = true;
                closeImageListView();
            }
        };

        //一覧をマウスホイールで区切り良くスクロールする
        const wheelScroll = (event) => {
            if(event.deltaY < 0) { //↑ホイール
                //デフォルトの動きを止める
                event.preventDefault();
                //行ぴったりなら上の行に移動
                if(Math.trunc(scrollLine) == scrollLine) {
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * (scrollLine - 1) : aHeight * (scrollLine - 1);
                } else { //行の途中ならその行ぴったりに移動
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine) : aHeight * Math.trunc(scrollLine);
                }
            }
            if(event.deltaY > 0) { //↓ホイール
                //デフォルトの動きを止める
                event.preventDefault();
                //下の行に移動
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine +1) : aHeight * Math.trunc(scrollLine +1);
            }
        };

        //上下カーソルキー、PageUp/Down、スペースキーで区切り良くスクロールする
        const keyScroll = (event) => {
            if (event.key === "ArrowUp") { //↑キー
                //デフォルトの動きを止める
                event.preventDefault();
                //行ぴったりなら上の行に移動
                if(Math.trunc(scrollLine) == scrollLine) {
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * (scrollLine - 1) : aHeight * (scrollLine - 1);
                } else { //行の途中ならその行ぴったりに移動
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine) : aHeight * Math.trunc(scrollLine);
                }
            }
            if (event.key === "ArrowDown") { //↓キー
                //デフォルトの動きを止める
                event.preventDefault();
                //下の行に移動
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine +1) : aHeight * Math.trunc(scrollLine +1);
            }
            if(event.key === "PageUp") {
                //デフォルトの動きを止める
                event.preventDefault();
                //一覧に見えてる行数
                let pageLine;
                if(!smallList) {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeight;
                } else {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeightS;
                }
                //見えてる行数少数切り捨て
                pageLine = Math.trunc(pageLine);

                //一番下までスクロールした後なんかで少し見切れてる上の行をPageUpした後に入るように
                // console.log(scrollLine, (scrollLine % 1).toFixed(2));
                let upLine;
                if(scrollLine % 1 > 0.2) { //数字は暫定
                    upLine = Math.trunc(scrollLine + 1);
                } else {
                    upLine = Math.trunc(scrollLine);
                }

                //スクロール
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? (upLine - pageLine) * aHeightS : (upLine - pageLine) * aHeight;
            }
            if(event.key === "PageDown" || event.key === " ") {
                //デフォルトの動きを止める
                event.preventDefault();
                //一覧に見えてる行数
                let pageLine;
                if(!smallList) {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeight;
                } else {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeightS;
                }
                //見えてる行数少数切り捨て
                pageLine = Math.trunc(pageLine);
                //見えてる最下の見切れ率
                let mikire;
                if(!smallList) {
                    mikire = (parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) - (pageLine * aHeight)) / parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container > a > img")).height);
                } else {
                    mikire = (parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) - (pageLine * aHeightS)) / parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container > a > img")).height);
                }

                if(mikire < 0.7) { //見えてる最下の見切れ7割(適当)以下
                    //スクロールバーで微妙にスクロールしてて最下の画像がほぼ見えてたら見えてる行数増やす
                    if(scrollLine % 1 >= (0.8 - mikire)) pageLine += 1;
                } else {
                    //見えてる最下の見切れ7割(適当)以上ならスクロール行増やす
                    pageLine += 1;
                }
                //スクロール
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? (Math.trunc(scrollLine) + pageLine) * aHeightS : (Math.trunc(scrollLine) + pageLine) * aHeight;
            }
        };

        //スクロールした後の行数計算
        const calcScrollLine = () => {
            //(現スクロール位置 / 行の高さ)を小数点2位で四捨五入
            if(!smallList) {
                scrollLine = Number((document.querySelector(".futaba_lightbox_image_list_container").scrollTop / aHeight).toFixed(2));
            } else {
                scrollLine = Number((document.querySelector(".futaba_lightbox_image_list_container").scrollTop / aHeightS).toFixed(2));
            }
            // console.log("%f 行目", scrollLine);
        };

        //レスポップアップ(枠内にマウスが入ったら)
        const resPopOver = (event) => {
            const target = event.target.closest(".excl, .tores, .DLB, .vmark, .kieta, .iddeta") ? event.target.closest(".add")?.previousElementSibling ?? false : event.target.closest("a");
            if(!target) return;

            let tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");

            //レスを収納して表示
            tooltip.innerHTML = (target.dataset.res === "") ? "[空レス]" : target.dataset.res ?? "[空レス]";
            //ふたクロでNG判定されてたら追記
            if(target.classList.contains("ng_hidden")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">ふたクロでNG判定`;
            //あぷファイルの差し替えでエラーなら追記
            if(LOAD_UPFILE_LIST && target.hasAttribute("data-404")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">2回読込みエラー`;
            //あぷファイルの差し替えでスキップしてるなら追記
            if(LOAD_UPFILE_LIST && target.hasAttribute("data-skip")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">別タブ見てると描けない`;
            //あぷファイルの差し替えで時間超過してるなら追記
            if(LOAD_UPFILE_LIST && target.hasAttribute("data-waited")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">サムネ化時間超過`;

            tooltip.style.width = "";
            tooltip.style.display = "block";

            //ポップアップ幅 > (ウィンドウ幅 - スクロールバー) ならフォントサイズを下げて最大幅を設定する
            if(tooltip.offsetWidth > window.innerWidth - thinSb) {
                    tooltip.style.fontSize = `${parseFloat(window.getComputedStyle(tooltip).fontSize) - 2}px`;
                    tooltip.style.maxWidth = `${window.innerWidth - thinSb - 40}px`;
            }

            //表示する
            if(!mobile) resPopMove(event);
        };

        //レスポップアップ(枠内でマウス動かしたらレスをポップアップ)
        const resPopMove = (event) => {
            const target = event.target.closest(".excl, .tores, .DLB, .vmark, .kieta, .iddeta") ? event.target.closest(".add")?.previousElementSibling ?? false : event.target.closest("a");
            if(!target) return;

            const tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");

            //初期X位置
            let tooltipX = event.clientX + 20;
            //初期Y位置
            let tooltipY = event.clientY + 30;

            //右端の調整（X座標）
            const windowWidth = window.innerWidth;
            const tooltipWidth = tooltip.offsetWidth;

            if(!smallList) {
                if(tooltipX + tooltipWidth > windowWidth - thinSb - 1) { //マウス位置からレス幅が表示範囲超えないか
                    tooltipX = windowWidth - tooltipWidth - thinSb - 1; //X位置調整
                }
            } else {
                //スクロールバーが出てたら
                if(document.documentElement.scrollHeight > window.innerHeight) {
                    if(tooltipX + tooltipWidth > windowWidth - thinSb - scrollbar - 1) { //マウス位置からレス幅が表示範囲超えないか
                        tooltipX = windowWidth - tooltipWidth - thinSb - scrollbar - 1; //X位置調整
                    }
                } else {
                    if(tooltipX + tooltipWidth > windowWidth - thinSb - 1) { //マウス位置からレス幅が表示範囲超えないか
                        tooltipX = windowWidth - tooltipWidth - thinSb - 1; //X位置調整
                    }
                }
            }

            //下端の調整（Y座標）
            const windowHeight = window.innerHeight;
            const tooltipHeight = tooltip.offsetHeight;
            if(tooltipY + tooltipHeight > windowHeight) { //マウス位置からレス高が表示範囲超えないか
                tooltipY = tooltipY - tooltipHeight *1.3 - 20; //Y位置調整
            }

            //位置更新
            tooltip.style.top = tooltipY + "px";
            tooltip.style.left = tooltipX + "px";
        };

        //レスポップアップ(枠を離れたらサイズをレスに合わせるために位置を変えて非表示にする)
        const resPopOut = (event) => {
            const tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");
            tooltip.style.display = "none";
            tooltip.style.top = "-500px";
            tooltip.style.left = "-500px";
            tooltip.style.maxWidth = "";
            tooltip.style.fontSize = "";
        };

        //レスポップアップ(携帯端末)
         const resPopMobile = (event) => {
             const tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");
             tooltip.style.right = "";
             resPopOut();
             resPopOver(event);
             //一覧の下に表示
             if(tooltip.classList.contains("small")) { //小さい一覧か
                 tooltip.style.maxWidth = `calc(${SMALL_LIST_SCALE}vw - 40px)`;
                 tooltip.style.top = "calc((100% - 30px - 1rem - 9px -  10vh) * 0.9 + 4px + 30px + 1rem + 9px)";
                 tooltip.style.left = `calc(100vw - ${SMALL_LIST_SCALE}vw)`;
             } else {
                 tooltip.style.top = `calc(1rem + 8px + ${listHeight}%)`;
                 tooltip.style.left = "0px";
             }
             tooltip.style.right = "0px";
         };

        //追加ボタン(DLB)クリック
        const dlbClick = (event) => {
            download(event.target.parentElement.previousElementSibling.href);
        };

        //追加ボタン(tores)クリック
        const toresClick = (event) => {
            //レス番
            const no = event.target.parentElement.dataset.no;
            //同レス番のレスが見つかったらスクロール
            for(let resNo of document.querySelectorAll(".thre span.cno, #res_body span.n")) {
                if(resNo.textContent === no) {
                    //携帯端末のちらつき軽減で飛んでおく
                    if(mobile && !smallList) window.scrollTo(0, resNo.closest(".thre, table, div[id^='r'][class^='c9']").offsetTop - 32);
                    //一覧を消す
                    if(!smallList) closeImageListView();
                    //レスの少し上にスクロール
                    if(!mobile) window.scrollTo(0, resNo.closest(".thre, table, div[id^='r'][class^='c9']").offsetTop - 32);
                    else {
                        setTimeout(() => {
                            window.scrollTo(0, resNo.closest(".thre, table, div[id^='r'][class^='c9']").offsetTop - 32);
                        }, 0);
                    }
                    break;
                }
            }
        };

        //追加ボタン(excl)クリック
        const exclClick = (event) => {
            //ボタンが付いてるaタグ
            const aEl = event.target.closest(".add").previousElementSibling;
            const url = aEl.pathname;
            //手動で除外したファイルに追加
            if(/\/\d{13,}/.test(url)) {
                exclFiles.add(url);
            } else if(/\/fu?\d{6,}/.test(url)) {
                exclUpFiles.add(url.match(/fu?\d{6,}.+/)[0]);
            } else {
                console.warn("知らん…怖…\n", url);
            }
            // console.log(exclFiles);
            // console.log(exclUpFiles);

            //追加ボタン削除
            event.target.closest(".add").remove();
            //画像付きレスのだったらデータ属性変更
            if(/\d{13,}\./.test(aEl.href)) {
                const file = aEl.href.match(/\d{13,}\./)[0];
                document.querySelector(`a[data-list="thread"][href*="${file}"]`).setAttribute("data-list", "excl");
            }
            //レスポップアップを非表示に
            if(POP_UP_RES) resPopOut();
            //枠を消すアニメ指定
            aEl.style.setProperty("animation", "exclusion 0.3s forwards");
            //0.3秒後に消す
            setTimeout(() => {
                aEl.remove();
                //何番目の画像か属性付け直し
                document.querySelectorAll(`.futaba_lightbox_image_list_container > a${document.querySelector("#ng-style > style") ? ":not(.ng_hidden)" : ""}`).forEach((el, index) => {
                    el.setAttribute('data-i', index);
                });
                //画像数の更新
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
            }, 300);
        };

        //動画に付くマークをクリックでその動画をクリック
        const vMarkClick = (event) => {
            if(event.target.parentElement.previousElementSibling.tagName == "A") event.target.parentElement.previousElementSibling.click();
        };

        //あぷ動画に付くマークを右クリックでサムネ化
        const redrawThumb = (event) => {
            event.preventDefault();
            const aEl = event.target.parentElement.previousElementSibling;
            //差し替え後の要素があったら消してまだ無かったら終わる
            if(!aEl.querySelector("span > canvas") && !aEl.hasAttribute("data-skip") && !aEl.hasAttribute("data-waited") && aEl.hasAttribute("data-list")) return;
            else {
                //マークの色変更
                event.target.style.backgroundColor = "red";
                setTimeout(() => {
                    //マークの色戻す
                    event.target.style.backgroundColor = "";
                }, 300);

                if(aEl.hasAttribute("data-skip") || aEl.hasAttribute("data-waited")) {
                    if(aEl.hasAttribute("data-skip")) { //スキップされたか
                        //まとめてサムネ化
                        for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-skip]")) {
                            el.removeAttribute("data-skip");
                            el.querySelector("span").remove();
                            //差し替え前のタグを用意
                            const spanEl = document.createElement("span");
                            spanEl.classList.add("upicon");
                            spanEl.innerHTML = beforeLoad;
                            el.prepend(spanEl);
                        }
                    }
                    if(aEl.hasAttribute("data-waited")) { //時間超過したか
                        //まとめてサムネ化
                        for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-waited]")) {
                            el.removeAttribute("data-waited");
                            el.querySelector("span").remove();
                            el.setAttribute("data-list", "ichiran");
                            //差し替え前のタグを用意
                            const spanEl = document.createElement("span");
                            spanEl.classList.add("upicon");
                            spanEl.innerHTML = beforeLoad;
                            el.prepend(spanEl);
                        }
                    }
                } else {
                    if(aEl.hasAttribute("data-404")) { //リンク切れか
                        aEl.querySelector("span").remove();
                        aEl.setAttribute("data-list", "ichiran");
                        aEl.setAttribute("href", aEl.dataset[404]);
                        aEl.removeAttribute("data-404");
                        upErrFiles.delete(aEl.href.match(/fu?\d{6,}\..+$/)[0]);
                    }
                    if(aEl.querySelector("span[data-file]")) { //描写済みか
                        aEl.querySelector("span[data-file]").remove();
                        if(aEl.querySelector("span.easelicon")) aEl.querySelector("span.easelicon").remove();
                    }
                    //差し替え前のタグを用意
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("upicon");
                    spanEl.innerHTML = beforeLoad;
                    aEl.prepend(spanEl);
                }
                //サムネ化
                upIconReplace();
            }
        };

        //別タブから戻ったらスキップしたサムネ化やり直す
        const redrewOnActive = () => {
            if (!document.hidden) {
                if(document.querySelector(".futaba_lightbox_image_list_container > a[data-skip]")) {
                    //まとめてサムネ化
                    for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-skip]")) {
                        el.removeAttribute("data-skip");
                        el.querySelector("span").remove();
                        //差し替え前のタグを用意
                        const spanEl = document.createElement("span");
                        spanEl.classList.add("upicon");
                        spanEl.innerHTML = beforeLoad;
                        el.prepend(spanEl);
                    }
                    //サムネ化
                    upIconReplace();
                }
            }
        };

        //画像一覧
        function showImageListView(mode = "") {
            closeImageListView();

            //展開されてるビデオ要素があったら再生を止める
            if(document.querySelector(".thre video")) {
                for(const el of document.querySelectorAll(".thre video")) {
                    el.pause();
                }
            }

            //あぷファイル込みのレスに追加した属性が消えてないか確認
            if(ADD_UPFILE_LIST && useFutakuro) addedAttrCheck();

            //赤福の操作パネル
            if(document.querySelector("#akahuku_thread_operator")) {
                //固定サムネを一覧に含まないようにデータ属性変更
                if(document.querySelector("#akahuku_thumbnail")) document.querySelector("#akahuku_throp_thumbnail_button").setAttribute("data-list", "");
                //一覧表示中は操作パネル隠す
                document.querySelector("#akahuku_thread_operator").style.display = "none";
            }

            //画像数がズレないよう確認
            if(SHOW_IMAGE_COUNT) setTimeout(ichiranImageCount, 100);

            //一覧のサイズでいまココボタンの補足を変える
            if(SHOW_KOKOBTN && smallList) document.querySelector(".ichirankoko").setAttribute("title", "今の一覧を見てる位置に飛ばす\n右クリで別サイズの一覧を開く");

            //属性付けたaタグを集める(引用元やプレビュー表示を巻き込まないように)
            let imageList = [...document.querySelectorAll(".thre a[data-list='thread'], #res_body a[data-list='thread']")].filter(el => !el.closest("#respopup_area, .akahuku_preview_container, td.qt, .previewArea"));
            imageList = futakuroNgFilter(imageList, "一覧");
            //除外したファイルがあったら除外する
            if(exclFiles.size) imageList = imageList.filter(el => !exclFiles.has(el.pathname));
            //ふたクロで動画を拡大してたら縮小する
            for(const el of imageList) {
                if(el.querySelector("video.extendWebm")) {
                    //動画を止めて空にしてリセット
                    el.querySelector("video").pause();
                    el.querySelector("video").removeAttribute("src");
                    el.querySelector("video").load();
                    //縮小をクリック
                    if(el.parentElement.querySelector("a.sp_exp")) el.parentElement.querySelector("a.sp_exp").click();
                    else el.querySelector(".img_view").click();
                }
            }
            //一覧用に複製
            imageList = imageList.map(el => el.cloneNode(true));

            //タグ加工
            for(const el of imageList) {
                //データ属性を変える
                el.setAttribute("data-list", "ichiran");
                el.setAttribute("data-from", "thre");
                //画像のファイルサイズの属性を消す
                el.children[0].removeAttribute("alt");
                //画像のスタイルを消す
                el.children[0].removeAttribute("style");
                if(el.querySelector("div.img_button")) el.querySelector("div.img_button").remove();
                //動画を展開中でサムネが非表示になってたら表示する
                if(el.style.display == "none") el.style.display = "";
                //ふたクロでNG判定されてたらクラス追加
                if(el.hasAttribute("data-ng")) el.classList.add("ng_hidden");
                //画像一覧にレス追加
                if(ADD_RES_LIST) {
                    //blockquoteだとビーニードルに判定されるからタグ変更
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("res");
                    spanEl.textContent = "仮レス";
                    el.append(spanEl);
                }
            }

            //ふたポの過去ログなら404画像のサムネをアイコンに置換
            if(location.hostname == "kako.futakuro.com") futapoLogImageReplace(imageList);

            //画像一覧のタグ
            const imageListContainer = document.createElement("div");
            imageListContainer.classList.add("futaba_lightbox_image_list_container");
            imageListContainer.setAttribute("data-kosuu", smallList ? IMAGE_NUM_S : IMAGE_NUM);
            imageListContainer.setAttribute("tabindex", "0");
            imageListContainer.addEventListener("keydown", event => { //Escキーで閉じるように
                if (event.key === "Escape") {
                    closeImageListView();
                }
            });
            if(CLOSE_LIST_CLICK) { //一覧の空白部分をクリックしたら一覧を閉じるか
                imageListContainer.addEventListener("click", event => {
                    if(event.target.classList.contains("futaba_lightbox_image_list_container") || (mobile && event.target.closest(".tooltip"))) {
                        closeImageListView();
                    }
                });
            }
            if(USE_WHEEL_LIST) { //一覧を区切り良くスクロールするか
                //上下カーソルキー、PageUp/Down、スペースキーで区切り良くスクロールする
                imageListContainer.removeEventListener("keydown", keyScroll, {passive: false}); //重複回避でまず解除
                imageListContainer.addEventListener("keydown", keyScroll, {passive: false}); //preventDefaultする宣言
                //スクロールした後の行数計算
                imageListContainer.removeEventListener("scroll", calcScrollLine, {passive: true}); //重複回避でまず解除
                imageListContainer.addEventListener("scroll", calcScrollLine, {passive: true}); //preventDefaultしない宣言
            }
            //一覧のサイズでクラス付け
            smallList ? imageListContainer.classList.add("small") : imageListContainer.classList.add("normal");
            //配列imageListを複数対応のappend内で展開してimageListContainerに追加
            imageListContainer.append(...imageList);

            //画像一覧の背景のタグ
            const imageListOverLay = document.createElement("div");
            imageListOverLay.classList.add("futaba_lightbox_image_list_overlay");
            imageListOverLay.addEventListener("click", event => { //画像一覧の背景クリックでも一覧を閉じるように
                if(event.target.classList.contains("futaba_lightbox_image_list_overlay")) {
                    closeImageListView();
                }
            });
            if(USE_WHEEL_LIST) { //一覧を区切り良くスクロールするか
                //マウスホイールで区切り良くスクロールする
                imageListOverLay.removeEventListener("wheel", wheelScroll, {passive: false}); //重複回避でまず解除
                imageListOverLay.addEventListener("wheel", wheelScroll, {passive: false}); //preventDefaultする宣言
            }
            //一覧のサイズでクラス付け
            smallList ? imageListOverLay.classList.add("small") : imageListOverLay.classList.add("normal");
            imageListOverLay.append(imageListContainer);

            //スクロールバーの状態チェック
            if(!smallList) sbCheck();

            document.body.prepend(imageListOverLay); //bodyに加えて表示(赤福の続きを読む対策でbody先頭に)
            //一覧にフォーカスを移す
            document.querySelector(".futaba_lightbox_image_list_container").focus();

            //ふたばかふたポの過去ログで
            if(location.hostname.includes("2chan.net") || location.hostname == "kako.futakuro.com") {
                //動画をクリックするとその場で開くのを一覧開いてる時は止めたい
                document.body.addEventListener("click", stopPropagation);
                document.body.addEventListener("touchstart", stopPropagation);
                document.body.addEventListener("pointerdown", stopPropagation);
            }
            //スレ落ちてるか
            if(location.hostname.includes("2chan.net") && SHOW_THREAD_DOWN && (threadDown || res1000)) {
                showThreadDown();
            }

            //ウインドウサイズが変わったら一覧を調整する
            window.removeEventListener("resize", windowHaba); //重複回避でまず解除
            window.addEventListener("resize", windowHaba);

            //別タブから戻ったらスキップしたあぷ動画のサムネ化をやり直す
            if(LOAD_UPFILE_LIST && LOAD_UPFILE_VIDEO) {
                document.removeEventListener("visibilitychange", redrewOnActive); //重複回避でまず解除
                document.addEventListener("visibilitychange", redrewOnActive);
            }

            if(mobile && !smallList) { //携帯端末か
                //戻る履歴に空を追加
                history.pushState(null, null);
                //履歴操作にイベント登録
                window.addEventListener("popstate", backToThread);
            }
            //行数
            scrollLine = 0;

            //一覧の加工
            editImageListView(mode);
            // console.log("arguments", arguments);
        }

        //更新での継ぎ足し
        function addImageListView(array) {
            let imageList = array.filter(el => el.dataset.list);
            imageList = futakuroNgFilter(imageList, "一覧");
            //複製
            imageList = imageList.map(el => el.cloneNode(true));

            //タグ加工
            for(const el of imageList) {
                //データ属性を変える
                el.setAttribute("data-list", "ichiran");
                el.setAttribute("data-from", "thre");
                //画像のファイルサイズの属性を消す
                el.children[0].removeAttribute("alt");
                //画像のスタイルを消す
                el.children[0].removeAttribute("style");
                if(el.querySelector("div.img_button")) el.querySelector("div.img_button").remove();
                //ふたクロでNG判定されてたらクラス追加
                if(el.hasAttribute("data-ng")) el.classList.add("ng_hidden");
                //画像一覧にレス追加
                if(ADD_RES_LIST) {
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("res");
                    spanEl.textContent = "仮レス";
                    el.append(spanEl);
                }
            }

            //一覧に追加
            //配列imageListを複数対応のappend内で展開してimageListContainerに追加
            document.querySelector(".futaba_lightbox_image_list_container").append(...imageList);

            //一覧の加工
            editImageListView();
        }

        function editImageListView(mode = "") {
            const ichiran = document.querySelector(".futaba_lightbox_image_list_container");

            //一覧にあぷファイル名を含める
            if(ADD_UPFILE_LIST) {
                let res;
                //もう一覧開いてたら差分を追加する
                if(openList) {
                    //引用表示じゃないdata-upf属性のレス
                    const upf = [...document.querySelectorAll(".thre[data-upf], .thre [data-upf], #res_body [data-upf]")].filter(el => !el.closest("#respopup_area, td.qt, .previewArea"));
                    //一覧にあるあぷファイルのレス番(重複整理)
                    const listUpANo = new Set(Array.from(document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-from="up"]`), el => el.dataset.no));
                    //追加する一覧にないレス番のレス
                    res = upf.filter(el => !listUpANo.has(el.querySelector(".cno").textContent)).map(el => el.querySelector("blockquote"));
                    // console.log(res);
                } else {
                    //追加する引用表示じゃないdata-upf属性のレス
                    res = [...document.querySelectorAll(".thre[data-upf] > blockquote, .thre [data-upf] blockquote, #res_body [data-upf] blockquote")].filter(el => !el.closest("#respopup_area, td.qt, .previewArea"));
                }
                if(res.length) {
                    //隔離か削除レスを表示しない設定か
                    if(HIDE_ISOLATION_RES) {
                        //隔離レス除外
                        res = res.filter(el => !el.innerHTML.includes('"#ff0000">削除依頼'));
                    }
                    if(HIDE_DELETED_RES) {
                        //削除レス除外
                        res = res.filter(el => !el.innerHTML.includes('"#ff0000">スレッド'));
                    }
                    //ふたクロでNG判定のレスをフィルター
                    res = futakuroNgFilter(res, "あぷ");

                    for(let el of res) {
                        //親要素ごと複製する
                        el = el.parentElement.cloneNode(true).querySelector("blockquote");
                        //動画をレス内で再生中に複製すると同時に再生されるから複製した方は止める
                        if(el.parentElement.querySelector("video")) {
                            for(const videoEl of el.parentElement.querySelectorAll("video")) { //赤福のプレビューも入るようにする
                                //動画を止めて空にしてリセット
                                videoEl.pause();
                                videoEl.removeAttribute("src");
                                videoEl.load();
                            }
                        }
                        //「」ッチーで展開してた画像をファイル名に置換
                        if(location.hostname.includes("tsumanne")) el.innerHTML = el.innerHTML.replace(/<a\shref="(fu[^"]+?)"[^>]+?><img[^>]+?><\/a>/g, "$1");
                        // console.log(el.innerHTML);
                        let up = el.innerHTML.match(/(?<!&gt;(.(?!<br>))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)(?!['"])/g);
                        if(up) {
                            //羅列荒らしか
                            if(up.length >= UP_IGNORE_NUM) continue;
                            //エラーだったあぷファイルを除外するか
                            if(OMIT_ERROR_UPFILE) up = up.filter(val => !upErrFiles.has(val));
                            //除外したあぷファイルを除外する
                            if(exclUpFiles.size) up = up.filter(val => !exclUpFiles.has(val));
                            const no = el.parentElement.querySelector("span.cno, span.n").textContent; //レス番
                            if(SHOW_KOKOBTN) { //いまココボタンを使うか
                                if(typeof el.dataset.y == "undefined") ichiranCheckPoint();
                                const y = el.dataset.y;
                                upUpko(up, el, no, y);
                            } else {
                                upUpko(up, el, no);
                            }
                        }
                    }
                    //あぷファイルをソートするか
                    if(SORT_UPFILE_LIST) {
                        //一覧開いてたらスクロール行を覚えておく(保険)
                        const slRec = openList ? scrollLine : 0;
                        //一覧のaタグをレス番でソートした配列
                        const newIchiran = [...document.querySelectorAll(".futaba_lightbox_image_list_container > a")].sort((a, b) => Number(a.dataset.no.slice(3)) - Number(b.dataset.no.slice(3)));
                        //aタグをソートした順に一覧の最後に移動していく
                        for(const el of newIchiran) {
                            ichiran.appendChild(el);
                            //同レス番のボタン用タグがあったらaタグの後ろに配置
                            if(document.querySelector(`.futaba_lightbox_image_list_container > div.add[data-no="${el.dataset.no}"]`)) el.after(document.querySelector(`.futaba_lightbox_image_list_container > div.add[data-no="${el.dataset.no}"]`));
                        }
                        //覚えた行にスクロール
                        if(slRec) ichiran.scrollTop = smallList ? aHeightS * slRec : aHeight * slRec;
                    }
                }
                //一覧にあぷファイルを読込む
                if(LOAD_UPFILE_LIST) upIconReplace();
            }

            //何番目の画像か属性付ける
            document.querySelectorAll(`.futaba_lightbox_image_list_container > a${document.querySelector("#ng-style > style") ? ":not(.ng_hidden)" : ""}`).forEach((el, index) => {
                el.setAttribute('data-i', index);
            });

            //画像一覧にボタン追加
            if(USE_JUMPBTN || USE_DLBTN || USE_EXCLBTN) makeButton();
            //動画にマーク付ける
            videoMarking();
            //非IDスレでID付いた画像を加工
            if(DECORATE_ID_RES && !idThread) decoIDRes();
            //レス枠超える文字を省略
            if(ADD_RES_LIST) omitRes();

            //いまココボタンから来たか
            if(mode == "いまココ") {
                // console.log("いまココ\t行個数\t%d\t画面Y\t%f", IMAGE_NUM, window.scrollY);
                for(const [i, el] of [...document.querySelectorAll(`.futaba_lightbox_image_list_container > a${document.querySelector("#ng-style > style") ? ":not(.ng_hidden)" : ""}`)].entries()) {
                    // console.log("%d\t行目\t%d\t枚目\t画像Y\t%f", Math.trunc(i / IMAGE_NUM) + 1, i + 1, el.dataset.y);

                    //一覧を画像がある行までスクロールする
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(i / IMAGE_NUM_S) : aHeight * Math.trunc(i / IMAGE_NUM);
                    //スクロールで表示が流れきってないか届いてない画像の行で抜ける
                    if((window.scrollY - 1) < el.dataset.y) break;
                }
            }

            //レスポップアップ
            if(POP_UP_RES) {
                //一覧を開いてるか
                if(openList) {
                    //レスの収納タグを一覧の最後に再配置
                    ichiran.appendChild(ichiran.querySelector(".tooltip"));
                } else {
                    //レスの収納タグを作る
                    const tooltip = document.createElement("div");
                    tooltip.classList.add("tooltip");
                    smallList ? tooltip.classList.add("small") : tooltip.classList.add("normal");
                    tooltip.style.display = "none";
                    tooltip.style.top = "-500px";
                    tooltip.style.left = "-500px";
                    ichiran.appendChild(tooltip);

                    // 継ぎ足し項目でも動くようにイベント設定
                    if(!mobile) {
                        //枠内にマウスが入ったら
                        ichiran.addEventListener("mouseover", resPopOver);
                        //枠内でマウス動かしたら
                        ichiran.addEventListener("mousemove", resPopMove);
                        //枠を離れたら
                        ichiran.addEventListener("mouseout", resPopOut);
                    } else {
                        //枠内でタッチしたら
                        ichiran.addEventListener("pointerdown", resPopMobile);
                    }
                }
            }
            //一覧を開いてる
            openList = true;
        }

        //一覧閉じる
        function closeImageListView() {
            const listoverlay = document.querySelector(".futaba_lightbox_image_list_overlay");
            if(!listoverlay) return;

            //一覧を区切り良くスクロールするイベント削除
            if(USE_WHEEL_LIST) {
                document.querySelector(".futaba_lightbox_image_list_overlay").removeEventListener("wheel", wheelScroll, {passive: false});
                document.querySelector(".futaba_lightbox_image_list_container").removeEventListener("keydown", keyScroll, {passive: false});
                document.querySelector(".futaba_lightbox_image_list_container").removeEventListener("scroll", calcScrollLine, {passive: true});
            }

            //あぷファイルの差し替え
            if(LOAD_UPFILE_LIST) {
                //あぷファイルの差し替え中を解除
                upReplacing = false;
                //あぷファイルのサムネを移動する
                if(REM_THUMB_TEMP) {
                    listoverlay.style.display = "none";
                    for(const el of Array.from(document.querySelectorAll(".futaba_lightbox_image_list_container > a > span[data-file] > canvas"), el => el.parentElement)) {
                        el.removeAttribute("class");
                        el.removeAttribute("title");
                        el.removeAttribute("style");
                        document.querySelector("upthumb").append(el);
                    }
                }
            }

            listoverlay.remove();
            //bodyのスタイル戻す
            document.body.style.overflow = "";
            document.body.style.paddingRight = "";

            if(mobile && !smallList) { //携帯端末か
                //履歴操作のイベント削除
                window.removeEventListener("popstate", backToThread);
                //ブラウザバック以外で閉じたら戻る履歴が溜まらないよう「戻る」をする(進む履歴が残る)
                if(!bBack) history.back();
                bBack = false;
            }

            //操作パネル戻す
            if(document.querySelector("#akahuku_thread_operator")) document.querySelector("#akahuku_thread_operator").style.display = "block";

            //動画クリック時のイベントを削除
            if(location.hostname.includes("2chan.net") || location.hostname == "kako.futakuro.com") {
                document.body.removeEventListener("click", stopPropagation);
                document.body.removeEventListener("touchstart", stopPropagation);
                document.body.removeEventListener("pointerdown", stopPropagation);
            }

            //いまココボタンの補足を戻す
            if(SHOW_KOKOBTN) document.querySelector(".ichirankoko").setAttribute("title", "画像一覧を見てる位置から開く\n右クリで別サイズの一覧を開く");

            //ウインドウサイズ変更で一覧を調整するイベントを削除
            window.removeEventListener("resize", windowHaba);

            //別タブから戻ったらスキップしてたあぷ動画のサムネ化をやり直すイベントを削除
            if(LOAD_UPFILE_LIST && LOAD_UPFILE_VIDEO) document.removeEventListener("visibilitychange", redrewOnActive);

            //一覧を閉じた
            openList = false;

            //開いてる間に変わった画像数を一覧ボタンに反映
            if(SHOW_IMAGE_COUNT) {
                setTimeout(() => {
                    ichiranImageCount("一覧閉じた")
                }, 100);
            }
        }

        //ふたクロでNG判定されたレスのフィルター
        function futakuroNgFilter(array, mode = "") {
            //設定でフィルターを変える
            if(NG_ALWAYS_HIDDEN) return array.filter(el => !el.closest(".ng_hidden"));
            else {
                if(mode) { //一覧の作成から来たか
                    for(const el of array) {
                        //ふたクロでNG判定されてたら属性付与
                        if(el.closest(".ng_hidden")) el.setAttribute("data-ng", "");
                    }
                    return array;
                }
                else return array.filter(el => !(el.closest(".ng_hidden") && window.getComputedStyle(el.closest(".ng_hidden")).display == "none"));
            }
        }

        //ふたポの過去ログで404画像のサムネをアイコンに置換
        function futapoLogImageReplace(list) {
            for(const el of list) {
                //リンク先が404画像か
                if(el.href.includes("/404.png")) {
                    //属性変更
                    el.setAttribute("data-list", "");
                    //アイコン挿入
                    const spanEl = document.createElement("span");
                    spanEl.innerHTML = stopIcon;
                    el.prepend(spanEl);
                    //サムネ非表示に
                    el.querySelector("img").style.display = "none";
                }
            }
        }
        //使うアイコン
        const stopIcon = `<svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#800000" d="M431.2 476.5L163.5 208.8C141.1 240.2 128 278.6 128 320C128 426 214 512 320 512C361.5 512 399.9 498.9 431.2 476.5zM476.5 431.2C498.9 399.8 512 361.4 512 320C512 214 426 128 320 128C278.5 128 240.1 141.1 208.8 163.5L476.5 431.2zM64 320C64 178.6 178.6 64 320 64C461.4 64 576 178.6 576 320C576 461.4 461.4 576 320 576C178.6 576 64 461.4 64 320z"/></svg>`;

        //同期して削除された画像にマーク付ける準備
        function deletedImageListView(threEl) {
            //消えたレスは一覧に画像があるか
            if(document.querySelector(`.futaba_lightbox_image_list_container > a[data-no="${threEl.querySelector(".cno").textContent}"]:not([data-kie])`)) {
                let listEl;
                let cat;
                //レスの種類
                //あぷファイル込みのレスか
                if([threEl.querySelector("blockquote")].filter(el => /(?<!>(.(?!\\n))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.innerText)).length) {
                    //種類
                    cat = "あぷ";
                    //消えたレスと同じレス番の複数の画像を一覧から探す
                    listEl = [...document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-no="${threEl.querySelector(".cno").textContent}"]`)];
                } else if(/"#ff0000">(書き込み|スレッド|削除依頼)/i.test(threEl.querySelector("blockquote").innerHTML)) {
                    if(threEl.querySelector("a > img")) { //レスに画像があるか
                        cat = "隔離画像";
                    } else {
                        cat = "削除画像";
                    }
                    //消えたレスと同じレス番の画像を一覧から探す
                    listEl = [document.querySelector(`.futaba_lightbox_image_list_container > a[data-no="${threEl.querySelector(".cno").textContent}"]`)];
                } else {
                    cat = "画像だけ";
                    //消えたレスと同じレス番の画像を一覧から探す
                    listEl = [document.querySelector(`.futaba_lightbox_image_list_container > a[data-no="${threEl.querySelector(".cno").textContent}"]`)];
                }
                // console.log(listEl);
                // console.log(cat);
                for(const el of listEl) {
                    //マーク付けに送る
                    deletedImageListViewMark(el, cat);
                }
            }
        }

        //同期して削除された画像にマーク付ける
        function deletedImageListViewMark(el, cat) {
            //後ろに追加ボタン用のタグが無かったら作る
            if(el.nextElementSibling?.className !== "add") {
                const divEl = document.createElement("div");
                divEl.classList.add("add");
                divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                el.after(divEl);
            }

            //削除マークのタグ
            const divEl = document.createElement("div");
            divEl.classList.add("kieta");
            smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
            divEl.style.opacity = 0;
            divEl.textContent = "仮";

            //削除の種類
            if(cat == "あぷ") {
                for(const threEl of document.querySelectorAll(".thre .deleted td.rtd")) {
                    //消えたレスの赤字で判別
                    if(el.dataset.no == threEl.querySelector(".cno").textContent) {
                        if(HIDE_ISOLATION_RES && threEl.querySelector("blockquote").innerHTML.includes('"#ff0000">削除依頼')) {
                            divEl.textContent = "隔離";
                            el.setAttribute("data-list", "kieta"); //グループ分け
                        }
                        if(HIDE_DELETED_RES && threEl.querySelector("blockquote").innerHTML.includes('"#ff0000">スレッド')) {
                            divEl.textContent = "削除";
                            el.setAttribute("data-list", "kieta"); //グループ分け
                        }
                        divEl.style.cursor= "pointer";
                        divEl.addEventListener("click", vMarkClick);
                    }
                }
            } else {
                if(HIDE_ISOLATION_RES && cat == "隔離画像") { //隔離か
                    divEl.textContent = "隔離";
                    divEl.style.cursor= "pointer";
                    divEl.addEventListener("click", vMarkClick);
                    el.setAttribute("data-list", "kieta"); //グループ分け
                } else if(HIDE_DELETED_RES && cat == "削除画像") { //削除か
                    divEl.textContent = "削除";
                    el.setAttribute("data-list", "kieta"); //グループ分け
                    const img = el.querySelector("img"); //画像を参照
                    img.onerror = () => { //読み込めなかったら書き込みをした人によって削除
                        divEl.textContent = "レス消";
                        el.setAttribute("href", "javascript:void(0);"); //リンク丸々消すとふたばのjsでエラー吐く
                        el.removeAttribute("target"); //あると空タブ開くから削除
                        el.removeAttribute("data-list"); //グループ削除
                        el.style.cursor= "default"; //リンクカーソルにしない
                        el.querySelector("img")?.remove(); //画像消す
                        const spanEl = document.createElement("span");
                        el.prepend(spanEl); //挿入
                        if(el.nextElementSibling.querySelector(".vmark")) el.nextElementSibling.querySelector(".vmark").remove(); //動画マークあったら消す
                    };
                } else if(cat == "画像だけ") { //画像だけ削除か
                    divEl.textContent = "画像消";
                    el.setAttribute("data-kie", "");
                    el.setAttribute("href", "javascript:void(0);"); //リンク丸々消すとふたばのjsでエラー吐く
                    el.removeAttribute("target"); //あると空タブ開くから削除
                    el.removeAttribute("data-list"); //グループ削除
                    el.style.cursor= "default"; //リンクカーソルにしない
                    el.querySelector("img")?.remove(); //画像消す
                    const spanEl = document.createElement("span");
                    el.prepend(spanEl); //挿入
                    if(el.nextElementSibling.querySelector(".vmark")) el.nextElementSibling.querySelector(".vmark").remove(); //動画マークあったら消す
                }
            }

            //マーク付け
            if((HIDE_ISOLATION_RES && divEl.textContent == "隔離") || (HIDE_DELETED_RES && ["削除", "消"].includes(divEl.textContent)) || divEl.textContent == "画像消") {
                //マークのタグを挿入
                el.nextElementSibling.append(divEl);
                //透明度初期値
                let markFade = 0;
                let imageFade = 1;
                //フィルター
                let imgBlur = 0;
                let imgGray = 0;
                //マークを徐々に出す
                const fadeIn = setInterval(() => {
                    markFade += 0.1;
                    el.nextElementSibling.querySelector(".kieta").style.opacity = markFade;

                    if (markFade >= 1) {
                        clearInterval(fadeIn);
                        el.nextElementSibling.querySelector(".kieta").style.opacity = 1;
                    }
                }, 50);
                if(!el.style.filter) {
                    //画像を徐々に薄くぼかす
                    const fadeOut = setInterval(() => {
                        imageFade -= 0.05;
                        imgBlur += 0.35;
                        imgGray += 0.07;
                        el.style.filter = `blur(${imgBlur}px) opacity(${imageFade}) grayscale(${imgGray})`;
                        if(el.nextElementSibling.querySelector(".vmark")) el.nextElementSibling.querySelector(".vmark").style.filter = `blur(${imgBlur / 5}px) opacity(${imageFade}) grayscale(${imgGray})`;

                        if (imageFade <= 0.3) {
                            clearInterval(fadeOut);
                            el.style.filter = "blur(5px) opacity(0.3) grayscale(1)";
                            //動画のマークも薄くする
                            if(el.nextElementSibling.querySelector(".vmark")) el.nextElementSibling.querySelector(".vmark").style.filter = "blur(1px) opacity(0.3) grayscale(1)";
                        }
                    }, 50);
                }

                //目印に一覧ボタン点滅
                document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"}`).style.background = "linear-gradient(#FFF, #E40)";
                setTimeout(() => {
                    document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"}`).style.background = "";
                }, 300);
            }
        }

        //一覧にスレ落ちや1000レス到達を表示する
        function showThreadDown() {
            const divEl = document.createElement("div");
            divEl.classList.add("sureochi");
            smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
            divEl.innerHTML = `<span>${res1000 ? "1000レス" : "スレ落ちた"}</span>`;
            //一覧の前に追加
            document.querySelector(".futaba_lightbox_image_list_container").before(divEl);
        }

        //あぷファイル名を含める
        function upUpko(file, tag, no, y) {
            let url;
            let up;
            for(const val of file) {
                if(/u/.test(val)) {
                    url = "https://dec.2chan.net/up2/src/";
                    up = "あぷ小";
                } else {
                    url = "https://dec.2chan.net/up/src/";
                    up = "あぷ";
                }
                //ファイルを読込んでレスを追加する設定の時はアイコンに変える
                if(LOAD_UPFILE_LIST && ADD_RES_LIST) {
                    if(/(mp4|webm)/.test(val)) { //動画か
                        up = `<svg xmlns="http://www.w3.org/2000/svg" height="1rem" width="1rem" viewBox="0 0 512 512">${movIcon}</svg>`;
                    } else {
                        up = `<svg xmlns="http://www.w3.org/2000/svg" height="1rem" width="1rem" viewBox="0 0 512 512">${imgIcon}</svg>`;
                    }
                }
                //バケツではサイトのファイルを読みに行く
                if(location.hostname.includes("ftbucket")) url = location.href.match(/^.+(?=index.htm)/)[0] + "other/";
                //「」ッチーか
                if(location.hostname.includes("tsumanne")) {
                    //あぷ小の画像はサイトのファイルを読みに行く
                    if(/u\d{6,}\.(bmp|jpg|jpeg|gif|png|webp)/.test(val)) url = location.href;
                    //リンクされてたら動画もサイトのファイルを読みに行く
                    if(tag.innerHTML.includes(`<a href="${val}">${val}</a>`)) url = location.href;
                    //赤福のオートリンク先がサイトならそのファイルを読みに行く
                    if(tag.querySelector(`a.akahuku_generated_link[href="${location.href + val}"]`)) url = location.href;
                }

                //レスの置換
                let dataRes = tag.innerHTML;
                // console.log("置換前", dataRes);
                dataRes = dataRes.replace(/<span\sclass="qbtn".+?">(.*?)<\/span>/g, "$1") //フォレストの引用レス表示用のタグ
                    .replace(/\sclass="bns-line-element[^>]+/g, "") //拡張機能「ビーニードルC」の追加クラス
                // .replace(/\t\[<a.+?>link<\/a>\]<br>/g, "") //URLに付くlink
                    .replace(/(?<!<(a|font)[^>]+?)'/g, "&apos;") //タグ壊れ予防、aタグとfontタグ外の ' を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<(a|font)[^>]+?)"/g, "&quot;") //タグ壊れ予防、aタグとfontタグ外の " を文字参照に置換(対になってないとまずい？)
                    .replace(/(?<!<a[^>]+?):/g, "&colon;") //タグ壊れ予防、aタグ外の：を文字参照に置換(IDへの画像レスでなんか壊れてた)
                    .replace(/<div\sclass=&quot;inline.+?\/div>/, "") //インライン再生タグ
                    .replace(/<a[^>]+>(fu?\d{6,}\.[a-z4]{3,4})<\/a>/g, "$1") //あぷへのリンク
                    .replace(/<input.+?>/g, "") //あぷファイル展開タグ
                    .replace(/<span.+?>\[見る\]<\/span>/g, "") //同上
                    .replace(/<small[^>]+akahuku.+?<\/small>/g, "") //同上(赤福)
                    .replace(/<span>(<br>)?<img.+?>(<br>)?<\/span>/g, "") //ふたクロのあぷファイル展開済みタグ
                    .replace(/(?<!&gt;)(fu?\d{6,}\.[a-z4]{3,4})/g, "<font class=upgaG>$1</font>") //あぷファイルのタグ付け
                    .replace(/<details[^>]+previewArea[^>]+>.+?<\/details>/g, "") //ユーザースクリプト「いろいろ自動読み込み [仮]」の追加タグ
                    .replace(/<div[^>]+preview-imageWrap.+?<\/div>(<p.+?<\/p>)?<\/div>/gs, "") //ユーザースクリプト「futaba-image-preview」の追加タグ
                    .replace(/(?:<span[^>]*>)+([\s\S]*?)(?:<\/span>)+/g, "$1") //拡張機能「ビーニードルC」の残り
                ;
                // console.log("置換後", dataRes);

                const upUpko = document.createElement("a");
                upUpko.setAttribute("href", url+val);
                upUpko.setAttribute("target", "_blank");
                upUpko.setAttribute("data-list", "ichiran"); //一覧用
                upUpko.setAttribute("data-from", "up");
                upUpko.setAttribute("data-no", no); //レス番
                upUpko.setAttribute("data-res", dataRes); //レスポップアップ用
                if(SORT_UPFILE_LIST) { //あぷファイルをソートするか
                    upUpko.setAttribute("data-y", y); //レス位置
                }
                //ふたクロでNG判定されてたらクラス追加
                if(tag.hasAttribute("data-ng")) upUpko.classList.add("ng_hidden");
                if(DECORATE_ID_RES && !idThread) { //非IDスレでID付いた画像を加工する設定か
                    if(document.querySelector(".cnw")) {
                        if(tag.parentElement.querySelector(".cnw").textContent.includes("ID:")) upUpko.setAttribute("data-id", "");
                    } else { //フォレスト
                        if(tag.parentElement.querySelector(".c9-3").nextSibling.textContent.includes("ID:")) upUpko.setAttribute("data-id", "");
                    }
                }

                //1レスのあぷファイル数が2以上だったら強調する
                if(upUpko.dataset.res.match(/<font\sclass=upgaG>/g).length > 1) {
                    upUpko.setAttribute("data-res", upUpko.dataset.res
                                        .replace(`<font class=upgaG>${val}</font>`, `<font color=#ff3300>${val}(これ)</font>`) //表示あぷ文字色変え
                                       );
                } else{
                    upUpko.setAttribute("data-res", upUpko.dataset.res
                                        .replace(`<font class=upgaG>${val}</font>`, `<font color=#0000ee>${val}</font>`) //表示あぷ文字色変え
                                       );
                }

                //ファイルを読込む設定でサムネがもうあるか
                if(LOAD_UPFILE_LIST && REM_THUMB_TEMP && document.querySelector(`upthumb > span[data-file="${val}"]`)) {
                    //あぷファイルのサムネを移す
                    const spanEl = document.querySelector(`upthumb > span[data-file="${val}"]`);
                    upUpko.append(spanEl);
                } else {
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("upicon");
                    //ファイルを読込むか
                    if(LOAD_UPFILE_LIST) {
                        if(ADD_RES_LIST) { //レスを追加する設定か
                            //読込み前のアイコンを表示
                            spanEl.innerHTML = beforeLoad;
                        } else {
                            //リンクアイコン+ファイル名を表示
                            spanEl.innerHTML = `<br>${linkIcon}<br><font style="font-size: 0.8em;">${val.replace(/\..+$/, "")}</font>`;
                        }
                    } else {
                        if(/(mp4|webm)/.test(val)) { //動画か
                            if(ADD_RES_LIST) { //レスを追加する設定か
                                spanEl.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${movIcon}</svg>`;
                            } else {
                                spanEl.innerHTML = `<br><svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${movIcon}</svg><br><font style="font-size:0.8em;">${val.replace(/\..+$/, "")}</font>`;
                            }
                        } else {
                            if(ADD_RES_LIST) {
                                spanEl.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${imgIcon}</svg>`;
                            } else {
                                spanEl.innerHTML = `<br><svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${imgIcon}</svg><br><font style="font-size:0.8em">${val.replace(/\..+$/, "")}</font>`;
                            }
                        }
                    }
                    upUpko.appendChild(spanEl);
                }

                //一覧に追加するレスのタグ
                if(ADD_RES_LIST) {
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("res");
                    spanEl.innerHTML = `${up}<font style='color:#33E'>${val}</font>`;
                    upUpko.appendChild(spanEl);
                }

                //一覧の最後に足していく
                document.querySelector(".futaba_lightbox_image_list_container").appendChild(upUpko);
            }
        }
        //使うアイコン
        const imgIcon = `<!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#800000" d="M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM323.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l96 0 32 0 208 0c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176zM112 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/>`;
        const movIcon = `<!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#800000" d="M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM48 368l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L64 96c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM160 128l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L192 96c-17.7 0-32 14.3-32 32zm32 160c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0z"/>`;
        const beforeLoad = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512"><g><path fill="#800000" d="M511.878,247.973l-21.488,0.672l21.488-0.68c-2.168-69.219-31.732-131.348-77.876-175.949 C387.882,27.377,324.93-0.004,256.13,0.004c-2.718,0-5.443,0.046-8.176,0.13h0.016C178.743,2.294,116.622,31.858,72.013,78.002 C27.382,124.122,0,187.074,0,255.874c0,2.709,0.046,5.435,0.13,8.16c2.168,69.22,31.732,131.347,77.875,175.949 c46.113,44.632,109.065,72.02,177.865,72.013c2.694,0,5.42-0.038,8.16-0.13c69.227-2.16,131.355-31.724,175.957-77.876 c44.64-46.121,72.021-109.065,72.013-177.857C512,253.416,511.962,250.699,511.878,247.973z M102.921,107.894 c19.64-20.29,43.274-36.647,69.67-47.891c-10.961,15.77-20.336,34.426-28.045,55.304H96.089 C98.303,112.779,100.585,110.306,102.921,107.894z M75.692,142.664h60.112c-8.282,30.212-13.327,63.906-14.365,99.661H43.472 C45.77,205.914,57.243,171.938,75.692,142.664z M75.647,369.344c-18.351-29.121-29.808-63.044-32.144-99.661h78.028 c1.046,35.732,5.954,69.471,14.236,99.661H75.647z M107.898,409.083c-4.091-3.962-7.984-8.114-11.748-12.381h48.442 c4.099,11.091,8.579,21.67,13.594,31.396c4.405,8.518,9.16,16.487,14.252,23.847C148.37,441.654,126.523,427.082,107.898,409.083z  M242.329,468.524c-5.931-0.374-11.809-0.946-17.603-1.801c-2.404-1.573-4.809-3.282-7.213-5.236 c-16.381-13.313-31.778-35.831-43.694-64.784h68.51V468.524z M242.329,369.344h-78.15c-8.794-29.411-14.267-63.365-15.381-99.661 h93.531V369.344z M242.329,242.325h-93.448c1.115-36.327,6.618-70.235,15.42-99.661h78.028V242.325z M242.329,115.306h-68.433 c2.71-6.588,5.542-12.954,8.595-18.84c10.298-19.969,22.404-35.647,35.022-45.945c2.366-1.924,4.732-3.604,7.099-5.16 c5.832-0.862,11.74-1.48,17.717-1.863V115.306z M436.369,142.664c18.351,29.128,29.8,63.044,32.136,99.661h-78.02 c-1.046-35.732-5.954-69.471-14.236-99.661H436.369z M404.11,102.917c4.092,3.961,7.985,8.114,11.756,12.389h-48.441 c-4.099-11.092-8.58-21.672-13.596-31.396c-4.412-8.527-9.167-16.496-14.267-23.847C363.63,70.353,385.484,84.918,404.11,102.917z  M269.687,43.476c5.924,0.374,11.801,0.954,17.587,1.802c2.412,1.58,4.824,3.282,7.229,5.244 c16.381,13.32,31.778,35.823,43.686,64.784h-68.502V43.476z M269.687,142.664h78.15c8.794,29.411,14.267,63.364,15.381,99.661 h-93.531V142.664z M269.687,269.683h93.448c-1.114,36.327-6.618,70.242-15.42,99.661h-78.028V269.683z M329.525,415.534 c-10.297,19.976-22.412,35.655-35.022,45.953c-2.359,1.924-4.725,3.595-7.091,5.152c-5.832,0.863-11.74,1.481-17.725,1.862v-71.799 h68.426C335.402,403.289,332.57,409.648,329.525,415.534z M409.087,404.106c-19.64,20.29-43.266,36.64-69.655,47.884 c10.962-15.771,20.328-34.419,28.037-55.288h48.449C413.698,399.22,411.423,401.694,409.087,404.106z M436.308,369.344h-60.105 c8.29-30.206,13.336-63.906,14.374-99.661h77.952C466.23,306.086,454.757,340.07,436.308,369.344z"></path></g></svg>`;
        const linkIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512"><g><path fill="#800000" d="M509.445,113.129c-2.547-13.219-7.047-26.141-13.453-38.359c-6.391-12.203-14.75-23.641-24.938-33.828 c-13.563-13.578-29.406-23.875-46.265-30.719c-25.297-10.219-52.828-12.781-79.266-7.656c-13.219,2.563-26.156,7-38.359,13.422 c-12.172,6.422-23.641,14.75-33.828,24.953l-66.25,66.25c-13.375,13.344-13.375,35.047,0,48.391s35.031,13.344,48.391,0 l66.25-66.281c7.031-7,15.016-12.172,23.594-15.672c12.844-5.203,27.031-6.531,40.547-3.906c6.75,1.313,13.328,3.594,19.531,6.844 c6.188,3.25,12,7.469,17.281,12.734c7.031,7.078,12.187,15.047,15.687,23.609c5.203,12.844,6.531,27.047,3.906,40.547 c-1.313,6.766-3.594,13.344-6.828,19.516c-3.281,6.219-7.484,12.031-12.765,17.313l-66.25,66.234 c-13.359,13.359-13.359,35.047,0,48.391s35.016,13.344,48.375,0l66.25-66.265c13.594-13.563,23.875-29.406,30.703-46.266 C512.008,167.083,514.555,139.551,509.445,113.129z"></path><path fill="#800000" d="M256.54,356.426l-66.266,66.266c-7.047,7.016-15.031,12.188-23.594,15.672 c-12.844,5.219-27.047,6.547-40.547,3.938c-6.766-1.328-13.328-3.625-19.531-6.859c-6.188-3.266-12-7.5-17.281-12.75 c-7.031-7.063-12.203-15.031-15.688-23.609c-5.203-12.828-6.531-27.031-3.922-40.563c1.313-6.75,3.609-13.328,6.844-19.516 c3.281-6.188,7.484-12,12.766-17.297l66.266-66.25c13.344-13.344,13.344-35.016,0-48.359c-13.375-13.359-35.031-13.359-48.391,0 l-66.25,66.234c-13.594,13.594-23.875,29.406-30.719,46.297c-10.234,25.266-12.781,52.844-7.672,79.219 c2.547,13.219,7.031,26.156,13.453,38.359c6.406,12.203,14.75,23.672,24.938,33.844c13.594,13.578,29.406,23.891,46.266,30.688 c25.281,10.266,52.844,12.813,79.25,7.703c13.234-2.563,26.156-7.047,38.344-13.453c12.203-6.391,23.672-14.75,33.859-24.938 l66.25-66.266c13.344-13.344,13.344-35.016,0-48.359C291.54,343.066,269.883,343.066,256.54,356.426z"></path><path fill="#800000" d="M342.43,169.567c-13.344-13.344-35.016-13.344-48.375,0l-124.516,124.5c-13.344,13.359-13.344,35.016,0,48.359 c13.375,13.375,35.047,13.375,48.391,0l124.5-124.5C355.805,204.567,355.805,182.926,342.43,169.567z"></path></g></svg>`;


        //あぷファイルを1つずつ差し替える
        function upIconReplace() {
            if(upReplacing) return;
            upReplacing = true;
            //エラーだったあぷファイル置換のリトライ中か
            let upRepRetry = false;
            //動画のメタデータを読込んだか
            let metaReady = false;
            //読込みスキップタイマー
            let waitTimer;
            //2度目以降のスキップを減らす時間
            let waitNthTime;

            //サムネ避難所
            if(REM_THUMB_TEMP && !document.querySelector("upthumb")) {
                const el = document.createElement("upthumb");
                document.body.after(el);
            }

            //イベント登録用
            //動画のメタデータを読込んだら
            const videoLoadedmetadata = (videoEl) => {
                if(document.querySelector(".futaba_lightbox_image_list_container")) {
                    //読込みスキップタイマー解除
                    clearTimeout(waitTimer);

                    upRepRetry = false;
                    metaReady = true;
                    //動画の0秒に移動(追加でどれだけ読込むかは動画の作りによる)
                    videoEl.currentTime = 0;
                }
            };
            //動画の再生位置部分のデータが集まったら
            const videoLoadeddata = (upFileEl, videoEl, canvasEl) => {
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    //メタデータ読込み済みか
                    if(metaReady) {
                        //スキップしたあぷファイル名セットにあったら削除
                        if(upWaitedFiles.has(upFileEl.href.match(/fu?\d{6,}\..+$/)[0])) upWaitedFiles.delete(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);

                        setTimeout(() => {
                            //canvasタグに動画の1フレームだけ描写
                            canvasDrawImage(canvasEl, videoEl);

                            if(upFileEl.querySelector("span.upicon")) {
                                //アイコン削除
                                upFileEl.querySelector("span.upicon").remove();
                                //canvas入れる位置調整用span要素
                                {
                                    const spanEl = document.createElement("span");
                                    spanEl.classList.add("video");
                                    spanEl.setAttribute("data-file", upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                                    //spanにcanvas追加
                                    spanEl.append(canvasEl);
                                    //span追加
                                    upFileEl.prepend(spanEl);
                                }
                                //準備中アイコン入れるspan要素
                                {
                                    const spanEl = document.createElement("span");
                                    spanEl.classList.add("easelicon");
                                    spanEl.innerHTML = easelIcon;
                                    upFileEl.prepend(spanEl);
                                    setTimeout(() => {
                                        spanEl.querySelector("svg").classList.add("hidden");
                                    }, 200);
                                }
                                //繰り返す
                                rep();
                            }
                            //サムネ化失敗の保険
                            setTimeout(() => {
                                //canvasタグに動画の1フレームだけ再描写
                                canvasDrawImage(canvasEl, videoEl, true);
                            }, 1000);
                        }, WAIT_THUMBNAIL_MAKE);
                    } else { //先にこっち来たらやり直す
                        //読込みスキップタイマー解除
                        clearTimeout(waitTimer);

                        //動画を止めて空にしてリセット
                        videoEl.pause();
                        videoEl.removeAttribute("src");
                        videoEl.load();

                        //リトライ
                        upRepRetry = true;
                        setTimeout(rep, 100);
                        return;
                    }
                } else {
                    //もう一覧閉じてたら一応空にしておく
                    videoEl.pause();
                    videoEl.removeAttribute("src");
                    videoEl.load();
                }
            };
            //画像を読込んだら
            const imgLoad = (upFileEl, imgEl) => {
                //読込みスキップタイマー解除
                clearTimeout(waitTimer);
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    //スキップしたあぷファイル名セットにあったら削除
                    if(upWaitedFiles.has(upFileEl.href.match(/fu?\d{6,}\..+$/)[0])) upWaitedFiles.delete(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);

                    upRepRetry = false;
                    //アイコン削除
                    upFileEl.querySelector("span.upicon").remove();
                    // 読込んだ画像を差し込む
                    upFileEl.prepend(imgEl);
                    //console.log("読込んだ！")

                    //アニメーション画像の動きを止め(たように見せ)るためにサムネをcanvasに描く
                    //imgタグを非表示に
                    imgEl.style.display = "none";
                    //canvasタグ
                    const canvasEl = document.createElement("canvas");
                    //canvasタグにアニメーション画像の1フレームだけ描写
                    canvasDrawImage(canvasEl, imgEl);
                    //canvas入れる位置調整用span
                    const spanEl = document.createElement("span");
                    spanEl.setAttribute("data-file", upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                    //spanにcanvas追加
                    spanEl.append(canvasEl);
                    //imgの後にspan追加
                    imgEl.after(spanEl);
                    //imgタグ削除
                    imgEl.remove();

                    //繰り返す
                    rep();
                } else {
                    //もう一覧閉じてたら一応空にしておく
                    imgEl.removeAttribute("src");
                }
            };
            //失敗したら
            const error = (upFileEl, mediaEl) => {
                //読込みスキップタイマー解除
                clearTimeout(waitTimer);
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    //エラーだったあぷファイルを除外するか
                    if(OMIT_ERROR_UPFILE) {
                        if(!upRepRetry) {
                            //リトライ
                            upRepRetry = true;
                            setTimeout(rep, 100);
                            return;
                        } else {
                            //リトライして駄目だったあぷファイル名を追加
                            upErrFiles.add(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                            // console.log(upFileList[0].href.match(/fu?\d{6,}\..+$/)[0]);
                            // console.log(upErrFiles);
                            upRepRetry = false;
                        }
                    }
                    // console.log(upFileList[0]);
                    //属性追加
                    upFileEl.setAttribute("data-404", upFileEl.href);
                    //属性削除
                    upFileEl.removeAttribute("href");
                    upFileEl.removeAttribute("data-list");
                    //アイコン変更
                    upFileEl.querySelector("span.upicon").innerHTML = `<br>${errorIcon}<br>`;
                    if(OMIT_ERROR_UPFILE) { //エラーだったあぷファイルを除外するか
                        upFileEl.querySelector("span.upicon").innerHTML += "<span>次回除外</span>";
                    } else {
                        upFileEl.querySelector("span.upicon").innerHTML += "<span>無いかも</span>";
                    }
                    //クラス削除
                    upFileEl.querySelector("span.upicon").classList.remove("upicon");
                    //繰り返す
                    rep();
                }
                //一応空にしておく
                if(mediaEl.tagNmae == "VIDEO") { //動画か
                    mediaEl.pause();
                    mediaEl.removeAttribute("src");
                    mediaEl.load();
                } else { //画像
                    mediaEl.removeAttribute("src");
                }
            }
            //読込みスキップ
            const skip = (upFileEl) => {
                //読込みスキップタイマー解除
                clearTimeout(waitTimer);
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    upRepRetry = false;
                    // console.log(upWaitedFiles);
                    //アイコン変更
                    upFileEl.querySelector("span.upicon").innerHTML = skipIcon;
                    //クラス削除
                    upFileEl.querySelector("span.upicon").classList.remove("upicon");
                    //属性変更
                    upFileEl.setAttribute("data-skip", "");
                    //繰り返す
                    rep();
                }
            };
            //読込み時間超過
            const waited = (upFileEl, mediaEl) => {
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    upRepRetry = false;
                    //スキップしたあぷファイル名を追加
                    upWaitedFiles.add(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                    // console.log(upWaitedFiles);
                    //アイコン変更
                    upFileEl.querySelector("span.upicon").innerHTML = waitedIcon;
                    //クラス削除
                    upFileEl.querySelector("span.upicon").classList.remove("upicon");
                    //属性変更
                    upFileEl.setAttribute("data-list", "");
                    upFileEl.setAttribute("data-waited", "");
                    //繰り返す
                    rep();
                }
                //一応空にしておく
                if(mediaEl.tagNmae == "VIDEO") { //動画か
                    mediaEl.pause();
                    mediaEl.removeAttribute("src");
                    mediaEl.load();
                } else { //画像
                    mediaEl.removeAttribute("src");
                }
            };

            //差し替え
            const rep = () => {
                //アイコン表示のあぷファイル
                const upFileList = Array.from(document.querySelectorAll(".futaba_lightbox_image_list_container span.upicon"), el => el.parentElement);
                //console.log("残り: ", upFileList.length);
                //残ってたら先頭の1つを処理する
                if(upFileList.length) {

                    //console.log("読み込み中");
                    //動画か
                    if(/(mp4|webm)/.test(upFileList[0].href)) {
                        //リンク先の動画に差し替えるか
                        if(LOAD_UPFILE_VIDEO) {
                            //ページが非アクティブ(別タブ中)だと制限で失敗するからスキップする
                            if(document.visibilityState === "hidden") {
                                skip(upFileList[0]);
                                return;
                            }
                            if(!upRepRetry) { //リトライ中じゃなければ
                                //ローディングアイコンに変える
                                upFileList[0].querySelector("span.upicon").innerHTML = loadingIcon;
                            }
                            metaReady = false;

                            //canvas要素
                            const canvasEl = document.createElement("canvas");
                            //video要素
                            const videoEl = document.createElement("video");
                            videoEl.preload = "metadata"; //メタデータのみ読込みたい(様々な都合で駄目な時は駄目)
                            //メタデータが読込まれたら実行
                            videoEl.addEventListener("loadedmetadata", () => videoLoadedmetadata(videoEl), {once: true});
                            //再生位置部分のデータが集まったら実行
                            videoEl.addEventListener("loadeddata", () => videoLoadeddata(upFileList[0], videoEl, canvasEl), {once: true});
                            //読込み失敗！
                            videoEl.addEventListener("error", () => error(upFileList[0], videoEl), {once: true});
                            //動画のsrc設定してイベント発火
                            videoEl.src = upFileList[0].href;

                            //ファイル名がupWaitedFilesに残ってたら待ち時間半分にする
                            if(upWaitedFiles.has(upFileList[0].href.match(/fu?\d{6,}\..+$/)[0])) {
                                waitNthTime = LOAD_WAIT_TIME / 2;
                            } else {
                                waitNthTime = 0;
                            }
                            //読込みスキップタイマー
                            waitTimer = setTimeout(() => {
                                waited(upFileList[0], videoEl);
                            }, LOAD_WAIT_TIME - waitNthTime);
                        } else { //動画の代替アイコンに変えるだけ
                            //アイコン変更
                            upFileList[0].querySelector("span.upicon").innerHTML = playIcon;
                            //クラス削除
                            upFileList[0].querySelector("span.upicon").classList.remove("upicon");
                            //console.log("変えた！")
                            //繰り返す
                            rep();
                        }
                    } else { //動画じゃない
                        //ローディングアイコンに変える
                        upFileList[0].querySelector("span.upicon").innerHTML = loadingIcon;
                        //画像要素の用意
                        const imgEl = document.createElement("img");
                        imgEl.src = upFileList[0].href;
                        imgEl.setAttribute("align", "left");
                        //読込まれたら実行
                        imgEl.addEventListener("load", () => imgLoad(upFileList[0], imgEl), {once: true});
                        //読込み失敗！
                        imgEl.addEventListener("error", () => error(upFileList[0], imgEl), {once: true});

                        //ファイル名がupWaitedFilesに残ってたら待ち時間半分にする
                        if(upWaitedFiles.has(upFileList[0].href.match(/fu?\d{6,}\..+$/)[0])) {
                            waitNthTime = LOAD_WAIT_TIME / 2;
                        } else {
                            waitNthTime = 0;
                        }
                        //読込みスキップタイマー
                        waitTimer = setTimeout(() => {
                            waited(upFileList[0], imgEl);
                        }, LOAD_WAIT_TIME - waitNthTime);
                    }
                } else {
                    //読込みスキップタイマー解除
                    clearTimeout(waitTimer);
                    //差し替え中を解除
                    upReplacing = false;
                }
            };
            //差し替え実行
            rep();
        }
        //使うアイコン
        const playIcon = `<svg xmlns="http://www.w3.org/2000/svg" height="30%" width="30%" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#800000" d="M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM188.3 147.1c-7.6 4.2-12.3 12.3-12.3 20.9l0 176c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88c-7.4-4.5-16.7-4.7-24.3-.5z"/></svg>`;
        const loadingIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512" style="animation:rotate 0.4s steps(8) infinite;"><g><path fill="#800000" d="M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/><path fill="#8000006D" d="M304 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/><path fill="#800000B6" d="M48 304a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/><path fill="#80000024" d="M512 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/><path fill="#80000091" d="M142.9 437A48 48 0 1 0 75 369.1 48 48 0 1 0 142.9 437z"/><path fill="#800000DA" d="M142.9 142.8A48 48 0 1 0 75 75a48 48 0 1 0 67.9 67.9z"/><path fill="#80000048" d="M369.1 437A48 48 0 1 0 437 369.1 48 48 0 1 0 369.1 437z"/></g></svg>`;
        const easelIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"height="30%" width="30%" viewBox="0 0 512 512"><g><path fill="#800000" d="M436.304,329.338h-56l-0.46-9.016l-1.289-25.629l-31.871-19.116l1.515,30.092H131.036l10.922-216.9H337.27 l3.377,67.043c3.316,1.312,6.49,2.986,9.362,5.134l22.668,17.058l-6.053-120.111H262.771V0h-46.314v57.892H112.605L98.923,329.338 H33.071v46.314h76.285L66.789,512h48.47l42.56-136.349h58.639v105.488h46.314V375.651h58.639L363.969,512h48.47l-42.567-136.349 h76.285v-41.225c-2.246-0.859-4.44-1.84-6.512-3.083L436.304,329.338z"></path><path fill="#800000" d="M306.19,169.493c1.108-13.659-5.239-26.881-16.576-34.509c-12.942-8.714-29.866-12.513-47.655-10.704 c-16.946,1.711-31.961,8.322-41.226,18.091l-1.983,2.111l2.571,1.342c0,0,2.54,1.44,7.372,6.302 c5.843,5.895,10.373,12.603,14.767,19.101c6.43,9.498,13.094,19.328,23.843,26.58c11.337,7.643,25.968,8.548,38.203,2.412 l0.505-0.272l20.142-29.896L306.19,169.493z M279.634,192.514c-8.805,3.755-19.139,2.79-27.054-2.547 c-3.649-2.458-6.762-5.292-9.581-8.383c-6.378-8.79-0.128-12,3.543-10.87c6.422,1.968,10.606,3.633,12.264,0.769 c2.759-4.749-3.912-7.922-6.634-11.088c-2.721-3.143-1.372-9.747,8.337-5.835c7.734,3.098,13.802-2.148,6.732-8.691 c-7.063-6.521-1.138-10.735,5.413-8.684c0.587,0.173,1.146,0.324,1.68,0.452c3.588,1.394,6.958,3.136,10.003,5.179 c7.907,5.329,12.695,14.548,12.521,24.114L279.634,192.514z"></path><path fill="#800000" d="M306.04,224.174l19.878,11.94l28.734-42.696l-18.513-13.93c-4.093-3.06-9.264-4.326-14.315-3.482 c-5.036,0.859-9.52,3.738-12.377,7.975l-9.288,13.795c-2.857,4.236-3.836,9.467-2.736,14.458 C298.539,217.224,301.652,221.544,306.04,224.174z"></path><path fill="#800000" d="M471.733,281.524l-110.501-83.145l-28.26,41.972l118.573,71.129c8.224,4.93,18.876,2.564,24.235-5.382 l0.068-0.106C481.209,298.047,479.407,287.283,471.733,281.524z"></path></g></svg>`;
        const errorIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="20%" width="20%" viewBox="0 0 512 512"><g><path d="M509.599,106.456c-2.406-12.453-6.641-24.625-12.672-36.109s-13.891-22.234-23.469-31.813c-12.75-12.781-27.672-22.484-43.531-28.906c-23.812-9.641-49.718-12.016-74.593-7.234C342.912,4.8,330.771,9.019,319.24,15.065c-11.469,6.016-22.25,13.859-31.844,23.469l-62.344,62.328c-12.563,12.578-12.563,32.953,0,45.516c12.594,12.578,32.984,12.578,45.547,0l62.328-62.328c6.625-6.625,14.141-11.453,22.219-14.766c12.078-4.906,25.453-6.141,38.141-3.703c6.375,1.266,12.578,3.406,18.375,6.453c5.844,3.047,11.297,7.063,16.281,12.016c6.625,6.625,11.484,14.125,14.766,22.172c4.891,12.109,6.141,25.484,3.672,38.172c-1.219,6.344-3.359,12.594-6.453,18.391c-3.031,5.859-7.016,11.297-11.984,16.266l-62.343,62.375c-12.547,12.547-12.547,32.922,0,45.5c12.578,12.563,32.938,12.563,45.516,0l62.343-62.359c12.797-12.75,22.469-27.656,28.922-43.531C512.021,157.222,514.396,131.315,509.599,106.456z" style="fill:rgb(128,0,0);"></path><path d="M241.396,365.597l-62.359,62.344c-6.609,6.625-14.125,11.484-22.188,14.734c-12.078,4.922-25.453,6.172-38.141,3.703c-6.375-1.25-12.563-3.375-18.391-6.438c-5.828-3.078-11.313-7.031-16.281-12c-6.578-6.625-11.484-14.141-14.75-22.203c-4.906-12.078-6.172-25.453-3.656-38.172c1.219-6.328,3.359-12.531,6.406-18.359c3.094-5.828,7.063-11.297,12-16.281l62.375-62.344c12.547-12.547,12.547-32.938,0-45.516c-12.563-12.594-32.953-12.594-45.516,0l-62.391,62.328c-12.75,12.781-22.469,27.672-28.859,43.547c-9.656,23.813-12.047,49.734-7.25,74.609c2.422,12.391,6.625,24.547,12.672,36.047c6.031,11.5,13.859,22.281,23.438,31.859c12.813,12.75,27.703,22.469,43.547,28.891c23.828,9.641,49.734,12.063,74.594,7.25c12.422-2.438,24.641-6.641,36.078-12.656c11.516-6.063,22.297-13.891,31.844-23.484l62.359-62.344c12.578-12.563,12.578-32.984,0-45.516C274.365,353.019,253.958,353.019,241.396,365.597z" style="fill:rgb(128,0,0);"></path><path d="M354.912,157.097c-12.578-12.578-32.953-12.578-45.531,0l-51.375,51.344l3.297,19.094l32.672,5.938l5.313,24.75l55.625-55.641C367.458,190.019,367.458,169.644,354.912,157.097z" style="fill:rgb(128,0,0);"></path><path d="M157.099,354.925c12.578,12.531,32.938,12.531,45.5,0l61.547-61.531l-5.313-24.797l-32.672-5.938l-3.266-19.094l-65.797,65.828C144.521,321.925,144.521,342.331,157.099,354.925z" style="fill:rgb(128,0,0);"></path><polygon points="190.833,108.003 181.068,37.331 148.146,45.175 171.427,112.644" style="fill:rgb(128,0,0);"></polygon><polygon points="123.927,160.925 61.568,126.222 48.083,157.284 115.943,179.206" style="fill:rgb(128,0,0);"></polygon><polygon points="318.271,397.69 328.037,468.331 360.958,460.487 337.677,393.05" style="fill:rgb(128,0,0);"></polygon><polygon points="385.208,344.737 447.536,379.425 461.036,348.409 393.162,326.425" style="fill:rgb(128,0,0);"></polygon></g></svg>`;
        const skipIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" viewBox="0 0 512 512"><g><path d="M434.115,239.04l-33.036-46.148c-8.024-10.894-18.451-19.779-30.478-25.988l-67.478-35.418c-15.591-6.356-26.846-11.578-43.15-12.33l-18.842-0.537c-11.675-0.196-23.536,3.475-31.689,11.841l-64.217,57.638l-55.627,15.258c-10.534,2.9-16.957,13.531-14.624,24.201l0.196,0.821c2.294,10.494,12.3,17.435,22.942,15.922l44.81-6.394c11.178-1.591,21.966-5.223,31.826-10.709l27.081-18.275l1.386,89.883c-0.274,7.234-0.43,12.173-3.466,17.455l-91.835,159.518c-6.561,11.374-2.685,25.9,8.649,32.51l0.791,0.459c10.729,6.257,24.455,3.241,31.562-6.932l104.908-148.37l40.182,87.94c3.105,4.09,6.863,7.634,11.129,10.485l80.189,53.704c10.094,6.765,23.722,4.617,31.259-4.93l0.899-1.152c3.856-4.892,5.584-11.12,4.822-17.31c-0.772-6.179-3.983-11.793-8.923-15.59l-69.158-53.138l-40.045-113.166l3.573-101.441l48.012,14.418l50.492,49.574c6.346,6.238,16.304,6.932,23.45,1.63l0.489-0.361C438.117,258.233,439.875,247.074,434.115,239.04z" style="fill:rgb(128,0,0);"></path><path d="M239.735,99.221c27.227,4.169,52.688-14.536,56.867-41.773c4.158-27.237-14.546-52.698-41.784-56.867c-27.237-4.168-52.698,14.536-56.857,41.774C193.783,69.593,212.497,95.053,239.735,99.221z" style="fill:rgb(128,0,0);"></path></g></svg><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" viewBox="0 0 512 512"><g><path d="M462.543,329.338h-65.852l-0.46-9.016L383.009,57.892H279.157V0h-46.314v57.892H128.991L115.31,329.338H49.457v46.314h76.285L83.175,512h48.47l42.559-136.349h58.639v105.488h46.314V375.651h58.638L380.356,512h48.47l-42.568-136.349h76.285V329.338z M147.422,305.668l10.923-216.9h195.311l10.93,216.9H147.422z" style="fill:rgb(128,0,0);"></path></g></svg>`;
        const waitedIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512"><g><path d="M329.364,237.908l42.558-39.905c25.236-23.661,39.552-56.701,39.552-91.292V49.156c0.009-13.514-5.53-25.918-14.402-34.754C388.235,5.529,375.833-0.009,362.318,0H149.681c-13.514-0.009-25.926,5.529-34.763,14.401c-8.871,8.837-14.41,21.24-14.392,34.754v57.554c0,34.591,14.315,67.632,39.552,91.292l42.55,39.888c2.342,2.205,3.678,5.271,3.678,8.492v19.234c0,3.221-1.336,6.279-3.669,8.476l-42.558,39.905c-25.237,23.652-39.552,56.701-39.552,91.292v57.554c-0.018,13.515,5.522,25.918,14.392,34.755c8.838,8.871,21.249,14.41,34.763,14.401h212.636c13.515,0.009,25.918-5.53,34.755-14.401c8.871-8.838,14.41-21.24,14.402-34.755V405.29c0-34.591-14.316-67.64-39.552-91.292l-42.55-39.897c-2.352-2.205-3.678-5.263-3.678-8.484v-19.234C325.694,243.162,327.021,240.096,329.364,237.908z M373.946,462.844c-0.009,3.273-1.274,6.056-3.411,8.218c-2.162,2.136-4.944,3.402-8.218,3.41H149.681c-3.273-0.009-6.064-1.274-8.226-3.41c-2.136-2.162-3.393-4.945-3.402-8.218V405.29c0-24.212,10.026-47.356,27.691-63.91l42.55-39.906c9.914-9.285,15.539-22.273,15.539-35.857v-19.234c0-13.592-5.625-26.58-15.547-35.866l-42.542-39.896c-17.666-16.554-27.691-39.69-27.691-63.91V49.156c0.009-3.273,1.266-6.055,3.402-8.226c2.162-2.127,4.953-3.394,8.226-3.402h212.636c3.273,0.008,6.056,1.274,8.218,3.402c2.136,2.171,3.402,4.952,3.411,8.226v57.554c0,24.22-10.026,47.356-27.692,63.91l-42.55,39.896c-9.914,9.286-15.538,22.274-15.538,35.866v19.234c0,13.584,5.625,26.572,15.547,35.874l42.541,39.88c17.666,16.563,27.692,39.707,27.692,63.919V462.844z" style="fill: rgb(128, 0, 0);"></path><path d="M237.261,378.95l-77.33,77.33h192.128l-77.33-77.33C264.385,368.614,247.615,368.614,237.261,378.95z" style="fill: rgb(128, 0, 0);"></path></g></svg>
`;

        //画像一覧にボタン追加
        function makeButton() {
            //まだdiv.addが無ければ各aタグの直後にボタンの基準位置用に追加
            for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a")) {
                if(el.nextElementSibling?.className !== "add") {
                    const divEl = document.createElement("div");
                    divEl.classList.add("add");
                    divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                    el.after(divEl);
                }
            }

            if(USE_DLBTN) { //画像一覧に画像を保存するボタン追加
                for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > div.add")) {
                    if(!el.querySelector("div.DLB")) {
                        const divEl = document.createElement("div");
                        divEl.classList.add("DLB");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.setAttribute("title", "ダウンロード");
                        divEl.textContent = "保存";
                        divEl.addEventListener("click", dlbClick);
                        el.appendChild(divEl);
                    }
                }
            }
            if(USE_JUMPBTN) { //画像一覧の画像にレスに飛ぶボタン追加
                for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > div.add")) {
                    if(!el.querySelector("div.tores")) {
                        const divEl = document.createElement("div");
                        divEl.classList.add("tores");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.setAttribute("title", "レスに飛ぶ");
                        divEl.textContent = smallList ? "飛ぶ" : "戻る";
                        divEl.addEventListener("click", toresClick);
                        el.appendChild(divEl);
                    }
                }
            }
            if(USE_EXCLBTN) { //画像一覧の画像に除外ボタン追加
                for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > div.add")) {
                    if(!el.querySelector("div.excl")) {
                        const divEl = document.createElement("div");
                        divEl.classList.add("excl");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.setAttribute("title", "一覧から除外");
                        divEl.innerHTML = exclIcon;
                        divEl.addEventListener("click", exclClick);
                        el.appendChild(divEl);

                        //レスポップアップちらつき対策用
                        const spanEl = document.createElement("span");
                        divEl.append(spanEl);
                    }
                }
            }

            //一覧に追加したボタンをマウスオーバーで表示させる
            if(!openList) { //一覧を開く毎に1回だけ実行
                const container = document.querySelector(".futaba_lightbox_image_list_container");
                //継ぎ足し項目でも動くようにイベント設定
                //枠内に入ったらボタンを半透明で表示
                container.addEventListener("mouseover", event => {
                    if(event.target.closest("a, .excl, .tores, .DLB, .kieta")) {
                        //まず表示されてるボタン隠す
                        for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                            el.style.opacity = "";
                            event.target.style.background = "";
                        }
                    }
                    if(event.target.closest("a")) {
                        for(const el of event.target.closest("a").nextElementSibling.querySelectorAll(".excl, .tores, .DLB")) {
                            if(el.classList.contains("excl")) {
                                el.style.opacity = 1;
                            } else {
                                el.style.opacity = 0.5;
                                event.target.style.background = "";
                            }
                        }
                    }
                    if(event.target.closest(".kieta, .iddeta")) {
                        for(const el of event.target.closest(".kieta, .iddeta").parentElement.querySelectorAll(".excl, .tores, .DLB")) {
                            if(el.classList.contains("excl")) {
                                el.style.opacity = 1;
                            } else {
                                el.style.opacity = 0.5;
                                event.target.style.background = "";
                            }
                        }
                    }
                });
                //離れたらボタン非表示
                container.addEventListener("mouseout", event => {
                    for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                        if(event.target.closest(".excl")) {
                            //アイコンの切替
                            event.target.closest(".excl").children[0].style.display = "";
                            event.target.closest(".excl").children[1].style.display = "";
                        }
                        el.style.opacity = "";
                        event.target.style.background = "";
                    }
                });
                if(USE_DLBTN) {
                    //DLボタンにマウス乗せたら
                    container.addEventListener("mouseover", event => {
                        if(event.target.closest(".DLB")) {
                            //まず表示されてるボタン隠す
                            for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                                el.style.opacity = "";
                                event.target.style.background = "";
                            }
                            event.target.style.opacity = 1;
                            event.target.style.background = "linear-gradient(#FFF, #DFF)";
                            if(USE_JUMPBTN) { //戻るボタンの半透明維持
                                event.target.closest(".add").querySelector(".tores").style.opacity = 0.5;
                            }
                            if(USE_EXCLBTN) { //除外ボタンの表示維持
                                event.target.closest(".add").querySelector(".excl").style.opacity = 1;
                            }
                        }
                    });
                }
                if(USE_JUMPBTN) {
                    //戻るボタンにマウス乗せたら
                    container.addEventListener("mouseover", event => {
                        if(event.target.closest(".tores")) {
                            //まず表示されてるボタン隠す
                            for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                                el.style.opacity = "";
                                event.target.style.background = "";
                            }
                            event.target.style.opacity = 1;
                            event.target.style.background = "linear-gradient(#FFF, #DFF)";
                            if(USE_DLBTN) { //DLボタンの半透明維持
                                event.target.closest(".add").querySelector(".DLB").style.opacity = 0.5;
                            }
                            if(USE_EXCLBTN) { //除外ボタンの表示維持
                                event.target.closest(".add").querySelector(".excl").style.opacity = 1;
                            }
                        }
                    });
                }
                if(USE_EXCLBTN) {
                    //除外ボタンにマウス乗せたら
                    container.addEventListener("mouseover", event => {
                        if(event.target.closest(".excl")) {
                            //まず表示されてるボタン隠す
                            for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                                el.style.opacity = "";
                                event.target.style.background = "";
                            }
                            //アイコンの切替
                            event.target.closest(".excl").children[1].style.display = "block";
                            event.target.closest(".excl").children[0].style.display = "none";
                            event.target.closest(".excl").style.opacity = 1;
                            if(USE_JUMPBTN) { //戻るボタンの半透明維持
                                event.target.closest(".add").querySelector(".tores").style.opacity = 0.5;
                            }
                            if(USE_DLBTN) { //DLボタンの半透明維持
                                event.target.closest(".add").querySelector(".DLB").style.opacity = 0.5;
                            }
                        }
                    });
                }
            }
        }
        //使うアイコン
        const exclIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="100%" width="100%" viewBox="0 0 512 512"><g><path d="M94.296,463.359C95.853,490.118,119.045,512,145.837,512h60.43c26.792,0,70.646,0,97.439,0h60.431c26.792,0,49.992-21.882,51.55-48.641l17.746-306.165H76.542L94.296,463.359z" style="fill: rgb(128, 0, 0);"></path><path class="st0" d="M433.696,80.591c-5.446-2.34-52.875-19.6-124.124-26.059c0.009-0.322,0.026-0.634,0.026-0.948C309.589,23.983,285.597,0,256.004,0c-29.602,0-53.592,23.983-53.6,53.584c0,0.313,0.017,0.626,0.024,0.948C131.18,60.991,83.734,78.251,78.297,80.591c-9.491,4.07-10.851,9.491-10.851,17.63c0,5.43,0,35.278,0,35.278h377.108c0,0,0-29.849,0-35.278C444.554,90.082,443.195,84.661,433.696,80.591z M255.996,52.102c-7.909,0-15.612,0.173-23.142,0.47c0.56-12.326,10.685-22.154,23.15-22.17c12.457,0.016,22.583,9.844,23.143,22.17C271.616,52.274,263.913,52.102,255.996,52.102z" style="fill: rgb(128, 0, 0);"></path></g></svg>
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="100%" width="102%" viewBox="0 0 512 512"><g><path d="M99.381,465.993c1.472,25.31,23.409,46.007,48.75,46.007h57.158c25.342,0,66.821,0,92.162,0h57.158c25.342,0,47.285-20.697,48.758-46.007l16.785-289.586H82.589L99.381,465.993z" style="fill: red;"></path><path class="st0" d="M427.011,107.022c-4.653-3.132-45.696-27.507-110.772-46.03c0.062-0.304,0.125-0.585,0.188-0.881c5.189-27.507-12.897-54.017-40.396-59.222c-27.516-5.19-54.026,12.88-59.231,40.396c-0.054,0.28-0.094,0.576-0.14,0.88c-67.351-6.506-114.487,1.192-119.95,2.408c-9.53,2.119-11.751,6.92-13.177,14.478c-0.958,5.05-6.202,32.791-6.202,32.791l350.484,66.252c0,0,5.245-27.741,6.204-32.79C435.441,117.745,435.129,112.47,427.011,107.022z M288.303,53.816c-6.951-1.59-14.08-3.102-21.437-4.489c-7.348-1.403-14.54-2.587-21.593-3.631c2.688-11.361,13.832-18.718,25.411-16.543C282.264,31.357,289.947,42.267,288.303,53.816z" style="fill: red;"></path></g></svg>
`;

        function download(url) {
            //console.log(url)
            const matches = url.match(/(?<=\/)(f|fu)?[0-9]+\..+$/);
            //console.log(matches)

            //ファイル名に板名を付ける
            if(ADD_BOARD_NAME) {
                let board = "futaba";
                if(/img.+?b\//.test(url)) board = "img_";
                if(/may.+?b\//.test(url)) board = "may_";
                if(/forest/.test(url)) board = "may_"; //フォレスト
                if(/img.+?b_/.test(url)) board = "img_"; //バケツ
                if(/may.+?b_/.test(url)) board = "may_"; //バケツ
                if(/fu?\d{6,}/.test(url)) board = ""; //あぷ
                //追加例
                //if(/jun/.test(url)) server = "jun_";
                //if(/jun.+?31\//.test(url)) server = "ゲーム_";
                //if(/27\//.test(url)) server = "ねこ_";

                //フォルダ
                folder = folder ? folder+"\\" : "";

                GM_download(url, folder + board + matches[0]);
            } else {
                GM_download(url, matches[0]);
            }
        }

        //一覧で動画にマークを付ける
        function videoMarking() {
            //まだマークがない動画レス(属性data-extはあるけどdiv.vmarkがない要素)
            const container = document.querySelector(".futaba_lightbox_image_list_container");
            let list = [...container.querySelectorAll("a[data-ext]")].filter(a => !a.nextElementSibling?.querySelector("div.add > div.vmark"));

            if(list.length) {
                for(const el of list) {
                    // console.log(el.dataset.ext)
                    if(/(mp4|webm|gif)/.test(el.dataset.ext)) {
                        //設定で一覧にボタンを何も足してなかったら基準位置のタグを追加
                        if(!USE_DLBTN && !USE_JUMPBTN && !USE_EXCLBTN) {
                            const divEl = document.createElement("div");
                            divEl.classList.add("add");
                            divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                            el.after(divEl);
                        }

                        //拡張子別にマーク付与
                        const divEl = document.createElement("div");
                        divEl.classList.add("vmark");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.style.alignContent = "center";
                        if(el.dataset.ext.includes("mp4")) divEl.textContent = "MP4";
                        if(el.dataset.ext.includes("webm")) divEl.textContent = "WebM";
                        if(el.dataset.ext.includes("gif")) divEl.textContent = "GIF";
                        divEl.addEventListener("click", vMarkClick);
                        el.nextElementSibling.appendChild(divEl);
                    }
                }
            }

            //読込んだあぷファイルのgifにマークを付ける
            if(LOAD_UPFILE_LIST && MARK_GIF_UPFILE) {
                let list = [...container.querySelectorAll("a")].filter(a => /fu?\d{6,}\.gif$/.test(a.href)).filter(a => !a.nextElementSibling?.querySelector("div.add > div.vmark"));

                if(list.length) {
                    for(const el of list) {
                        //設定で一覧にボタンを何も足してなかったら基準位置のタグを追加
                        if(!USE_DLBTN && !USE_JUMPBTN && !USE_EXCLBTN) {
                            const divEl = document.createElement("div");
                            divEl.classList.add("add");
                            divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                            el.after(divEl);
                        }
                        //マーク
                        const divEl = document.createElement("div");
                        divEl.classList.add("vmark");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.style.alignContent = "center";
                        divEl.textContent = "GIF";
                        divEl.addEventListener("click", vMarkClick);
                        el.nextElementSibling.appendChild(divEl);
                    }
                }
            }

            //あぷファイルの代用アイコンをリンク先に差し替えた動画にマークを付ける
            if(LOAD_UPFILE_LIST && LOAD_UPFILE_VIDEO && MARK_VIDEO_UPFILE) {
                let list = [...container.querySelectorAll("a")].filter(a => /fu?\d{6,}\.(mp4|webm)$/.test(a.href)).filter(a => !a.nextElementSibling?.querySelector("div.add > div.vmark"));

                if(list.length) {
                    for(const el of list) {
                        //設定で一覧にボタンを何も足してなかったら基準位置のタグを追加
                        if(!USE_DLBTN && !USE_JUMPBTN && !USE_EXCLBTN) {
                            const divEl = document.createElement("div");
                            divEl.classList.add("add");
                            divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                            el.after(divEl);
                        }
                        //マーク
                        const divEl = document.createElement("div");
                        divEl.classList.add("vmark", "up");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.style.alignContent = "center";
                        divEl.title = "右クリでサムネの再描写";
                        if(el.href.includes("mp4")) divEl.textContent = "MP4";
                        if(el.href.includes("webm")) divEl.textContent = "WEBM";
                        divEl.addEventListener("click", vMarkClick);
                        divEl.addEventListener("contextmenu", redrawThumb); //右クリックでサムネを再描写する
                        el.nextElementSibling.appendChild(divEl);
                    }
                }
            }
            if(USE_JUMPBTN || USE_DLBTN || USE_EXCLBTN) {
                //マークにマウス乗せたら
                container.addEventListener("mouseover", event => {
                    if(event.target.closest(".vmark")) {
                        //まず表示されてるボタン隠す
                        for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                            el.style.opacity = "";
                            event.target.style.background = "";
                        }
                        if(USE_JUMPBTN) { //戻るボタンの半透明維持
                            event.target.closest(".add").querySelector(".tores").style.opacity = 0.5;
                        }
                        if(USE_DLBTN) { //DLボタンの半透明維持
                            event.target.closest(".add").querySelector(".DLB").style.opacity = 0.5;
                        }
                        if(USE_EXCLBTN) { //除外ボタンの表示維持
                            event.target.closest(".add").querySelector(".excl").style.opacity = 1;
                        }
                    }
                });
            }
        }

        //非IDスレでIDが付いたレスの画像を加工
        function decoIDRes() {
            for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-id]")) {
                if(el.style.filter) continue;
                //枠にフィルターをかける
                el.style.filter = "blur(5px) opacity(0.3) grayscale(1)";
                //属性変更
                el.setAttribute("data-list", "");

                //後ろに追加ボタン用のタグが無かったら作る
                if(el.nextElementSibling?.className !== "add") {
                    const divEl = document.createElement("div");
                    divEl.classList.add("add");
                    divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                    el.after(divEl);
                }
                //IDマーク
                const divEl = document.createElement("div");
                divEl.classList.add("iddeta");
                smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                divEl.textContent = "ID";
                divEl.style.cursor= "pointer";
                divEl.addEventListener("click", vMarkClick); //動画マークのクリックイベントを流用
                //マークを挿入
                el.nextElementSibling.append(divEl);
                //追加ボタン用タグに属性付与
                divEl.parentElement.setAttribute("data-id", "");
                //動画マークがあったらフィルターをかける
                if(el.nextElementSibling.querySelector(".vmark")) el.nextElementSibling.querySelector(".vmark").style.filter = "blur(1px) opacity(0.3) grayscale(1)";
            }
        }

        //追加した画像一覧のレスを幅に合わせて省略
        function omitRes() {
            //今一覧にある画像のレス
            const imageListRes = document.querySelectorAll(".futaba_lightbox_image_list_container > a > span.res");
            if(imageListRes.length) {
                //内容だけ
                const innerRes = Array.from(imageListRes, el => {
                    //設定で追加したあぷファイル名はそのまま
                    if(/^あぷ小?<(font|br)/.test(el.innerHTML)) return el.innerHTML;
                    //設定で追加したあぷ用アイコンはそのまま
                    if(/^<svg/.test(el.innerHTML)) return el.innerHTML;
                    //レス枠付けた時の仮レスは元レスをコピーしておいた親タグのデータ属性で置換
                    return el.parentElement.cloneNode(true).dataset.res;
                });

                //略す前の置換
                for(let [i, html] of innerRes.entries()) {
                    // console.log("%d %s", i, html);
                    //ｷﾀｰは飛ばす
                    if(/^ｷﾀ━━━/.test(html)) continue;
                    //一覧に追加されたあぷは飛ばす
                    if(/^あぷ小?<(font|br)/.test(html)) continue;
                    //一覧に追加されたあぷ用アイコンは飛ばす
                    if(/^<svg/.test(html)) continue;
                    //画像一覧にレスを表示する
                    html = String(html)//置換
                        .replace(/#789922/g, "#6e8c21") //一覧での引用レスのコントラストを下げる
                        .replace(/<a.+?>(.+?)<\/a>(<br>)*/g, "<font style='color:#33E'>略 </font>") //リンク
                        .replace(/gt;<a.+?>(.+?)<\/a><\/font><br>(<font.+?>(&gt;)+)?/g, "gt;<font style='color:#33E'>略 </font>") //引用リンク
                        .replace(/\[<font color=\"#ff0000\">.+?<\/font>\]<br>/, '<font color="#F00">IP </font>') //ナッパ
                        .replaceAll("&apos;", "'") //タグ壊れ予防してたのを戻す
                        .replaceAll("&quot;", '"')
                        .replaceAll("&colon;", ":")
                        .replace(/<br>.*/, ""); //2行目以降
                    if(html == "" || /^\s+$/.test(html)) html = "[空レス]";
                    innerRes[i] = html;
                    // console.log("%d %s", i, html);
                }

                const bWidth = parseFloat(window.getComputedStyle(imageListRes[0]).width);
                const bFontSize = parseFloat(window.getComputedStyle(imageListRes[0]).fontSize);
                //収める文字数
                const bFontNum = Math.trunc(bWidth / bFontSize) -1;
                //レスの装飾で省略文字数を変える
                const bFontNumR = new RegExp(`(` +
                                             `^(?!<font).{${bFontNum}}` + //普通の省略
                                             `|^<font.+?>略\\s</font>.{${(bFontNum - 2)}}` + //リンク有りの省略
                                             `|^<font.+?>(&gt;)+<font.+?>略\\s</font>.{${(bFontNum - 2)}}` + //引用リンク有りの省略
                                             `|^<font.+?>(&gt;)+(https?://)?((?<!<font).){${(bFontNum - 2)}}(?=.*</font>)` + //引用有りの省略
                                             `|^<font.+?>IP\\s</font>.{${(bFontNum - 2)}}` + //ナッパ
                                             `).*`, "");
                //ｷﾀ━は幅最大に伸ばす
                const ktNum = Math.ceil(((bWidth / bFontSize) - 5) / 2); //左右の━数
                let ktReplace = "";
                for(let i = 0; i < ktNum; i++) ktReplace += "━";
                ktReplace += "(ﾟ∀ﾟ)";
                for(let i = 0; i<ktNum; i++) ktReplace += "━";

                //省略して一覧のレスに
                for(let [i, html] of innerRes.entries()) {
                    if(/^ｷﾀ━━━/.test(html)) {
                        html = ktReplace;
                    } else if(!/^(>No\.\d+|あぷ小?<(font|br)|<svg)/.test(html.replace(/\n/g, ""))) { //レス番引用、あぷは適用外
                        //省略したら...を末に付ける
                        html = html.replace(bFontNumR, "$1<font style='letter-spacing: -0.1em;font-weight: 400;'>...");
                    }
                    if(/^あぷ小?<(font|br)/.test(html.replace(/\n/g, ""))) {
                        if(mobile) { //携帯端末か
                            if(bFontNum < 12) html = html.replace(/(あぷ小?).*/, "$1<font/>");
                        } else {
                            //ファイル名が収まらなくなったら略す
                            if(bFontNum < 12) html = html.replace(/(あぷ小?)(<br>)*/, "$1<br><br>");
                            //ファイル名が収まるなら戻す
                            if(bFontNum >= 12) html = html.replace(/(あぷ小?)<br><br>/, "$1");
                        }
                    }
                    if(/^<svg/.test(html.replace(/\n/g, ""))) {
                        if(mobile) { //携帯端末か
                            //ファイル名が収まらなくなったら略す
                            if(bFontNum < 10) html = `<svg width="0px" height="0px"></svg>&nbsp;<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="0.9rem" width="0.9rem" viewBox="0 0 512 512"><g><path fill="#800000" d="M509.445,113.129c-2.547-13.219-7.047-26.141-13.453-38.359c-6.391-12.203-14.75-23.641-24.938-33.828 c-13.563-13.578-29.406-23.875-46.265-30.719c-25.297-10.219-52.828-12.781-79.266-7.656c-13.219,2.563-26.156,7-38.359,13.422 c-12.172,6.422-23.641,14.75-33.828,24.953l-66.25,66.25c-13.375,13.344-13.375,35.047,0,48.391s35.031,13.344,48.391,0 l66.25-66.281c7.031-7,15.016-12.172,23.594-15.672c12.844-5.203,27.031-6.531,40.547-3.906c6.75,1.313,13.328,3.594,19.531,6.844 c6.188,3.25,12,7.469,17.281,12.734c7.031,7.078,12.187,15.047,15.687,23.609c5.203,12.844,6.531,27.047,3.906,40.547 c-1.313,6.766-3.594,13.344-6.828,19.516c-3.281,6.219-7.484,12.031-12.765,17.313l-66.25,66.234 c-13.359,13.359-13.359,35.047,0,48.391s35.016,13.344,48.375,0l66.25-66.265c13.594-13.563,23.875-29.406,30.703-46.266 C512.008,167.083,514.555,139.551,509.445,113.129z"></path><path fill="#800000" d="M256.54,356.426l-66.266,66.266c-7.047,7.016-15.031,12.188-23.594,15.672 c-12.844,5.219-27.047,6.547-40.547,3.938c-6.766-1.328-13.328-3.625-19.531-6.859c-6.188-3.266-12-7.5-17.281-12.75 c-7.031-7.063-12.203-15.031-15.688-23.609c-5.203-12.828-6.531-27.031-3.922-40.563c1.313-6.75,3.609-13.328,6.844-19.516 c3.281-6.188,7.484-12,12.766-17.297l66.266-66.25c13.344-13.344,13.344-35.016,0-48.359c-13.375-13.359-35.031-13.359-48.391,0 l-66.25,66.234c-13.594,13.594-23.875,29.406-30.719,46.297c-10.234,25.266-12.781,52.844-7.672,79.219 c2.547,13.219,7.031,26.156,13.453,38.359c6.406,12.203,14.75,23.672,24.938,33.844c13.594,13.578,29.406,23.891,46.266,30.688 c25.281,10.266,52.844,12.813,79.25,7.703c13.234-2.563,26.156-7.047,38.344-13.453c12.203-6.391,23.672-14.75,33.859-24.938 l66.25-66.266c13.344-13.344,13.344-35.016,0-48.359C291.54,343.066,269.883,343.066,256.54,356.426z"></path><path fill="#800000" d="M342.43,169.567c-13.344-13.344-35.016-13.344-48.375,0l-124.516,124.5c-13.344,13.359-13.344,35.016,0,48.359 c13.375,13.375,35.047,13.375,48.391,0l124.5-124.5C355.805,204.567,355.805,182.926,342.43,169.567z"></path></g></svg>&nbsp;`;
                        } else {
                            //ファイル名が収まらなくなったら略す
                            if(bFontNum < 10) html = html.replace(/^(<svg[^>]+width="1rem".+?\/svg>)/, `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="0.9rem" width="0.9rem" viewBox="0 0 512 512"><g><path fill="#800000" d="M509.445,113.129c-2.547-13.219-7.047-26.141-13.453-38.359c-6.391-12.203-14.75-23.641-24.938-33.828 c-13.563-13.578-29.406-23.875-46.265-30.719c-25.297-10.219-52.828-12.781-79.266-7.656c-13.219,2.563-26.156,7-38.359,13.422 c-12.172,6.422-23.641,14.75-33.828,24.953l-66.25,66.25c-13.375,13.344-13.375,35.047,0,48.391s35.031,13.344,48.391,0 l66.25-66.281c7.031-7,15.016-12.172,23.594-15.672c12.844-5.203,27.031-6.531,40.547-3.906c6.75,1.313,13.328,3.594,19.531,6.844 c6.188,3.25,12,7.469,17.281,12.734c7.031,7.078,12.187,15.047,15.687,23.609c5.203,12.844,6.531,27.047,3.906,40.547 c-1.313,6.766-3.594,13.344-6.828,19.516c-3.281,6.219-7.484,12.031-12.765,17.313l-66.25,66.234 c-13.359,13.359-13.359,35.047,0,48.391s35.016,13.344,48.375,0l66.25-66.265c13.594-13.563,23.875-29.406,30.703-46.266 C512.008,167.083,514.555,139.551,509.445,113.129z"></path><path fill="#800000" d="M256.54,356.426l-66.266,66.266c-7.047,7.016-15.031,12.188-23.594,15.672 c-12.844,5.219-27.047,6.547-40.547,3.938c-6.766-1.328-13.328-3.625-19.531-6.859c-6.188-3.266-12-7.5-17.281-12.75 c-7.031-7.063-12.203-15.031-15.688-23.609c-5.203-12.828-6.531-27.031-3.922-40.563c1.313-6.75,3.609-13.328,6.844-19.516 c3.281-6.188,7.484-12,12.766-17.297l66.266-66.25c13.344-13.344,13.344-35.016,0-48.359c-13.375-13.359-35.031-13.359-48.391,0 l-66.25,66.234c-13.594,13.594-23.875,29.406-30.719,46.297c-10.234,25.266-12.781,52.844-7.672,79.219 c2.547,13.219,7.031,26.156,13.453,38.359c6.406,12.203,14.75,23.672,24.938,33.844c13.594,13.578,29.406,23.891,46.266,30.688 c25.281,10.266,52.844,12.813,79.25,7.703c13.234-2.563,26.156-7.047,38.344-13.453c12.203-6.391,23.672-14.75,33.859-24.938 l66.25-66.266c13.344-13.344,13.344-35.016,0-48.359C291.54,343.066,269.883,343.066,256.54,356.426z"></path><path fill="#800000" d="M342.43,169.567c-13.344-13.344-35.016-13.344-48.375,0l-124.516,124.5c-13.344,13.359-13.344,35.016,0,48.359 c13.375,13.375,35.047,13.375,48.391,0l124.5-124.5C355.805,204.567,355.805,182.926,342.43,169.567z"></path></g></svg><br><br>$1`);
                            //ファイル名が収まるなら戻す
                            if(bFontNum >= 10) html = html.replace(/^(<svg.+?\/svg><br><br>)+/, "");
                        }
                    }
                    imageListRes[i].innerHTML = html;
                }
            }
        }

        //一覧の画像を数えたい
        function ichiranImageCount(mode = "") {
            let imgs = [...document.querySelectorAll(".thre a > img, #res_body a > img")].filter(el => !el.closest("blockquote, #respopup_area, .akahuku_preview_container, td.qt, .previewArea"));
            imgs = futakuroNgFilter(imgs);
            //画像数
            const numImg = imgs.length;
            let isoImg = HIDE_ISOLATION_RES ? imgs.filter(el => el.closest(".deleted")).length : 0;
            let threBq;
            let threUp = 0;
            let resUpIso = 0;
            let resUpDel = 0;
            let resDec = false;
            let upIgnore = 0;
            let threUpErr = 0;
            let resUpErrIso = 0;
            let resUpErrDel = 0;
            let excluded = 0;
            let upExcluded = 0;

            if(USE_EXCLBTN && exclFiles.size) { //手動で除外したファイルがあるか
                for(const el of imgs.filter(el => !el.closest(".deleted"))) {
                    if(exclFiles.has(el.parentElement.pathname)) { //除外したファイルか
                        excluded ++;
                    }
                }
            }

            //一覧にあぷファイル名を含める設定か
            if(ADD_UPFILE_LIST) {
                threBq = [...document.querySelectorAll(".thre blockquote, #res_body blockquote")].filter(el => !el.closest("#respopup_area, td.qt, .previewArea"));
                threBq = futakuroNgFilter(threBq);
                threBq = threBq.map(el => el.cloneNode(true));
                if(threBq.length) {
                    for(const el of threBq) {
                        //動画をインライン再生中にレスを複製すると同時に再生されるから複製した方は止める
                        if(el.querySelector("video")) {
                            for(const videoEl of el.querySelectorAll("video")) {
                                //動画を止めて空にしてリセット
                                videoEl.pause();
                                videoEl.removeAttribute("src");
                                videoEl.load();
                            }
                        }
                        //「」ッチーで展開してた画像をファイル名に置換
                        if(location.hostname.includes("tsumanne")) el.innerHTML = el.innerHTML.replace(/<a\shref="(fu[^"]+?)"[^>]+?><img[^>]+?><\/a>/g, "$1");
                        //レス内の引用されてないあぷファイル
                        const files = el.innerHTML.match(/(?<!&gt;(.(?!<br>))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)(?!['"])/g) || [];
                        //レス内の引用されてないあぷファイル数
                        const filesNum = files.length;
                        //羅列荒らしか
                        if(filesNum >= UP_IGNORE_NUM) {
                            upIgnore ++;
                            continue;
                        }
                        threUp += filesNum;

                        //レス内のエラーあぷファイル数
                        let errFilesNum = 0;
                        if(OMIT_ERROR_UPFILE && mode != "数え直し") {
                            for(const file of files) {
                                if(upErrFiles.has(file)) {
                                    threUpErr ++;
                                    errFilesNum ++;
                                }
                            }
                        }

                        //手動で除外したあぷファイル数
                        if(USE_EXCLBTN && exclUpFiles.size) {
                            for(const file of files) {
                                //隔離･削除レスを表示しない設定か
                                if(HIDE_ISOLATION_RES) {
                                    if(el.innerHTML.includes('"#ff0000">削除依頼')) {
                                        continue;
                                    }
                                }
                                if(HIDE_DELETED_RES) {
                                    if(el.innerHTML.includes('"#ff0000">スレッド')) {
                                        continue;
                                    }
                                }
                                if(exclUpFiles.has(file)) {
                                    upExcluded ++;
                                }
                            }
                        }

                        //隔離･削除レスを表示しない設定か
                        if(HIDE_ISOLATION_RES) {
                            //隔離レスの画像数に足す
                            if(el.innerHTML.includes('"#ff0000">削除依頼')) {
                                resUpIso += filesNum;
                                if(OMIT_ERROR_UPFILE) resUpErrIso += errFilesNum;
                            }
                        }
                        if(HIDE_DELETED_RES) {
                            //削除レスの画像数に足す
                            if(el.innerHTML.includes('"#ff0000">スレッド')) {
                                resUpDel += filesNum;
                                if(OMIT_ERROR_UPFILE) resUpErrDel += errFilesNum;
                            }
                        }
                    }
                }
            }
            if(mode == "数え直し") {
                //数え直した場合に出す
                console.log("数え直し\n画像数\t%d\n隔離画像\t%d\nあぷ\t%d\nDelあぷ\t%d\n隔離あぷ\t%d"
                            , numImg, isoImg, threUp, resUpDel, resUpIso);
                console.log("荒らし判定 %dレス", upIgnore);
            }
            // console.log("エラーあぷ %d\nエラーDelあぷ %d\nエラー隔離あぷ %d\n", threUpErr, resUpErrDel, resUpErrIso);

            //画像数合計
            let imgCount;
            let upCount;
            imgCount = numImg - isoImg - excluded;
            upCount = threUp - resUpDel - resUpIso - upExcluded;
            if(OMIT_ERROR_UPFILE) { //エラーだったあぷファイルを除外するか
                let upErrCount = threUpErr - resUpErrDel - resUpErrIso;
                upCount -= upErrCount;
            }

            //一覧開いてる間は開いた時より数を減らさない
            if(location.hostname.includes("2chan.net") && OBSERVE_OTHER_CHANGES && openList) {
                let listIsoImg = 0;
                let listDelImg = 0;
                let listIsoDelImg = 0;
                let listUpIsoImg = 0;
                let listUpDelImg = 0;
                let listUpIsoDelImg = 0;
                let threImgDel = 0;
                //削除レス番
                const resNo = [...document.querySelectorAll(".thre blockquote")].filter(el => !el.closest("#respopup_area"));
                const isoResNo = resNo.filter(el => /"#ff0000">削除依頼/i.test(el.innerHTML)).filter(el => !/"#ff0000">(書き込み|スレッド)/i.test(el.innerHTML)).map(el => el.parentElement.querySelector(".cno").textContent);
                const delResNo = resNo.filter(el => !/"#ff0000">削除依頼/i.test(el.innerHTML)).filter(el => /"#ff0000">(書き込み|スレッド)/i.test(el.innerHTML)).map(el => el.parentElement.querySelector(".cno").textContent);
                const isoDelResNo = resNo.filter(el => /"#ff0000">削除依頼/i.test(el.innerHTML)).filter(el => /"#ff0000">(書き込み|スレッド)/i.test(el.innerHTML)).map(el => el.parentElement.querySelector(".cno").textContent);
                if(isoResNo.length || delResNo.length || isoDelResNo.length) {
                    //一覧にある画像のレス番
                    const listANo = Array.from(document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-from="thre"]`), el => el.dataset.no);
                    for(const no of listANo) {
                        if(isoResNo.length && HIDE_ISOLATION_RES && isoResNo.includes(no)) {
                            // console.log("一覧にある隔離画像 ", no);
                            listIsoImg ++;
                        }
                        if(delResNo.length && HIDE_DELETED_RES && delResNo.includes(no)) {
                            // console.log("一覧にある削除画像 ", no);
                            listDelImg ++;
                        }
                        if(isoDelResNo.length && (HIDE_DELETED_RES || HIDE_ISOLATION_RES) && isoDelResNo.includes(no)) {
                            // console.log("一覧にある隔離削除画像 ", no);
                            listIsoDelImg ++;
                        }
                    }
                    if(listIsoImg || listDelImg || listIsoDelImg) {
                        resDec = true;
                        imgCount += listIsoImg;
                        imgCount += listDelImg;
                        imgCount += listIsoDelImg;
                    }
                    // console.log("画像数(%d)-隔離画像(%d)+一覧隔離(%d)+一覧削除(%d)+一覧隔離削除(%d)=%d"
                    //             , numImg, isoImg, listIsoImg, listDelImg, listIsoDelImg, numImg - isoImg + listIsoImg + listDelImg + listIsoDelImg);
                    if(ADD_UPFILE_LIST) {
                        //一覧にあるあぷファイルのレス番
                        const listUpANo = Array.from(document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-from="up"]`), el => el.dataset.no);
                        if(listUpANo.length) {
                            for(const no of listUpANo) {
                                if(isoResNo.length && HIDE_ISOLATION_RES && isoResNo.includes(no)) {
                                    // console.log("一覧にある隔離あぷ画像 ", no);
                                    listUpIsoImg ++;
                                }
                                if(delResNo.length && HIDE_DELETED_RES && delResNo.includes(no)) {
                                    // console.log("一覧にある削除あぷ画像 ", no);
                                    listUpDelImg ++;
                                }
                                if(isoDelResNo.length && (HIDE_DELETED_RES || HIDE_ISOLATION_RES) && isoDelResNo.includes(no)) {
                                    // console.log("一覧にある隔離削除あぷ画像 ", no);
                                    listUpIsoDelImg ++;
                                }
                            }
                        }
                        if(listUpIsoImg || listUpDelImg || listUpIsoDelImg) {
                            resDec = true;
                            upCount += listUpIsoImg;
                            upCount += listUpDelImg;
                            upCount += listUpIsoDelImg;
                        }
                        // console.log("あぷ(%d)-Delあぷ(%d)-隔離あぷ(%d)+一覧隔離あぷ(%d)+一覧削除あぷ(%d)+一覧隔離削除あぷ(%d)=%d"
                        //             , threUp, resUpDel, resUpIso, listUpIsoImg, listUpDelImg, listUpIsoDelImg, threUp - resUpDel - resUpIso + listUpIsoImg + listUpDelImg + listUpIsoDelImg);
                    }
                    //カウントが少なかったら画像だけ削除レスか
                    if(imgCount + upCount < document.querySelectorAll(".futaba_lightbox_image_list_container > a").length) {
                        for(const no of listANo) {
                            // console.log("不足？：", no);
                            const threEl = [Array.from(document.querySelectorAll('.thre .cno')).find(el => el.textContent == no).parentElement].filter(el => !/"#ff0000">(書き込み|スレッド)/i.test(el.querySelector("blockquote").innerHTML));
                            //画像が消えてるけど赤字レスではないか
                            if(threEl.length && !threEl[0].querySelector("a > img")) {
                                threImgDel ++;
                                //一覧画像にマーク付け
                                if(MARK_HIDE_IMAGE) deletedImageListView(threEl[0]);
                            }
                        }
                        if(threImgDel) {
                            resDec = true;
                            imgCount += threImgDel;
                        }
                    }
                }
            }
            //一覧ボタンに表示
            if(document.querySelector(".ichiran")) {
                if(mode == "数え直し" || (OBSERVE_OTHER_CHANGES && mode == "一覧閉じた" && resDec)) {
                    //文字を徐々に出す
                    let fontFade = 0;
                    const fadeIn = setInterval(() => {
                        fontFade += 1;
                        if (fontFade >= 16) {
                            fontFade = 16;
                            clearInterval(fadeIn);
                            if(mode == "数え直し") {
                                document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"}`).style.color = "#000" + fontFade.toString(16);
                            } else {
                                document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"} > span`).style.color = "#000" + fontFade.toString(16);
                            }
                        }
                        if(mode == "数え直し") {
                            document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"}`).style.color = "#000" + fontFade.toString(16);
                        } else {
                            document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"} > span`).style.color = "#000" + fontFade.toString(16);
                        }
                    }, 50);
                }
                if(SHOW_KOKOBTN) {
                    if(ADD_UPFILE_LIST) {
                        document.querySelector(".ichiranopn").innerHTML = `画像一覧(<span>${imgCount}${upCount ? `+${upCount}` : ""}</span>)`;
                    } else {
                        document.querySelector(".ichiranopn").innerHTML = `画像一覧(<span>${imgCount}</span>)`;
                    }

                    //ふたクロのスマホモードで横幅変わってたら一覧の一枠の高さ計算する
                    if(mobile && widthCheck != window.innerWidth) calcAheight();

                    //いまココボタンを出すのに必要な画像数(一覧でスクロール要る数)
                    //一覧の表示範囲/枠の高さ*1行の画像の数
                    const normalNum = Math.trunc(window.innerHeight * (listHeight / 100) / aHeight) * IMAGE_NUM;
                    //小さい一覧の配置と表示範囲はCSSの値変えてない前提
                    //containerの高さ=overlayの高さ90%=(ウィンドウの高さ-(margin-top分+padding-top分+margin-bottom分))*0.9
                    const smallNum = Math.trunc((window.innerHeight - (30 + parseFloat(getComputedStyle(document.documentElement).fontSize) + 9 + (window.innerHeight * 0.1))) * 0.9 / aHeightS) * IMAGE_NUM_S;
                    if(normalNum <= smallNum) {
                        needImg = normalNum;
                    } else {
                        needImg = smallNum;
                    }
                    //画像数が足りない時はいまココボタンを非表示
                    if(ADD_UPFILE_LIST) { //あぷファイルを追加するか
                        if(needImg >= (imgCount + upCount)) { //あぷファイルも含めて判定
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 90 : 70}px`;
                            document.querySelector(".ichirankoko").style.display = "none";
                        } else {
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 140 : 100}px`;
                            document.querySelector(".ichirankoko").style.display = "block";
                        }
                    } else {
                        if(needImg >= imgCount) { //画像数だけで判定
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 90 : 70}px`;
                            document.querySelector(".ichirankoko").style.display = "none";
                        } else {
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 140 : 100}px`;
                            document.querySelector(".ichirankoko").style.display = "block";
                        }
                    }
                } else {
                    if(ADD_UPFILE_LIST) {
                        if(document.querySelector(".ichiran")) document.querySelector(".ichiran").innerHTML = `画像一覧(<span>${imgCount}${upCount ? `+${upCount}` : ""}</span>)`;
                    } else {
                        if(document.querySelector(".ichiran")) document.querySelector(".ichiran").innerHTML = `画像一覧(<span>${imgCount}</span>)`;
                    }
                }
            }
        }

        //画像のページ位置を属性付け
        function ichiranCheckPoint() {
            let sure;
            let res;
            let list;

            if(ADD_UPFILE_LIST && SORT_UPFILE_LIST) {
                //削除されてないそれぞれの画像にあぷファイルも含める
                sure = Array.from(document.querySelectorAll(".thre > a > img, .thre[data-upf] > blockquote"), el => {
                    if(el.tagName == "IMG") return el.parentElement; //画像なら親のaにする
                    return el;
                });
                if(document.querySelector("#master")) {
                    sure = Array.from(document.querySelectorAll("#master > a > img, #master[data-upf] > blockquote"), el => {
                        if(el.tagName == "IMG") return el.parentElement; //画像なら親のaにする
                        return el;
                    });
                }
                res = Array.from(document.querySelectorAll(".thre table:not(.deleted) a > img, .thre table[data-upf] blockquote, #res_body table:not(.deleted) a > img, #res_body table[data-upf] blockquote"), el => {
                    if(el.closest("#respopup_area, .akahuku_preview_container, td.qt, .previewArea")) return "";
                    if(el.tagName == "IMG") return el.parentElement; //画像なら親のaにする
                    return el;
                });
            } else {
                //削除されてないそれぞれの画像
                sure = document.querySelectorAll(".thre > a > img") ? [document.querySelectorAll(".thre > a > img").parentElement] : [];
                if(document.querySelector("#master > a > img")) sure = [document.querySelector("#master > a > img").parentElement];
                res = Array.from(document.querySelectorAll(".thre table:not(.deleted) a > img, #res_body table:not(.deleted) a > img"), el => {
                    if(el.closest("#respopup_area, .akahuku_preview_container, td.qt, .previewArea")) return "";
                    return el.parentElement;
                });
            }
            //まとめ
            let array = [...sure, ...res].filter(Boolean);
            // console.log(array);

            //削除レスを除外するか
            if(HIDE_ISOLATION_RES) {
                //隔離レス除外
                array = array.filter(el => !el.innerHTML.includes('"#ff0000">削除依頼'));
            }
            if(HIDE_DELETED_RES) {
                //削除レス除外
                array = array.filter(el => !el.innerHTML.includes('"#ff0000">スレッド'));
            }
            // console.log(array);
            //属性追加
            ichiranCheckPointEl(array);
        }

        function ichiranCheckPointEl(array) {
            let madadame = false;
            //属性追加
            for(let el of array) {
                //スレ画か
                if(el.parentElement.classList.contains("thre") || el.parentElement.id === "master" ) {
                    if(el.parentElement.offsetTop == "0") {
                        madadame = true;
                        break; //まだページ位置が決まって無かったら止める
                    }
                    //親のページ位置で設定
                    el.setAttribute("data-y", el.parentElement.offsetTop);
                } else {
                    if(el.closest("table") && el.closest("table").offsetTop == "0" && !(el.closest("table.ng_hidden") && document.querySelector("#ng-style > style"))) {
                        madadame = true;
                        break; //まだページ位置が決まって無かったら止める
                    }
                    //親タグが画像持ちか
                    if(el.parentElement.querySelector("a > img")) {
                        //いまココボタンの見た画像ラインを「画像が半分以上画面外に出てたら」に
                        //親テーブル位置+そこから画像の位置+画像の半分の高さで設定
                        el.setAttribute("data-y", el.closest("table").offsetTop +
                                        el.closest("tbody").offsetTop + el.parentElement.querySelector("a > img").offsetTop +
                                        (el.parentElement.querySelector("a > img").height / 2));
                        // console.log("table：%f\ttbody：%f\ttr：%f\ttd：%f\ta：%f\timg：%f\t画像/2：%f", el.closest("table").offsetTop, el.closest("tbody").offsetTop, el.closest("tr").offsetTop, el.parentElement.offsetTop, el.parentElement.querySelector("a > img").parentElement.offsetTop, el.parentElement.querySelector("a > img").offsetTop, (el.parentElement.querySelector("a > img").height / 2));
                    } else {
                        //こっちはあぷファイルだけの想定
                        //親テーブル位置+そこからタグの位置で設定
                        el.setAttribute("data-y", el.closest("table").offsetTop + el.closest("tbody").offsetTop + el.offsetTop);
                    }
                }
                // console.log("数 %d/%d\tdata-y：%s", Number(i) + 1, array.length, el.dataset.y);
                // console.log(el);
            }
            //まだダメならやり直す
            if(madadame) {
                // console.log("タグのページ位置がまだ未設定なのでやり直す");
                setTimeout(() => {
                    ichiranCheckPoint();
                }, 1000);
            }
        }

        function yattaka() {
            //一覧の一枠の高さが未設定なら計算
            if(!aHeight || !aHeightS) calcAheight();

            //一覧リセット用
            const ichiranReset = (event) => {
                console.time("おわり");

                console.log("画像一覧リセット %d:%d:%d ", new Date().getHours(), new Date().getMinutes(), new Date().getSeconds());

                //ブラウザで違うスクロールバー幅を取得
                setScrollbarSize();
                console.log("再取得\nスクロールバー幅\t\t%dpx\n細いスクロールバー幅\t%dpx", scrollbar, thinSb);

                //aタグに付けた属性を消す
                let imgA = document.querySelectorAll(".thre a[data-checked], #res_body a[data-checked]");
                removeAttr(imgA, "checked");

                //aタグ再収集
                imgA = Array.from(document.querySelectorAll(".thre a > img, #res_body a > img"), el => el.parentElement).filter(el => !el.closest("#respopup_area, .akahuku_preview_container, td.qt, .previewArea, blockquote"));
                //属性付け
                addAttr(imgA);

                //あぷファイルを一覧に含めるか
                if(ADD_UPFILE_LIST) {
                    let resBq = document.querySelectorAll(".thre[data-upf] > blockquote, .thre [data-upf] blockquote, #res_body [data-upf] blockquote");
                    removeAttr(resBq);
                    resBq = document.querySelectorAll(".thre blockquote, #res_body blockquote");
                    //属性付け
                    addAttrUp(resBq);
                }

                //手動で除外したファイルを空にする
                if(USE_EXCLBTN && (exclFiles.size || exclUpFiles.size)) {
                    exclFiles.clear();
                    exclUpFiles.clear();
                    console.log("手動で除外したファイルを忘れた");
                }

                if(SHOW_IMAGE_COUNT) ichiranImageCount("数え直し");
                //画像のページ位置保存し直し
                if(SHOW_KOKOBTN) ichiranCheckPoint();

                //エラーあぷファイル名を収納してるupErrFilesを空にする
                if(upErrFiles.size) {
                    upErrFiles.clear();
                    console.log("エラーあぷファイル名を忘れた");
                }
                //あぷファイルのサムネを忘れる
                if(document.querySelector("upthumb") && document.querySelector("upthumb").children.length) {
                    document.querySelector("upthumb").textContent = "";
                    console.log("あぷファイルのサムネを忘れた");
                }
                if(document.querySelector(".futaba_lightbox_image_list_container > a > span[data-file]")) {
                    for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a > span[data-file]")) {
                        el.removeAttribute("data-file");
                    }
                    console.log("実行時のあぷファイルのサムネは覚えない");
                }

                //一覧の一枠の高さ再計算
                calcAheight();

                console.timeEnd("おわり");
            };


            //画像一覧ボタンを追加
            if(SHOW_KOKOBTN) { //いまココボタンを表示するか
                //ボタン枠
                const divEl = document.createElement("div");
                divEl.classList.add("ichiran");

                //画像一覧ボタン
                const divEl2 = document.createElement("div");
                divEl2.classList.add("ichiranopn");
                divEl2.title = `画像一覧を開閉\n右クリで別サイズの一覧を開く\n中クリ${mobile ? "かマルチタッチ" : ""}でリセット`;
                divEl2.textContent = "画像一覧";
                divEl2.addEventListener("click", () => {
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        closeImageListView();
                    } else {
                        if(LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl2.addEventListener("contextmenu", event => {
                    event.preventDefault();
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        smallList = !smallList;
                        showImageListView();
                    } else {
                        if(!LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl2.addEventListener("mousedown", event => {
                    if(event.button === 1) { //中クリック
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });
                divEl2.addEventListener("touchstart", event => {
                    if(event.touches.length >= 2) { //マルチタッチ
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });
                divEl.append(divEl2);

                //いまココボタン
                const divEl3 = document.createElement("div");
                divEl3.classList.add("ichirankoko");
                divEl3.title = "画像一覧を見てる位置から開く\n右クリで別サイズの一覧を開く";
                divEl3.innerHTML = "<span>いま<br>ココ</span>";
                divEl3.addEventListener("click", () => {
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        showImageListView("いまココ");
                    } else {
                        if(LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView("いまココ");
                    }
                });
                divEl3.addEventListener("contextmenu", event => {
                    event.preventDefault();
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        smallList = !smallList;
                        showImageListView("いまココ");
                    } else {
                        if(!LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView("いまココ");
                    }
                });
                divEl.append(divEl3);

                //bodyにコンテナ追加
                document.body.append(divEl);

                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                ichiranCheckPoint();
            } else {
                //画像一覧ボタン
                const divEl = document.createElement("div");
                divEl.classList.add("ichiran");
                divEl.title = `画像一覧を開閉\n右クリで別サイズの一覧を開く\n中クリ${mobile ? "かマルチタッチ" : ""}でリセット`;
                divEl.textContent = "画像一覧";
                divEl.addEventListener("click", () => {
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        closeImageListView();
                    } else {
                        if(LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl.addEventListener("contextmenu", event => {
                    event.preventDefault();
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        smallList = !smallList;
                        showImageListView();
                    } else {
                        if(!LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl.addEventListener("mousedown", event => {
                    if(event.button === 1) { //中クリック
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });
                divEl.addEventListener("touchstart", event => {
                    if(event.touches.length >= 2) { //マルチタッチ
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });

                //bodyに一覧ボタン追加
                document.body.append(divEl);
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
            }
        }

        //ウインドウサイズが変わったら枠の高さ計算(一覧に表示出来る画像数が変わる)
        window.addEventListener("resize", event => {
            calcAheight();
        });

        //いまココボタンを補助するイベント
        if(SHOW_KOKOBTN) {
            let waitCalcKOKO;
            window.addEventListener("resize", event => {
                clearTimeout(waitCalcKOKO);
                waitCalcKOKO = setTimeout(() => {
                    //いまココボタンを出すのに必要な画像数(一覧にきれいに収まる画像数)
                    //一覧の表示範囲/枠の高さ*1行の画像の数
                    const normalNum = Math.trunc(window.innerHeight * (listHeight / 100) / aHeight) * IMAGE_NUM;
                    //小さい一覧の配置と表示範囲はCSSの値変えてない前提
                    //containerの高さ=overlayの高さ90%=(ウィンドウの高さ-(margin-top分+padding-top分+margin-bottom分))*0.9
                    const smallNum = Math.trunc((window.innerHeight - (30 + parseFloat(getComputedStyle(document.documentElement).fontSize) + 9 + (window.innerHeight * 0.1))) * 0.9 / aHeightS) * IMAGE_NUM_S;
                    if(normalNum <= smallNum) {
                        needImg = normalNum;
                    } else {
                        needImg = smallNum;
                    }
                    // console.log("resizeイベント");
                    ichiranCheckPoint();
                }, 100);
            });
            //ページの高さが変わったら画像の位置再計算
            let waitCalcBodyHeight;
            window.addEventListener("scroll", event => {
                clearTimeout(waitCalcBodyHeight);
                waitCalcBodyHeight = setTimeout(() => {
                    //ページの高さが未設定なら保存
                    if(!bodyHeight) bodyHeight = document.body.scrollHeight;
                    // console.log("ページ記録高さ %s\nページ現在高さ %s", bodyHeight, document.body.scrollHeight);
                    //変わってたら画像の位置を再計算する
                    if(bodyHeight && document.body.scrollHeight !== bodyHeight) {
                        bodyHeight = document.body.scrollHeight;
                        ichiranCheckPoint();
                    }
                }, 100);
            }, {passive: true});
        }
    })();
} else {
    console.info("404だから働かないぞ俺");
}

/* 改変ログ
画像一覧のデザインをざっくりとしあき(仮) 出張版っぽく
スレに画像一覧ボタン追加
画像一覧にレスに戻るボタン追加
画像拡大時の上部ボタンを画像一覧からレスに戻るに変更(整頓で削除)
画像一覧と拡大画像にDLボタン追加
画像一覧の一行の画像数を設定可能に
画像一覧でボタンを表示するか設定可能に
拡大画像にレスを追加表示
拡大画像のレス部分をクリックでレス位置に戻るように(整頓で削除)
画像一覧ボタンの位置を設定可能に
ボタンの見た目を出張版っぽくするか設定可能に(整頓で削除)
画像一覧の動画にマーク追加
FTBucketとふたばフォレストで使えるように
CSS弄り
拡大画像のホイール有効範囲拡大、設定可能に(整頓で削除)
画像一覧にレスを表示、設定可能に
画像一覧のホイール有効範囲拡大、設定可能に
画像一覧を区切りよくホイールスクロールするように
jQueryを3.7.1に、fancyboxを5に載せ替え
fancyboxを使うか設定可能に
整頓、後の俺用に何したかここに書いて説明もなるべく残す
動画のデフォ音量設定可能に
fancyboxのオプションを整頓
404時に動かないように
動画がレス内で展開される対策(微妙)
fancyboxのスライドを閉じたらそのレスに飛ぶか設定可能に
DLファイル名に板名を付けるか設定可能に
fancyboxのオプション弄り
DL先のサブフォルダを設定可能に
レス内で展開される対策した動画のホイールクリックの挙動弄り(後に削除)
CSS弄り
続・動画がレス内で展開される対策
画像一覧を開いてるとスライドの画像数が倍増する対策
画像一覧でレスをポップアップするよう設定可能に
レスポップアップ弄り
スライドを閉じたらレスに飛ぶが有効なら画像一覧でスライドを閉じるとそこの画像位置に戻るように
スライドのキャプションに写すとタグが壊れるレス対策
画像一覧から隔離画像を消す、設定可能に
続・スライドのキャプションに写すとタグが壊れるレス対策
画像一覧でレスが数字だけの場合に出るエラー対策
画像一覧にあぷ込みレスも含める
画像一覧であぷファイルをスライドに含める、設定可能に
画像一覧でだけfancyboxを使うか設定可能に
続・スライドのキャプションに写すとタグが壊れるレス対策
画像一覧の区切りいいホイールスクロールがcssの計算で出る小数点で地味にズレるの対策
画像一覧で範囲から飛び出るレスを省略するように
↑URLの省略方法を変更
↑↑あぷファイル省略方法を変更
バケツで画像＆あぷ込みのレスで表示崩れる対策
あぷ判定の調整
レスポップアップのフォントサイズが小さくなりすぎる対策
画像一覧を出してウインドウ幅を変えた時に画像枠のサイズも変わるように
画像一覧を出してウインドウ幅を変えた時にレスの省略数も変わるように
画像一覧を出してウインドウ幅を変えた時のレスの省略を微調整
画像一覧を出してる間のふたクロの更新を画像一覧に反映するように
↑マウスイベントが重複しまくる対策
↑↑あぷファイルが重複する対策
画像一覧周りの整頓と修正
画像一覧を出してウインドウ幅を大きく変えた時に「区切り良くスクロール」がぶっ壊れるの対策
↑に合わせてスライドから画像一覧に戻った時の位置調整も修正
画像一覧をPageUp/Downし辛かった対策
画像一覧をPageUp/Downでも「区切り良くスクロール」が出来るように
↑↑firefoxで動かない対策
レスポップアップで使う置換の修正
レスポップアップで使う置換の追加
表示してるあぷファイル名をスライドキャプションで色分けするように
表示するあぷファイル名をレスポップアップで色分けするように
↑↑をスライドのリンクから飛んだあぷファイルでもしたかった(組み合わせ未確認)
↑あぷとあぷ小混合の画像付きレスでタグ壊れたので修正
画像一覧でだけFancyboxを使う設定の時に画像一覧に追加するあぷファイルのデータ属性が変わってなかったのを修正
Firefox+赤福:非公式 Extended 版(以降 赤福)でおかしくなるとこをざっくり修正
画像一覧のあぷファイルを1つずつ読込んで差し替えられるよう設定可能に
「」ッチーで使えるように
画像一覧に追加されるレスがURLだけだと文字省略でまるっと消えてたのを修正
思いつきであれこれ足してたら遅くなったから機能分離してjQueryを抜き始める
整頓
赤福の続きを読むで画像一覧が壊れるのを修正
スレ開いた時に属性を2度付けしてたのを修正
拡張機能で同期して隔離された画像を一覧に表示しないよう設定可能に
表示しない画像が消されたのか隔離されたものかで選べるよう設定可能に
画像一覧のレス省略にナッパ追加
jQuery抜けた
画像一覧ボタンに画像数を表示するよう設定可能に
画像が多いと遅くなってたレス省略の処理変更
画像一覧に追加されたあぷファイルを↑の途中で余分に巻き込んだのを修正
空白文字での空レスで画像一覧のレス枠が消えるの対策
画像一覧をスクロール位置から開くボタンの表示を設定可能に
引用表示中の画像もカウントしてたのを修正
引用表示中の画像を一覧に巻き込むのを修正
画像一覧ボタンの右クリに属性付けや画像カウントをやり直す機能を追加
スレにスクロールバーが出てない時にスクロールバーを消す処理をしないよう修正
「同期機能で削除画像を監視」を使った時の 削除されたからタグの属性消す→属性付け漏れ確認(後に削除)に引っかかる→属性付け のたらい回しを修正
スレの勢いが良いとタグの属性付けが漏れるのを何とかしたいけど難しいので漏れを逃さないように↑機能を気持ち向上(後に削除)
続きを読むの監視を止める手段の1つの1000レス判定がふたクロの引用ポップアップ込みだったのを修正
画像一覧ボタンの右クリであぷファイルも属性付けをやり直すよう修正
画像一覧をスクロール位置から開くボタン用にページの高さを保存したまま更新してなかったのを修正
画像一覧をスクロール位置から開くが隔離画像をカウントしたままでズレるのを修正
散らばった一覧の一枠の高さ計算と属性付け外しを整頓(続きを読むの属性付けが漏れる原因も判明、お恥)
画像一覧に追加したあぷファイルが削除されてたら表示しないのが働いてなかったのを修正
画像一覧の画像とあぷファイルをレス順に並べるよう設定可能に
画像一覧であぷファイルに表示するレスを一部変更
表記の整理したのと画像一覧であぷファイルの読込んでる感をアップ！
↑x3で変えてたいまココボタンの見た画像ラインを「画像が半分以上画面外に出てたら」に戻した
「>～～～○○○」と引用されたあぷファイルが画像一覧に並ぶのを修正
画像一覧ボタンの位置設定を少し変えたのと画像一覧を↑↓キーでも「区切り良くスクロール」が出来るように
画像一覧でGIFへのマーキングが抜けてたのを修正
画像一覧をEscキーでも閉じるようにして空白部分をクリックしたら閉じるのを設定可能に
ふたクロの画像付きレスポップアップには単独のデータ属性を付けるように
ふたクロのスマホモード用の画像一覧ボタンの位置設定とCSS調整等をざっくり追加
Android版Edge Canaryで見るログサイト用の調整
モバイル版ふたばフォレストでレスに飛ぶボタンが効かないのを修正
モバイル版ふたばフォレストだと変わる動画リンクをデスクトップ版に置換
見直しとあぷファイル関連のSVGアイコン(リンク先読込み前と文字数省略時)を変更
画像一覧開いてる時にスレ落ちか1000レス到達したら画像一覧に表示するか設定可能に
「区切り良くスクロール」をスペースキーにも適用
レスに飛ぶ先がページの一番下ら辺にあるとズレるの対策
スクロールバーがまだ出てない時に画像一覧を出して後からスクロールバーが出てきた時に画像一覧が崩れないように修正
本文にあぷファイル名がある場合の処理がふたクロの邪魔するの対策
画像一覧であぷファイルのアイコンをリンク先と差し替える時にアニメgifを止めるか設定可能に
レス省略の微修正したのと↑で止めたgifの枠にマークを付けるか設定可能に
Android版Edge Canaryで出てきた不具合を修正
レスにあぷファイルがある場合の処理を変更
あぷファイル名込みのレスに足したタグとデータ属性がふたクロの更新で消えたら付け直すように(後に変更)
続・レスにあぷファイルがある場合の処理を変更
ふたクロでNGしたレスを画像一覧にも反映するようにしたのと本文にあぷファイルあるスレでふたクロの邪魔しないよう動かすのを1秒ずらした
更新で追加されたレスをNGした時の画像カウントが外れてたのを修正
監視部分で一部無駄なことしてたのを修正したのと画像一覧を開いてる時は画像数カウントを変えないように変更
画像一覧開いてて同期で削除された画像にマーク付ける機能実行保留中
あぷのアニメgifを止める処理をpngとwebpにも適用(止めるだけでマークはしない)したのとアス比計算のミス修正
レス内のURLがすごい長いとレスポップアップからはみ出すのを修正したのと画像一覧開いてる時は画像数カウント表示を変えない→減らさないに変更
一覧ボタン右クリの画像数え直し演出を変更したのと画像一覧開いてる時の画像数カウントが変数ごちゃって増えもしなかったのを修正
画像一覧の左端を空けた
画像一覧開いてて同期で削除された画像にマーク付けるか設定可能にしたのと一覧開いてる間は開いた時より画像数カウントを減らさない処理を変更
ふたクロの更新で画像一覧であぷファイルが重複するの対策
画像一覧を開いてる時の画像数カウントが画像だけ消したレスでずれるのを修正したのと動き出し時間延長
画像一覧でナッパの文字省略処理が外れてたのを修正したのとタグ壊れ予防で置換してた記号が文字省略処理で余分に文字数使うのを修正
いまココボタンを出す計算式を修正
画像一覧に表示するレス用の置換を修正
小さい画像一覧を開けるように
画像一覧ボタンをクリックしたらどちらのサイズで開くか設定可能に
スクロールバー幅取得の修正と小さい画像一覧でのボタンとレスポップアップの位置調整
画像一覧でマウス移動が速かったりボタンの上でスクロールするとボタンが残りまくる対策したのとレスに戻るボタンで飛ぶ先を調整
画像一覧のCSSをサイズでちゃんと分けた
ログサイトならすぐ動くようにした
ふたクロがスマホモードの時用のCSSがサイズ別画像一覧のCSSに優先度で負けてたのを修正
画像一覧のあぷ動画を読込んでアイコンと差し替えられるよう設定可能に
あぷ動画のサムネ化出来たかの確認がセキュリティ制限に引っかかるから止めたのと繰り返し処理のミス修正
あぷ動画のサムネ化の待ち時間を設定可能に
画像一覧のスクロールで行途中からのPageUpで動く行を調整
大量のあぷファイルを羅列する荒らし対策
ユーザースクリプト「いろいろ自動読み込み [仮]」と併用でエラーが出ないように
↑の漏れを追加修正
ユーザースクリプト「futaba-image-preview」と併用で画像一覧のレスポップアップが崩れないように修正
あぷファイルのサムネ化でリトライしてもエラーになるあぷファイルを画像一覧に追加しないか設定可能に
↑で番号だけじゃなく拡張子も含めて覚えるように修正したのとあぷファイルの差し替えを整頓
↑の整頓で動画のリトライ部分を変え忘れたから修正ついでにもう少し整頓
あぷファイルのサムネ化で10秒(設定で変更可能)経ったらスキップするように
画像一覧を開いた時に↑でスキップしたファイルは待ち時間を半分に
「」ッチーのページ上部に被るようになったから位置調整
画像一覧を加工する部分で無駄になってた処理の整理
はっちゃん使った後に画像一覧がスクロールバーを消さないのを修正
あぷファイルのサムネ化が出来なかった理由をレスポップアップに追記
「」ッチーが動画取得を停止してるので読みに行くURLを修正
画像一覧で描写したあぷファイルのサムネを一時的に覚えておくか設定可能に
差し替えたあぷ動画に付くマーク(MP4、WEBMてとこ)をクリックするとサムネを再描写するように
↑でサムネ化スキップされたあぷ動画はまとめて再描写するように変更
「区切り良くスクロール」に使うキーがふと無反応になることがあったので整頓して様子見
ページが非アクティブ(別タブ中や最小化)だとvideo要素の制限でサムネ化止まる→これは無反応！になるから制限中のスキップと無反応で状態を分けた
↑でスキップしたあぷ動画のサムネ化をページがアクティブになったらやり直すように
↑x5でリンク切れだったサムネを再描写出来ても「次回除外するファイル」に入ったままだったのを修正
「」ッチーでレスのあぷ画像を展開して画像一覧を開くと壊れる修正と赤福でのミス修正と少し見直し
描写済みのあぷ動画のサムネをマークから再描写した時に消す要素を変え忘れたのを修正
携帯端末だとマルチタッチ(2点目以降で画像一覧ボタンタッチ)でリセットするように
画像一覧をリセットした時にブラウザ毎のスクロールバー幅も再取得するように
ページの表示後に拡大率を変えた時に画像一覧の列が減る場合の対策とレスポップアップの整頓とあぷサムネのCSSを変更
追加するCSSが赤福の「mhtで保存」で含まれないように位置変更
既に削除されてるレスが続きを読むで追加された時にふたクロで削除同期がされたか見張る部分が誤検出してエラー出てたのを修正
あぷファイルのサムネを一時的に覚えておく機能とリセット機能を微修正
画像一覧の各画像に画像一覧から除外するボタンを追加するか設定可能に(携帯端末では追加したら誤タッチ対策で常に表示)
画像一覧の追加ボタンのイベントを整頓したのと追加ボタンや動画マークの上でもレスポップアップが消えないように
除外ボタンのアイコン切替でレスポップアップがちらつかないように修正
動画に付くマークのクリックでも再生するようにしたのと差し替えたあぷ動画に付くマークのサムネ再描写機能をクリックから右クリックに変更
体感はない早さ向上と整理とスペースの統一
非IDスレでIDが付いたレスの画像を画像一覧で加工するか設定可能に
同期機能で消えたレス画像のマークを↑と他の追加ボタンに合わせて変更
ふたクロで画像や動画を拡大した後の画像一覧の表示崩れを修正
携帯端末での動画のタッチイベントの予防とレスポップアップの挙動を変更
携帯端末での画像一覧を戻るで閉じるように
↑↑のCSSを修正したのとスレ落ちバーの文字位置を調整したのと消し忘れを削除
Chrome拡張機能「ビーニードル」と併用で画像一覧が崩れないように修正
ふたクロ+ビーニードルCと併用で更新時に固まるのを修正
赤福の「mhtで保存」への割り込みを変更
小さい画像一覧用のいまココボタンを出す計算式を修正
ふたクロであぷファイルを展開した後の画像一覧のレスポップアップを修正
ふたポのimgログで使えるように
ふたポのimgログでの修正
些細な表記統一とふたクロでNG判定されてクラスが追加されたレスの画像をNG機能オフで表示するか設定可能に(これまではクラスだけ見て表示してなかった)
ふたクロであぷファイルを展開した後の画像一覧のレスポップアップを修正
↑↑で更新での継ぎ足しでのミス修正
携帯端末でのレスポップアップが2回目からフォントが小さいままなのを修正
*/