(() => {
    var AccountsInChromeStorageClass = class {
        key = "MeBoy.signAccounts";
        async load() {
            return (await chrome.storage.local.get(this.key))[this.key];
        }
        async save(json) {
            await chrome.storage.local.set({ [this.key]: json });
        }
    };
    var AccountsInChromeStorage = new AccountsInChromeStorageClass();
    var protoOf = Object.getPrototypeOf;
    var changedStates;
    var derivedStates;
    var curDeps;
    var curNewDerives;
    var alwaysConnectedDom = { isConnected: 1 };
    var gcCycleInMs = 1e3;
    var statesToGc;
    var propSetterCache = {};
    var objProto = protoOf(alwaysConnectedDom);
    var funcProto = protoOf(protoOf);
    var _undefined;
    var addAndScheduleOnFirst = (set, s, f, waitMs) => (set ?? (waitMs ? setTimeout(f, waitMs) : queueMicrotask(f), new Set())).add(s);
    var runAndCaptureDeps = (f, deps, arg) => {
        let prevDeps = curDeps;
        curDeps = deps;
        try {
            return f(arg);
        }
        catch (e) {
            console.error(e);
            return arg;
        }
        finally {
            curDeps = prevDeps;
        }
    };
    var keepConnected = (l) => l.filter((b3) => b3._dom?.isConnected);
    var addStatesToGc = (d) => statesToGc = addAndScheduleOnFirst(statesToGc, d, () => {
        for (let s of statesToGc)
            s._bindings = keepConnected(s._bindings), s._listeners = keepConnected(s._listeners);
        statesToGc = _undefined;
    }, gcCycleInMs);
    var stateProto = {
        get val() {
            curDeps?._getters?.add(this);
            return this.rawVal;
        },
        get oldVal() {
            curDeps?._getters?.add(this);
            return this._oldVal;
        },
        set val(v) {
            curDeps?._setters?.add(this);
            if (v !== this.rawVal) {
                this.rawVal = v;
                this._bindings.length + this._listeners.length ? (derivedStates?.add(this), changedStates = addAndScheduleOnFirst(changedStates, this, updateDoms)) : this._oldVal = v;
            }
        }
    };
    var state = (initVal) => ({
        __proto__: stateProto,
        rawVal: initVal,
        _oldVal: initVal,
        _bindings: [],
        _listeners: []
    });
    var bind = (f, dom) => {
        let deps = { _getters: new Set(), _setters: new Set() }, binding = { f }, prevNewDerives = curNewDerives;
        curNewDerives = [];
        let newDom = runAndCaptureDeps(f, deps, dom);
        newDom = (newDom ?? document).nodeType ? newDom : new Text(newDom);
        for (let d of deps._getters)
            deps._setters.has(d) || (addStatesToGc(d), d._bindings.push(binding));
        for (let l of curNewDerives)
            l._dom = newDom;
        curNewDerives = prevNewDerives;
        return binding._dom = newDom;
    };
    var derive = (f, s = state(), dom) => {
        let deps = { _getters: new Set(), _setters: new Set() }, listener = { f, s };
        listener._dom = dom ?? curNewDerives?.push(listener) ?? alwaysConnectedDom;
        s.val = runAndCaptureDeps(f, deps, s.rawVal);
        for (let d of deps._getters)
            deps._setters.has(d) || (addStatesToGc(d), d._listeners.push(listener));
        return s;
    };
    var add = (dom, ...children) => {
        for (let c of children.flat(Infinity)) {
            let protoOfC = protoOf(c ?? 0);
            let child = protoOfC === stateProto ? bind(() => c.val) : protoOfC === funcProto ? bind(c) : c;
            child != _undefined && dom.append(child);
        }
        return dom;
    };
    var tag = (ns, name, ...args) => {
        let [{ is, ...props }, ...children] = protoOf(args[0] ?? 0) === objProto ? args : [{}, ...args];
        let dom = ns ? document.createElementNS(ns, name, { is }) : document.createElement(name, { is });
        for (let [k, v] of Object.entries(props)) {
            let getPropDescriptor = (proto) => proto ? Object.getOwnPropertyDescriptor(proto, k) ?? getPropDescriptor(protoOf(proto)) : _undefined;
            let cacheKey = name + "," + k;
            let propSetter = propSetterCache[cacheKey] ??= getPropDescriptor(protoOf(dom))?.set ?? 0;
            let setter = k.startsWith("on") ? (v2, oldV) => {
                let event = k.slice(2);
                dom.removeEventListener(event, oldV);
                dom.addEventListener(event, v2);
            } : propSetter ? propSetter.bind(dom) : dom.setAttribute.bind(dom, k);
            let protoOfV = protoOf(v ?? 0);
            k.startsWith("on") || protoOfV === funcProto && (v = derive(v), protoOfV = stateProto);
            protoOfV === stateProto ? bind(() => (setter(v.val, v._oldVal), dom)) : setter(v);
        }
        return add(dom, children);
    };
    var handler = (ns) => ({ get: (_, name) => tag.bind(_undefined, ns, name) });
    var update = (dom, newDom) => newDom ? newDom !== dom && dom.replaceWith(newDom) : dom.remove();
    var updateDoms = () => {
        let iter = 0, derivedStatesArray = [...changedStates].filter((s) => s.rawVal !== s._oldVal);
        do {
            derivedStates = new Set();
            for (let l of new Set(derivedStatesArray.flatMap((s) => s._listeners = keepConnected(s._listeners))))
                derive(l.f, l.s, l._dom), l._dom = _undefined;
        } while (++iter < 100 && (derivedStatesArray = [...derivedStates]).length);
        let changedStatesArray = [...changedStates].filter((s) => s.rawVal !== s._oldVal);
        changedStates = _undefined;
        for (let b3 of new Set(changedStatesArray.flatMap((s) => s._bindings = keepConnected(s._bindings))))
            update(b3._dom, bind(b3.f, b3._dom)), b3._dom = _undefined;
        for (let s of changedStatesArray)
            s._oldVal = s.rawVal;
    };
    var van_default = {
        tags: new Proxy((ns) => new Proxy(tag, handler(ns)), handler()),
        hydrate: (dom, f) => update(dom, bind(f, dom)),
        add,
        state,
        derive
    };
    var FutabaBoard = class {
        static get isCatalog() {
            const url = new URL(document.URL);
            return url.searchParams.get("mode") == "cat";
        }
        static get isImage() {
            return document.URL.indexOf("src") != -1;
        }
        static get isThread() {
            if (document.URL.endsWith("futaba.htm")) {
                return false;
            }
            return this.hasCommentForm;
        }
        static get hasCommentForm() {
            return !!document.querySelector("#ftbl");
        }
    };
    function wait(ms) {
        return new Promise((resolve) => {
            setTimeout(() => {
                resolve();
            }, ms);
        });
    }
    var sleep = wait;
    function base64ToArrayBuffer(base64) {
        return Uint8Array.fromBase64(base64).buffer;
    }
    function arrayBufferToBase64(arrayBuffer) {
        return new Uint8Array(arrayBuffer).toBase64({
            omitPadding: true
        });
    }
    async function fromAsync(promises) {
        return await Array.fromAsync(promises);
    }
    var { a, b, button, br, div, select, style, span, table, tbody, td, tr } = van_default.tags;
    function querySelector(selector) {
        return document.querySelector(selector);
    }
    function stringToElement(htmlString) {
        const element = div();
        element.innerHTML = htmlString;
        return element.children[0];
    }
    function createSvgTags() {
        return van_default.tags("http://www.w3.org/2000/svg");
    }
    var svg = createSvgTags();
    function base64ToBlob(base64) {
        return new Blob([base64ToArrayBuffer(base64)]);
    }
    var ContentScript = {
        async uploadToUp2(origin, data) {
            await chrome.runtime.sendMessage({
                type: "upload",
                value: data,
                origin
            });
        },
        async downloadUp2Html(origin) {
            return await chrome.runtime.sendMessage({
                type: "downloadHtml",
                origin
            });
        }
    };
    async function canvasToBlob(canvas) {
        return new Promise((resolve) => canvas.toBlob(resolve));
    }
    function findUploadedFileName(html, keyComment) {
        const dom = div();
        dom.innerHTML = html;
        const uploadedFileRows = [...dom.querySelectorAll(`.files tr`)];
        const myFile = uploadedFileRows.find((row) => row.querySelector(".fco")?.textContent.trim() == keyComment);
        return myFile?.querySelector(".fnm")?.textContent.trim();
    }
    async function downloadUploadedFileName(params) {
        const html = await ContentScript.downloadUp2Html(params.upOrigin);
        return findUploadedFileName(html, params.keyComment);
    }
    async function uploadFileToUp2(params) {
        const file = Array.from(new Uint8Array(await params.blob.arrayBuffer()));
        const keyComment = `${Math.random()}`;
        await ContentScript.uploadToUp2(params.upOrigin, {
            file,
            comment: keyComment,
            pass: params.password
        });
        for (let i = 0; i < 4; i++) {
            await sleep(200 * 2 ** i);
            const result = await downloadUploadedFileName({
                keyComment,
                upOrigin: params.upOrigin
            });
            if (result) {
                return result;
            }
        }
        return;
    }
    function generatePassword() {
        return arrayBufferToBase64(crypto.getRandomValues(new Uint8Array(4)).buffer).toUpperCase();
    }
    function loadPass() {
        const passwordKey = "MeBoy.passUp2";
        const password = localStorage.getItem(passwordKey) ?? generatePassword();
        localStorage.setItem(passwordKey, password);
        return password;
    }
    async function computeTegakiBlob() {
        const canvas = document.getElementById("oejs");
        if (canvas) {
            const blob = await canvasToBlob(canvas);
            if (!blob)
                return null;
            return {
                blob,
                dispose() {
                    canvas.remove();
                }
            };
        }
        const baseform = document.getElementById("baseform");
        if (baseform) {
            return {
                blob: base64ToBlob(baseform.value),
                dispose() {
                    baseform.value = "";
                }
            };
        }
        return null;
    }
    function UpTegakiExtension(upOrigin) {
        if (!FutabaBoard.hasCommentForm)
            return;
        const password = loadPass();
        const uploadTegaki = async () => {
            const blobResult = await computeTegakiBlob();
            if (!blobResult) {
                alert("canvasからblobを作成できませんでした");
                return;
            }
            const up2FileName = await uploadFileToUp2({
                blob: blobResult.blob,
                password,
                upOrigin
            });
            if (!up2FileName) {
                alert("ファイルの投稿に失敗しました");
                return;
            }
            const commentArea = document.getElementById("ftxa");
            commentArea.value += `${up2FileName}
`;
            console.log("uploaded", up2FileName);
            blobResult.dispose();
            document.getElementById("oebtnj")?.click();
        };
        van_default.add(document.querySelector("#MeBoy-extension-menu-container"), [
            div({
                title: `pass:${password}`,
                class: "pdms",
                onclick: uploadTegaki
            }, "あぷ小にUp")
        ]);
    }
    function getSubmitButton() {
        return document.querySelector(`[value="返信する"]`) ?? document.querySelector(`[value='スレッドを立てる']`);
    }
    function createNewSubmitButton(submitButton, beforeSubmission) {
        const originalOnClick = submitButton.getAttribute("onclick") ?? "";
        const newOnClick = async () => {
            await beforeSubmission();
            evalOnClick(originalOnClick);
            const isNewThread = newSubmitButton.value == "スレッドを立てる";
            if (isNewThread) {
                findParentForm(newSubmitButton)?.submit();
            }
        };
        const newSubmitButton = stringToElement(`<input type="submit" value="${submitButton.value}" isNew="true">`);
        newSubmitButton.onclick = newOnClick;
        return newSubmitButton;
    }
    function findParentForm(element) {
        const parent = element.parentElement;
        if (!parent) {
            return;
        }
        if (parent instanceof HTMLFormElement) {
            return parent;
        }
        return findParentForm(parent);
    }
    function evalOnClick(onclickText) {
        const button2 = stringToElement(`<button onclick='${onclickText}'></button>`);
        button2.click();
    }
    function TaskBeforeSubmissionForm(taskBeforeSubmission) {
        function replaceSubmitButton(taskBeforeOnSubmit) {
            const submitButton = getSubmitButton();
            if (!submitButton)
                return;
            submitButton.parentElement.replaceChild(createNewSubmitButton(submitButton, taskBeforeOnSubmit), submitButton);
        }
        replaceSubmitButton(taskBeforeSubmission);
        const fm = querySelector("#fm");
        fm?.addEventListener("submit", (e) => e.preventDefault());
    }
    var TimeStamp = class {
        constructor(resolutionInSec) {
            this.resolutionInSec = resolutionInSec;
        }
        get(date) {
            return this.#get_rough_time(date);
        }
        #get_rough_time(date) {
            return Math.round(date.getTime() / 1e3 / this.resolutionInSec);
        }
        getNeighbours(date) {
            const time = this.#get_rough_time(date);
            return [time - 1, time, time + 1];
        }
    };
    function catchError(func) {
        try {
            return [void 0, func()];
        }
        catch (e) {
            return [e];
        }
    }
    function trimRuby(text) {
        return text?.replace(/^[ \r\n\t\uFEFF\xA0]+|[ \t\r\n\uFEFF\xA0]+$/g, "");
    }
    function commentBlockToString(blockquote) {
        let text = "";
        for (const node of blockquote.childNodes) {
            if (node instanceof HTMLBRElement) {
                text += "\n";
            }
            else {
                text += trimRuby(node.textContent);
            }
        }
        return text;
    }
    function flatCommentBlock(blockquote) {
        const text = commentBlockToString(blockquote);
        const lines = text.split("\n");
        const newNodes = [];
        for (let i = 0; i < lines.length - 1; i++) {
            newNodes.push(document.createTextNode(lines[i]));
            newNodes.push(br());
        }
        newNodes.push(document.createTextNode(lines[lines.length - 1]));
        blockquote.innerHTML = "";
        blockquote.append(...newNodes);
    }
    function getDateFromMailElement(mail_element) {
        const dateString = mail_element.textContent.match(/\d\d\/\d\d\/\d\d\([月火水木金土日]\)\d\d:\d\d:\d\d/)?.[0];
        return new Date(`20${dateString}`);
    }
    function getDateFromCommentBlock(commentBlock) {
        const mailElement = commentBlock.parentElement?.querySelector(".cnw");
        return mailElement && getDateFromMailElement(mailElement);
    }
    function stringToContentOfCommentBlock(text, comment) {
        comment.innerHTML = "";
        const lines = text.split("\n");
        for (let i = 0; i < lines.length - 1; i++) {
            comment.appendChild(document.createTextNode(lines[i]));
            comment.appendChild(document.createElement("br"));
        }
        comment.appendChild(document.createTextNode(lines[lines.length - 1]));
    }
    function getCommentNumberFromCommentBlock(block) {
        const cno = block.parentElement?.querySelector(".cno");
        if (!cno)
            return;
        const match = cno.textContent.match(/No\.(?<no>\d+)/);
        if (!match?.groups)
            return;
        const { no } = match.groups;
        return Number(no);
    }
    function findCommentTable(block) {
        function findParentTable(element) {
            const parent = element.parentElement;
            if (!parent)
                return;
            if (parent instanceof HTMLTableElement)
                return parent;
            return findParentTable(parent);
        }
        return findParentTable(block);
    }
    var permutationCityDeletedClassName = "PermutationCity-deleted";
    function hideCommentBlock(block) {
        const table2 = findCommentTable(block);
        table2?.classList.add(permutationCityDeletedClassName);
    }
    function showCommentBlock(block) {
        findCommentTable(block)?.classList.remove(permutationCityDeletedClassName);
    }
    var CommentController = class {
        constructor(commentBlock) {
            this.commentBlock = commentBlock;
        }
        texts = {};
        async run(defaultRoomName) {
            const block = this.commentBlock;
            this.texts[defaultRoomName] = {
                text: commentBlockToString(block),
                isVisible: true
            };
        }
        async setRoom(room, timeStamp) {
            const roomName = room.name;
            if (this.texts[roomName] === void 0) {
                const date = getDateFromCommentBlock(this.commentBlock);
                const no = getCommentNumberFromCommentBlock(this.commentBlock);
                const commentText = date && no !== void 0 ? await room.decryptComment(commentBlockToString(this.commentBlock), date, no, timeStamp) : void 0;
                this.texts[roomName] = {
                    text: commentText?.text,
                    isVisible: commentText !== void 0
                };
            }
            const roomInfo = this.texts[roomName];
            if (roomInfo.isVisible) {
                stringToContentOfCommentBlock(roomInfo.text, this.commentBlock);
                showCommentBlock(this.commentBlock);
            }
            else {
                hideCommentBlock(this.commentBlock);
            }
        }
    };
    function PermutationCityStyle() {
        return style(`
.${permutationCityDeletedClassName}{display: none;}
`);
    }
    var Stopwatch = class {
        #isRunning = false;
        #firstTimeStamp;
        #time;
        onTick;
        get time() {
            return this.#time;
        }
        #animate(timeStamp) {
            if (!this.#isRunning) {
                return;
            }
            window.requestAnimationFrame((timeStamp2) => {
                this.#animate(timeStamp2);
            });
            this.#updateTime(timeStamp);
            this.onTick?.();
        }
        #updateTime(timeStamp) {
            this.#firstTimeStamp = this.#firstTimeStamp ?? timeStamp;
            this.#time = this.#getTime(timeStamp);
        }
        #getTime(timeStamp) {
            if (timeStamp == null) {
                return 0;
            }
            else if (this.#firstTimeStamp == null) {
                return timeStamp;
            }
            else {
                return timeStamp - this.#firstTimeStamp;
            }
        }
        start() {
            this.#isRunning = true;
            this.#firstTimeStamp = void 0;
            this.#animate();
        }
        stop() {
            this.#isRunning = false;
        }
    };
    var EasterEggTimer = class {
        #countDownStartSeconds = 0.7;
        #activationSeconds = 2;
        #stopwatch = null;
        onStartCountDown = () => {
        };
        onTick = () => {
        };
        onActivate = () => {
        };
        onInterrupted = () => {
        };
        get progressRate() {
            return (this.#stopwatch.time / 1e3 - this.#countDownStartSeconds) / (this.#activationSeconds - this.#countDownStartSeconds);
        }
        start() {
            if (this.#stopwatch != null) {
                this.#stopwatch.stop();
                this.#stopwatch = null;
            }
            this.#stopwatch = new Stopwatch();
            var isCountDownStarted = false;
            this.#stopwatch.onTick = () => {
                this.onTick();
                if (!isCountDownStarted) {
                    if (this.#stopwatch.time > 1e3 * this.#countDownStartSeconds) {
                        isCountDownStarted = true;
                        this.onStartCountDown();
                    }
                }
                if (this.#stopwatch.time > 1e3 * this.#activationSeconds) {
                    this.#stopwatch.stop();
                    this.onActivate();
                }
            };
            this.#stopwatch.start();
        }
        stop() {
            if (this.#stopwatch == null) {
                return;
            }
            this.#stopwatch.stop();
            this.#stopwatch = null;
            this.onInterrupted();
        }
    };
    function WaitingIcon(props) {
        const width = 32;
        const height = 32;
        const progressRateText = () => {
            let text = "";
            const pointNumber = 64;
            const radius = 12;
            for (let i = 0; i < pointNumber; i++) {
                const angle = i / (pointNumber - 1) * Math.PI * 2 * props.progressRate.val;
                let pointText = i == 0 ? "M" : "L";
                pointText += width / 2 + radius * Math.sin(angle) + " ";
                pointText += height / 2 - radius * Math.cos(angle) + " ";
                text += pointText;
            }
            return text;
        };
        const arc = svg.path({
            fill: "transparent",
            d: () => progressRateText(),
            "stroke-width": `${props.thickness ?? 6}`,
            stroke: props.color ?? "deepskyblue"
        });
        const native = svg.svg({
            width: `${width}`,
            height: `${height}`,
            style: () => `position: absolute; filter: drop-shadow(2px 2px 4px rgba(0, 0, 0, 0.3)); visibility: ${props.visible.val ? "" : "hidden"}`
        }, arc);
        return native;
    }
    function EasterEgg(button2, callback) {
        let isActivated = false;
        const easterEggTimer = new EasterEggTimer();
        let waitingIcon;
        const visible = van_default.state(true);
        const progressRate = van_default.state(0);
        easterEggTimer.onStartCountDown = () => {
            if (waitingIcon == null) {
                waitingIcon = WaitingIcon({ visible, progressRate });
                van_default.add(button2, [waitingIcon]);
            }
            visible.val = true;
            progressRate.val = 0;
        };
        easterEggTimer.onTick = () => {
            if (waitingIcon != null) {
                progressRate.val = easterEggTimer.progressRate;
            }
        };
        easterEggTimer.onActivate = () => {
            visible.val = false;
            callback(position);
            isActivated = true;
        };
        easterEggTimer.onInterrupted = () => {
            if (waitingIcon != null) {
                visible.val = false;
            }
        };
        let position;
        const listeners = {
            pointerdown: (e) => {
                isActivated = false;
                easterEggTimer.start();
                position = { x: e.pageX, y: e.pageY };
            },
            pointerleave: () => {
                easterEggTimer.stop();
            },
            pointerup: () => {
                easterEggTimer.stop();
            }
        };
        for (const eventKey in listeners) {
            button2.addEventListener(eventKey, listeners[eventKey]);
        }
        button2.addEventListener("click", (e) => {
            if (isActivated) {
                e.stopPropagation();
            }
        }, true);
        return button2;
    }
    function preventReset(select2) {
        document.addEventListener("reset", async () => {
            const prev = select2.selectedIndex;
            await sleep(0);
            select2.selectedIndex = prev;
        });
        return select2;
    }
    function signalList(createList, itemsState, createListItem) {
        const listItems = new Map();
        const items = new Map();
        const list = createList();
        van_default.derive(() => {
            const currentItems = new Set(itemsState.val);
            for (const prevItem of items.values()) {
                if (!currentItems.has(prevItem)) {
                    const listItem = listItems.get(prevItem);
                    listItem.remove();
                    listItems.delete(prevItem);
                    items.delete(listItem);
                }
            }
            for (const item of itemsState.val) {
                if (!listItems.has(item)) {
                    const listItem = createListItem(item);
                    listItems.set(item, listItem);
                    items.set(listItem, item);
                }
            }
            for (const item of itemsState.val) {
                const listItem = listItems.get(item);
                list.insertBefore(listItem, null);
            }
        });
        return list;
    }
    function Dropdown(button2, menu) {
        const visible = van_default.state(false);
        function toggle() {
            visible.val = !visible.val;
        }
        document.body.addEventListener("click", (e) => {
            if (e.target == button2)
                return;
            if (visible.val) {
                toggle();
            }
        });
        button2.addEventListener("click", toggle);
        return span({ style: `position: relative; display: inline-block;` }, button2, div({
            class: "pdmm",
            style: () => `
background: #ffe;
display: ${visible.val ? "block" : "none"};
position: absolute;`
        }, menu));
    }
    var { option, tr: tr2 } = van_default.tags;
    function PermutationCityRow(rooms, handleAddVisitorEnv) {
        async function onAddButtonClick() {
            const name = prompt("部屋の名前を決めてください：");
            if (!name)
                return;
            await rooms.addPermutationCity(name);
            rooms.selectedIndex.val = rooms.rooms.val.length - 1;
        }
        function onSelectChange(e) {
            const newValue = e.target.selectedIndex;
            rooms.selectedIndex.val = newValue;
        }
        const roomSelect = signalList(() => {
            return preventReset(select({
                onchange: onSelectChange,
                selectedIndex: rooms.selectedIndex,
                onclick: () => rooms.load()
            }));
        }, rooms.rooms, (room) => option(room.name));
        return tr2(td({ class: "ftdc" }, b("部屋")), td(roomSelect, EasterEgg(button({
            title: "部屋追加",
            onclick: onAddButtonClick
        }, "+"), handleAddVisitorEnv), PermutationCityDropdownMenu({ deleteRoom: rooms.removeRoom })));
    }
    function PermutationCityDropdownMenu(props) {
        return Dropdown(span({ class: "pdms" }, "⋯"), span([span({ class: "pdms", onclick: props.deleteRoom }, "部屋の削除")]));
    }
    var kitaComment = "ｷﾀ━━━━━━(ﾟ∀ﾟ)━━━━━━ !!!!!";
    function strToBuffer(str) {
        return new TextEncoder().encode(str).buffer;
    }
    async function deriveKey(password, salt) {
        const baseKey = await crypto.subtle.importKey("raw", strToBuffer(password), { name: "PBKDF2" }, false, ["deriveKey"]);
        return crypto.subtle.deriveKey({
            name: "PBKDF2",
            salt,
            iterations: 1e5,
            hash: "SHA-256"
        }, baseKey, { name: "AES-CTR", length: 128 }, true, ["encrypt", "decrypt"]);
    }
    var CtrEncryption = class _CtrEncryption {
        constructor(key) {
            this.key = key;
        }
        static async create(password, salt = new Uint8Array([]).buffer) {
            const key = await deriveKey(password, salt);
            return new _CtrEncryption(key);
        }
        static async fromRandom() {
            const key = await crypto.subtle.generateKey({ name: "AES-CTR", length: 128 }, true, ["encrypt", "decrypt"]);
            return new _CtrEncryption(key);
        }
        static async fromKeyAgreement(publicKey, privateKey) {
            const key = await crypto.subtle.deriveKey({ name: publicKey.algorithm.name, public: publicKey }, privateKey, {
                name: "AES-CTR",
                length: 128
            }, true, ["encrypt", "decrypt"]);
            return new _CtrEncryption(key);
        }
        static async fromArrayBuffer(arrayBuffer) {
            const key = await crypto.subtle.importKey("raw", arrayBuffer, { name: "AES-CTR", length: 128 }, true, ["encrypt", "decrypt"]);
            return new _CtrEncryption(key);
        }
        async encrypt(plaintext, counter) {
            const ciphertext = await crypto.subtle.encrypt({
                name: "AES-CTR",
                length: 128,
                counter
            }, this.key, plaintext);
            return ciphertext;
        }
        async decrypt(ciphertext, counter) {
            const plaintextBuffer = await crypto.subtle.decrypt({
                name: "AES-CTR",
                length: 128,
                counter
            }, this.key, ciphertext);
            return plaintextBuffer;
        }
        async export() {
            return await crypto.subtle.exportKey("jwk", this.key);
        }
        static async import(keyData) {
            const key = await crypto.subtle.importKey("jwk", keyData, { name: "AES-CTR", length: 128 }, true, ["encrypt", "decrypt"]);
            return new _CtrEncryption(key);
        }
    };
    var DustUri = class _DustUri {
        constructor(data) {
            this.data = data;
        }
        static scheme = "dust";
        get base64() {
            return arrayBufferToBase64(this.data);
        }
        static parse(uri) {
            if (!uri.startsWith(`${_DustUri.scheme}:`))
                return;
            const match = uri.match(/dust:(?<body>[\w\d+/]+)/);
            if (!match?.groups)
                return;
            try {
                return new _DustUri(base64ToArrayBuffer(match.groups.body));
            }
            catch (_) {
                return;
            }
        }
        toString() {
            return `${_DustUri.scheme}:${this.base64}`;
        }
    };
    var Crc = class _Crc {
        static #TABLE;
        static #InitTable() {
            _Crc.#TABLE = new Uint32Array(256);
            for (let i = 0; i < 256; i++) {
                let c = i;
                for (let k = 0; k < 8; k++) {
                    c = (c & 1) !== 0 ? 3988292384 ^ c >>> 1 : c >>> 1;
                }
                _Crc.#TABLE[i] = c;
            }
        }
        static crc32(current) {
            if (!_Crc.#TABLE) {
                _Crc.#InitTable();
            }
            let crc = -1;
            for (let index = 0; index < current.length; index++) {
                crc = _Crc.#TABLE[(crc ^ current[index]) & 255] ^ crc >>> 8;
            }
            return (crc ^ -1) >>> 0;
        }
    };
    function uint32ToUint8Array(value) {
        return new Uint8Array(new Uint32Array([value]).buffer);
    }
    function arrayBufferToUint32(array) {
        return new Uint32Array(array)[0];
    }
    var TextToUint8ArrayWithCrc32Class = class {
        encode(text) {
            const textData = new TextEncoder().encode(text);
            const crc32 = Crc.crc32(textData);
            const crc32Array = uint32ToUint8Array(crc32);
            const result = new Uint8Array([...crc32Array, ...textData]);
            return { result, crc32 };
        }
        decode(array) {
            const crc32Array = array.slice(0, 4);
            const expectedCrc32 = arrayBufferToUint32(crc32Array.buffer);
            const textData = array.slice(4);
            const text = new TextDecoder().decode(textData);
            return {
                expectedCrc32,
                text,
                actualCrc32: Crc.crc32(textData)
            };
        }
    };
    var TextToUint8ArrayWithCrc32 = new TextToUint8ArrayWithCrc32Class();
    var DefaultRoom = class {
        name = "なし（初期設定）";
        async decryptComment(comment, date, no, timeStampComputer) {
            return;
        }
        async extendSubmission(timeStamp) {
            return;
        }
    };
    async function decryptCommentText(commentText, date, timeStampComputer, encryption) {
        async function decryptUriAroundTimeStamp(uri2, timeStamp2) {
            const timeStamps = [timeStamp2, timeStamp2 - 1, timeStamp2 + 1];
            for (const timeStamp3 of timeStamps) {
                const result = await decryptUriWithTimeStamp(uri2, timeStamp3);
                if (result)
                    return result;
            }
            return;
        }
        async function decryptUriWithTimeStamp(uri2, timeStamp2) {
            try {
                const counter = numberTo16BytesArray(timeStamp2);
                const decrypted = await encryption.decrypt(uri2.data, counter);
                const analyzed = TextToUint8ArrayWithCrc32.decode(new Uint8Array(decrypted));
                if (analyzed.expectedCrc32 != analyzed.actualCrc32)
                    return;
                return analyzed;
            }
            catch (_) {
                return;
            }
        }
        const uri = DustUri.parse(commentText);
        if (!uri)
            return;
        const timeStamp = timeStampComputer.get(date);
        return await decryptUriAroundTimeStamp(uri, timeStamp);
    }
    async function encryptComment(textArea, timeStampComputer, encryption, date) {
        const text = textArea.value || kitaComment;
        const plaintextData = TextToUint8ArrayWithCrc32.encode(text);
        const timeStamp = timeStampComputer.get(date);
        const encryptedData = await encryption.encrypt(plaintextData.result, numberTo16BytesArray(timeStamp));
        const dustUri = new DustUri(encryptedData);
        textArea.value = dustUri.toString();
    }
    var PermutationCity = class _PermutationCity {
        constructor(name, encryption) {
            this.name = name;
            this.encryption = encryption;
        }
        static async create(password) {
            const name = `順列都市@"${password}"`;
            const encryption = await CtrEncryption.create(password);
            return new _PermutationCity(name, encryption);
        }
        async decryptComment(comment, date, no, timeStampComputer) {
            return decryptCommentText(comment, date, timeStampComputer, this.encryption);
        }
        async extendSubmission(timeStampComputer, textArea, date) {
            encryptComment(textArea, timeStampComputer, this.encryption, date);
        }
    };
    function numberTo16BytesArray(value) {
        return new Uint8Array(new Uint32Array([value, Math.floor(value / 2 ** 32), 0, 0]).buffer).buffer;
    }
    var ChromeKeyStorage = class {
        async get(key) {
            return (await chrome.storage.local.get(key))?.[key];
        }
        async set(key, obj) {
            await chrome.storage.local.set({ [key]: obj });
        }
    };
    function createPermutationCities(storage) {
        const permutationCityKey = "MeBoy.permutationCities";
        const permutationCities = van_default.state([]);
        const save = async () => {
            if (permutationCities.val.length == 0)
                return;
            const jsonPromises = permutationCities.val.map(async (room) => {
                return {
                    name: room.name,
                    cryptoKey: await room.encryption.export()
                };
            });
            const jsons = await Promise.all(jsonPromises);
            await storage.set(permutationCityKey, jsons);
        };
        van_default.derive(async () => {
            save();
        });
        const add3 = async (password) => {
            await load();
            return await addWithoutLoading(password);
        };
        const addWithoutLoading = async (password) => {
            const room = await PermutationCity.create(password);
            permutationCities.val = [...permutationCities.val, room];
            return room;
        };
        const load = async () => {
            if (permutationCities.val.length != 0)
                return;
            const permutationCityJsons = await storage.get(permutationCityKey);
            if (!permutationCityJsons || permutationCityJsons?.length === 0) {
                await addWithoutLoading("エリュシオン");
            }
            else {
                permutationCities.val = await Promise.all(permutationCityJsons.map(async (city) => {
                    const room = new PermutationCity(city.name, await CtrEncryption.import(city.cryptoKey));
                    return room;
                }));
            }
        };
        return {
            permutationCities,
            load,
            add: add3
        };
    }
    function arrayBufferToBase64Url(arrayBuffer) {
        return arrayBufferToBase64(arrayBuffer).replaceAll("+", "-").replaceAll("/", "_");
    }
    function base64UrlToArrayBuffer(base64Url) {
        return base64ToArrayBuffer(base64Url.replaceAll("-", "+").replaceAll("_", "/"));
    }
    function jsonToBase64Url(json) {
        return arrayBufferToBase64Url(new TextEncoder().encode(JSON.stringify(json)).buffer);
    }
    function base64UrlToJson(base64Url) {
        return JSON.parse(new TextDecoder().decode(base64UrlToArrayBuffer(base64Url)));
    }
    async function verifyBase64Url(publicKeyJsonBase64Url, signArrayBufferBase64Url, text) {
        const key = await crypto.subtle.importKey("jwk", base64UrlToJson(publicKeyJsonBase64Url), "Ed25519", true, ["verify"]);
        const verifyResult = await crypto.subtle.verify("Ed25519", key, base64UrlToArrayBuffer(signArrayBufferBase64Url), new TextEncoder().encode(text));
        return verifyResult;
    }
    async function createKeyAgreementKeyPair() {
        return await crypto.subtle.generateKey("X25519", true, [
            "deriveKey"
        ]);
    }
    async function createSignVerifyKeyPair() {
        return await crypto.subtle.generateKey("Ed25519", true, [
            "sign",
            "verify"
        ]);
    }
    function findEncryptionFromNo(encryptions, no) {
        const index = findIndexFromNo(encryptions, no);
        if (index == -1)
            return;
        return encryptions[index];
    }
    function findIndexFromNo(encryptions, no) {
        if (encryptions.length == 0)
            return -1;
        let min = 0;
        let max = encryptions.length;
        while (true) {
            if (min + 1 >= max) {
                return min;
            }
            const center = Math.floor((min + max) / 2);
            const centerEncryption = encryptions[center];
            if (no < centerEncryption.no) {
                max = center;
            }
            else {
                min = center;
            }
        }
        return -1;
    }
    var VisitorEnvEncryptions = class _VisitorEnvEncryptions {
        encryptions = [];
        #loadedTokens = new Set();
        get encryption() {
            return this.encryptions.at(-1)?.encryption;
        }
        get isHost() {
            return this.encryptions[0]?.no == -1;
        }
        async start(date) {
            this.encryptions.push({
                encryption: await CtrEncryption.fromRandom(),
                token: "",
                date: date ?? new Date(),
                no: -1
            });
        }
        find(no) {
            return findEncryptionFromNo(this.encryptions, no);
        }
        async addEncryption(decryptedText, options) {
            if (decryptedText === void 0)
                return;
            const parsed = await parseAckUri(decryptedText, this.encryption ? { prevEncryption: this.encryption } : { keyAgreement: options.keyAgreement });
            if (!parsed)
                return;
            if (this.#loadedTokens.has(parsed.token))
                return;
            this.#loadedTokens.add(parsed.token);
            this.encryptions.push({
                encryption: parsed.encryption,
                token: parsed.token,
                date: options.date,
                no: options.no
            });
        }
        async processComment(comment, options) {
            const decryptedComment = await options.parent.decryptComment(comment, options.date, options.no, options.timeStampComputer);
            const decryptedText = decryptedComment?.text ?? comment;
            const decryptedFirstLine = getFirstNonEmptyLine(decryptedText);
            await this.addEncryption(decryptedFirstLine, {
                no: options.no,
                date: options.date,
                keyAgreement: options.keyAgreement
            });
            if (this.isHost && decryptedFirstLine?.startsWith("visitor-env://")) {
                const [_, uri] = catchError(() => new URL(decryptedFirstLine));
                if (options.startUri.host != uri?.host)
                    return;
                if (uri?.pathname == "/request") {
                    return {
                        result: {
                            text: decryptedFirstLine,
                            expectedCrc32: 0,
                            actualCrc32: 0
                        }
                    };
                }
            }
        }
        static async import(json) {
            const result = new _VisitorEnvEncryptions();
            result.encryptions = await Promise.all(json.map(async (e) => ({
                encryption: await CtrEncryption.import(e.encryption),
                token: e.token,
                date: new Date(e.date),
                no: e.no
            })));
            result.#loadedTokens = new Set(result.encryptions.map((e) => e.token));
            return result;
        }
        async export() {
            return await Promise.all(this.encryptions.map(async (e) => ({
                encryption: await e.encryption.export(),
                token: e.token,
                date: e.date.toJSON(),
                no: e.no
            })));
        }
    };
    function getFirstNonEmptyLine(text) {
        return text.split("\n").filter((line) => line != "")[0];
    }
    async function createStartUri(publicKey) {
        const jwkBase64Url = await createUriHost(publicKey);
        return `visitor-env://${jwkBase64Url}/start`;
    }
    async function createUriHost(publicKey) {
        const jwk = await crypto.subtle.exportKey("jwk", publicKey);
        return jsonToBase64Url(jwk);
    }
    async function getVisitorPublicKey(requestUri) {
        const visitorPublicKeyBase64Url = requestUri.searchParams.get("pk");
        if (!visitorPublicKeyBase64Url)
            return;
        const json = base64UrlToJson(visitorPublicKeyBase64Url);
        const visitorPublicKey = await crypto.subtle.importKey("jwk", json, "X25519", true, []);
        return visitorPublicKey;
    }
    async function createEncryptedSharedKeyBase64Url(prevEncryption, encryption) {
        if (!prevEncryption)
            return "";
        const currentSharedKey = encryption.key;
        const currentSharedKeyArray = await crypto.subtle.exportKey("raw", currentSharedKey);
        const encryptedKey = await prevEncryption.encrypt(currentSharedKeyArray, numberTo16BytesArray(0));
        return `.${arrayBufferToBase64Url(encryptedKey)}`;
    }
    async function createAckUri(options) {
        const { prevEncryption, encryption, keyAgreementPublicKey, host: hostBase64Url, visitorPublicKeyBase64Url, adminPrivateKey } = options;
        const myPublicKeyBase64Url = jsonToBase64Url(await crypto.subtle.exportKey("jwk", keyAgreementPublicKey));
        const encryptedSharedKeyBase64Url = await createEncryptedSharedKeyBase64Url(prevEncryption, encryption);
        const signed = `${myPublicKeyBase64Url}${encryptedSharedKeyBase64Url}`;
        const tokenSign = arrayBufferToBase64Url(await crypto.subtle.sign("Ed25519", adminPrivateKey, new TextEncoder().encode(signed)));
        const token = `${signed}.${tokenSign}`;
        return `visitor-env://${hostBase64Url}/acknowledge?token=${token}&vpk=${visitorPublicKeyBase64Url}`;
    }
    async function parseAckUri(ackUri, options) {
        const [_, url] = catchError(() => new URL(ackUri));
        if (!url)
            return;
        if (url.pathname != "/acknowledge")
            return;
        const token = url.searchParams.get("token");
        if (!token)
            return;
        const match = token.match(/(?<keyAgreementPublicKeyBase64Url>[\w-_]+)\.(?<encryptedSharedKeyBase64Url>[\w-_]+)\.(?<signBase64Url>[\w-_]+)/);
        if (!match?.groups)
            return;
        const { keyAgreementPublicKeyBase64Url, encryptedSharedKeyBase64Url, signBase64Url } = match.groups;
        const verify = async () => {
            const verification = await verifyBase64Url(url.host, signBase64Url, `${keyAgreementPublicKeyBase64Url}.${encryptedSharedKeyBase64Url}`);
            return verification;
        };
        if (!await verify())
            return;
        if ("prevEncryption" in options) {
            const encryptedSharedKey = base64UrlToArrayBuffer(encryptedSharedKeyBase64Url);
            const sharedKeyBuffer = await options.prevEncryption.decrypt(encryptedSharedKey, new ArrayBuffer(16));
            return {
                encryption: await CtrEncryption.fromArrayBuffer(sharedKeyBuffer),
                token
            };
        }
        else if ("keyAgreement" in options) {
            async function isValidVisitorPublicKey(url2, keyAgreementPublicKey2) {
                const publicKeyBase64Url = await createPublicKeyBase64Url(keyAgreementPublicKey2);
                return publicKeyBase64Url == url2.searchParams.get("vpk");
            }
            if (!await isValidVisitorPublicKey(url, options.keyAgreement.publicKey))
                return;
            const keyAgreementPublicKeyArray = base64UrlToJson(keyAgreementPublicKeyBase64Url);
            const keyAgreementPublicKey = await crypto.subtle.importKey("jwk", keyAgreementPublicKeyArray, { name: "X25519" }, true, []);
            return {
                encryption: await CtrEncryption.fromKeyAgreement(keyAgreementPublicKey, options.keyAgreement.privateKey),
                token
            };
        }
    }
    var VisitorEnv = class _VisitorEnv {
        constructor(name, parent) {
            this.name = name;
            this.parent = parent;
        }
        adminKeyPair = {};
        startUri;
        keyAgreement;
        encryptions = new VisitorEnvEncryptions();
        get encryption() {
            return this.encryptions.encryption;
        }
        async decryptComment(comment, date, no, timeStampComputer) {
            const uriResult = await this.encryptions.processComment(comment, {
                date,
                no,
                timeStampComputer,
                keyAgreement: this.keyAgreement,
                parent: this.parent,
                startUri: new URL(this.startUri)
            });
            if (uriResult)
                return uriResult.result;
            const encryption = this.encryptions.find(no);
            if (!encryption)
                return;
            return await decryptCommentText(comment, date, timeStampComputer, encryption.encryption);
        }
        async extendSubmission(timeStamp, textArea, date) {
            const isOperationUri = () => {
                const line = getFirstNonEmptyLine(textArea.value);
                if (!line?.startsWith("visitor-env://"))
                    return false;
                const [_, url] = catchError(() => new URL(line));
                if (url)
                    return true;
                return false;
            };
            if (isOperationUri()) {
                await this.parent.extendSubmission(timeStamp, textArea, date);
                return;
            }
            if (!this.encryption)
                return;
            await encryptComment(textArea, timeStamp, this.encryption, date);
        }
        static async start(name, parent, options) {
            const keyPair = await createSignVerifyKeyPair();
            const room = new _VisitorEnv(name, parent);
            room.adminKeyPair = keyPair;
            room.startUri = await createStartUri(keyPair.publicKey);
            room.keyAgreement = await createKeyAgreementKeyPair();
            await room.encryptions.start(options?.date);
            return room;
        }
        static async request(startUri, parent) {
            const room = new _VisitorEnv(`ビジター環境@"${(new Date()).toLocaleString("ja")}"`, parent);
            room.adminKeyPair.publicKey = await crypto.subtle.importKey("jwk", base64UrlToJson(startUri.host), { name: "Ed25519" }, true, ["verify"]);
            room.startUri = startUri.toString();
            room.keyAgreement = await createKeyAgreementKeyPair();
            return room;
        }
        async acknowledge(requestUri) {
            const visitorPublicKey = await getVisitorPublicKey(requestUri);
            if (!visitorPublicKey)
                return;
            if (!this.adminKeyPair.privateKey)
                return;
            const keyAgreement = await crypto.subtle.generateKey("X25519", true, [
                "deriveKey"
            ]);
            const prevEncryption = this.encryption;
            const encryption = await CtrEncryption.fromKeyAgreement(visitorPublicKey, keyAgreement.privateKey);
            return createAckUri({
                encryption,
                prevEncryption,
                keyAgreementPublicKey: keyAgreement.publicKey,
                visitorPublicKeyBase64Url: requestUri.searchParams.get("pk"),
                host: requestUri.host,
                adminPrivateKey: this.adminKeyPair.privateKey
            });
        }
        async toJson() {
            const adminKeyPair = this.adminKeyPair;
            return {
                name: this.name,
                parent: this.parent.name,
                adminKeyPair: adminKeyPair && {
                    publicKey: await crypto.subtle.exportKey("jwk", adminKeyPair.publicKey),
                    privateKey: adminKeyPair.privateKey && await crypto.subtle.exportKey("jwk", adminKeyPair.privateKey)
                },
                encryptions: await this.encryptions.export(),
                keyAgreement: {
                    publicKey: await crypto.subtle.exportKey("jwk", this.keyAgreement.publicKey),
                    privateKey: await crypto.subtle.exportKey("jwk", this.keyAgreement.privateKey)
                }
            };
        }
        static async fromJson(json, rooms) {
            const parent = rooms.find((r) => r.name == json.parent);
            if (!parent)
                return null;
            const room = new _VisitorEnv(json.name, parent);
            if (json.adminKeyPair) {
                room.adminKeyPair = {
                    publicKey: await crypto.subtle.importKey("jwk", json.adminKeyPair.publicKey, "Ed25519", true, ["verify"]),
                    privateKey: json.adminKeyPair.privateKey && await crypto.subtle.importKey("jwk", json.adminKeyPair.privateKey, "Ed25519", true, ["sign"])
                };
            }
            room.startUri = await createStartUri(room.adminKeyPair.publicKey);
            room.encryptions = await VisitorEnvEncryptions.import(json.encryptions);
            room.keyAgreement = {
                publicKey: await crypto.subtle.importKey("jwk", json.keyAgreement.publicKey, "X25519", true, []),
                privateKey: await crypto.subtle.importKey("jwk", json.keyAgreement.privateKey, "X25519", true, ["deriveKey"])
            };
            return room;
        }
    };
    async function createRequestUri(startUri, keyAgreementPublicKey) {
        const publicKeyBase64Url = await createPublicKeyBase64Url(keyAgreementPublicKey);
        const requestUri = `visitor-env://${startUri.host}/request?pk=${publicKeyBase64Url}`;
        return requestUri;
    }
    async function createPublicKeyBase64Url(publicKey) {
        const publicKeyJson = await crypto.subtle.exportKey("jwk", publicKey);
        return jsonToBase64Url(publicKeyJson);
    }
    function createVisitorEnvs(storage) {
        const key = "MeBoy.visitorEnvs";
        const visitorEnvs = van_default.state([]);
        const isLoaded = van_default.state(false);
        const save = async () => {
            if (!isLoaded.val)
                return;
            const jsonPromises = visitorEnvs.val.map(async (room) => {
                return await room.toJson();
            });
            const jsons = await Promise.all(jsonPromises);
            await storage.set(key, jsons);
        };
        van_default.derive(async () => {
            await save();
        });
        const start = async (id, parent) => {
            const room = await VisitorEnv.start(`ビジター環境@"${id}"`, parent);
            visitorEnvs.val = [...visitorEnvs.val, room];
            return room;
        };
        const load = async (rooms) => {
            if (isLoaded.val)
                return;
            isLoaded.val = true;
            const jsons = await storage.get(key);
            if (!jsons)
                return;
            const newVisitorEnvs = [];
            for (const json of jsons) {
                const room = await VisitorEnv.fromJson(json, [
                    ...rooms.val,
                    ...newVisitorEnvs
                ]);
                if (!room)
                    continue;
                newVisitorEnvs.push(room);
            }
            visitorEnvs.val = newVisitorEnvs;
        };
        const request = async (startUri, parent) => {
            const room = await VisitorEnv.request(startUri, parent);
            visitorEnvs.val = [...visitorEnvs.val, room];
            return {
                env: room,
                uri: await createRequestUri(startUri, room.keyAgreement.publicKey)
            };
        };
        const acknowledge = async (requestUri) => {
            const env = visitorEnvs.val.find((env2) => {
                const [_, url] = catchError(() => new URL(env2.startUri));
                if (url) {
                    return url.host == requestUri.host;
                }
                return false;
            });
            if (!env)
                return;
            return await env.acknowledge(requestUri);
        };
        return {
            visitorEnvs,
            start,
            load,
            request,
            acknowledge
        };
    }
    function createRooms(storage = new ChromeKeyStorage()) {
        const defaultRoom = new DefaultRoom();
        const selectedIndex = van_default.state(0);
        const permutationCities = createPermutationCities(storage);
        const visitorEnvs = createVisitorEnvs(storage);
        const rooms = van_default.derive(() => [
            defaultRoom,
            ...permutationCities.permutationCities.val,
            ...visitorEnvs.visitorEnvs.val
        ]);
        const load = async () => {
            await permutationCities.load();
            await visitorEnvs.load(rooms);
        };
        const getSelectedRoom = () => {
            return rooms.val[selectedIndex.val];
        };
        const removeRoom = () => {
            const currentRoom = getSelectedRoom();
            selectedIndex.val = 0;
            permutationCities.permutationCities.val = permutationCities.permutationCities.val.filter((room) => room != currentRoom);
            visitorEnvs.visitorEnvs.val = visitorEnvs.visitorEnvs.val.filter((room) => room != currentRoom);
        };
        const acknowledge = async (requestUri) => {
            await load();
            return await visitorEnvs.acknowledge(requestUri);
        };
        const startVisitorEnv = async (name) => {
            await load();
            const env = await visitorEnvs.start(name, getSelectedRoom());
            selectedIndex.val = rooms.val.indexOf(env);
            return env;
        };
        const requestVisitorEnv = async (startUri) => {
            const result = await visitorEnvs.request(startUri, getSelectedRoom());
            selectedIndex.val = rooms.val.indexOf(result.env);
            return result;
        };
        return {
            permutationCities: permutationCities.permutationCities,
            rooms,
            selectedIndex,
            load,
            getSelectedRoom,
            defaultRoom,
            addPermutationCity: permutationCities.add,
            removeRoom,
            visitorEnvs: visitorEnvs.visitorEnvs,
            startVisitorEnv,
            requestVisitorEnv,
            acknowledge
        };
    }
    function isAnagram(lineCharacters, original) {
        const characters = original.toUpperCase();
        for (const c of characters) {
            if (!lineCharacters.has(c))
                return false;
        }
        return true;
    }
    function hasPermutationCityAnagram(line) {
        const lineCharacters = new Set(line.toUpperCase());
        const charactersList = ["PermutationCity", "順列都市", "じゅんれつとし"];
        return charactersList.some((characters) => isAnagram(lineCharacters, characters));
    }
    function isPermutationCityThread(body) {
        const comment = body.querySelector(".thre blockquote");
        if (!comment)
            return false;
        const commentString = commentBlockToString(comment);
        const commentLines = commentString.split("\n");
        return commentLines.some((line) => hasPermutationCityAnagram(line));
    }
    function addButtonForVisitorEnvUri(commentBlock, createButton) {
        const processLine = (line2, next) => {
            if (line2.startsWith("visitor-env://")) {
                const button2 = createButton(line2);
                if (button2) {
                    commentBlock.insertBefore(br(), next);
                    commentBlock.insertBefore(button2, next);
                }
            }
        };
        let line = "";
        for (const child of [...commentBlock.childNodes]) {
            if (child instanceof HTMLBRElement) {
                processLine(line, child);
                line = "";
                continue;
            }
            line += child.textContent;
        }
        processLine(line, null);
    }
    function PermutationCityExtension(tasksBeforeSubmission, commentProcessor, keyStorage, docBody = document.body) {
        if (new Date("2026/02/14") < new Date())
            return;
        if (!isPermutationCityThread(docBody))
            return;
        const rooms = createRooms(keyStorage);
        const timeStamp = new TimeStamp(3);
        const comments = new Map();
        tasksBeforeSubmission.push(async () => {
            await rooms.getSelectedRoom().extendSubmission(timeStamp, docBody.querySelector("#ftxa"), new Date());
        });
        commentProcessor.initialTasks.push(async (comment) => {
            const controller = new CommentController(comment);
            comments.set(comment, controller);
            await controller.run(rooms.defaultRoom.name);
        });
        commentProcessor.processes.push(async (comment) => {
            await comments.get(comment)?.setRoom(rooms.getSelectedRoom(), timeStamp);
        });
        van_default.derive(async () => {
            const selected = rooms.selectedIndex.val;
            for (const controller of comments.values()) {
                const block = controller.commentBlock;
                await commentProcessor.process(block);
                await commentProcessor.postProcess(block);
            }
        });
        const handleAddVisitorEnv = async () => {
            const textarea = docBody.querySelector("#ftxa");
            const room = await rooms.startVisitorEnv((new Date()).toLocaleString("ja"));
            textarea.value += `
${room.startUri}`;
        };
        commentProcessor.postProcesses.push(async (comment) => {
            addButtonForVisitorEnvUri(comment, (uriString) => {
                const [_, uri] = catchError(() => new URL(uriString));
                if (!uri)
                    return null;
                if (uri.pathname === "/start") {
                    const handleClick = async () => {
                        const textarea = docBody.querySelector("#ftxa");
                        const { uri: requestUri } = await rooms.requestVisitorEnv(uri);
                        textarea.value += `
${requestUri}
`;
                    };
                    const newButton = button({
                        onclick: handleClick,
                        title: "入室許可リクエスト",
                        class: reqButtonClass,
                        disabled: () => rooms.visitorEnvs.val.find((env) => env.startUri === uriString)
                    }, "🚪");
                    return newButton;
                }
                if (uri.pathname === "/request") {
                    const isHost = () => {
                        const selectedRoom = rooms.getSelectedRoom();
                        if (!selectedRoom)
                            return false;
                        const isVisitorEnv = (room) => {
                            return room instanceof VisitorEnv;
                        };
                        if (!isVisitorEnv(selectedRoom))
                            return false;
                        return selectedRoom.encryptions.isHost;
                    };
                    if (!isHost())
                        return null;
                    const handleClick = async () => {
                        const textarea = docBody.querySelector("#ftxa");
                        const resultUri = await rooms.acknowledge(uri);
                        if (!resultUri)
                            return;
                        textarea.value += `
${resultUri}
`;
                    };
                    return button({
                        onclick: handleClick,
                        class: ackButtonClass
                    }, "入室許可");
                }
                return null;
            });
        });
        van_default.add(docBody.querySelector("#fm .ftbl tbody"), [
            PermutationCityRow(rooms, handleAddVisitorEnv),
            PermutationCityStyle()
        ]);
        return { rooms, comments };
    }
    var reqButtonClass = `visitor-env-req-button`;
    var ackButtonClass = `visitor-env-ack-button`;
    var SignVerifyClass = class {
        #timeStamp = new TimeStamp(3);
        async sign(signMethod, comment, date) {
            return await crypto.subtle.sign(signMethod.algorithm, signMethod.keyPair.privateKey, new TextEncoder().encode(`${comment}${this.#timeStamp.get(date)}`));
        }
        async #verify(publicKeyUri, signUri, originalComment, commentDate) {
            const timeStamp = this.#timeStamp.get(commentDate);
            const publicKeyArray = base64ToArrayBuffer(publicKeyUri.base64PublicKey);
            const sign = base64ToArrayBuffer(signUri.base64Sign);
            const publicKey = await crypto.subtle.importKey("raw", publicKeyArray, publicKeyUri.algorithm, true, ["verify"]);
            for (let i = 0; i < 3; i++) {
                const isVerified = await crypto.subtle.verify(publicKeyUri.algorithm, publicKey, sign, new TextEncoder().encode(`${originalComment}${timeStamp - 1 + i}`));
                if (isVerified) {
                    return true;
                }
            }
            return false;
        }
        async verify(publicKeyUri, signUri, originalComment, commentDate) {
            try {
                return await this.#verify(publicKeyUri, signUri, originalComment, commentDate);
            }
            catch (_) {
                return false;
            }
        }
    };
    var SignVerify = new SignVerifyClass();
    var FileHelper = {
        saveDataUrl(fileName, dataUrl) {
            const a2 = a();
            a2.href = dataUrl;
            a2.download = fileName;
            a2.click();
        },
        createFileInput(accept) {
            return stringToElement(`<input type='file' accept='${accept}' style='width:0;height:0;overflow:hidden,position:absolute'>`);
        },
        readTextFile(file) {
            return new Promise((resolve) => {
                const reader = new FileReader();
                reader.onload = () => {
                    const text = reader.result;
                    resolve(text);
                };
                reader.readAsText(file);
            });
        }
    };
    var { label } = van_default.tags;
    function SignDropdownMenu(sigAccounts, selectedIndex) {
        function renameAccount() {
            if (sigAccounts.selectedIndex == 0)
                return;
            const newName = prompt(`署名アカウントの新しい名前を入力してください：`);
            if (!newName)
                return;
            sigAccounts.rename(newName);
        }
        async function deleteAccount() {
            if (!sigAccounts.canDelete()) {
                alert(`${sigAccounts.selectedName}は削除できません`);
                return;
            }
            if (!confirm(`${sigAccounts.selectedName}を削除します。よろしいですか？`))
                return;
            await sigAccounts.delete();
        }
        async function exportAccounts() {
            const jsonText = JSON.stringify(await sigAccounts.toJson(), null, "	");
            FileHelper.saveDataUrl(`署名アカウントデータ.json`, `data:text/json,${jsonText}`);
        }
        async function importAccounts(e) {
            const input = e.target;
            const file = input.files?.[0];
            if (!file)
                return;
            const text = await FileHelper.readTextFile(file);
            const json = JSON.parse(text);
            await sigAccounts.loadJson(json);
            await sigAccounts.save();
            sigAccounts.selectedIndex = 0;
            selectedIndex.val = sigAccounts.selectedIndex;
        }
        const importInput = FileHelper.createFileInput(".json");
        importInput.addEventListener("change", importAccounts);
        return Dropdown(span({ class: "pdms" }, "⋯"), span([
            span({ class: "pdms", onclick: renameAccount }, "アカウント名の変更"),
            span({ class: "pdms", onclick: deleteAccount }, "アカウントの削除"),
            span({ class: "pdms", onclick: exportAccounts }, "エクスポート"),
            label({ class: "pdms" }, "インポート", importInput)
        ]));
    }
    var { b: b2, option: option2, tr: tr3, td: td2 } = van_default.tags;
    function SignatureRow(sigAccounts) {
        const selectedIndex = van_default.state(sigAccounts.selectedIndex);
        function addAccount() {
            sigAccounts.addAccount();
        }
        return tr3([
            td2({ class: "ftdc" }, b2(["署名"])),
            td2([
                AccountSelect(sigAccounts, selectedIndex),
                span([
                    button({ type: "button", title: "追加", onclick: addAccount }, "+"),
                    SignDropdownMenu(sigAccounts, selectedIndex)
                ])
            ])
        ]);
    }
    function AccountSelect(sigAccounts, selectedIndex) {
        const accounts = van_default.state(sigAccounts.accounts);
        sigAccounts.onDidAccountAdd = () => {
            accounts.val = [...sigAccounts.accounts];
        };
        sigAccounts.onDidAccountsLoad = () => {
            accounts.val = [...sigAccounts.accounts];
            selectedIndex.val = Math.min(sigAccounts.selectedIndex, sigAccounts.accounts.length - 1);
        };
        function loadAccount() {
            sigAccounts.load();
        }
        function setSelectedIndex(e) {
            const newSelectedIndex = e.target.selectedIndex;
            selectedIndex.val = newSelectedIndex;
            sigAccounts.selectedIndex = newSelectedIndex;
        }
        const accountSelect = signalList(() => preventReset(select({
            onpointerdown: loadAccount,
            onchange: setSelectedIndex,
            selectedIndex
        })), accounts, (account) => {
            const name = van_default.state(account.name);
            account.onDidRename = () => {
                name.val = account.name;
            };
            return option2(name);
        });
        return accountSelect;
    }
    async function jsonToSignatureAccount(json) {
        return {
            name: json.name,
            signMethod: json.signMethod && {
                algorithm: json.signMethod.algorithm,
                keyPair: {
                    publicKey: await crypto.subtle.importKey("raw", base64ToArrayBuffer(json.signMethod.publicKey), json.signMethod.algorithm, true, ["verify"]),
                    privateKey: await crypto.subtle.importKey("pkcs8", base64ToArrayBuffer(json.signMethod.privateKey), json.signMethod.algorithm, true, ["sign"])
                }
            }
        };
    }
    async function signatureAccountToJson(account) {
        return {
            name: account.name,
            signMethod: account.signMethod && {
                algorithm: account.signMethod.algorithm,
                publicKey: arrayBufferToBase64(await crypto.subtle.exportKey("raw", account.signMethod.keyPair.publicKey)),
                privateKey: arrayBufferToBase64(await crypto.subtle.exportKey("pkcs8", account.signMethod.keyPair.privateKey))
            }
        };
    }
    var SignatureAccounts = class {
        constructor(accountsStorage) {
            this.accountsStorage = accountsStorage;
            this.accounts.push({ name: "なし（初期設定）" });
        }
        selectedIndex = 0;
        accounts = [];
        get lastIndex() {
            return this.accounts.length - 1;
        }
        get selectedName() {
            return this.accounts[this.selectedIndex].name;
        }
        async load() {
            const json = await this.accountsStorage.load();
            if (!json)
                return;
            await this.loadJson(json);
        }
        async loadJson(json) {
            const accountPromises = json.accounts.map(jsonToSignatureAccount);
            const loadedAccounts = await fromAsync(accountPromises);
            this.accounts = loadedAccounts;
            this.onDidAccountsLoad?.();
        }
        async toJson() {
            return {
                accounts: await fromAsync(this.accounts.map(signatureAccountToJson))
            };
        }
        async save() {
            await this.accountsStorage.save(await this.toJson());
        }
        async addAccount() {
            const accountName = `署名アカウント${this.accounts.length}`;
            const newAccount = {
                name: accountName,
                signMethod: {
                    algorithm: "Ed25519",
                    keyPair: await crypto.subtle.generateKey("Ed25519", true, [
                        "sign",
                        "verify"
                    ])
                }
            };
            this.accounts.push(newAccount);
            const index = this.lastIndex;
            this.selectedIndex = index;
            this.onDidAccountAdd?.(accountName, index);
            await this.save();
        }
        async rename(newName) {
            this.accounts[this.selectedIndex].name = newName;
            this.accounts[this.selectedIndex].onDidRename?.();
            await this.save();
        }
        canDelete = () => this.selectedIndex != 0;
        async delete() {
            if (!this.canDelete())
                return;
            this.accounts.splice(this.selectedIndex, 1);
            this.selectedIndex = Math.min(this.selectedIndex, this.lastIndex);
            await this.save();
            this.onDidAccountsLoad?.();
        }
        onDidAccountAdd;
        onDidAccountsLoad;
    };
    var SignUri = class _SignUri {
        constructor(publicKeyLocation, base64Sign) {
            this.publicKeyLocation = publicKeyLocation;
            this.base64Sign = base64Sign;
        }
        static parse(uri) {
            if (!uri) {
                return null;
            }
            const match = uri.match(/sign:\/\/(?<publicKeyLocation>\d+)\/(?<base64Sign>[\d\w/+=]+)/);
            if (!match?.groups) {
                return;
            }
            const publicKeyLocation = match.groups.publicKeyLocation;
            const base64Sign = match.groups.base64Sign;
            return new _SignUri(publicKeyLocation, base64Sign);
        }
        toString() {
            return `sign://${this.publicKeyLocation}/${this.base64Sign}`;
        }
    };
    var PublicKeyUri = class _PublicKeyUri {
        constructor(algorithm, base64PublicKey) {
            this.algorithm = algorithm;
            this.base64PublicKey = base64PublicKey;
        }
        static parse(uri) {
            if (!uri) {
                return null;
            }
            const match = uri.match(/public-key:(?<algorithm>[\d\w]+);(?<base64PublicKey>[\d\w/+=]+)/);
            if (!match?.groups) {
                return;
            }
            const algorithm = match.groups.algorithm;
            const base64PublicKey = match.groups.base64PublicKey;
            return new _PublicKeyUri(algorithm, base64PublicKey);
        }
        toString() {
            return `public-key:${this.algorithm};${this.base64PublicKey}`;
        }
    };
    function extractSignUris(comment) {
        const lines = comment.split("\n");
        const lastLine = lines[lines.length - 1];
        const hasSign = lastLine.startsWith("sign://");
        const signUri = hasSign ? lastLine : null;
        const secondLastLine = lines[lines.length - 2];
        const hasPublicKey = secondLastLine?.startsWith("public-key:");
        const publicKeyUri = hasPublicKey ? secondLastLine : null;
        const uriCount = (hasSign ? 1 : 0) + (hasPublicKey ? 1 : 0);
        const linesWithoutSign = lines.slice(0, lines.length - uriCount);
        const originalComment = linesWithoutSign.join("\n");
        return { signUri, originalComment, publicKeyUri };
    }
    async function verifyComment(commentBlock, accountsDB) {
        const comment = commentBlockToString(commentBlock);
        const extracted = extractSignUris(comment);
        const publicKeyUri = PublicKeyUri.parse(extracted.publicKeyUri);
        const signUri = SignUri.parse(extracted.signUri);
        if (!(publicKeyUri && signUri)) {
            return { status: "none" };
        }
        const date = getDateFromCommentBlock(commentBlock);
        const isVerified = await SignVerify.verify(publicKeyUri, signUri, extracted.originalComment, date);
        const status = !isVerified ? "attacker" : await accountsDB.getAccount(extracted.publicKeyUri) ? "trusted" : "verified";
        return {
            publicKeyUri: extracted.publicKeyUri,
            status
        };
    }
    function wrap(node, createWrapper) {
        const parent = node.parentNode;
        const wrapper = createWrapper();
        parent.replaceChild(wrapper, node);
        wrapper.append(node);
    }
    function wrapUris(commentBlock, createWrapper) {
        const childNodes = [...commentBlock.childNodes];
        const lastNode = childNodes[childNodes.length - 1];
        const last3Node = childNodes[childNodes.length - 3];
        if (last3Node?.textContent?.startsWith("public-key:")) {
            wrap(last3Node, createWrapper);
        }
        if (lastNode?.textContent?.startsWith("sign:")) {
            wrap(lastNode, createWrapper);
        }
    }
    var { span: span2, img, div: div2 } = van_default.tags;
    var CommentController2 = class {
        constructor(commentBlock, db, trustUser) {
            this.commentBlock = commentBlock;
            this.db = db;
            van_default.derive(() => {
                if (this.status == "trusted") {
                    wrapUris(this.commentBlock, () => span2({ style: `font-size: 0.5em; opacity: 0.2;` }));
                }
            });
            const userInfoUI = span2(() => {
                switch (this.status) {
                    case "attacker":
                        return span2("✖");
                    case "verified":
                        return VerifiedUserUI(() => trustUser(this.publicKeyUri));
                    case "trusted":
                        return TrustedUserUI(this.#iconUrl);
                    default:
                        return span2();
                }
            });
            const parent = commentBlock.parentElement;
            parent?.insertBefore(userInfoUI, parent.querySelector(".cnw"));
        }
        #status = van_default.state("none");
        publicKeyUri;
        get status() {
            return this.#status.val;
        }
        set status(value) {
            this.#status.val = value;
        }
        #iconUrl = van_default.state(void 0);
        async verify(icons) {
            const result = await verifyComment(this.commentBlock, this.db);
            await icons.check(result);
            if (result.publicKeyUri) {
                this.#iconUrl.val = icons.getThumbnailUri(result.publicKeyUri);
            }
            this.publicKeyUri = result.publicKeyUri;
            this.status = result.status;
        }
        trust(iconUrl) {
            this.status = "trusted";
            this.#iconUrl.val = iconUrl;
        }
    };
    function TrustedUserUI(iconUrl) {
        return span2([
            img({
                src: () => iconUrl.val,
                style: `border: solid white; border-radius: 5px`
            }),
            span2(["✅"])
        ]);
    }
    function VerifiedUserUI(trustUser) {
        return Dropdown(span2({ style: `cursor: pointer` }, "❔"), div2([div2({ class: "pdms", onclick: trustUser }, "本人だと信じる")]));
    }
    function getTegakiThumbnail(commentBlock) {
        const parent = commentBlock.parentElement;
        return parent.querySelector(`img[src^='/b/thumb/']`);
    }
    function getFirstTegakiThumbnail(commentBlocks) {
        for (const block of commentBlocks) {
            const result = getTegakiThumbnail(block);
            if (result) {
                return result;
            }
        }
        return null;
    }
    function getIconUrl(thumbnailImage) {
        const size = { x: 40, y: 40 };
        const canvas = van_default.tags.canvas();
        canvas.width = size.x;
        canvas.height = size.y;
        const context = canvas.getContext("2d");
        const sourceMin = Math.min(thumbnailImage.width, thumbnailImage.height);
        const srcOffset = {
            x: (thumbnailImage.width - sourceMin) / 2,
            y: (thumbnailImage.height - sourceMin) / 2
        };
        context.drawImage(thumbnailImage, srcOffset.x, srcOffset.y, sourceMin, sourceMin, 0, 0, size.x, size.y);
        return canvas.toDataURL("image/webp", 0.9);
    }
    var IconRecord = class {
        constructor(accountsDB) {
            this.accountsDB = accountsDB;
        }
        record = {};
        async check(commentEx) {
            if (commentEx.status != "trusted")
                return;
            if (!commentEx.publicKeyUri)
                return;
            if (this.record[commentEx.publicKeyUri])
                return;
            const account = await this.accountsDB.getAccount(commentEx.publicKeyUri);
            if (!account)
                return;
            this.record[commentEx.publicKeyUri] = account.thumbnailUri;
        }
        getThumbnailUri(publicKeyUri) {
            return this.record[publicKeyUri];
        }
    };
    function openDB(dbName, params) {
        const req = indexedDB.open(dbName);
        req.onupgradeneeded = () => {
            params.upgrade(req.result);
        };
        return requestDB(req);
    }
    function requestDB(request) {
        return new Promise((resolve, reject) => {
            request.addEventListener("success", () => {
                resolve(request.result);
            });
            request.addEventListener("error", (e) => {
                reject(e);
            });
        });
    }
    var TrustedAccountsDatabase = class _TrustedAccountsDatabase {
        constructor(db) {
            this.db = db;
        }
        static #thumbnailStoreName = "thumbnails";
        static async create() {
            const db = await openDB("MeBoy-trustedAccounts", {
                upgrade: (db2) => {
                    db2.createObjectStore(_TrustedAccountsDatabase.#thumbnailStoreName, {
                        keyPath: "publicKeyUri"
                    });
                }
            });
            return new _TrustedAccountsDatabase(db);
        }
        async addAccount(publicKeyUri, thumbnailUri) {
            const transaction = this.db.transaction(_TrustedAccountsDatabase.#thumbnailStoreName, "readwrite");
            const store = transaction.objectStore(_TrustedAccountsDatabase.#thumbnailStoreName);
            const obj = { publicKeyUri, thumbnailUri };
            const req = store.add(obj);
            return await requestDB(req);
        }
        async getAccount(publicKeyUri) {
            const transaction = this.db.transaction(_TrustedAccountsDatabase.#thumbnailStoreName, "readonly");
            const store = transaction.objectStore(_TrustedAccountsDatabase.#thumbnailStoreName);
            const req = store.get(publicKeyUri);
            return await requestDB(req);
        }
    };
    async function VerifierExtension(commentProcessor) {
        const db = await TrustedAccountsDatabase.create();
        const icons = new IconRecord(db);
        const controllers = new Map();
        async function trustUser(publicKeyUri) {
            console.log("ontrust");
            const verifiedComments = [...controllers.values()].filter((c) => c.publicKeyUri == publicKeyUri && c.status == "verified");
            const tegakiThumbnail = getFirstTegakiThumbnail(verifiedComments.map((c) => c.commentBlock));
            if (!tegakiThumbnail)
                return;
            const iconUrl = getIconUrl(tegakiThumbnail);
            for (const controller of verifiedComments) {
                controller.trust(iconUrl);
            }
            await db.addAccount(publicKeyUri, iconUrl);
        }
        commentProcessor.initialTasks.push(async (comment) => {
            const controller = new CommentController2(comment, db, trustUser);
            controllers.set(comment, controller);
        });
        commentProcessor.processes.push(async (comment) => {
            const controller = controllers.get(comment);
            await controller?.verify(icons);
        });
    }
    function getCommentFromTextArea(textArea) {
        const value = textArea.value;
        const lines = value.split("\n");
        return lines.map((line) => trimRuby(line)).join("\n");
    }
    async function getPublicKeyUri(account) {
        const publicKeyArray = await crypto.subtle.exportKey("raw", account.keyPair.publicKey);
        return `public-key:${account.algorithm};${arrayBufferToBase64(publicKeyArray)}`;
    }
    async function extendSubmission(signAccounts) {
        const commentArea = querySelector("#ftxa");
        const account = signAccounts.accounts[signAccounts.selectedIndex];
        if (!account?.signMethod)
            return;
        const signMethod = account?.signMethod;
        const publicKeyUri = await getPublicKeyUri(signMethod);
        const comment = getCommentFromTextArea(commentArea) || kitaComment;
        const sign = await SignVerify.sign(signMethod, comment, new Date());
        commentArea.value = [
            comment,
            publicKeyUri,
            new SignUri("0", arrayBufferToBase64(sign)).toString()
        ].join("\n");
    }
    async function SignVerifyExtension(tasksBeforeSubmission, commentProcessor, accountsStorage) {
        const sigAccounts = new SignatureAccounts(accountsStorage);
        tasksBeforeSubmission.push(async () => extendSubmission(sigAccounts));
        const tbody2 = querySelector(".ftbl tbody");
        tbody2.insertBefore(SignatureRow(sigAccounts), tbody2.children[0]);
        await VerifierExtension(commentProcessor);
    }
    var { div: div3 } = van_default.tags;
    function ContextMenu(position, children) {
        const contextMenu = div3({
            style: `
left: ${position.x}px;
top: ${position.y}px;
position: absolute;
background: #ffe;
border: solid 1px;
border-radius: 5px;`,
            onclick: (e) => {
                contextMenu.remove();
                window.removeEventListener("click", clickListener);
                e.stopPropagation();
            }
        });
        van_default.add(contextMenu, children);
        const clickListener = () => {
            contextMenu.remove();
        };
        window.addEventListener("click", clickListener);
        van_default.add(document.body, [contextMenu]);
    }
    var CatalogExtension = class {
        #ngs;
        run(ngs) {
            this.#ngs = ngs;
            this.enableNG();
        }
        async enableNG() {
            this.#hideNGThreads();
            this.#enableNGMenu();
            await wait(1e3);
            this.#deleteObsoleteNGs();
        }
        #deleteObsoleteNGs() {
            const loadedNGs = this.#ngs.getNGs();
            const hour = 6;
            const obsoleteNGs = loadedNGs.filter((ng) => Date.now() - Date.parse(ng.time) > hour * 60 * 60 * 1e3);
            console.log(obsoleteNGs);
            this.#ngs.deleteNumbers(obsoleteNGs.map((ng) => ng.dataNo));
        }
        #enableNGMenu() {
            for (const el of document.querySelectorAll(".pdmc")) {
                EasterEgg(el, (pagePosition) => this.#showNGMenu(el, pagePosition));
            }
        }
        #hideNGThreads() {
            const ngs = this.#ngs.getNGs();
            for (const thread of document.querySelectorAll("#cattable td")) {
                const dataNo = thread.querySelector(".pdmc").getAttribute("data-no");
                if (ngs.some((ng) => ng.dataNo == dataNo)) {
                    thread.remove();
                    console.log("removed", dataNo);
                }
            }
        }
        #showNGMenu(button2, pagePosition) {
            const addNG = () => {
                this.#ngs.add(button2.getAttribute("data-no"));
                button2.parentElement?.remove();
            };
            ContextMenu(pagePosition, [
                van_default.tags.div({ style: `padding: 10px`, onclick: addNG }, "NGに登録")
            ]);
        }
    };
    var NGStorage = class {
        #storageKey = "MeBoy.NGs";
        add(dataNo) {
            const newData = { dataNo, time: (new Date()).toString() };
            const ngSetting = {
                ngs: [...this.getNGs(), newData]
            };
            this.#saveJson(ngSetting);
        }
        getNGs() {
            const ngText = localStorage.getItem(this.#storageKey);
            if (!ngText)
                return [];
            const loaded = JSON.parse(ngText);
            return loaded.ngs;
        }
        deleteNumbers(dataNos) {
            const ngs = this.getNGs().filter((ng) => dataNos.every((dataNo) => dataNo != ng.dataNo));
            const settingJson = {
                ngs
            };
            this.#saveJson(settingJson);
        }
        #saveJson(settingJson) {
            localStorage.setItem(this.#storageKey, JSON.stringify(settingJson));
        }
    };
    var CommentProcessor = class {
        initialTasks = [];
        async init(comment) {
            for (const task of this.initialTasks) {
                await task(comment);
            }
        }
        processes = [];
        async process(comment) {
            for (const task of this.processes) {
                await task(comment);
            }
        }
        postProcesses = [];
        async postProcess(comment) {
            for (const task of this.postProcesses) {
                await task(comment);
            }
        }
    };
    var buttonClassName = `MeBoy-button`;
    function BottomMenu(options) {
        function CatalogButton() {
            return div({
                class: buttonClassName,
                onclick: () => {
                    const a2 = a();
                    a2.href = "/b/futaba.php?mode=cat";
                    a2.click();
                }
            }, "カタログ");
        }
        function StartThreadButton() {
            return div({
                class: buttonClassName,
                onclick: () => {
                    const a2 = a();
                    a2.href = "/b/futaba.htm";
                    a2.target = "_blank";
                    a2.click();
                }
            }, "スレ立て");
        }
        function ShowButton(floatingForm) {
            return div({
                class: buttonClassName,
                onclick: () => {
                    floatingForm.isFormVisible.val = true;
                }
            }, "□");
        }
        return div({
            style: `
display: flex;
position: fixed;
right: 30px;
bottom: 0px;
background: #FFFFEE;
height: 30px;
overflow: hidden;
border-top-left-radius: 5px;
border-top-right-radius: 5px;
border: solid;
border-bottom: none;`
        }, CatalogButton(), StartThreadButton(), ShowButton(options), style(`
.${buttonClassName} {
	display: flex;
	padding-left: 10px;
	padding-right: 10px;
	justify-content: center;
	align-items: center;
	cursor: default;
	background: transparent;
	transition: background 0.5s;
}
.${buttonClassName}:hover {
	background: rgba(0, 0, 0, 0.1);
	transition: background 0.1s;
}
`));
    }
    var { fromEntries, entries, keys, hasOwn, getPrototypeOf, create, assign } = Object;
    var { get: refGet, set: refSet, deleteProperty: refDelete, ownKeys: refOwnKeys } = Reflect;
    var { state: state2, derive: derive2, add: add2 } = van_default;
    var _undefined2;
    var replacing;
    var statesSym = Symbol();
    var isCalcFunc = Symbol();
    var bindingsSym = Symbol();
    var keysGenSym = Symbol();
    var keyToChildSym = Symbol();
    var noreactiveSym = Symbol();
    var isObject = (x) => x instanceof Object && !(x instanceof Function) && !x[noreactiveSym];
    var toState = (v) => {
        if (v?.[isCalcFunc]) {
            let s = state2();
            derive2(() => {
                let newV = v();
                isObject(s.rawVal) && isObject(newV) ? replace(s.rawVal, newV) : s.val = reactive(newV);
            });
            return s;
        }
        else
            return state2(reactive(v));
    };
    var buildStates = (srcObj) => {
        let states = Array.isArray(srcObj) ? [] : { __proto__: getPrototypeOf(srcObj) };
        for (let [k, v] of entries(srcObj))
            states[k] = toState(v);
        states[bindingsSym] = [];
        states[keysGenSym] = state2(1);
        return states;
    };
    var reactiveHandler = {
        get: (states, name, proxy) => name === statesSym ? states : hasOwn(states, name) ? Array.isArray(states) && name === "length" ? (states[keysGenSym].val, states.length) : states[name].val : refGet(states, name, proxy),
        set: (states, name, v, proxy) => hasOwn(states, name) ? Array.isArray(states) && name === "length" ? (v !== states.length && ++states[keysGenSym].val, states.length = v, 1) : (states[name].val = reactive(v), 1) : name in states ? refSet(states, name, v, proxy) : refSet(states, name, toState(v)) && (++states[keysGenSym].val, filterBindings(states).forEach(addToContainer.bind(_undefined2, proxy, name, states[name], replacing)), 1),
        deleteProperty: (states, name) => (refDelete(states, name) && onDelete(states, name), ++states[keysGenSym].val),
        ownKeys: (states) => (states[keysGenSym].val, refOwnKeys(states))
    };
    var reactive = (srcObj) => !isObject(srcObj) || srcObj[statesSym] ? srcObj : new Proxy(buildStates(srcObj), reactiveHandler);
    var stateProto2 = getPrototypeOf(state2());
    var filterBindings = (states) => states[bindingsSym] = states[bindingsSym].filter((b3) => b3._containerDom.isConnected);
    var addToContainer = (items, k, v, skipReorder, { _containerDom, f }) => {
        let isArray = Array.isArray(items), typedK = isArray ? Number(k) : k;
        add2(_containerDom, () => _containerDom[keyToChildSym][k] = f(v, () => delete items[k], typedK));
        isArray && !skipReorder && typedK !== items.length - 1 && _containerDom.insertBefore(_containerDom.lastChild, _containerDom[keyToChildSym][keys(items).find((key) => Number(key) > typedK)]);
    };
    var onDelete = (states, k) => {
        for (let b3 of filterBindings(states)) {
            let keyToChild = b3._containerDom[keyToChildSym];
            keyToChild[k]?.remove();
            delete keyToChild[k];
        }
    };
    var replaceInternal = (obj, replacement) => {
        for (let [k, v] of entries(replacement)) {
            let existingV = obj[k];
            isObject(existingV) && isObject(v) ? replaceInternal(existingV, v) : obj[k] = v;
        }
        for (let k in obj)
            hasOwn(replacement, k) || delete obj[k];
        let newKeys = keys(replacement), isArray = Array.isArray(obj);
        if (isArray || keys(obj).some((k, i) => k !== newKeys[i])) {
            let states = obj[statesSym];
            if (isArray)
                obj.length = replacement.length;
            else {
                ++states[keysGenSym].val;
                let statesCopy = { ...states };
                for (let k of newKeys)
                    delete states[k];
                for (let k of newKeys)
                    states[k] = statesCopy[k];
            }
            for (let { _containerDom } of filterBindings(states)) {
                let { firstChild: dom, [keyToChildSym]: keyToChild } = _containerDom;
                for (let k of newKeys)
                    dom === keyToChild[k] ? dom = dom.nextSibling : _containerDom.insertBefore(keyToChild[k], dom);
            }
        }
        return obj;
    };
    var replace = (obj, replacement) => {
        replacing = 1;
        try {
            return replaceInternal(obj, replacement instanceof Function ? Array.isArray(obj) ? replacement(obj.filter((_) => 1)) : fromEntries(replacement(entries(obj))) : replacement);
        }
        finally {
            replacing = _undefined2;
        }
    };
    function CloseButton(onClick) {
        return div({
            class: "MeBoy-title-button",
            onclick: onClick
        }, "✖");
    }
    function ExtendOriginalForm() {
        function ExtendFileInputToSupportThumbnail(tempInput) {
            if (!tempInput)
                return;
            const tempThumbContainer = div();
            van_default.add(tempInput.parentElement.parentElement, [tempThumbContainer]);
            tempInput.addEventListener("change", () => {
                const filesToUpload = [...tempInput.files ?? []];
                const thumbImages = filesToUpload.map((file) => {
                    const thumb = new Image();
                    thumb.width = 150;
                    thumb.src = URL.createObjectURL(file);
                    return thumb;
                });
                tempThumbContainer.innerHTML = "";
                van_default.add(tempThumbContainer, thumbImages);
                console.log("thumb created");
            });
        }
        ExtendFileInputToSupportThumbnail(querySelector("#fm input[name='upfile']"));
        return querySelector("#fm");
    }
    var FormPositionSetting = class {
        #storageKey = "MeBoy.form.topLeft";
        topLeft = { x: 20, y: 20 };
        constructor() {
            const settingText = localStorage.getItem(this.#storageKey);
            if (settingText != null) {
                const settings = JSON.parse(settingText);
                const me = this.topLeft;
                me.x = settings.x ?? me.x;
                me.y = settings.y ?? me.y;
            }
        }
        save() {
            localStorage.setItem(this.#storageKey, JSON.stringify(this.topLeft));
        }
    };
    function GrabArea(onMove, saveTopLeft) {
        let prevPosition = null;
        const grabArea = div({
            style: `
width: 100%;
height: 100%;
cursor: grab;
`,
            onpointerdown: (e) => {
                grabArea.setPointerCapture(e.pointerId);
                prevPosition = { x: e.clientX, y: e.clientY };
                window.getSelection()?.removeAllRanges();
            },
            onpointermove: (e) => {
                if (prevPosition == null) {
                    return;
                }
                onMove(e.clientX - prevPosition.x, e.clientY - prevPosition.y);
                prevPosition = { x: e.clientX, y: e.clientY };
            },
            onpointerup: () => {
                saveTopLeft();
                prevPosition = null;
            }
        });
        return grabArea;
    }
    function ShowNoteButton(form) {
        const isNoteVisible = van_default.state(false);
        van_default.derive(() => {
            form.querySelector(".ftb2").style.display = isNoteVisible.val ? "" : "none";
        });
        return div({
            style: `align-items: center; justify-content: center;`,
            class: buttonClassName,
            onclick: () => {
                isNoteVisible.val = !isNoteVisible.val;
            }
        }, () => isNoteVisible.val ? "▲" : "▼");
    }
    function clamp(value, min, max) {
        return Math.min(Math.max(min, value), max);
    }
    function updateFormPositionSettings(settings) {
        if (window.innerWidth == 0) {
            return;
        }
        settings.topLeft.x = clamp(settings.topLeft.x, 0, window.innerWidth - 100);
        settings.topLeft.y = clamp(settings.topLeft.y, 0, window.innerHeight - 100);
    }
    function MainMenuIcon() {
        const dropdown = Dropdown(div({ class: "MeBoy-title-button", style: `height: 100%;` }, ["▼"]), div({ id: "MeBoy-extension-menu-container" }));
        dropdown.style.height = "100%";
        return dropdown;
    }
    function FloatingFormContainer(isVisible) {
        const positionSetting = new FormPositionSetting();
        updateFormPositionSettings(positionSetting);
        const topLeft = reactive(positionSetting.topLeft);
        function handleCloseButtonClick() {
            isVisible.val = false;
        }
        const handleDrag = (dx, dy) => {
            topLeft.x += dx;
            topLeft.y += dy;
        };
        const handleSave = () => {
            positionSetting.topLeft.x = topLeft.x;
            positionSetting.topLeft.y = topLeft.y;
            positionSetting.save();
        };
        const titleBar = div({
            style: `
display: flex;
background: orange;
height: 30px;
justify-content: end;
user-select: none;
touch-action: none;
position: relative;
`
        }, [
            MainMenuIcon(),
            GrabArea(handleDrag, handleSave),
            CloseButton(handleCloseButtonClick),
            style(`
.MeBoy-title-button {
	display: flex;
	width: 50px;
	justify-content: center;
	align-items: center;
	background: transparent;
	transition: background 0.5s;
}
.MeBoy-title-button:hover{
	background: rgba(255, 0, 0, 0.3);
	transition: background 0.1s;
},
			`)
        ]);
        const form = ExtendOriginalForm();
        const ftblContainer = div({
            style: `
position: relative;
left: 0;
top: 0;
padding: 10px;
`
        }, form);
        return div({
            style: () => `
position: fixed;
top: ${topLeft.y}px;
left: ${topLeft.x}px;
flex-direction: column;
background: #FFFFEE;
box-shadow: 3px 3px 3px rgba(0, 0, 0, 0.5);
z-index: 1000;
border-radius: 5px;
display: ${isVisible.val ? "flex" : "none"};
`
        }, [titleBar, ftblContainer, ShowNoteButton(form)]);
    }
    function FloatingFormExtension() {
        const isVisible = van_default.state(true);
        van_default.add(querySelector(".thre"), FloatingFormContainer(isVisible));
        for (const reszb of document.querySelectorAll("#reszb")) {
            reszb.style.display = "none";
        }
        van_default.add(document.body, BottomMenu({
            isFormVisible: isVisible
        }));
    }
    function isNodeInAnchor(node) {
        if (node.parentNode instanceof HTMLAnchorElement)
            return true;
        const parent = node.parentNode;
        if (!parent)
            return false;
        return isNodeInAnchor(parent);
    }
    function AnchorInComment(url, text = url) {
        const a2 = a();
        a2.href = url;
        a2.textContent = text;
        a2.referrerPolicy = "no-referrer";
        a2.target = "_blank";
        return a2;
    }
    function enableAbsoluteUrlLinks(commentBlock) {
        enableLinks(commentBlock, {
            regexp: /https?:\/\/[\w!?/+\-_~;.,*&@#$%()'=]+/g,
            getUrlFromFileName: (fileName) => fileName
        });
    }
    function enableUpUp2Links(node, options) {
        enableUpLinks(node, options);
        enableUp2Links(node, options);
    }
    function enableUp2Links(node, options) {
        enableLinks(node, {
            regexp: /fu\d+\.[\d\w]+/g,
            getUrlFromFileName(fileName) {
                return `${options.upOrigin}/up2/src/${fileName}`;
            }
        });
    }
    function enableUpLinks(node, options) {
        enableLinks(node, {
            regexp: /f\d+\.[\d\w]+/g,
            getUrlFromFileName(fileName) {
                return `${options.upOrigin}/up/src/${fileName}`;
            }
        });
    }
    function mapTextWithRegex(text, options) {
        const matches = [...text.matchAll(options.regexp)];
        const result = [];
        let prevIndex = 0;
        for (const match of matches) {
            const before = text.substring(prevIndex, match.index);
            if (before) {
                result.push(options.mapNonMatch(before));
            }
            const fileName = match[0];
            result.push(options.mapMatch(fileName));
            prevIndex = match.index + fileName.length;
        }
        const lastText = text.substring(prevIndex);
        if (lastText) {
            result.push(options.mapNonMatch(lastText));
        }
        return result;
    }
    function enableLinks(node, options) {
        for (const child of [...node.childNodes]) {
            if (isNodeInAnchor(child))
                continue;
            if (!(child instanceof Text)) {
                enableLinks(child, options);
                continue;
            }
            const text = child.textContent;
            const newNodes = mapTextWithRegex(text, {
                regexp: options.regexp,
                mapMatch: (fileName) => AnchorInComment(options.getUrlFromFileName(fileName), fileName),
                mapNonMatch: (fileName) => document.createTextNode(fileName)
            });
            for (const newNode of newNodes) {
                node.insertBefore(newNode, child);
            }
            child.remove();
        }
    }
    function separateDateAndEmail(element) {
        for (const cnw of element.querySelectorAll(".cnw")) {
            const anchor = cnw.querySelector("a");
            if (anchor == null) {
                continue;
            }
            const date = anchor.textContent;
            const href = anchor.getAttribute("href");
            const emailSpan = span({ style: `color: blue` }, [
                `[${cleanMailHref(href)}]`
            ]);
            cnw.innerHTML = "";
            van_default.add(cnw, `${date} `, emailSpan);
        }
    }
    function cleanMailHref(href) {
        const mailto = "mailto:";
        const cleanedHref = href.startsWith(mailto) ? href.substring(mailto.length) : href;
        return cleanedHref;
    }
    function FutabaQuote(children) {
        return van_default.add(stringToElement(`<font color="#789922"></font>`), ...children);
    }
    function wrapQuotedLines(commentBlock) {
        let nodesInLine = [];
        function check(node) {
            if (nodesInLine[0]?.textContent?.startsWith(">")) {
                commentBlock.insertBefore(FutabaQuote(nodesInLine), node);
            }
            nodesInLine = [];
        }
        for (const node of [...commentBlock.childNodes]) {
            if (node instanceof HTMLBRElement) {
                check(node);
            }
            else {
                nodesInLine.push(node);
            }
        }
        if (nodesInLine.length != 0) {
            check(null);
        }
    }
    async function observeThread(thre, processComment) {
        for (const commentBlock of thre.querySelectorAll("blockquote")) {
            await processComment(commentBlock);
        }
        const observer = new MutationObserver(async (mutations) => {
            for (const mutation of mutations) {
                for (const node of mutation.addedNodes) {
                    if (!(node instanceof HTMLTableElement))
                        continue;
                    await processComment(node.querySelector("blockquote"));
                }
            }
        });
        observer.observe(thre, { childList: true });
    }
    function ShowButtonIcon() {
        return svg.svg({
            width: "15",
            height: "15",
            viewBox: "0 0 1 1"
        }, svg.polygon({
            fill: "-webkit-link",
            points: "0.2,0.1 0.8,0.5 0.2,0.9"
        }));
    }
    var { audio, iframe, img: img2, video } = van_default.tags;
    function UploaderImageThumbnail(absoluteURL) {
        const thumb = img2({ style: "max-width: 800px" });
        thumb.src = absoluteURL;
        return thumb;
    }
    function UploaderVideoThumbnail(absoluteURL) {
        const thumb = video({ style: "max-width: 800px" });
        thumb.controls = true;
        thumb.src = absoluteURL;
        return thumb;
    }
    function UploaderTextThumbnail(absoluteURL) {
        const thumb = iframe({
            style: `border: solid gray;background: white;resize: both;`
        });
        thumb.src = absoluteURL;
        return thumb;
    }
    function UploaderAudioThumbnail(absoluteURL) {
        const thumb = audio();
        thumb.controls = true;
        thumb.src = absoluteURL;
        return thumb;
    }
    function UploaderThumbnail(absoluteURL) {
        const extension = absoluteURL.match(/\.[0-9a-z]+$/i)?.[0] ?? "";
        if ([".webm", ".mp4", ".mov"].includes(extension)) {
            return UploaderVideoThumbnail(absoluteURL);
        }
        if (extension == ".txt") {
            return UploaderTextThumbnail(absoluteURL);
        }
        if ([".mp3", ".wav"].includes(extension)) {
            return UploaderAudioThumbnail(absoluteURL);
        }
        return UploaderImageThumbnail(absoluteURL);
    }
    function ShowThumbButton(absoluteURL) {
        const isThumbVisible = van_default.state(false);
        return span(span({
            style: `cursor: pointer; padding-left: 5px;`,
            onclick: () => {
                isThumbVisible.val = !isThumbVisible.val;
            }
        }, ShowButtonIcon()), span(() => isThumbVisible.val ? UploaderThumbnail(absoluteURL) : span()));
    }
    function addThumbnailButtonsToLinks(comment, options) {
        for (const a2 of [...comment.querySelectorAll("a")]) {
            if (!a2.href.startsWith(options.upOrigin))
                continue;
            const linkContainer = span();
            a2.parentElement?.replaceChild(linkContainer, a2);
            van_default.add(linkContainer, [a2, ShowThumbButton(a2.href)]);
        }
    }
    async function ThreadExtension(thre, options) {
        await observeThread(thre, async (comment) => {
            flatCommentBlock(comment);
            const processor = options.commentProcessor;
            await processor.init(comment);
            await processor.process(comment);
            await processor.postProcess(comment);
        });
    }
    function ThreadNGMenu(ngSetting) {
        function openNGMenu(pagePosition) {
            function addNGThread() {
                const urlTokens = document.URL.split("/");
                const lastToken = urlTokens.pop() ?? "";
                const threadNumber = lastToken.match(/\d+/g)?.[0] ?? "";
                ngSetting.add(threadNumber);
            }
            ContextMenu(pagePosition, [
                div({
                    style: `padding: 10px`,
                    onclick: addNGThread
                }, "NGに登録")
            ]);
        }
        EasterEgg(document.querySelector(".cno"), openNGMenu);
    }
    function enableWheelReloading() {
        let wheelCount = 0;
        const documentElement = document.documentElement;
        documentElement.addEventListener("wheel", (e) => {
            if (e.deltaY < 0) {
                wheelCount = 0;
                return;
            }
            const condition1 = window.pageYOffset + window.innerHeight >= document.body.offsetHeight;
            const condition2 = documentElement.clientHeight > documentElement.offsetHeight;
            if (condition1 || condition2) {
                wheelCount++;
            }
            else {
                wheelCount = 0;
            }
            if (wheelCount >= 6) {
                const reloadAnchor = document.querySelector("#contres a");
                if (reloadAnchor) {
                    reloadAnchor.click();
                }
                else {
                    const background = van_default.tags.div({
                        style: `
							position: fixed;
							top: 0;
							left: 0;
							width: 100%;
							height: 100%;
						`
                    }, "Reloading...");
                    document.body.appendChild(background);
                    window.location.reload();
                }
                wheelCount = 0;
            }
        });
    }
    function getUpOrigin() {
        if (document.URL.includes("localhost")) {
            return "http://localhost:1100";
        }
        return "https://dec.2chan.net";
    }
    function createCommentProcessor(options) {
        const result = new CommentProcessor();
        result.postProcesses.push(async (comment) => enableAbsoluteUrlLinks(comment), async (comment) => enableUpUp2Links(comment, options), async (comment) => addThumbnailButtonsToLinks(comment, options), async (comment) => wrapQuotedLines(comment), async (comment) => separateDateAndEmail(comment.parentElement));
        return result;
    }
    async function MeBoyExtension(options) {
        const ngSetting = new NGStorage();
        if (!FutabaBoard.isImage) {
            enableWheelReloading();
        }
        if (FutabaBoard.isCatalog) {
            new CatalogExtension().run(ngSetting);
        }
        const commentProcessor = createCommentProcessor({
            upOrigin: getUpOrigin()
        });
        if (FutabaBoard.hasCommentForm) {
            const tasksBeforeSubmission = [];
            FloatingFormExtension();
            PermutationCityExtension(tasksBeforeSubmission, commentProcessor, options.keyStorage);
            await SignVerifyExtension(tasksBeforeSubmission, commentProcessor, options.accountsStorage);
            TaskBeforeSubmissionForm(async () => {
                for (const task of tasksBeforeSubmission.toReversed()) {
                    await task();
                }
            });
        }
        if (FutabaBoard.isThread) {
            ThreadExtension(document.querySelector(".thre"), {
                commentProcessor
            });
            ThreadNGMenu(ngSetting);
        }
        options.extensions?.();
        console.log(document.URL);
    }
    async function main() {
        console.log("MeBoy");
        await MeBoyExtension({
            accountsStorage: AccountsInChromeStorage,
            extensions: () => {
                UpTegakiExtension(getUpOrigin());
            }
        });
    }
    main();
})();
