// ==UserScript==
// @name         緑っぽい画像一覧@あいもげ
// @namespace    http://tampermonkey.net/
// @version      0.6(0.193+)
// @description  スレに「としあき(仮) 出張版」っぽい画像一覧ボタンを追加する
// @author
// @match        https://nijiurachan.net/pc/thread.php*
// @grant        GM_download
// ==/UserScript==

/*
改変元
futaba lightbox
copyright (c) 2015 himuro-majika
Released under the MIT license
https://spdx.org/licenses/MIT.html
https://greasyfork.org/ja/scripts/435787-futaba-lightbox
*/

(function() {
    /*
        　一覧ボタンの設定
    */

    //ふたばでの画像一覧ボタンの位置(好みで変える)
    //縦の位置、上から○○ピクセル
    const ichiranPosY = -1;
    //横の位置、左から○○ピクセル
    const ichiranPosX = 200;

    //一覧ボタンクリックでどちらを開くか(選ばなかった方は右クリで開く)
    //0(大きいの)　1(小さいの)
    const LIST_SIZE = 0;

    //一覧ボタンに画像数を表示する
    const SHOW_IMAGE_COUNT = true;

    //一覧を見てる位置から開くいまココボタンを追加する(スクロールできる数になったら表示される)
    const SHOW_KOKOBTN = true;

    /*
        　一覧の設定
    */

    //一覧で一行に並べる画像の数
    const IMAGE_NUM = 5;

    //小さい一覧で一行に並べる画像の数
    const IMAGE_NUM_S = 3;

    //小さい一覧の割合(%)
    const SMALL_LIST_SCALE = 40;

    //一覧の空白部分をクリックしたら一覧を閉じる
    const CLOSE_LIST_CLICK = true;

    //一覧に保存ボタンを表示する
    const USE_DLBTN = false;

    //一覧にレスに飛ぶボタンを表示する
    const USE_JUMPBTN = true;

    //一覧に除外ボタンを表示する
    const USE_EXCLBTN = true;

    //一覧にレスを表示する
    const ADD_RES_LIST = true;

    //一覧でレスをポップアップする
    const POP_UP_RES = true;

    //非IDスレでIDが付いたレスの画像を加工する
    const DECORATE_ID_RES = true;

    //一覧をマウスホイールで区切り良くスクロールする
    const USE_WHEEL_LIST = true;

    //一覧にスレ落ちとレス上限到達を表示する
    const SHOW_THREAD_DOWN = true;

    /*
        　あぷファイルの設定
    */

    //一覧にあぷファイルもまとめる(画像の後に追加)
    const ADD_UPFILE_LIST = true;

    //↑の画像とあぷファイルをレス順にソート
    const SORT_UPFILE_LIST = true;

    //あぷファイルの代用アイコンをリンク先の画像に差し替える
    const LOAD_UPFILE_LIST = true;

    //縦横最大このサイズ相当のサムネにする(大きくすると綺麗になるけどメモリ増)
    const THUMBNAIL_SIZE_EQ= 200;

    //動画も差し替える
    //動画の一部だけ受け取る仕組みを使うけどFirefoxや動画の作りによっては丸々受け取るので転送量に注意
    //環境や動画によっては間に合わず失敗する
    const LOAD_UPFILE_VIDEO = true;

    //動画の0秒を読込んでサムネ化するまで待つ時間(ミリ秒)
    //サムネ化で空欄が多かったら数値を300→600→1000と上げて試す
    const WAIT_THUMBNAIL_MAKE = 300;

    //差し替えて描写したサムネを一時的に覚えておく
    //一覧ボタンを中クリで忘れる
    //動画に付くマークがサムネ再描写のボタンになる
    const REM_THUMB_TEMP = true;

    //読込みの応答を待つ時間(ミリ秒)
    //この時間エラーにもならずに無反応なら読込みを飛ばす
    const LOAD_WAIT_TIME = 10000;

    //差し替えた動画にマークを付ける
    const MARK_VIDEO_UPFILE = true;

    //1レス内のあぷファイル数がこの数以上なら羅列荒らし判定
    const UP_IGNORE_NUM = 15;

    //差し替えに失敗したあぷファイルを次に一覧を開いた時に追加しない
    //失敗記録はスレッド毎、リロードか一覧ボタンを中クリでリセット
    const OMIT_ERROR_UPFILE = true;

    /*
        　その他の設定
    */

    //(ダウンロードフォルダ内の)保存フォルダ
    //サブフォルダに保存する場合は\\で繋げる（例 "kokoni\\hozon"）
    let folder = "";

    /*
        　設定ここまで
    */


    //スレ画が読込まれたら動く
    let checkCount = 0;
    const loadedCheck = setInterval(()=>{
        checkCount ++;
        if(document.querySelector(".thre a > img, .thre video > a")) {
            setTimeout(start, 1000);
            clearInterval(loadedCheck);
        }
        //15秒読込まれてなかったら終わる
        if(checkCount > 14) {
            clearInterval(loadedCheck);
        }
    }, 1000);

    function start() {
        //画像一覧の一枠の高さ
        let aHeight;
        //小さい一覧の一枠の高さ
        let aHeightS;
        //画像一覧の現スクロール行
        let scrollLine;
        //画像一覧が開かれてるか
        let openList = false;
        //小さい一覧が開かれるか
        let smallList = LIST_SIZE ? true : false;
        //いまココボタンの画像必要数
        let needImg;
        //ページの高さ保存用
        let bodyHeight;
        //ダークモードか
        const darkMode = document.querySelector("body.dark-mode") ? true : false;
        //IDスレか
        let idThread;
        //スレ落ちてるか
        let threadDown = document.querySelector(".reply-form-body > div").innerText.includes("このスレッドは落ちています");
        //永久スレか
        const permanentThre = Array.from(document.querySelectorAll(".thre > div > span"), el => el.textContent).some(text => text == " 永久") ? 1500 : 1000;
        //レス上限行ったか
        let resLimit = Number([...document.querySelectorAll("span.rsc")].at(-1).textContent) >= permanentThre ? true : false;
        //一覧(大)の高さ割合(%)
        const listHeight = 85;
        //スクロールバー幅
        let scrollbar;
        //細いスクロールバー幅
        let thinSb;
        //ページの拡大率
        let zoom = window.devicePixelRatio;
        //エラーだったあぷファイル
        let upErrFiles = new Set();
        //無応答だったあぷファイル
        let upWaitedFiles = new Set();
        //あぷファイルの差し替え中か
        let upReplacing = false;
        //手動で除外したファイル
        let exclFiles = new Set();
        //手動で除外したあぷファイル
        let exclUpFiles = new Set();


        getShowIdState();
        setScrollbarSize();
        addAttrReady();
        addCSS();
        yattaka();


        //id表示スレか確認
        async function getShowIdState() {
            const url = document.location.href.replace("pc/thread.php?id=", "api/v1/thread/");
            const response = await fetch(url);
            const json = await response.json();
            idThread = json?.data?.thread?.show_id ?? false;
            // console.log("このスレはID表示か：", idThread);
        }

        //ブラウザで違うスクロールバー幅を取得
        function setScrollbarSize() {
            const divEl = document.createElement("div");
            divEl.style.overflow = "scroll";
            divEl.style.width = "100px";
            divEl.style.height = "100px";
            divEl.style.position = "absolute";
            divEl.style.visibility = "hidden";

            document.body.append(divEl);

            //スクロールバー幅
            scrollbar = divEl.offsetWidth - divEl.clientWidth;
            //うまく取得出来なかったら余裕持った値を入れておく
            if(scrollbar <= 0) scrollbar = 20;
            // console.log("スクロールバー幅：", scrollbar);

            //スクロールバーを細くする
            divEl.style.scrollbarWidth = "thin";
            //細いスクロールバー幅
            thinSb = divEl.offsetWidth - divEl.clientWidth;
            //うまく取得出来なかったら余裕持った値を入れておく
            if(thinSb <= 0) thinSb = 15;
            //CSS変数を更新
            document.documentElement.style.setProperty("--thinSb", `${thinSb}px`);
            // console.log("細いスクロールバー幅：", thinSb);

            document.body.removeChild(divEl);
        }

        // 初めてスレ内の画像レスにデータ属性を付加する
        function addAttrReady() {
            if(ADD_UPFILE_LIST) addAttrResBq();
            addAttrFirst();
            if(!threadDown) observeInserted();

            //画像付きレスに属性付け
            function addAttrFirst() {
                const imgA = Array.from(document.querySelectorAll(".thre a > img"), el => el.parentElement).filter(el => !el.closest("blockquote"));
                if(imgA.length) addAttr(imgA);

                //動画の場合
                const videoA = Array.from(document.querySelectorAll(".thre video > a[href^='/uploads/']")).filter(el => !el.closest("blockquote"));
                if(videoA.length) addAttrV(videoA);
            }

            //あぷファイル込みのレスにタグ追加
            function addAttrResBq() {
                const resBq = [...document.querySelectorAll(".thre blockquote")];
                addAttrUp(resBq);
            }

            // 続きを読むで挿入される要素を監視
            function observeInserted() {
                //見守る
                let resCheck;
                const observer = new MutationObserver((mutations) => {
                    // console.log(mutations);
                    for(const mutation of mutations) {
                        // console.log(mutation);
                        for(const node of mutation.addedNodes) {
                            //追加･削除されたのは要素か
                            if(node.nodeType === 1) {
                                //画像付きレス
                                if(node.querySelector("a > img")) {
                                    const aImg = Array.from(node.querySelectorAll("a > img"), el => el.parentElement);
                                    //属性を付ける
                                    // console.log("レス監視から[画像]");
                                    if(aImg.length) addAttr(aImg, "監視");
                                }
                                //動画付きレス
                                if(node.querySelector("video > a")) {
                                    const videoA = Array.from(node.querySelectorAll("video > a[href^='/uploads/']"));
                                    //属性を付ける
                                    // console.log("レス監視から[動画]");
                                    if(videoA.length) addAttrV(videoA, "監視");
                                }
                                //あぷを一覧に含める設定か
                                if(ADD_UPFILE_LIST && node.querySelector("blockquote")) {
                                    // console.log(node.querySelectorAll("blockquote"));
                                    //引用されてないあぷファイル名があるか
                                    const bq = [...node.querySelectorAll("blockquote")].filter(el => /(?<!>(.(?!\\n))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.innerText));
                                    // console.log("あぷ監視から");
                                    if(bq.length) addAttrUp(bq, "監視");
                                }
                            }
                        }
                    }
                    //重複回避
                    clearTimeout(resCheck);
                    resCheck = setTimeout(() => {
                        //レス上限行ったか確認
                        if(Number([...document.querySelectorAll("span.rsc")].at(-1).textContent) >= permanentThre) {
                            console.info("レス上限行った(レス監視)");
                            //レス上限行った
                            resLimit = true;
                            //一覧開いてたら表示
                            if(SHOW_THREAD_DOWN && openList) showThreadDown();
                            //監視おわり
                            observer.disconnect();
                        }
                        //スレ落ちたか確認(無くなった？)
                        if(document.querySelector("#thread-gone-notice")) {
                            console.info("スレ落ちた(レス監視)");
                            //スレ落ち
                            threadDown = true;
                            //一覧開いてたら表示
                            if(SHOW_THREAD_DOWN && openList) showThreadDown();
                            //監視おわり
                            observer.disconnect();
                        }
                    }, 1000);

                    //スクロールバーの状態チェック
                    if(openList && !smallList) sbCheck();
                });

                //追加されるレスを監視
                const target = document.querySelector(".thre");
                if(!resLimit) observer.observe(target, {childList: true, subtree: true});
            }
        }

        // 動画付きレスを加工してからaddAttrに投げる
        function addAttrV(array, obs = false) {
            //加工
            for(const el of array) {
                //<video>直下のaタグよりデータ属性付けるのに都合いい位置にあるaタグ
                const linkA = el.parentElement.parentElement.querySelector(`a[href="${el.pathname}"]`) ?? false;
                //見つからなかったら飛ばす
                if(!linkA) continue;
                const poster = el.parentElement.getAttribute("poster");
                linkA.setAttribute("data-poster", poster);
            }
            const linkAs = array.map(el => el.parentElement.parentElement.querySelector(`a[href="${el.pathname}"]`)).filter(Boolean);
            addAttr(linkAs, obs);
        }

        // 画像付きレスにデータ属性を付加
        function addAttr(array, obs) {
            //加工
            for(const el of array) {
                //二度づけしない
                if(el.dataset.checked) continue;
                //確認した
                el.setAttribute("data-checked", "");

                //レス番
                const dataNo = el.parentElement.querySelector("span.cno, span.n").textContent || "";

                //レスポップアップに使うレスのコピー
                let dataRes = (el.parentElement.querySelector("blockquote").innerHTML === "") ? "[無言]" : el.parentElement.querySelector("blockquote").innerHTML ?? "[無言]";

                // console.log("置換前", dataRes);

                //レスポップアップ用に置換
                dataRes = dataRes
                    .replace(/(?<!<(a|font)[^>]+?)'/g, "&apos;") //タグ壊れ予防、aタグとfontタグ外の ' を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<(a|font)[^>]+?)"/g, "&quot;") //タグ壊れ予防、aタグとfontタグ外の " を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<a[^>]+?):/g, "&colon;") //タグ壊れ予防、aタグ外の：を文字参照に置換(IDへの画像レスでなんか壊れてた)
                    .replace(/<a[^>]+>[^>]*?(fu?\d{6,}\.[a-z4]{3,4})<\/a>/g, "$1") //あぷへのリンク
                    .replace(/f(u?\d{6,}\.)/g, "&#102;$1") //タグ壊れ予防、あぷファイル名のfを文字参照に置換(ファイル名に反応してリンク足されて壊れる)
                    .replace(/<a\shref="#"[^>]+>(([\s\S]*?))<\/a>/g, "$1") //ポップアップ用のタグ
                    .replace(/<div[^>]+ogp-preview[^>]+>[\s\S]*?<\/div><\/div><\/div>/g, "") //プレビュー
                ;
                // console.log("置換後", dataRes);

                //動画なら一覧での識別用に拡張子をコピー
                const dataExt = /\.(gif|mp4|webm)$/.test(el.href) ? el.href.match(/(?<=\.)(gif|mp4|webm)$/)[0] : ""

                //属性の設定
                el.setAttribute("data-list", "thread");
                el.setAttribute("data-no", dataNo);
                el.setAttribute("data-res", dataRes);
                if(dataExt) el.setAttribute("data-ext", dataExt);
                if(DECORATE_ID_RES && !idThread) { //非IDスレでID付いた画像を加工する設定か
                    if(el.parentElement.querySelector(".cnw")?.textContent.includes("ID:")) {
                        el.setAttribute("data-id", "");
                    }
                }
                // console.log("画像付きレスに属性付け", el.dataset.no);

                //あぷファイル名があったらデータ属性付きのリンク作る
                if(/&#102;u?\d{6,}\.(?!txt)/.test(el.dataset.res)) {
                    const upgaRes = el.dataset.res.replace(/(&#102;u?\d{6,}\.(?!txt)[a-z4]{3,4})/g, "<font class=upgaS>$1</font>");
                    el.setAttribute("data-res", el.dataset.res
                                    //ファイル名にリンクを付ける
                                    .replace(/(&#102;u?\d{6,}\.(?!txt)[a-z4]{3,4})/g, `<a data-list href=https://dec.2chan.net/up2/src/$1 target=_blank data-res='${upgaRes}'>$1</a>`)
                                    //↑あぷはURLを修正
                                    .replace(/up2(?=\/src\/&#102;\d)/g, "up")
                                   );
                }
                // console.log("置換後", el.dataset.res);
            }
            //監視から来たら実行
            if(obs === "監視") {
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                if(SHOW_KOKOBTN) ichiranCheckPoint();
                if(openList) addImageListView(array); //一覧を開いてたら継ぎ足す
            }
        }

        // あぷファイル込みのレスにタグ追加
        function addAttrUp(array, obs) {
            for(const el of array) {
                //二度づけしない
                if(el.closest("[data-upf]")) continue;

                //あぷファイル名込みのレスか
                if((el.textContent && /(?<!>(.(?!\\n))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)/.test(el.innerText))) {
                    //一覧にまとめる用に先祖タグに属性付け
                    if(el.parentElement.hasAttribute("data-thread-op")) el.parentElement.setAttribute("data-upf", ""); //本文
                    if(el.parentElement.tagName == "TD") el.closest("table").setAttribute("data-upf", ""); //レス

                    if(SHOW_KOKOBTN && obs) ichiranCheckPointEl([el]);
                }
            }

            //監視から来たら実行
            if(obs) {
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                //あぷファイルを含める設定で一覧開いてたら加える
                if(ADD_UPFILE_LIST && openList) editImageListView();
            }
        }

        //データ属性やらを消す
        function removeAttr(array, checked) {
            for(const el of array) {
                if(checked) el.removeAttribute("data-checked");
                el.removeAttribute("data-list");
                el.removeAttribute("data-id");
                el.removeAttribute("data-no");
                el.removeAttribute("data-res");
                el.removeAttribute("data-ext");
                el.removeAttribute("data-y");
                el.removeAttribute("data-poster");
                //あぷファイル
                if(el.closest("[data-upf]")) {
                    el.closest("[data-upf]").removeAttribute("data-upf");
                }
            }
        }

        //一覧の一枠の高さ計算
        function calcAheight() {
            //ページの拡大率が変わってたらスクロールバー幅の更新
            if(zoom != window.devicePixelRatio) {
                zoom = window.devicePixelRatio;
                setScrollbarSize();
            }

            //横幅
            //位置調整とスクロールバー幅と遊びを引いて並べる画像数で割ったのを小数点第一位で切捨て
            const aWidth = Math.floor(((window.innerWidth - 4 - thinSb - 1) / IMAGE_NUM) * 10) / 10;
            //小
            const aWidthS = Math.floor(((window.innerWidth * (SMALL_LIST_SCALE / 100) - 4 - thinSb - 1) / IMAGE_NUM_S) * 10) / 10;

            //画像サイズ
            //横幅から枠の隙間分引く
            const iSize = aWidth - 4;
            //小
            const iSizeS = aWidthS - 4;

            //高さ
            if(ADD_RES_LIST) { //枠にレスを足すか
                //横幅を少数四捨五入してレス表示枠の高さを足す
                aHeight = Math.round(aWidth + parseFloat(window.getComputedStyle(document.body).fontSize) * 1.5 );
                //小
                aHeightS = Math.round(aWidthS + parseFloat(window.getComputedStyle(document.body).fontSize) * 1.5 );
            } else {
                //横幅を少数四捨五入
                aHeight = Math.round(aWidth);
                //小
                aHeightS = Math.round(aWidthS);
            }

            //CSS変数を更新
            document.documentElement.style.setProperty("--viewlistW", `${aWidth}px`);
            document.documentElement.style.setProperty("--viewlistH", `${aHeight}px`);
            document.documentElement.style.setProperty("--viewlistI", `${iSize}px`);
            document.documentElement.style.setProperty("--sViewlistW", `${aWidthS}px`);
            document.documentElement.style.setProperty("--sViewlistH", `${aHeightS}px`);
            document.documentElement.style.setProperty("--sViewlistI", `${iSizeS}px`);
            document.documentElement.style.setProperty("--viewlistBar", `${aWidth * IMAGE_NUM + 4}px`);
            document.documentElement.style.setProperty("--sViewlistBar", `${aWidthS * IMAGE_NUM_S + 4}px`);
        }

        //一覧出してる時のスクロールバーの状態チェック
        function sbCheck() {
            //スクロールバーが出てきたらbodyのスタイル変更
            if(document.documentElement.scrollHeight > window.innerHeight) {
                //スクロールバーが非表示じゃないなら
                if(window.getComputedStyle(document.body).overflowY !== "hidden") {
                    document.body.style.overflow = "hidden"; //スクロールバーを消す
                    document.body.style.paddingRight = scrollbar + "px";
                }
            } else if(window.getComputedStyle(document.body).overflowY === "hidden") { //スクロールバーが非表示なら
                //bodyのスタイル戻す
                document.body.style.overflow = "";
                document.body.style.paddingRight = "";
            }
        }

        //canvasタグにアニメーションの1フレームだけ描写
        function canvasDrawImage(canvasEl, el, ins = false) {
            //アス比
            let imageAR;
            if(el.naturalWidth) {
                imageAR = el.naturalWidth / el.naturalHeight;
            } else {
                imageAR = el.videoWidth / el.videoHeight;
            }
            //アス比でサイズ決め
            let imageW;
            let imageH;
            if(imageAR >= 1) { //横長か
                imageW = THUMBNAIL_SIZE_EQ;
                imageH = Math.round(THUMBNAIL_SIZE_EQ / imageAR * 100) / 100;
            } else {
                imageW = Math.round(THUMBNAIL_SIZE_EQ * imageAR * 100) / 100;
                imageH = THUMBNAIL_SIZE_EQ;
            }

            //canvasサイズを画像に合わせる
            canvasEl.setAttribute("width", imageW);
            canvasEl.setAttribute("height", imageH);
            //canvasの2Dコンテキスト取得
            const ctx = canvasEl.getContext("2d");
            //縮小に補正
            ctx.imageSmoothingEnabled = true;
            ctx.imageSmoothingQuality = "medium";
            //canvasに描写
            ctx.drawImage(el, 0, 0, imageW, imageH);

            //動画の保険から来たら
            if(ins) {
                //動画を止めて空にしてリセット
                el.pause();
                el.removeAttribute("src");
                el.load();
            }
        }

        // CSSを設定
        function addCSS() {
            //諸々の調整
            const sonotaCSS = `
/*　変数　*/
/*
--thinSb         細いスクロールバー幅
--viewlistW     一枠の幅
--viewlistH     一枠の高さ
--viewlistI      一枠の画像サイズ
--sViewlistW  小さい一枠の幅
--sViewlistH 小さい一枠の高さ
--sViewlistI    小さい一枠の画像サイズ
*/
:hover {
    outline : 0!important;
}
/* 回転用 */
@keyframes rotate {
    from {
        transform: rotate(0deg);
    }
    to {
        transform: rotate(360deg);
    }
}
/* 除外用 */
@keyframes exclusion {
    from {
        transform: rotate(0deg);
        scale: 0.5;
        opacity: 1;
    }
    to {
        transform: rotate(360deg);
        scale: 0;
        opacity: 0;
    }
}${SHOW_KOKOBTN ? `
/* 一覧表示 */
.ichiran {
    top: ${ichiranPosY}px;
    left: ${ichiranPosX}px;
    display: flex;
    position: fixed;
    width: ${SHOW_IMAGE_COUNT ? 130 : 100}px;
    height: 30px;
    user-select: none;
    border: 1px solid #888;
    box-shadow: #0006 0px 0px 5px;
}
/* 一覧表示ボタン */
.ichiranopn {
    width: ${SHOW_IMAGE_COUNT ? 90 : 70}px;
    font-size: 12px;
    color: #000;
    background: linear-gradient(#FFF, #EEE);
    align-content: center;
    text-align: center;
    line-height: 0.9em;
    cursor: pointer;
    user-select: none;
}
.ichiranopn:hover {
    background:  linear-gradient(#FFE, #FC9);
}
/* いまココボタン */
.ichirankoko {
    width: 49px;
    font-size: 11px;
    color: #000;
    background: linear-gradient(#FFF, #EEE);
    align-content: center;
    text-align: center;
    line-height: 0.9em;
    cursor: pointer;
    user-select: none;
    padding-top: 1px;
    border-left: 1px solid #888;
}
.ichirankoko:hover {
    background:  linear-gradient(#FFE, #FC9);
}` : `
/* 一覧表示ボタン */
.ichiran {
    top: ${ichiranPosY}px;
    left: ${ichiranPosX}px;
    position: fixed;
    width: ${SHOW_IMAGE_COUNT ? 90 : 70}px;
    height: 30px;
    font-size: 12px;
    color: #000;
    background: linear-gradient(#FFF, #EEE);
    align-content: center;
    text-align: center;
    cursor: pointer;
    user-select: none;
    border: 1px solid #888;
    box-shadow: #0006 0px 0px 5px;
}
.ichiran:hover {
    background:  linear-gradient(#FFE, #FC9);
}`}
/*　画像一覧　*/
/* 背景共通 */
.futaba_lightbox_image_list_overlay {
    position: fixed;
    top: 0;
    bottom: 0;
    right: 0;
    z-index: 2000000014;
}
/* 背景 */
.futaba_lightbox_image_list_overlay.normal {
    left: 0;
    background-color: #0008;
}
/* 背景(小) */
.futaba_lightbox_image_list_overlay.small {
    width: ${SMALL_LIST_SCALE}vw;
    float: right;
    background-color: #EA8A;
    padding-top: calc(1rem + 9px);
    margin-top: 30px;
    margin-bottom: 10vh;
    box-shadow: #0006 0px 0px 5px;
}
/* 背景(小)-ダークモード */
body.dark-mode .futaba_lightbox_image_list_overlay.small {
    background-color: #5A4A3AAA;
}
/* スレ落ちバー共通 */
.sureochi {
    width: 100%;
    background-color: #E04000;
    padding: 2px 0px;
    position: absolute;
    text-align: center;
    color: #FFF;
    font-weight: bold;
    line-height: 1rem;
    user-select: none;
}
/* スレ落ちバー共通-ダークモード */
body.dark-mode .sureochi {
    background-color: #0040A0;
    color: #E0E0E0;
}
/* スレ落ちバー */
.sureochi.normal {
    margin-top: calc(5% - 1rem - 4px);
}
/* スレ落ちバー(小) */
.sureochi.small {
    margin-top: calc(-1rem - 4px);
}
/* スレ落ちテキスト */
.sureochi.normal > span {
    display: block;
    width: var(--viewlistBar);
}
/* スレ落ちテキスト(小) */
.sureochi.small > span {
    display: block;
    width: var(--sViewlistBar);
}
/* 一覧共通 */
.futaba_lightbox_image_list_container {
    width: auto;
    overflow-y: scroll;
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    align-content: flex-start;
    padding-top: 4px;
    padding-left: 4px;
    background-color: #FFE;
    user-select: none;
    /* 細いスクロールバー */
    scrollbar-width: thin;
    scrollbar-color: #800000 #F0E0D6;
}
/* 一覧 */
.futaba_lightbox_image_list_container.normal {
    height: ${listHeight}%;
    margin-top: 5%;
}
/* 一覧(小) */
.futaba_lightbox_image_list_container.small {
    height: 90%;
}
.futaba_lightbox_image_list_container:focus {
    outline: none;
}
/* 一覧共通-ダークモード */
body.dark-mode .futaba_lightbox_image_list_container {
    background-color: #1A1A2E;
    scrollbar-color: gray #2C2C2C;
}
/* 一枠共通 */
.futaba_lightbox_image_list_container > a {
    position: relative;
    overflow: hidden;
    text-align-last: center;
    color: #800000;
    text-decoration: none;
}
.futaba_lightbox_image_list_container > a:focus {
    outline: none;
}
/* 一枠 */
.futaba_lightbox_image_list_container.normal > a {
    width: var(--viewlistW);
    height: var(--viewlistH);
}
/* 一枠(小) */
.futaba_lightbox_image_list_container.small > a {
    width: var(--sViewlistW);
    height: var(--sViewlistH);
}
/* 一枠共通-ダークモード */
body.dark-mode .futaba_lightbox_image_list_container > a {
    color: #E0E0E0;
}
body.dark-mode .futaba_lightbox_image_list_container > a:hover {
    background-color: #0000!important;
    color: #7EB8DA!important;
}
/* 画像共通 */
.futaba_lightbox_image_list_container > a > img {
    display: block;
    background-color: #F0E0D6;
    object-fit: contain;
    margin: 0px;
    border-width: 0px!important;
}
/* 画像 */
.futaba_lightbox_image_list_container.normal > a > img {
    width: var(--viewlistI);
    height: var(--viewlistI);
}
/* 画像(小) */
.futaba_lightbox_image_list_container.small > a > img {
    width: var(--sViewlistI);
    height: var(--sViewlistI);
}
/* 画像共通-ダークモード */
body.dark-mode .futaba_lightbox_image_list_container > a > img {
    background-color: #252540;
}
/* レス共通 */
.futaba_lightbox_image_list_container > a > span.res {
    display: block;
    color: #800000;
    font-size: 0.9rem;
    font-weight: 600;
    background-color: #EA8;
    min-width: 0px;
    line-height: 1.5rem;
    margin: 0px;
    padding: 0px;
    overflow: clip;
}
/* レス */
.futaba_lightbox_image_list_container.normal > a > span.res {
    max-width: var(--viewlistI);
    max-height: calc(var(--viewlistI) + 1.5rem);
}
/* レス(小) */
.futaba_lightbox_image_list_container.small > a > span.res {
    max-width: var(--sViewlistI);
    max-height: calc(var(--sViewlistI) + 1.5rem);
}
/* レス共通-ダークモード */
body.dark-mode .futaba_lightbox_image_list_container > a > span.res {
    background-color: #5A4A3A;
    color: #E0E0E0;
}
/* レスポップアップ共通 */
.futaba_lightbox_image_list_container > .tooltip {
    display: none;
    padding: 10px 20px;
    margin: 0px auto;
    background-color: #FFE;
    color: #800000;
    max-width: 800px;
    box-shadow: #0006 0px 0px 5px;
    word-wrap: break-word;
}
/* レスポップアップ */
.futaba_lightbox_image_list_container > .tooltip.normal {
    position: absolute;
}
/* レスポップアップ(小) */
.futaba_lightbox_image_list_container > .tooltip.small {
    position: fixed;
}
/* レスポップアップのあぷ文字色 */
.futaba_lightbox_image_list_container > .tooltip > .upgaG {
    color: #00E;
}
/* レスポップアップ共通-ダークモード */
body.dark-mode .futaba_lightbox_image_list_container > .tooltip {
    background-color: #252540;
    color: #E0E0E0;
    box-shadow: #FFF6 0px 0px 2px;
}
/* あぷ共通 */
.futaba_lightbox_image_list_container > a > span:not(.res) {
    background-color:#F0E0D6;
    display: block;
    float: left;
    margin:0px;
    border-width: 0px!important;
    align-content: center;
}
/* あぷ */
.futaba_lightbox_image_list_container.normal > a > span:not(.res) {
    width: var(--viewlistI);
    height: var(--viewlistI);
}
/* あぷ(小) */
.futaba_lightbox_image_list_container.small > a > span:not(.res) {
    width: var(--sViewlistI);
    height: var(--sViewlistI);
}
/* あぷ共通-ダークモード */
body.dark-mode .futaba_lightbox_image_list_container > a > span:not(.res) {
    background-color:#252540;
}
/* あぷ用レスアイコン */
.futaba_lightbox_image_list_container > a > span.res > svg {
    margin-top: 4px;
    margin-bottom: -2px;
    padding-right: 2px;
}
/* 差し替えサムネ */
.futaba_lightbox_image_list_container > a > span > canvas {
    width: 100%;
    height: 100%;
    object-fit: contain;
}
/* 差し替え動画サムネ準備アイコン入れ */
.futaba_lightbox_image_list_container > a > span.easelicon {
    position: absolute;
}
/* 差し替え動画サムネ準備アイコン */
.futaba_lightbox_image_list_container > a > span.easelicon > svg {
    opacity: 1;
    transition: opacity 1s ease;
}
.futaba_lightbox_image_list_container > a > span.easelicon > svg.hidden {
    opacity: 0;
}
/* 差し替え動画サムネ入れ */
.futaba_lightbox_image_list_container > a > span.video {
    background-color: #0000;
    position: relative;
}
/* 差し替え描写済みサムネ避難所 */
upthumb {
    display: none;
}
/* 追加ボタンの基準位置 */
.add {
    position:relative;
    line-height: 1;
}
/* 動画マーク共通 */
.vmark {
    cursor: pointer;
    width: 50px;
    max-width: 50px;
    height: 17px;
    margin: 0px;
    padding: 0px;
    position: absolute;
    left: -54px;
    background-color: #800000;
    color: #FFF;
    font-size: 12px;
    text-align: center;
}
/* 動画マーク共通-ダークモード */
body.dark-mode .vmark {
    background-color: #0040A0;
    color: #E0E0E0;
}
/* 動画マーク */
.vmark.normal {
    /* レスを付けるかで位置を変える */
    top: calc(-21px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--viewlistW)/2);
}
/* 動画マーク(小) */
.vmark.small {
    /* レスを付けるかで位置を変える */
    top: calc(-21px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--sViewlistW)/2);
}
/* 追加ボタン共通 */
.tores, .DLB {
    cursor: pointer;
    position:absolute;
    width: 50px;
    height: 25px;
    align-items: center;
    align-content: center;
    padding-top: 3px;
    background-color: #FFF;
    border: 1px solid #666;
    color: #333;
    font-size: 13px;
    text-align: center;
    text-decoration: none;
    user-select: none;
    opacity: 0;
}
/* 追加ボタン */
.tores.normal, .DLB.normal {
    max-width: 50px;
    /* レスを付けるかで位置を変える */
    bottom: calc(-40px + var(--viewlistW)/2 ${ADD_RES_LIST ? " + 1.5rem / 2" : ""});
}
/* 追加ボタン(小) */
.tores.small, .DLB.small {
    max-width: 40px;
    /* レスを付けるかで位置を変える */
    bottom: calc(-30px + var(--sViewlistW)/2 ${ADD_RES_LIST ? " + 1.5rem / 2" : ""});
}
/* DLボタン */
.DLB.normal {
    left: calc(9px - var(--viewlistW));
}
/* DLボタン(小) */
.DLB.small {
    left: calc(0px - var(--sViewlistW));
}
/* レスに飛ぶボタン */
.tores.normal {
    /* 保存ボタンの有無で戻るボタンの位置を変える */
    left : calc(${USE_DLBTN ? "9px + 50px + 1px" : "9px"} - var(--viewlistW));
}
/* レスに飛ぶボタン(小) */
.tores.small {
    /* 保存ボタンの有無で戻るボタンの位置を変える */
    left : calc(${USE_DLBTN ? "40px + 1px" : "0px"} - var(--sViewlistW));
}
/* 除外ボタン枠共通 */
.excl {
    cursor: pointer;
    position: absolute;
    max-width: none;
    opacity: 0;
}
/* 除外ボタン枠 */
.excl.normal {
    width: 24px;
    height: 24px;
    left: calc(2px - var(--viewlistW));
    /* レスを付けるかで位置を変える */
    top: calc(-33px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--viewlistW)/2);
}
/* 除外ボタン枠(小) */
.excl.small {
    width: 20px;
    height: 20px;
    left: calc(2px - var(--sViewlistW));
    /* レスを付けるかで位置を変える */
    top: calc(-29px ${ADD_RES_LIST ? "- 1.5rem / 2" : ""} + var(--sViewlistW)/2);
}
/* 除外アイコン1 */
.excl > svg:first-child {
    display: block;
}
/* 除外アイコン2 */
.excl > svg:nth-child(2) {
    display: none;
}
/* 除外ボタンカバー共通 */
.excl > span {
    width: 100%;
    height: 100%;
    /*background-color: white;*/
    display: block;
}
/* 除外ボタンカバー */
.excl.normal> span {
    transform: translateY(-24px);
}
/* 除外ボタンカバー(小) */
.excl.small> span {
    transform: translateY(-20px);
}
/* IDマーク共通 */
.iddeta {
    background-color: #789922;
    position: absolute;
    max-width: none;
    top: -1.5rem;
    font-weight: bold;
    color: #FFF;
    text-align: center;
    line-height: 1.5rem;
}
/* IDマーク */
.iddeta.normal {
    font-size: 1.2rem;
    width: var(--viewlistI);
    left: calc(-4px - var(--viewlistI));
}
/* IDマーク(小) */
.iddeta.small {
    font-size: 1.1rem;
    width: var(--sViewlistI);
    left: calc(-4px - var(--sViewlistI));
}
/* 削除されたマーク共通 */
.kieta {
    background-color: #0A0;
    position: absolute;
    max-width: none;
    top: -1.5rem;
    font-weight: bold;
    color: #FFF;
    text-align: center;
    line-height: 1.5rem;
}
/* 削除されたマーク */
.kieta.normal {
    font-size: 1.3rem;
    width: var(--viewlistI);
    left: calc(-4px - var(--viewlistI));
}
/* 削除されたマーク(小) */
.kieta.small {
    font-size: 1.2rem;
    width: var(--sViewlistI);
    left: calc(-4px - var(--sViewlistI));
}
`;
            //css埋め込み
            const styleEl = document.createElement("style");
            styleEl.id = "ichiranCSS";
            styleEl.textContent = sonotaCSS;
            document.body.after(styleEl);
        }

        //一覧のイベント用この辺にまとめる
        //「ウインドウサイズが変わったら一覧も調整する」用
        const windowHaba = () => {
            //スクロールバーの状態チェック
            if(!smallList) sbCheck();

            const ichiran = document.querySelector(".futaba_lightbox_image_list_container");

            //スクロール位置の修正
            ichiran.scrollTop = smallList ? aHeightS * scrollLine : aHeight * scrollLine;

            //一覧レスの省略文字数を更新
            if(ADD_RES_LIST) omitRes();
        };

        //一覧をマウスホイールで区切り良くスクロールする
        const wheelScroll = (event) => {
            if(event.deltaY < 0) { //↑ホイール
                //デフォルトの動きを止める
                event.preventDefault();
                //リロードを誘発しない
                event.stopPropagation();
                //行ぴったりなら上の行に移動
                if(Math.trunc(scrollLine) == scrollLine) {
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * (scrollLine - 1) : aHeight * (scrollLine - 1);
                } else { //行の途中ならその行ぴったりに移動
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine) : aHeight * Math.trunc(scrollLine);
                }
            }
            if(event.deltaY > 0) { //↓ホイール
                //デフォルトの動きを止める
                event.preventDefault();
                //リロードを誘発しない
                event.stopPropagation();
                //下の行に移動
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine +1) : aHeight * Math.trunc(scrollLine +1);
            }
        };

        //上下カーソルキー、PageUp/Down、スペースキーで区切り良くスクロールする
        const keyScroll = (event) => {
            if (event.key === "ArrowUp") { //↑キー
                //デフォルトの動きを止める
                event.preventDefault();
                //行ぴったりなら上の行に移動
                if(Math.trunc(scrollLine) == scrollLine) {
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * (scrollLine - 1) : aHeight * (scrollLine - 1);
                } else { //行の途中ならその行ぴったりに移動
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine) : aHeight * Math.trunc(scrollLine);
                }
            }
            if (event.key === "ArrowDown") { //↓キー
                //デフォルトの動きを止める
                event.preventDefault();
                //下の行に移動
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(scrollLine +1) : aHeight * Math.trunc(scrollLine +1);
            }
            if(event.key === "PageUp") {
                //デフォルトの動きを止める
                event.preventDefault();
                //一覧に見えてる行数
                let pageLine;
                if(!smallList) {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeight;
                } else {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeightS;
                }
                //見えてる行数少数切り捨て
                pageLine = Math.trunc(pageLine);

                //一番下までスクロールした後なんかで少し見切れてる上の行をPageUpした後に入るように
                // console.log(scrollLine, (scrollLine % 1).toFixed(2));
                let upLine;
                if(scrollLine % 1 > 0.2) { //数字は暫定
                    upLine = Math.trunc(scrollLine + 1);
                } else {
                    upLine = Math.trunc(scrollLine);
                }

                //スクロール
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? (upLine - pageLine) * aHeightS : (upLine - pageLine) * aHeight;
            }
            if(event.key === "PageDown" || event.key === " ") {
                //デフォルトの動きを止める
                event.preventDefault();
                //一覧に見えてる行数
                let pageLine;
                if(!smallList) {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeight;
                } else {
                    pageLine = parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) / aHeightS;
                }
                //見えてる行数少数切り捨て
                pageLine = Math.trunc(pageLine);
                //見えてる最下の見切れ率
                let mikire;
                if(!smallList) {
                    mikire = (parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) - (pageLine * aHeight)) / parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container > a > img")).height);
                } else {
                    mikire = (parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container")).height) - (pageLine * aHeightS)) / parseFloat(window.getComputedStyle(document.querySelector(".futaba_lightbox_image_list_container > a > img")).height);
                }

                if(mikire < 0.7) { //見えてる最下の見切れ7割(適当)以下
                    //スクロールバーで微妙にスクロールしてて最下の画像がほぼ見えてたら見えてる行数増やす
                    if(scrollLine % 1 >= (0.8 - mikire)) pageLine += 1;
                } else {
                    //見えてる最下の見切れ7割(適当)以上ならスクロール行増やす
                    pageLine += 1;
                }
                //スクロール
                document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? (Math.trunc(scrollLine) + pageLine) * aHeightS : (Math.trunc(scrollLine) + pageLine) * aHeight;
            }
        };

        //スクロールした後の行数計算
        const calcScrollLine = () => {
            //(現スクロール位置 / 行の高さ)を小数点2位で四捨五入
            if(!smallList) {
                scrollLine = Number((document.querySelector(".futaba_lightbox_image_list_container").scrollTop / aHeight).toFixed(2));
            } else {
                scrollLine = Number((document.querySelector(".futaba_lightbox_image_list_container").scrollTop / aHeightS).toFixed(2));
            }
            // console.log("%f 行目", scrollLine);
        };

        //レスポップアップ(枠内にマウスが入ったら)
        const resPopOver = (event) => {
            const target = event.target.closest(".excl, .tores, .DLB, .vmark, .kieta, .iddeta") ? event.target.closest(".add")?.previousElementSibling ?? false : event.target.closest("a");
            if(!target) return;

            let tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");

            //レスを収納して表示
            tooltip.innerHTML = (target.dataset.res === "") ? "[空レス]" : target.dataset.res ?? "[空レス]";
            //あぷファイルの差し替えでエラーなら追記
            if(LOAD_UPFILE_LIST && target.hasAttribute("data-404")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">2回読込みエラー`;
            //あぷファイルの差し替えでスキップしてるなら追記
            if(LOAD_UPFILE_LIST && target.hasAttribute("data-skip")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">別タブ見てると描けない`;
            //あぷファイルの差し替えで時間超過してるなら追記
            if(LOAD_UPFILE_LIST && target.hasAttribute("data-waited")) tooltip.innerHTML += `<br><hr size ="1"color="#800000">サムネ化時間超過`;
            tooltip.style.width = "";
            tooltip.style.display = "block";

            //ポップアップ幅 > (ウィンドウ幅 - スクロールバー) ならフォントサイズを下げて最大幅を設定する
            if(tooltip.offsetWidth > window.innerWidth - thinSb) {
                tooltip.style.fontSize = `${parseFloat(window.getComputedStyle(tooltip).fontSize) - 2}px`;
                tooltip.style.maxWidth = `${window.innerWidth - thinSb - 40}px`;
            }

            //表示する
            resPopMove(event);
        };

        //レスポップアップ(枠内でマウス動かしたらレスをポップアップ)
        const resPopMove = (event) => {
            const target = event.target.closest(".excl, .tores, .DLB, .vmark, .kieta, .iddeta") ? event.target.closest(".add")?.previousElementSibling ?? false : event.target.closest("a");
            if(!target) return;

            const tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");

            //初期X位置
            let tooltipX = event.clientX + 20;
            //初期Y位置
            let tooltipY = event.clientY + 30;

            //右端の調整（X座標）
            const windowWidth = window.innerWidth;
            const tooltipWidth = tooltip.offsetWidth;

            if(!smallList) {
                if(tooltipX + tooltipWidth > windowWidth - thinSb - 1) { //マウス位置からレス幅が表示範囲超えないか
                    tooltipX = windowWidth - tooltipWidth - thinSb - 1; //X位置調整
                }
            } else {
                //スクロールバーが出てたら
                if(document.documentElement.scrollHeight > window.innerHeight) {
                    if(tooltipX + tooltipWidth > windowWidth - thinSb - scrollbar - 1) { //マウス位置からレス幅が表示範囲超えないか
                        tooltipX = windowWidth - tooltipWidth - thinSb - scrollbar - 1; //X位置調整
                    }
                } else {
                    if(tooltipX + tooltipWidth > windowWidth - thinSb - 1) { //マウス位置からレス幅が表示範囲超えないか
                        tooltipX = windowWidth - tooltipWidth - thinSb - 1; //X位置調整
                    }
                }
            }

            //下端の調整（Y座標）
            const windowHeight = window.innerHeight;
            const tooltipHeight = tooltip.offsetHeight;
            if(tooltipY + tooltipHeight > windowHeight) { //マウス位置からレス高が表示範囲超えないか
                tooltipY = tooltipY - tooltipHeight *1.3 - 20; //Y位置調整
            }

            //位置更新
            tooltip.style.top = tooltipY + "px";
            tooltip.style.left = tooltipX + "px";
        };

        //レスポップアップ(枠を離れたらサイズをレスに合わせるために位置を変えて非表示にする)
        const resPopOut = (event) => {
            const tooltip = document.querySelector(".futaba_lightbox_image_list_container > .tooltip");
            tooltip.style.display = "none";
            tooltip.style.top = "-500px";
            tooltip.style.left = "-500px";
            tooltip.style.maxWidth = "";
            tooltip.style.fontSize = "";
        };

        //追加ボタン(DLB)クリック
        const dlbClick = (event) => {
            download(event.target.parentElement.previousElementSibling.href);
        };

        //追加ボタン(tores)クリック
        const toresClick = (event) => {
            //レス番
            const no = event.target.parentElement.dataset.no;
            //同レス番のレスが見つかったらスクロール
            for(let resNo of document.querySelectorAll(".thre span.cno")) {
                if(resNo.textContent === no) {
                    //一覧を消す
                    if(!smallList) closeImageListView();
                    //レスの少し上にスクロール
                    window.scrollTo(0, resNo.closest(".thre, table, div[id^='r'][class^='c9']").offsetTop - 32);
                    break;
                }
            }
        };

        //追加ボタン(excl)クリック
        const exclClick = (event) => {
            //ボタンが付いてるaタグ
            const aEl = event.target.closest(".add").previousElementSibling;
            const url = aEl.pathname;
            //手動で除外したファイルに追加
            if(/\/uploads\/\d{10,}/.test(url)) {
                exclFiles.add(url);
            } else if(/\/fu?\d{6,}/.test(url)) {
                exclUpFiles.add(url.match(/fu?\d{6,}.+/)[0]);
            } else {
                console.warn("知らん…怖…\n", url);
            }
            // console.log(exclFiles);
            // console.log(exclUpFiles);

            //追加ボタン削除
            event.target.closest(".add").remove();
            //画像付きレスのだったらデータ属性変更
            if(/\d{13,}\./.test(aEl.href)) {
                const file = aEl.href.match(/\d{13,}\./)[0];
                document.querySelector(`a[data-list="thread"][href*="${file}"]`).setAttribute("data-list", "excl");
            }
            //レスポップアップを非表示に
            if(POP_UP_RES) resPopOut();
            //枠を消すアニメ指定
            aEl.style.setProperty("animation", "exclusion 0.3s forwards");
            //0.3秒後に消す
            setTimeout(() => {
                aEl.remove();
                //何番目の画像か属性付け直し
                document.querySelectorAll(".futaba_lightbox_image_list_container > a").forEach((el, index) => {
                    el.setAttribute('data-i', index);
                });
                //画像数の更新
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
            }, 300);
        };

        //動画に付くマークをクリックでその動画をクリック
        const vMarkClick = (event) => {
            if(event.target.parentElement.previousElementSibling.tagName == "A") event.target.parentElement.previousElementSibling.click();
        };

        //あぷ動画に付くマークを右クリックでサムネ化
        const redrawThumb = (event) => {
            event.preventDefault();
            const aEl = event.target.parentElement.previousElementSibling;
            //差し替え後の要素があったら消してまだ無かったら終わる
            if(!aEl.querySelector("span > canvas") && !aEl.hasAttribute("data-skip") && !aEl.hasAttribute("data-waited") && aEl.hasAttribute("data-list")) return;
            else {
                //マークの色変更
                event.target.style.backgroundColor = `${darkMode ? "skyblue" : "red"}`;
                setTimeout(()=>{
                    //マークの色戻す
                    event.target.style.backgroundColor = "";
                }, 300);

                if(aEl.hasAttribute("data-skip") || aEl.hasAttribute("data-waited")) {
                    if(aEl.hasAttribute("data-skip")) { //スキップされたか
                        //まとめてサムネ化
                        for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-skip]")) {
                            el.removeAttribute("data-skip");
                            el.querySelector("span").remove();
                            //差し替え前のタグを用意
                            const spanEl = document.createElement("span");
                            spanEl.classList.add("upicon");
                            spanEl.innerHTML = beforeLoad;
                            el.prepend(spanEl);
                        }
                    }
                    if(aEl.hasAttribute("data-waited")) { //時間超過したか
                        //まとめてサムネ化
                        for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-waited]")) {
                            el.removeAttribute("data-waited");
                            el.querySelector("span").remove();
                            el.setAttribute("data-list", "ichiran");
                            //差し替え前のタグを用意
                            const spanEl = document.createElement("span");
                            spanEl.classList.add("upicon");
                            spanEl.innerHTML = beforeLoad;
                            el.prepend(spanEl);
                        }
                    }
                } else {
                    if(aEl.hasAttribute("data-404")) { //リンク切れか
                        aEl.querySelector("span").remove();
                        aEl.setAttribute("data-list", "ichiran");
                        aEl.setAttribute("href", aEl.dataset[404]);
                        aEl.removeAttribute("data-404");
                        upErrFiles.delete(aEl.href.match(/fu?\d{6,}\..+$/)[0]);
                    }
                    if(aEl.querySelector("span[data-file]")) { //描写済みか
                        aEl.querySelector("span[data-file]").remove();
                        if(aEl.querySelector("span.easelicon")) aEl.querySelector("span.easelicon").remove();
                    }
                    //差し替え前のタグを用意
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("upicon");
                    spanEl.innerHTML = beforeLoad;
                    aEl.prepend(spanEl);
                }
                //サムネ化
                upIconReplace();
            }
        };

        //別タブから戻ったらスキップしたサムネ化やり直す
        const redrewOnActive = () => {
            if (!document.hidden) {
                if(document.querySelector(".futaba_lightbox_image_list_container > a[data-skip]")) {
                    //まとめてサムネ化
                    for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-skip]")) {
                        el.removeAttribute("data-skip");
                        el.querySelector("span").remove();
                        //差し替え前のタグを用意
                        const spanEl = document.createElement("span");
                        spanEl.classList.add("upicon");
                        spanEl.innerHTML = beforeLoad;
                        el.prepend(spanEl);
                    }
                    //サムネ化
                    upIconReplace();
                }
            }
        };

        //画像一覧
        function showImageListView(mode = "") {
            closeImageListView();

            //ビデオ要素があったら再生を止める
            if(document.querySelector(".thre video")) {
                for(const el of document.querySelectorAll(".thre video")) {
                    el.pause();
                }
            }

            //画像数がズレないよう確認
            if(SHOW_IMAGE_COUNT) setTimeout(ichiranImageCount, 100);

            //一覧のサイズでいまココボタンの補足を変える
            if(SHOW_KOKOBTN && smallList) document.querySelector(".ichirankoko").setAttribute("title", "今の一覧を見てる位置に飛ばす\n右クリで別サイズの一覧を開く");

            //属性付けたaタグを集める(引用元やプレビュー表示を巻き込まないように)
            let imageList = [...document.querySelectorAll(".thre a[data-list='thread']")];
            //除外したファイルがあったら除外する
            if(exclFiles.size) imageList = imageList.filter(el => !exclFiles.has(el.pathname));

            //一覧用に複製
            imageList = imageList.map(el => el.cloneNode(true));

            //タグ加工
            for(const el of imageList) {
                //データ属性を変える
                el.setAttribute("data-list", "ichiran");
                el.setAttribute("data-from", "thre");
                //画像付きレスか
                if(el.children[0]) {
                    //画像のファイルサイズの属性を消す
                    el.children[0].removeAttribute("alt");
                    //画像のスタイルを消す
                    el.children[0].removeAttribute("style");
                } else {
                    //ファイル名除去
                    el.textContent = "";
                    //動画レスならposterでimg作る
                    const imgEl = document.createElement("img");
                    if(el.dataset.poster != "null") {
                        imgEl.src = el.dataset.poster;
                        el.append(imgEl);
                    } else {
                        //poster未設定なら代わりに動画アイコンを表示する
                        const spanEl = document.createElement("span");
                        spanEl.innerHTML = `<br><svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${movIcon}</svg><br><font style="font-size:0.8em;">サムネ未設定</font>`;
                        el.appendChild(spanEl);
                    }
                }
                if(el.querySelector("div.img_button")) el.querySelector("div.img_button").remove();
                //画像一覧にレス追加
                if(ADD_RES_LIST) {
                    //blockquoteだとビーニードルに判定されるからタグ変更
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("res");
                    spanEl.textContent = "仮レス";
                    el.append(spanEl);
                }
            }

            //画像一覧のタグ
            const imageListContainer = document.createElement("div");
            imageListContainer.classList.add("futaba_lightbox_image_list_container");
            imageListContainer.setAttribute("data-kosuu", smallList ? IMAGE_NUM_S : IMAGE_NUM);
            imageListContainer.setAttribute("tabindex", "0");
            imageListContainer.addEventListener("keydown", event => { //Escキーで閉じるように
                if (event.key === "Escape") {
                    closeImageListView();
                }
            });
            if(CLOSE_LIST_CLICK) { //一覧の空白部分をクリックしたら一覧を閉じるか
                imageListContainer.addEventListener("click", event => {
                    if(event.target.classList.contains("futaba_lightbox_image_list_container")) {
                        closeImageListView();
                    }
                });
            }
            if(USE_WHEEL_LIST) { //一覧を区切り良くスクロールするか
                //上下カーソルキー、PageUp/Down、スペースキーで区切り良くスクロールする
                imageListContainer.removeEventListener("keydown", keyScroll, {passive: false}); //重複回避でまず解除
                imageListContainer.addEventListener("keydown", keyScroll, {passive: false}); //preventDefaultする宣言
                //スクロールした後の行数計算
                imageListContainer.removeEventListener("scroll", calcScrollLine, {passive: true}); //重複回避でまず解除
                imageListContainer.addEventListener("scroll", calcScrollLine, {passive: true}); //preventDefaultしない宣言
            }
            //一覧のサイズでクラス付け
            smallList ? imageListContainer.classList.add("small") : imageListContainer.classList.add("normal");
            //配列imageListを複数対応のappend内で展開してimageListContainerに追加
            imageListContainer.append(...imageList);

            //画像一覧の背景のタグ
            const imageListOverLay = document.createElement("div");
            imageListOverLay.classList.add("futaba_lightbox_image_list_overlay");
            imageListOverLay.addEventListener("click", event => { //画像一覧の背景クリックでも一覧を閉じるように
                if(event.target.classList.contains("futaba_lightbox_image_list_overlay")) {
                    closeImageListView();
                }
            });
            if(USE_WHEEL_LIST) { //一覧を区切り良くスクロールするか
                //マウスホイールで区切り良くスクロールする
                imageListOverLay.removeEventListener("wheel", wheelScroll, {passive: false}); //重複回避でまず解除
                imageListOverLay.addEventListener("wheel", wheelScroll, {passive: false}); //preventDefaultする宣言
            }
            //一覧のサイズでクラス付け
            smallList ? imageListOverLay.classList.add("small") : imageListOverLay.classList.add("normal");
            imageListOverLay.append(imageListContainer);

            //スクロールバーの状態チェック
            if(!smallList) sbCheck();

            document.body.prepend(imageListOverLay); //bodyに加えて表示(赤福の続きを読む対策でbody先頭に)
            //一覧にフォーカスを移す
            document.querySelector(".futaba_lightbox_image_list_container").focus();

            //スレ落ちてるか
            if(SHOW_THREAD_DOWN && (threadDown || resLimit)) showThreadDown();

            //ウインドウサイズが変わったら一覧を調整する
            window.removeEventListener("resize", windowHaba); //重複回避でまず解除
            window.addEventListener("resize", windowHaba);

            //別タブから戻ったらスキップしたあぷ動画のサムネ化をやり直す
            if(LOAD_UPFILE_LIST && LOAD_UPFILE_VIDEO) {
                document.removeEventListener("visibilitychange", redrewOnActive); //重複回避でまず解除
                document.addEventListener("visibilitychange", redrewOnActive);
            }

            //行数
            scrollLine = 0;

            //一覧の加工
            editImageListView(mode);
            // console.log("arguments", arguments);
        }

        //更新での継ぎ足し
        function addImageListView(array) {
            //リロード押すとデータ属性全部付け直しで小さい一覧開いてると重複する対策
            const listANo = new Set(Array.from(document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-from="thre"]`), el => el.dataset.no));
            //引数からもうある画像と除外したファイルを除いて複製
            let imageList = array.filter(el => el.dataset.list).filter(el => !listANo.has(el.dataset.no)).filter(el => !exclFiles.has(el.pathname)).map(el => el.cloneNode(true));

            //タグ加工
            for(const el of imageList) {
                //データ属性を変える
                el.setAttribute("data-list", "ichiran");
                el.setAttribute("data-from", "thre");
                //画像付きレスか
                if(el.children[0]) {
                    //画像のファイルサイズの属性を消す
                    el.children[0].removeAttribute("alt");
                    //画像のスタイルを消す
                    el.children[0].removeAttribute("style");
                } else {
                    //ファイル名除去
                    el.textContent = "";
                    //動画レスならimg作る
                    const imgEl = document.createElement("img");
                    if(el.dataset.poster != "null") {
                        imgEl.src = el.dataset.poster;
                        el.append(imgEl);
                    } else {
                        //poster未設定なら代わりに動画アイコンを表示する
                        const spanEl = document.createElement("span");
                        spanEl.innerHTML = `<br><svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${movIcon}</svg><br><font style="font-size:0.8em;">サムネ未設定</font>`;
                        el.appendChild(spanEl);
                    }
                }
                if(el.querySelector("div.img_button")) el.querySelector("div.img_button").remove();
                //画像一覧にレス追加
                if(ADD_RES_LIST) {
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("res");
                    spanEl.textContent = "仮レス";
                    el.append(spanEl);
                }
            }

            //一覧に追加
            //配列imageListを複数対応のappend内で展開してimageListContainerに追加
            document.querySelector(".futaba_lightbox_image_list_container").append(...imageList);

            //一覧の加工
            editImageListView();
        }

        function editImageListView(mode = "") {
            const ichiran = document.querySelector(".futaba_lightbox_image_list_container");

            //一覧にあぷファイル名を含める
            if(ADD_UPFILE_LIST) {
                let res;
                //もう一覧開いてたら差分を追加する
                if(openList) {
                    //引用表示じゃないdata-upf属性のレス
                    const upf = [...document.querySelectorAll(".thre [data-upf]")];
                    //一覧にあるあぷファイルのレス番(重複整理)
                    const listUpANo = new Set(Array.from(document.querySelectorAll(`.futaba_lightbox_image_list_container > a[data-from="up"]`), el => el.dataset.no));
                    //追加する一覧にないレス番のレス
                    res = upf.filter(el => !listUpANo.has(el.querySelector(".cno").textContent)).map(el => el.querySelector("blockquote"));
                    // console.log(res);
                } else {
                    //追加する引用表示じゃないdata-upf属性のレス
                    res = [...document.querySelectorAll(".thre [data-upf] blockquote")];
                }
                if(res.length) {
                    for(let el of res) {
                        //親要素ごと複製する
                        el = el.parentElement.cloneNode(true).querySelector("blockquote");
                        //動画をレス内で再生中に複製すると同時に再生されるから複製した方は止める
                        if(el.parentElement.querySelector("video")) {
                            for(const videoEl of el.parentElement.querySelectorAll("video")) { //赤福のプレビューも入るようにする
                                //動画を止めて空にしてリセット
                                videoEl.pause();
                                videoEl.removeAttribute("src");
                                videoEl.load();
                            }
                        }
                        // console.log(el.innerHTML);
                        let up = el.innerHTML.match(/(?<!&gt;(.(?!<br>))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)(?!['"])/g);
                        if(up) {
                            //羅列荒らしか
                            if(up.length >= UP_IGNORE_NUM) continue;
                            //エラーだったあぷファイルを除外するか
                            if(OMIT_ERROR_UPFILE) up = up.filter(val => !upErrFiles.has(val));
                            //除外したあぷファイルを除外する
                            if(exclUpFiles.size) up = up.filter(val => !exclUpFiles.has(val));
                            const no = el.parentElement.querySelector("span.cno, span.n").textContent; //レス番
                            if(SHOW_KOKOBTN) { //いまココボタンを使うか
                                if(typeof el.dataset.y == "undefined") ichiranCheckPoint();
                                const y = el.dataset.y;
                                upUpko(up, el, no, y);
                            } else {
                                upUpko(up, el, no);
                            }
                        }
                    }
                    //あぷファイルをソートするか
                    if(SORT_UPFILE_LIST) {
                        //一覧開いてたらスクロール行を覚えておく(保険)
                        const slRec = openList ? scrollLine : 0;
                        //一覧のaタグをレス番でソートした配列
                        const newIchiran = [...document.querySelectorAll(".futaba_lightbox_image_list_container > a")].sort((a, b) => Number(a.dataset.no.slice(3)) - Number(b.dataset.no.slice(3)));
                        //aタグをソートした順に一覧の最後に移動していく
                        for(const el of newIchiran) {
                            ichiran.appendChild(el);
                            //同レス番のボタン用タグがあったらaタグの後ろに配置
                            if(document.querySelector(`.futaba_lightbox_image_list_container > div.add[data-no="${el.dataset.no}"]`)) el.after(document.querySelector(`.futaba_lightbox_image_list_container > div.add[data-no="${el.dataset.no}"]`));
                        }
                        //覚えた行にスクロール
                        if(slRec) ichiran.scrollTop = smallList ? aHeightS * slRec : aHeight * slRec;
                    }
                }
                //一覧にあぷファイルを読込む
                if(LOAD_UPFILE_LIST) upIconReplace();
            }

            //何番目の画像か属性付ける
            document.querySelectorAll(".futaba_lightbox_image_list_container > a").forEach((el, index) => {
                el.setAttribute('data-i', index);
            });

            //画像一覧にボタン追加
            if(USE_JUMPBTN || USE_DLBTN || USE_EXCLBTN) makeButton();
            //動画にマーク付ける
            videoMarking();
            //非IDスレでID付いた画像を加工
            if(DECORATE_ID_RES && !idThread) decoIDRes();
            //レス枠超える文字を省略
            if(ADD_RES_LIST) omitRes();

            //いまココボタンから来たか
            if(mode == "いまココ") {
                // console.log("いまココ\t行個数\t%d\t画面Y\t%f", IMAGE_NUM, window.scrollY);
                for(const [i, el] of [...document.querySelectorAll(".futaba_lightbox_image_list_container > a")].entries()) {
                    // console.log("%d\t行目\t%d\t枚目\t画像Y\t%f", Math.trunc(i / IMAGE_NUM) + 1, i + 1, el.dataset.y);

                    //一覧を画像がある行までスクロールする
                    document.querySelector(".futaba_lightbox_image_list_container").scrollTop = smallList ? aHeightS * Math.trunc(i / IMAGE_NUM_S) : aHeight * Math.trunc(i / IMAGE_NUM);
                    //スクロールで表示が流れきってないか届いてない画像の行で抜ける
                    if((window.scrollY - 1) < el.dataset.y) break;
                }
            }

            //レスポップアップ
            if(POP_UP_RES) {
                //一覧を開いてるか
                if(openList) {
                    //レスの収納タグを一覧の最後に再配置
                    ichiran.appendChild(ichiran.querySelector(".tooltip"));
                } else {
                    //レスの収納タグを作る
                    const tooltip = document.createElement("div");
                    tooltip.classList.add("tooltip");
                    smallList ? tooltip.classList.add("small") : tooltip.classList.add("normal");
                    tooltip.style.display = "none";
                    tooltip.style.top = "-500px";
                    tooltip.style.left = "-500px";
                    ichiran.appendChild(tooltip);

                    // 継ぎ足し項目でも動くようにイベント設定
                    //枠内にマウスが入ったら
                    ichiran.addEventListener("mouseover", resPopOver);
                    //枠内でマウス動かしたら
                    ichiran.addEventListener("mousemove", resPopMove);
                    //枠を離れたら
                    ichiran.addEventListener("mouseout", resPopOut);
                }
            }
            //一覧を開いてる
            openList = true;
        }

        //一覧閉じる
        function closeImageListView() {
            const listoverlay = document.querySelector(".futaba_lightbox_image_list_overlay");
            if(!listoverlay) return;

            //一覧を区切り良くスクロールするイベント削除
            if(USE_WHEEL_LIST) {
                document.querySelector(".futaba_lightbox_image_list_overlay").removeEventListener("wheel", wheelScroll, {passive: false});
                document.querySelector(".futaba_lightbox_image_list_container").removeEventListener("keydown", keyScroll, {passive: false});
                document.querySelector(".futaba_lightbox_image_list_container").removeEventListener("scroll", calcScrollLine, {passive: true});
            }

            //あぷファイルの差し替え
            if(LOAD_UPFILE_LIST) {
                //あぷファイルの差し替え中を解除
                upReplacing = false;
                //あぷファイルのサムネを移動する
                if(REM_THUMB_TEMP) {
                    listoverlay.style.display = "none";
                    for(const el of Array.from(document.querySelectorAll(".futaba_lightbox_image_list_container > a > span[data-file] > canvas"), el => el.parentElement)) {
                        el.removeAttribute("class");
                        el.removeAttribute("title");
                        el.removeAttribute("style");
                        document.querySelector("upthumb").append(el);
                    }
                }
            }

            listoverlay.remove();
            //bodyのスタイル戻す
            document.body.style.overflow = "";
            document.body.style.paddingRight = "";

            //操作パネル戻す
            if(document.querySelector("#akahuku_thread_operator")) document.querySelector("#akahuku_thread_operator").style.display = "block";

            //いまココボタンの補足を戻す
            if(SHOW_KOKOBTN) document.querySelector(".ichirankoko").setAttribute("title", "画像一覧を見てる位置から開く\n右クリで別サイズの一覧を開く");

            //ウインドウサイズ変更で一覧を調整するイベントを削除
            window.removeEventListener("resize", windowHaba);

            //別タブから戻ったらスキップしてたあぷ動画のサムネ化をやり直すイベントを削除
            if(LOAD_UPFILE_LIST && LOAD_UPFILE_VIDEO) document.removeEventListener("visibilitychange", redrewOnActive);

            //一覧を閉じた
            openList = false;

            //開いてる間に変わった画像数を一覧ボタンに反映
            if(SHOW_IMAGE_COUNT) {
                setTimeout(() => {
                    ichiranImageCount("一覧閉じた")
                }, 100);
            }
        }

        //一覧にスレ落ちや1000レス到達を表示する
        function showThreadDown() {
            if(document.querySelector(".reply-form-body > div").innerText.includes("このスレッドは落ちています")) {
                const divEl = document.createElement("div");
                divEl.classList.add("sureochi");
                smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                divEl.innerHTML = `<span>過去ログ</span>`;
                //一覧の前に追加
                document.querySelector(".futaba_lightbox_image_list_container").before(divEl);
            } else {
                const divEl = document.createElement("div");
                divEl.classList.add("sureochi");
                smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                divEl.innerHTML = `<span>${resLimit ? `${permanentThre}レス` : "スレ落ちた"}</span>`;
                //一覧の前に追加
                document.querySelector(".futaba_lightbox_image_list_container").before(divEl);
            }
        }

        //あぷファイル名を含める
        function upUpko(file, tag, no, y) {
            let url;
            let up;
            for(const val of file) {
                if(/u/.test(val)) {
                    url = "https://dec.2chan.net/up2/src/";
                    up = "あぷ小";
                } else {
                    url = "https://dec.2chan.net/up/src/";
                    up = "あぷ";
                }
                //ファイルを読込んでレスを追加する設定の時はアイコンに変える
                if(LOAD_UPFILE_LIST && ADD_RES_LIST) {
                    if(/(mp4|webm)/.test(val)) { //動画か
                        up = `<svg xmlns="http://www.w3.org/2000/svg" height="1rem" width="1rem" viewBox="0 0 512 512">${movIcon}</svg>`;
                    } else {
                        up = `<svg xmlns="http://www.w3.org/2000/svg" height="1rem" width="1rem" viewBox="0 0 512 512">${imgIcon}</svg>`;
                    }
                }

                //レスの置換
                let dataRes = tag.innerHTML;
                // console.log("置換前", dataRes);
                dataRes = dataRes
                    .replace(/(?<!<(a|font)[^>]+?)'/g, "&apos;") //タグ壊れ予防、aタグとfontタグ外の ' を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<(a|font)[^>]+?)"/g, "&quot;") //タグ壊れ予防、aタグとfontタグ外の " を文字参照に置換(対になってないと壊れる？)
                    .replace(/(?<!<a[^>]+?):/g, "&colon;") //タグ壊れ予防、aタグ外の：を文字参照に置換(IDへの画像レスでなんか壊れてた)
                    .replace(/<a[^>]+>[^>]*?(fu?\d{6,}\.[a-z4]{3,4})<\/a>/g, "$1") //あぷへのリンク
                    .replace(/(?<!&gt;)(fu?\d{6,}\.[a-z4]{3,4})/g, "<font class=upgaG>$1</font>") //あぷファイルのタグ付け
                    .replace(/<a\shref="#"[^>]+>(([\s\S]*?))<\/a>/g, "$1") //ポップアップ用のタグ
                    .replace(/<div[^>]+ogp-preview[^>]+>[\s\S]*?<\/div><\/div><\/div>/g, "") //プレビュー
                ;
                // console.log("置換後", dataRes);

                const upUpko = document.createElement("a");
                upUpko.setAttribute("href", url+val);
                upUpko.setAttribute("target", "_blank");
                upUpko.setAttribute("data-list", "ichiran"); //一覧用
                upUpko.setAttribute("data-from", "up");
                upUpko.setAttribute("data-no", no); //レス番
                upUpko.setAttribute("data-res", dataRes); //レスポップアップ用
                if(SORT_UPFILE_LIST) { //あぷファイルをソートするか
                    upUpko.setAttribute("data-y", y); //レス位置
                }
                if(DECORATE_ID_RES && !idThread) { //非IDスレでID付いた画像を加工する設定か
                    if(tag.parentElement.querySelector(".cnw")?.textContent.includes("ID:")) upUpko.setAttribute("data-id", "");
                }

                //1レスのあぷファイル数が2以上だったら強調する
                if(upUpko.dataset.res.match(/<font\sclass=upgaG>/g).length > 1) {
                    upUpko.setAttribute("data-res", upUpko.dataset.res
                                        .replace(`<font class=upgaG>${val}</font>`, `<font color=#ff3300>${val}(これ)</font>`) //表示あぷ文字色変え
                                       );
                } else{
                    upUpko.setAttribute("data-res", upUpko.dataset.res
                                        .replace(`<font class=upgaG>${val}</font>`, `<font color=${darkMode ? "7EB8DA" : "#0000ee"}>${val}</font>`) //表示あぷ文字色変え
                                       );
                }

                //ファイルを読込む設定でサムネがもうあるか
                if(LOAD_UPFILE_LIST && REM_THUMB_TEMP && document.querySelector(`upthumb > span[data-file="${val}"]`)) {
                    //あぷファイルのサムネを移す
                    const spanEl = document.querySelector(`upthumb > span[data-file="${val}"]`);
                    upUpko.append(spanEl);
                } else {
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("upicon");
                    //ファイルを読込むか
                    if(LOAD_UPFILE_LIST) {
                        if(ADD_RES_LIST) { //レスを追加する設定か
                            //読込み前のアイコンを表示
                            spanEl.innerHTML = beforeLoad;
                        } else {
                            //リンクアイコン+ファイル名を表示
                            spanEl.innerHTML = `<br>${linkIcon}<br><font style="font-size: 0.8em;">${val.replace(/\..+$/, "")}</font>`;
                        }
                    } else {
                        if(/(mp4|webm)/.test(val)) { //動画か
                            if(ADD_RES_LIST) { //レスを追加する設定か
                                spanEl.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${movIcon}</svg>`;
                            } else {
                                spanEl.innerHTML = `<br><svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${movIcon}</svg><br><font style="font-size:0.8em;">${val.replace(/\..+$/, "")}</font>`;
                            }
                        } else {
                            if(ADD_RES_LIST) {
                                spanEl.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${imgIcon}</svg>`;
                            } else {
                                spanEl.innerHTML = `<br><svg xmlns="http://www.w3.org/2000/svg" height="40%" width="40%" viewBox="0 0 512 512">${imgIcon}</svg><br><font style="font-size:0.8em">${val.replace(/\..+$/, "")}</font>`;
                            }
                        }
                    }
                    upUpko.appendChild(spanEl);
                }

                //一覧に追加するレスのタグ
                if(ADD_RES_LIST) {
                    const spanEl = document.createElement("span");
                    spanEl.classList.add("res");
                    spanEl.innerHTML = `${up}<font style='color:${darkMode ? "#7EB8DA" : "#33E"}'>${val}</font>`;
                    upUpko.appendChild(spanEl);
                }

                //一覧の最後に足していく
                document.querySelector(".futaba_lightbox_image_list_container").appendChild(upUpko);
            }
        }
        //使うアイコン
        const imgIcon = `<!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="${darkMode ? "skyblue" : "#800000"}" d="M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM323.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l96 0 32 0 208 0c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176zM112 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/>`;
        const movIcon = `<!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="${darkMode ? "skyblue" : "#800000"}" d="M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM48 368l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L64 96c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM160 128l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L192 96c-17.7 0-32 14.3-32 32zm32 160c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0z"/>`;
        const beforeLoad = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512"><g><path fill="${darkMode ? "skyblue" : "#800000"}" d="M511.878,247.973l-21.488,0.672l21.488-0.68c-2.168-69.219-31.732-131.348-77.876-175.949 C387.882,27.377,324.93-0.004,256.13,0.004c-2.718,0-5.443,0.046-8.176,0.13h0.016C178.743,2.294,116.622,31.858,72.013,78.002 C27.382,124.122,0,187.074,0,255.874c0,2.709,0.046,5.435,0.13,8.16c2.168,69.22,31.732,131.347,77.875,175.949 c46.113,44.632,109.065,72.02,177.865,72.013c2.694,0,5.42-0.038,8.16-0.13c69.227-2.16,131.355-31.724,175.957-77.876 c44.64-46.121,72.021-109.065,72.013-177.857C512,253.416,511.962,250.699,511.878,247.973z M102.921,107.894 c19.64-20.29,43.274-36.647,69.67-47.891c-10.961,15.77-20.336,34.426-28.045,55.304H96.089 C98.303,112.779,100.585,110.306,102.921,107.894z M75.692,142.664h60.112c-8.282,30.212-13.327,63.906-14.365,99.661H43.472 C45.77,205.914,57.243,171.938,75.692,142.664z M75.647,369.344c-18.351-29.121-29.808-63.044-32.144-99.661h78.028 c1.046,35.732,5.954,69.471,14.236,99.661H75.647z M107.898,409.083c-4.091-3.962-7.984-8.114-11.748-12.381h48.442 c4.099,11.091,8.579,21.67,13.594,31.396c4.405,8.518,9.16,16.487,14.252,23.847C148.37,441.654,126.523,427.082,107.898,409.083z  M242.329,468.524c-5.931-0.374-11.809-0.946-17.603-1.801c-2.404-1.573-4.809-3.282-7.213-5.236 c-16.381-13.313-31.778-35.831-43.694-64.784h68.51V468.524z M242.329,369.344h-78.15c-8.794-29.411-14.267-63.365-15.381-99.661 h93.531V369.344z M242.329,242.325h-93.448c1.115-36.327,6.618-70.235,15.42-99.661h78.028V242.325z M242.329,115.306h-68.433 c2.71-6.588,5.542-12.954,8.595-18.84c10.298-19.969,22.404-35.647,35.022-45.945c2.366-1.924,4.732-3.604,7.099-5.16 c5.832-0.862,11.74-1.48,17.717-1.863V115.306z M436.369,142.664c18.351,29.128,29.8,63.044,32.136,99.661h-78.02 c-1.046-35.732-5.954-69.471-14.236-99.661H436.369z M404.11,102.917c4.092,3.961,7.985,8.114,11.756,12.389h-48.441 c-4.099-11.092-8.58-21.672-13.596-31.396c-4.412-8.527-9.167-16.496-14.267-23.847C363.63,70.353,385.484,84.918,404.11,102.917z  M269.687,43.476c5.924,0.374,11.801,0.954,17.587,1.802c2.412,1.58,4.824,3.282,7.229,5.244 c16.381,13.32,31.778,35.823,43.686,64.784h-68.502V43.476z M269.687,142.664h78.15c8.794,29.411,14.267,63.364,15.381,99.661 h-93.531V142.664z M269.687,269.683h93.448c-1.114,36.327-6.618,70.242-15.42,99.661h-78.028V269.683z M329.525,415.534 c-10.297,19.976-22.412,35.655-35.022,45.953c-2.359,1.924-4.725,3.595-7.091,5.152c-5.832,0.863-11.74,1.481-17.725,1.862v-71.799 h68.426C335.402,403.289,332.57,409.648,329.525,415.534z M409.087,404.106c-19.64,20.29-43.266,36.64-69.655,47.884 c10.962-15.771,20.328-34.419,28.037-55.288h48.449C413.698,399.22,411.423,401.694,409.087,404.106z M436.308,369.344h-60.105 c8.29-30.206,13.336-63.906,14.374-99.661h77.952C466.23,306.086,454.757,340.07,436.308,369.344z"></path></g></svg>`;
        const linkIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512"><g><path fill="${darkMode ? "skyblue" : "#800000"}" d="M509.445,113.129c-2.547-13.219-7.047-26.141-13.453-38.359c-6.391-12.203-14.75-23.641-24.938-33.828 c-13.563-13.578-29.406-23.875-46.265-30.719c-25.297-10.219-52.828-12.781-79.266-7.656c-13.219,2.563-26.156,7-38.359,13.422 c-12.172,6.422-23.641,14.75-33.828,24.953l-66.25,66.25c-13.375,13.344-13.375,35.047,0,48.391s35.031,13.344,48.391,0 l66.25-66.281c7.031-7,15.016-12.172,23.594-15.672c12.844-5.203,27.031-6.531,40.547-3.906c6.75,1.313,13.328,3.594,19.531,6.844 c6.188,3.25,12,7.469,17.281,12.734c7.031,7.078,12.187,15.047,15.687,23.609c5.203,12.844,6.531,27.047,3.906,40.547 c-1.313,6.766-3.594,13.344-6.828,19.516c-3.281,6.219-7.484,12.031-12.765,17.313l-66.25,66.234 c-13.359,13.359-13.359,35.047,0,48.391s35.016,13.344,48.375,0l66.25-66.265c13.594-13.563,23.875-29.406,30.703-46.266 C512.008,167.083,514.555,139.551,509.445,113.129z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M256.54,356.426l-66.266,66.266c-7.047,7.016-15.031,12.188-23.594,15.672 c-12.844,5.219-27.047,6.547-40.547,3.938c-6.766-1.328-13.328-3.625-19.531-6.859c-6.188-3.266-12-7.5-17.281-12.75 c-7.031-7.063-12.203-15.031-15.688-23.609c-5.203-12.828-6.531-27.031-3.922-40.563c1.313-6.75,3.609-13.328,6.844-19.516 c3.281-6.188,7.484-12,12.766-17.297l66.266-66.25c13.344-13.344,13.344-35.016,0-48.359c-13.375-13.359-35.031-13.359-48.391,0 l-66.25,66.234c-13.594,13.594-23.875,29.406-30.719,46.297c-10.234,25.266-12.781,52.844-7.672,79.219 c2.547,13.219,7.031,26.156,13.453,38.359c6.406,12.203,14.75,23.672,24.938,33.844c13.594,13.578,29.406,23.891,46.266,30.688 c25.281,10.266,52.844,12.813,79.25,7.703c13.234-2.563,26.156-7.047,38.344-13.453c12.203-6.391,23.672-14.75,33.859-24.938 l66.25-66.266c13.344-13.344,13.344-35.016,0-48.359C291.54,343.066,269.883,343.066,256.54,356.426z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M342.43,169.567c-13.344-13.344-35.016-13.344-48.375,0l-124.516,124.5c-13.344,13.359-13.344,35.016,0,48.359 c13.375,13.375,35.047,13.375,48.391,0l124.5-124.5C355.805,204.567,355.805,182.926,342.43,169.567z"></path></g></svg>`;


        //あぷファイルを1つずつ差し替える
        function upIconReplace() {
            if(upReplacing) return;
            upReplacing = true;
            //エラーだったあぷファイル置換のリトライ中か
            let upRepRetry = false;
            //動画のメタデータを読込んだか
            let metaReady = false;
            //読込みスキップタイマー
            let waitTimer;
            //2度目以降のスキップを減らす時間
            let waitNthTime;

            //サムネ避難所
            if(REM_THUMB_TEMP && !document.querySelector("upthumb")) {
                const el = document.createElement("upthumb");
                document.body.after(el);
            }

            //イベント登録用
            //動画のメタデータを読込んだら
            const videoLoadedmetadata = (videoEl) => {
                if(document.querySelector(".futaba_lightbox_image_list_container")) {
                    //読込みスキップタイマー解除
                    clearTimeout(waitTimer);

                    upRepRetry = false;
                    metaReady = true;
                    //動画の0秒に移動(追加でどれだけ読込むかは動画の作りによる)
                    videoEl.currentTime = 0;
                }
            };
            //動画の再生位置部分のデータが集まったら
            const videoLoadeddata = (upFileEl, videoEl, canvasEl) => {
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    //メタデータ読込み済みか
                    if(metaReady) {
                        //スキップしたあぷファイル名セットにあったら削除
                        if(upWaitedFiles.has(upFileEl.href.match(/fu?\d{6,}\..+$/)[0])) upWaitedFiles.delete(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);

                        setTimeout(() => {
                            //canvasタグに動画の1フレームだけ描写
                            canvasDrawImage(canvasEl, videoEl);

                            if(upFileEl.querySelector("span.upicon")) {
                                //アイコン削除
                                upFileEl.querySelector("span.upicon").remove();
                                //canvas入れる位置調整用span要素
                                {
                                    const spanEl = document.createElement("span");
                                    spanEl.classList.add("video");
                                    spanEl.setAttribute("data-file", upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                                    //spanにcanvas追加
                                    spanEl.append(canvasEl);
                                    //span追加
                                    upFileEl.prepend(spanEl);
                                }
                                //準備中アイコン入れるspan要素
                                {
                                    const spanEl = document.createElement("span");
                                    spanEl.classList.add("easelicon");
                                    spanEl.innerHTML = easelIcon;
                                    upFileEl.prepend(spanEl);
                                    setTimeout(() => {
                                        spanEl.querySelector("svg").classList.add("hidden");
                                    }, 200);
                                }
                                //繰り返す
                                rep();
                            }
                            //サムネ化失敗の保険
                            setTimeout(() => {
                                //canvasタグに動画の1フレームだけ再描写
                                canvasDrawImage(canvasEl, videoEl, true);
                            }, 1000);
                        }, WAIT_THUMBNAIL_MAKE);
                    } else { //先にこっち来たらやり直す
                        //読込みスキップタイマー解除
                        clearTimeout(waitTimer);

                        //動画を止めて空にしてリセット
                        videoEl.pause();
                        videoEl.removeAttribute("src");
                        videoEl.load();

                        //リトライ
                        upRepRetry = true;
                        setTimeout(rep, 100);
                        return;
                    }
                } else {
                    //もう一覧閉じてたら一応空にしておく
                    videoEl.pause();
                    videoEl.removeAttribute("src");
                    videoEl.load();
                }
            };
            //画像を読込んだら
            const imgLoad = (upFileEl, imgEl) => {
                //読込みスキップタイマー解除
                clearTimeout(waitTimer);
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    //スキップしたあぷファイル名セットにあったら削除
                    if(upWaitedFiles.has(upFileEl.href.match(/fu?\d{6,}\..+$/)[0])) upWaitedFiles.delete(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);

                    upRepRetry = false;
                    //アイコン削除
                    upFileEl.querySelector("span.upicon").remove();
                    // 読込んだ画像を差し込む
                    upFileEl.prepend(imgEl);
                    //console.log("読込んだ！")

/* aimgはサムネで動くからやらない
                    //アニメーション画像の動きを止め(たように見せ)るためにサムネをcanvasに描く
                    //imgタグを非表示に
                    imgEl.style.display = "none";
                    //canvasタグ
                    const canvasEl = document.createElement("canvas");
                    //canvasタグにアニメーション画像の1フレームだけ描写
                    canvasDrawImage(canvasEl, imgEl);
                    //canvas入れる位置調整用span
                    const spanEl = document.createElement("span");
                    spanEl.setAttribute("data-file", upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                    //spanにcanvas追加
                    spanEl.append(canvasEl);
                    //imgの後にspan追加
                    imgEl.after(spanEl);
                    //imgタグ削除
                    imgEl.remove();
*/
                    //繰り返す
                    rep();
                } else {
                    //もう一覧閉じてたら一応空にしておく
                    imgEl.removeAttribute("src");
                }
            };
            //失敗したら
            const error = (upFileEl, mediaEl) => {
                //読込みスキップタイマー解除
                clearTimeout(waitTimer);
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    //エラーだったあぷファイルを除外するか
                    if(OMIT_ERROR_UPFILE) {
                        if(!upRepRetry) {
                            //リトライ
                            upRepRetry = true;
                            setTimeout(rep, 100);
                            return;
                        } else {
                            //リトライして駄目だったあぷファイル名を追加
                            upErrFiles.add(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                            // console.log(upFileList[0].href.match(/fu?\d{6,}\..+$/)[0]);
                            // console.log(upErrFiles);
                            upRepRetry = false;
                        }
                    }
                    // console.log(upFileList[0]);
                    //属性追加
                    upFileEl.setAttribute("data-404", upFileEl.href);
                    //属性削除
                    upFileEl.removeAttribute("href");
                    upFileEl.removeAttribute("data-list");
                    //アイコン変更
                    upFileEl.querySelector("span.upicon").innerHTML = `<br>${errorIcon}<br>`;
                    if(OMIT_ERROR_UPFILE) { //エラーだったあぷファイルを除外するか
                        upFileEl.querySelector("span.upicon").innerHTML += "<span>次回除外</span>";
                    } else {
                        upFileEl.querySelector("span.upicon").innerHTML += "<span>無いかも</span>";
                    }
                    //クラス削除
                    upFileEl.querySelector("span.upicon").classList.remove("upicon");
                    //繰り返す
                    rep();
                }
                //一応空にしておく
                if(mediaEl.tagNmae == "VIDEO") { //動画か
                    mediaEl.pause();
                    mediaEl.removeAttribute("src");
                    mediaEl.load();
                } else { //画像
                    mediaEl.removeAttribute("src");
                }
            }
            //読込みスキップ
            const skip = (upFileEl) => {
                //読込みスキップタイマー解除
                clearTimeout(waitTimer);
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    upRepRetry = false;
                    // console.log(upWaitedFiles);
                    //アイコン変更
                    upFileEl.querySelector("span.upicon").innerHTML = skipIcon;
                    //クラス削除
                    upFileEl.querySelector("span.upicon").classList.remove("upicon");
                    //属性変更
                    upFileEl.setAttribute("data-skip", "");
                    //繰り返す
                    rep();
                }
            };
            //読込み時間超過
            const waited = (upFileEl, mediaEl) => {
                if(document.querySelector(".futaba_lightbox_image_list_container") && upFileEl.querySelector("span.upicon")) {
                    upRepRetry = false;
                    //スキップしたあぷファイル名を追加
                    upWaitedFiles.add(upFileEl.href.match(/fu?\d{6,}\..+$/)[0]);
                    // console.log(upWaitedFiles);
                    //アイコン変更
                    upFileEl.querySelector("span.upicon").innerHTML = waitedIcon;
                    //クラス削除
                    upFileEl.querySelector("span.upicon").classList.remove("upicon");
                    //属性変更
                    upFileEl.setAttribute("data-list", "");
                    upFileEl.setAttribute("data-waited", "");
                    //繰り返す
                    rep();
                }
                //一応空にしておく
                if(mediaEl.tagNmae == "VIDEO") { //動画か
                    mediaEl.pause();
                    mediaEl.removeAttribute("src");
                    mediaEl.load();
                } else { //画像
                    mediaEl.removeAttribute("src");
                }
            };

            //差し替え
            const rep = () => {
                //アイコン表示のあぷファイル
                const upFileList = Array.from(document.querySelectorAll(".futaba_lightbox_image_list_container span.upicon"), el => el.parentElement);
                //console.log("残り: ", upFileList.length);
                //残ってたら先頭の1つを処理する
                if(upFileList.length) {

                    //console.log("読み込み中");
                    //動画か
                    if(/(mp4|webm)/.test(upFileList[0].href)) {
                        //リンク先の動画に差し替えるか
                        if(LOAD_UPFILE_VIDEO) {
                            //ページが非アクティブ(別タブ中)だと制限で失敗するからスキップする
                            if(document.visibilityState === "hidden") {
                                skip(upFileList[0]);
                                return;
                            }
                            if(!upRepRetry) { //リトライ中じゃなければ
                                //ローディングアイコンに変える
                                upFileList[0].querySelector("span.upicon").innerHTML = loadingIcon;
                            }
                            metaReady = false;

                            //canvas要素
                            const canvasEl = document.createElement("canvas");
                            //video要素
                            const videoEl = document.createElement("video");
                            videoEl.preload = "metadata"; //メタデータのみ読込みたい(様々な都合で駄目な時は駄目)
                            //メタデータが読込まれたら実行
                            videoEl.addEventListener("loadedmetadata", () => videoLoadedmetadata(videoEl), {once: true});
                            //再生位置部分のデータが集まったら実行
                            videoEl.addEventListener("loadeddata", () => videoLoadeddata(upFileList[0], videoEl, canvasEl), {once: true});
                            //読込み失敗！
                            videoEl.addEventListener("error", () => error(upFileList[0], videoEl), {once: true});
                            //動画のsrc設定してイベント発火
                            videoEl.src = upFileList[0].href;

                            //ファイル名がupWaitedFilesに残ってたら待ち時間半分にする
                            if(upWaitedFiles.has(upFileList[0].href.match(/fu?\d{6,}\..+$/)[0])) {
                                waitNthTime = LOAD_WAIT_TIME / 2;
                            } else {
                                waitNthTime = 0;
                            }
                            //読込みスキップタイマー
                            waitTimer = setTimeout(() => {
                                waited(upFileList[0], videoEl);
                            }, LOAD_WAIT_TIME - waitNthTime);
                        } else { //動画の代替アイコンに変えるだけ
                            //アイコン変更
                            upFileList[0].querySelector("span.upicon").innerHTML = playIcon;
                            //クラス削除
                            upFileList[0].querySelector("span.upicon").classList.remove("upicon");
                            //console.log("変えた！")
                            //繰り返す
                            rep();
                        }
                    } else { //動画じゃない
                        //ローディングアイコンに変える
                        upFileList[0].querySelector("span.upicon").innerHTML = loadingIcon;
                        //画像要素の用意
                        const imgEl = document.createElement("img");
                        imgEl.src = upFileList[0].href;
                        imgEl.setAttribute("align", "left");
                        //読込まれたら実行
                        imgEl.addEventListener("load", () => imgLoad(upFileList[0], imgEl), {once: true});
                        //読込み失敗！
                        imgEl.addEventListener("error", () => error(upFileList[0], imgEl), {once: true});

                        //ファイル名がupWaitedFilesに残ってたら待ち時間半分にする
                        if(upWaitedFiles.has(upFileList[0].href.match(/fu?\d{6,}\..+$/)[0])) {
                            waitNthTime = LOAD_WAIT_TIME / 2;
                        } else {
                            waitNthTime = 0;
                        }
                        //読込みスキップタイマー
                        waitTimer = setTimeout(() => {
                            waited(upFileList[0], imgEl);
                        }, LOAD_WAIT_TIME - waitNthTime);
                    }
                } else {
                    //読込みスキップタイマー解除
                    clearTimeout(waitTimer);
                    //差し替え中を解除
                    upReplacing = false;
                }
            };
            //差し替え実行
            rep();
        }
        //使うアイコン
        const playIcon = `<svg xmlns="http://www.w3.org/2000/svg" height="30%" width="30%" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="${darkMode ? "skyblue" : "#800000"}" d="M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM188.3 147.1c-7.6 4.2-12.3 12.3-12.3 20.9l0 176c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88c-7.4-4.5-16.7-4.7-24.3-.5z"/></svg>`;
        const loadingIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512" style="animation:rotate 0.4s steps(8) infinite;"><g><path fill="${darkMode ? "skyblue" : "#800000"}" d="M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/><path fill="${darkMode ? "#87ceeb" : "#800000"}6D" d="M304 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/><path fill="${darkMode ? "#87ceeb" : "#800000"}B6" d="M48 304a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"/><path fill="${darkMode ? "#87ceeb" : "#800000"}24" d="M512 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"/><path fill="${darkMode ? "#87ceeb" : "#800000"}91" d="M142.9 437A48 48 0 1 0 75 369.1 48 48 0 1 0 142.9 437z"/><path fill="${darkMode ? "#87ceeb" : "#800000"}DA" d="M142.9 142.8A48 48 0 1 0 75 75a48 48 0 1 0 67.9 67.9z"/><path fill="${darkMode ? "#87ceeb" : "#800000"}48" d="M369.1 437A48 48 0 1 0 437 369.1 48 48 0 1 0 369.1 437z"/></g></svg>`;
        const easelIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"height="30%" width="30%" viewBox="0 0 512 512"><g><path fill="${darkMode ? "skyblue" : "#800000"}" d="M436.304,329.338h-56l-0.46-9.016l-1.289-25.629l-31.871-19.116l1.515,30.092H131.036l10.922-216.9H337.27 l3.377,67.043c3.316,1.312,6.49,2.986,9.362,5.134l22.668,17.058l-6.053-120.111H262.771V0h-46.314v57.892H112.605L98.923,329.338 H33.071v46.314h76.285L66.789,512h48.47l42.56-136.349h58.639v105.488h46.314V375.651h58.639L363.969,512h48.47l-42.567-136.349 h76.285v-41.225c-2.246-0.859-4.44-1.84-6.512-3.083L436.304,329.338z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M306.19,169.493c1.108-13.659-5.239-26.881-16.576-34.509c-12.942-8.714-29.866-12.513-47.655-10.704 c-16.946,1.711-31.961,8.322-41.226,18.091l-1.983,2.111l2.571,1.342c0,0,2.54,1.44,7.372,6.302 c5.843,5.895,10.373,12.603,14.767,19.101c6.43,9.498,13.094,19.328,23.843,26.58c11.337,7.643,25.968,8.548,38.203,2.412 l0.505-0.272l20.142-29.896L306.19,169.493z M279.634,192.514c-8.805,3.755-19.139,2.79-27.054-2.547 c-3.649-2.458-6.762-5.292-9.581-8.383c-6.378-8.79-0.128-12,3.543-10.87c6.422,1.968,10.606,3.633,12.264,0.769 c2.759-4.749-3.912-7.922-6.634-11.088c-2.721-3.143-1.372-9.747,8.337-5.835c7.734,3.098,13.802-2.148,6.732-8.691 c-7.063-6.521-1.138-10.735,5.413-8.684c0.587,0.173,1.146,0.324,1.68,0.452c3.588,1.394,6.958,3.136,10.003,5.179 c7.907,5.329,12.695,14.548,12.521,24.114L279.634,192.514z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M306.04,224.174l19.878,11.94l28.734-42.696l-18.513-13.93c-4.093-3.06-9.264-4.326-14.315-3.482 c-5.036,0.859-9.52,3.738-12.377,7.975l-9.288,13.795c-2.857,4.236-3.836,9.467-2.736,14.458 C298.539,217.224,301.652,221.544,306.04,224.174z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M471.733,281.524l-110.501-83.145l-28.26,41.972l118.573,71.129c8.224,4.93,18.876,2.564,24.235-5.382 l0.068-0.106C481.209,298.047,479.407,287.283,471.733,281.524z"></path></g></svg>`;
        const errorIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="20%" width="20%" viewBox="0 0 512 512"><g><path d="M509.599,106.456c-2.406-12.453-6.641-24.625-12.672-36.109s-13.891-22.234-23.469-31.813c-12.75-12.781-27.672-22.484-43.531-28.906c-23.812-9.641-49.718-12.016-74.593-7.234C342.912,4.8,330.771,9.019,319.24,15.065c-11.469,6.016-22.25,13.859-31.844,23.469l-62.344,62.328c-12.563,12.578-12.563,32.953,0,45.516c12.594,12.578,32.984,12.578,45.547,0l62.328-62.328c6.625-6.625,14.141-11.453,22.219-14.766c12.078-4.906,25.453-6.141,38.141-3.703c6.375,1.266,12.578,3.406,18.375,6.453c5.844,3.047,11.297,7.063,16.281,12.016c6.625,6.625,11.484,14.125,14.766,22.172c4.891,12.109,6.141,25.484,3.672,38.172c-1.219,6.344-3.359,12.594-6.453,18.391c-3.031,5.859-7.016,11.297-11.984,16.266l-62.343,62.375c-12.547,12.547-12.547,32.922,0,45.5c12.578,12.563,32.938,12.563,45.516,0l62.343-62.359c12.797-12.75,22.469-27.656,28.922-43.531C512.021,157.222,514.396,131.315,509.599,106.456z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path><path d="M241.396,365.597l-62.359,62.344c-6.609,6.625-14.125,11.484-22.188,14.734c-12.078,4.922-25.453,6.172-38.141,3.703c-6.375-1.25-12.563-3.375-18.391-6.438c-5.828-3.078-11.313-7.031-16.281-12c-6.578-6.625-11.484-14.141-14.75-22.203c-4.906-12.078-6.172-25.453-3.656-38.172c1.219-6.328,3.359-12.531,6.406-18.359c3.094-5.828,7.063-11.297,12-16.281l62.375-62.344c12.547-12.547,12.547-32.938,0-45.516c-12.563-12.594-32.953-12.594-45.516,0l-62.391,62.328c-12.75,12.781-22.469,27.672-28.859,43.547c-9.656,23.813-12.047,49.734-7.25,74.609c2.422,12.391,6.625,24.547,12.672,36.047c6.031,11.5,13.859,22.281,23.438,31.859c12.813,12.75,27.703,22.469,43.547,28.891c23.828,9.641,49.734,12.063,74.594,7.25c12.422-2.438,24.641-6.641,36.078-12.656c11.516-6.063,22.297-13.891,31.844-23.484l62.359-62.344c12.578-12.563,12.578-32.984,0-45.516C274.365,353.019,253.958,353.019,241.396,365.597z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path><path d="M354.912,157.097c-12.578-12.578-32.953-12.578-45.531,0l-51.375,51.344l3.297,19.094l32.672,5.938l5.313,24.75l55.625-55.641C367.458,190.019,367.458,169.644,354.912,157.097z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path><path d="M157.099,354.925c12.578,12.531,32.938,12.531,45.5,0l61.547-61.531l-5.313-24.797l-32.672-5.938l-3.266-19.094l-65.797,65.828C144.521,321.925,144.521,342.331,157.099,354.925z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path><polygon points="190.833,108.003 181.068,37.331 148.146,45.175 171.427,112.644" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></polygon><polygon points="123.927,160.925 61.568,126.222 48.083,157.284 115.943,179.206" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></polygon><polygon points="318.271,397.69 328.037,468.331 360.958,460.487 337.677,393.05" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></polygon><polygon points="385.208,344.737 447.536,379.425 461.036,348.409 393.162,326.425" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></polygon></g></svg>`;
        const skipIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" viewBox="0 0 512 512"><g><path d="M434.115,239.04l-33.036-46.148c-8.024-10.894-18.451-19.779-30.478-25.988l-67.478-35.418c-15.591-6.356-26.846-11.578-43.15-12.33l-18.842-0.537c-11.675-0.196-23.536,3.475-31.689,11.841l-64.217,57.638l-55.627,15.258c-10.534,2.9-16.957,13.531-14.624,24.201l0.196,0.821c2.294,10.494,12.3,17.435,22.942,15.922l44.81-6.394c11.178-1.591,21.966-5.223,31.826-10.709l27.081-18.275l1.386,89.883c-0.274,7.234-0.43,12.173-3.466,17.455l-91.835,159.518c-6.561,11.374-2.685,25.9,8.649,32.51l0.791,0.459c10.729,6.257,24.455,3.241,31.562-6.932l104.908-148.37l40.182,87.94c3.105,4.09,6.863,7.634,11.129,10.485l80.189,53.704c10.094,6.765,23.722,4.617,31.259-4.93l0.899-1.152c3.856-4.892,5.584-11.12,4.822-17.31c-0.772-6.179-3.983-11.793-8.923-15.59l-69.158-53.138l-40.045-113.166l3.573-101.441l48.012,14.418l50.492,49.574c6.346,6.238,16.304,6.932,23.45,1.63l0.489-0.361C438.117,258.233,439.875,247.074,434.115,239.04z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path><path d="M239.735,99.221c27.227,4.169,52.688-14.536,56.867-41.773c4.158-27.237-14.546-52.698-41.784-56.867c-27.237-4.168-52.698,14.536-56.857,41.774C193.783,69.593,212.497,95.053,239.735,99.221z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path></g></svg><svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" viewBox="0 0 512 512"><g><path d="M462.543,329.338h-65.852l-0.46-9.016L383.009,57.892H279.157V0h-46.314v57.892H128.991L115.31,329.338H49.457v46.314h76.285L83.175,512h48.47l42.559-136.349h58.639v105.488h46.314V375.651h58.638L380.356,512h48.47l-42.568-136.349h76.285V329.338z M147.422,305.668l10.923-216.9h195.311l10.93,216.9H147.422z" style="fill:${darkMode ? "skyblue" : "rgb(128,0,0)"};"></path></g></svg>`;
        const waitedIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="30%" width="30%" viewBox="0 0 512 512"><g><path d="M329.364,237.908l42.558-39.905c25.236-23.661,39.552-56.701,39.552-91.292V49.156c0.009-13.514-5.53-25.918-14.402-34.754C388.235,5.529,375.833-0.009,362.318,0H149.681c-13.514-0.009-25.926,5.529-34.763,14.401c-8.871,8.837-14.41,21.24-14.392,34.754v57.554c0,34.591,14.315,67.632,39.552,91.292l42.55,39.888c2.342,2.205,3.678,5.271,3.678,8.492v19.234c0,3.221-1.336,6.279-3.669,8.476l-42.558,39.905c-25.237,23.652-39.552,56.701-39.552,91.292v57.554c-0.018,13.515,5.522,25.918,14.392,34.755c8.838,8.871,21.249,14.41,34.763,14.401h212.636c13.515,0.009,25.918-5.53,34.755-14.401c8.871-8.838,14.41-21.24,14.402-34.755V405.29c0-34.591-14.316-67.64-39.552-91.292l-42.55-39.897c-2.352-2.205-3.678-5.263-3.678-8.484v-19.234C325.694,243.162,327.021,240.096,329.364,237.908z M373.946,462.844c-0.009,3.273-1.274,6.056-3.411,8.218c-2.162,2.136-4.944,3.402-8.218,3.41H149.681c-3.273-0.009-6.064-1.274-8.226-3.41c-2.136-2.162-3.393-4.945-3.402-8.218V405.29c0-24.212,10.026-47.356,27.691-63.91l42.55-39.906c9.914-9.285,15.539-22.273,15.539-35.857v-19.234c0-13.592-5.625-26.58-15.547-35.866l-42.542-39.896c-17.666-16.554-27.691-39.69-27.691-63.91V49.156c0.009-3.273,1.266-6.055,3.402-8.226c2.162-2.127,4.953-3.394,8.226-3.402h212.636c3.273,0.008,6.056,1.274,8.218,3.402c2.136,2.171,3.402,4.952,3.411,8.226v57.554c0,24.22-10.026,47.356-27.692,63.91l-42.55,39.896c-9.914,9.286-15.538,22.274-15.538,35.866v19.234c0,13.584,5.625,26.572,15.547,35.874l42.541,39.88c17.666,16.563,27.692,39.707,27.692,63.919V462.844z" style="fill: ${darkMode ? "skyblue" : "rgb(128, 0, 0)"};"></path><path d="M237.261,378.95l-77.33,77.33h192.128l-77.33-77.33C264.385,368.614,247.615,368.614,237.261,378.95z" style="fill: ${darkMode ? "skyblue" : "rgb(128, 0, 0)"};"></path></g></svg>
`;

        //画像一覧にボタン追加
        function makeButton() {
            //まだdiv.addが無ければ各aタグの直後にボタンの基準位置用に追加
            for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a")) {
                if(el.nextElementSibling?.className !== "add") {
                    const divEl = document.createElement("div");
                    divEl.classList.add("add");
                    divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                    el.after(divEl);
                }
            }

            if(USE_DLBTN) { //画像一覧に画像を保存するボタン追加
                for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > div.add")) {
                    if(!el.querySelector("div.DLB")) {
                        const divEl = document.createElement("div");
                        divEl.classList.add("DLB");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.setAttribute("title", "ダウンロード");
                        divEl.textContent = "保存";
                        divEl.addEventListener("click", dlbClick);
                        el.appendChild(divEl);
                    }
                }
            }
            if(USE_JUMPBTN) { //画像一覧の画像にレスに飛ぶボタン追加
                for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > div.add")) {
                    if(!el.querySelector("div.tores")) {
                        const divEl = document.createElement("div");
                        divEl.classList.add("tores");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.setAttribute("title", "レスに飛ぶ");
                        divEl.textContent = smallList ? "飛ぶ" : "戻る";
                        divEl.addEventListener("click", toresClick);
                        el.appendChild(divEl);
                    }
                }
            }
            if(USE_EXCLBTN) { //画像一覧の画像に除外ボタン追加
                for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > div.add")) {
                    if(!el.querySelector("div.excl")) {
                        const divEl = document.createElement("div");
                        divEl.classList.add("excl");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.setAttribute("title", "一覧から除外");
                        divEl.innerHTML = exclIcon;
                        divEl.addEventListener("click", exclClick);
                        el.appendChild(divEl);

                        //レスポップアップちらつき対策用
                        const spanEl = document.createElement("span");
                        divEl.append(spanEl);
                    }
                }
            }

            //一覧に追加したボタンをマウスオーバーで表示させる
            if(!openList) { //一覧を開く毎に1回だけ実行
                const container = document.querySelector(".futaba_lightbox_image_list_container");
                //継ぎ足し項目でも動くようにイベント設定
                //枠内に入ったらボタンを半透明で表示
                container.addEventListener("mouseover", event => {
                    if(event.target.closest("a, .excl, .tores, .DLB, .kieta")) {
                        //まず表示されてるボタン隠す
                        for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                            el.style.opacity = "";
                            event.target.style.background = "";
                        }
                    }
                    if(event.target.closest("a")) {
                        for(const el of event.target.closest("a").nextElementSibling.querySelectorAll(".excl, .tores, .DLB")) {
                            if(el.classList.contains("excl")) {
                                el.style.opacity = 1;
                            } else {
                                el.style.opacity = 0.5;
                                event.target.style.background = "";
                            }
                        }
                    }
                    if(event.target.closest(".kieta, .iddeta")) {
                        for(const el of event.target.closest(".kieta, .iddeta").parentElement.querySelectorAll(".excl, .tores, .DLB")) {
                            if(el.classList.contains("excl")) {
                                el.style.opacity = 1;
                            } else {
                                el.style.opacity = 0.5;
                                event.target.style.background = "";
                            }
                        }
                    }
                });
                //離れたらボタン非表示
                container.addEventListener("mouseout", event => {
                    for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                        if(event.target.closest(".excl")) {
                            //アイコンの切替
                            event.target.closest(".excl").children[0].style.display = "";
                            event.target.closest(".excl").children[1].style.display = "";
                        }
                        el.style.opacity = "";
                        event.target.style.background = "";
                    }
                });
                if(USE_DLBTN) {
                    //DLボタンにマウス乗せたら
                    container.addEventListener("mouseover", event => {
                        if(event.target.closest(".DLB")) {
                            //まず表示されてるボタン隠す
                            for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                                el.style.opacity = "";
                                event.target.style.background = "";
                            }
                            event.target.style.opacity = 1;
                            event.target.style.background = "linear-gradient(#FFF, #DFF)";
                            if(USE_JUMPBTN) { //戻るボタンの半透明維持
                                event.target.closest(".add").querySelector(".tores").style.opacity = 0.5;
                            }
                            if(USE_EXCLBTN) { //除外ボタンの表示維持
                                event.target.closest(".add").querySelector(".excl").style.opacity = 1;
                            }
                        }
                    });
                }
                if(USE_JUMPBTN) {
                    //戻るボタンにマウス乗せたら
                    container.addEventListener("mouseover", event => {
                        if(event.target.closest(".tores")) {
                            //まず表示されてるボタン隠す
                            for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                                el.style.opacity = "";
                                event.target.style.background = "";
                            }
                            event.target.style.opacity = 1;
                            event.target.style.background = "linear-gradient(#FFF, #DFF)";
                            if(USE_DLBTN) { //DLボタンの半透明維持
                                event.target.closest(".add").querySelector(".DLB").style.opacity = 0.5;
                            }
                            if(USE_EXCLBTN) { //除外ボタンの表示維持
                                event.target.closest(".add").querySelector(".excl").style.opacity = 1;
                            }
                        }
                    });
                }
                if(USE_EXCLBTN) {
                    //除外ボタンにマウス乗せたら
                    container.addEventListener("mouseover", event => {
                        if(event.target.closest(".excl")) {
                            //まず表示されてるボタン隠す
                            for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                                el.style.opacity = "";
                                event.target.style.background = "";
                            }
                            //アイコンの切替
                            event.target.closest(".excl").children[1].style.display = "block";
                            event.target.closest(".excl").children[0].style.display = "none";
                            event.target.closest(".excl").style.opacity = 1;
                            if(USE_JUMPBTN) { //戻るボタンの半透明維持
                                event.target.closest(".add").querySelector(".tores").style.opacity = 0.5;
                            }
                            if(USE_DLBTN) { //DLボタンの半透明維持
                                event.target.closest(".add").querySelector(".DLB").style.opacity = 0.5;
                            }
                        }
                    });
                }
            }
        }
        //使うアイコン
        const exclIcon = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="100%" width="100%" viewBox="0 0 512 512"><g><path d="M94.296,463.359C95.853,490.118,119.045,512,145.837,512h60.43c26.792,0,70.646,0,97.439,0h60.431c26.792,0,49.992-21.882,51.55-48.641l17.746-306.165H76.542L94.296,463.359z" style="fill: ${darkMode ? "#0040A0" : "rgb(128, 0, 0)"};"></path><path class="st0" d="M433.696,80.591c-5.446-2.34-52.875-19.6-124.124-26.059c0.009-0.322,0.026-0.634,0.026-0.948C309.589,23.983,285.597,0,256.004,0c-29.602,0-53.592,23.983-53.6,53.584c0,0.313,0.017,0.626,0.024,0.948C131.18,60.991,83.734,78.251,78.297,80.591c-9.491,4.07-10.851,9.491-10.851,17.63c0,5.43,0,35.278,0,35.278h377.108c0,0,0-29.849,0-35.278C444.554,90.082,443.195,84.661,433.696,80.591z M255.996,52.102c-7.909,0-15.612,0.173-23.142,0.47c0.56-12.326,10.685-22.154,23.15-22.17c12.457,0.016,22.583,9.844,23.143,22.17C271.616,52.274,263.913,52.102,255.996,52.102z" style="fill: ${darkMode ? "#0040A0" : "rgb(128, 0, 0)"};"></path></g></svg>
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="100%" width="102%" viewBox="0 0 512 512"><g><path d="M99.381,465.993c1.472,25.31,23.409,46.007,48.75,46.007h57.158c25.342,0,66.821,0,92.162,0h57.158c25.342,0,47.285-20.697,48.758-46.007l16.785-289.586H82.589L99.381,465.993z" style="fill: ${darkMode ? "skyblue" : "red"};"></path><path class="st0" d="M427.011,107.022c-4.653-3.132-45.696-27.507-110.772-46.03c0.062-0.304,0.125-0.585,0.188-0.881c5.189-27.507-12.897-54.017-40.396-59.222c-27.516-5.19-54.026,12.88-59.231,40.396c-0.054,0.28-0.094,0.576-0.14,0.88c-67.351-6.506-114.487,1.192-119.95,2.408c-9.53,2.119-11.751,6.92-13.177,14.478c-0.958,5.05-6.202,32.791-6.202,32.791l350.484,66.252c0,0,5.245-27.741,6.204-32.79C435.441,117.745,435.129,112.47,427.011,107.022z M288.303,53.816c-6.951-1.59-14.08-3.102-21.437-4.489c-7.348-1.403-14.54-2.587-21.593-3.631c2.688-11.361,13.832-18.718,25.411-16.543C282.264,31.357,289.947,42.267,288.303,53.816z" style="fill: ${darkMode ? "skyblue" : "red"};"></path></g></svg>
`;

        function download(url) {
            //console.log(url)
            const matches = url.match(/(?<=\/)(f|fu)?[0-9]+\..+$/);
            //console.log(matches)

            //フォルダ
            folder = folder ? folder+"\\" : "";

            GM_download(url, folder + matches[0]);
        }

        //一覧で動画にマークを付ける
        function videoMarking() {
            //まだマークがない動画レス(属性data-extはあるけどdiv.vmarkがない要素)
            const container = document.querySelector(".futaba_lightbox_image_list_container");
            let list = [...container.querySelectorAll("a[data-ext]")].filter(a => !a.nextElementSibling?.querySelector("div.add > div.vmark"));

            if(list.length) {
                for(const el of list) {
                    // console.log(el.dataset.ext)
                    //aimgは動画だけ
                    if(/(mp4|webm)/.test(el.dataset.ext)) {
                        //設定で一覧にボタンを何も足してなかったら基準位置のタグを追加
                        if(!USE_DLBTN && !USE_JUMPBTN && !USE_EXCLBTN) {
                            const divEl = document.createElement("div");
                            divEl.classList.add("add");
                            divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                            el.after(divEl);
                        }

                        //拡張子別にマーク付与
                        const divEl = document.createElement("div");
                        divEl.classList.add("vmark");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.style.alignContent = "center";
                        if(el.dataset.ext.includes("mp4")) divEl.textContent = "MP4";
                        if(el.dataset.ext.includes("webm")) divEl.textContent = "WebM";
                        // if(el.dataset.ext.includes("gif")) divEl.textContent = "GIF";
                        divEl.addEventListener("click", vMarkClick);
                        el.nextElementSibling.appendChild(divEl);
                    }
                }
            }

            //あぷファイルの代用アイコンをリンク先に差し替えた動画にマークを付ける
            if(LOAD_UPFILE_LIST && LOAD_UPFILE_VIDEO && MARK_VIDEO_UPFILE) {
                let list = [...container.querySelectorAll("a")].filter(a => /fu?\d{6,}\.(mp4|webm)$/.test(a.href)).filter(a => !a.nextElementSibling?.querySelector("div.add > div.vmark"));

                if(list.length) {
                    for(const el of list) {
                        //設定で一覧にボタンを何も足してなかったら基準位置のタグを追加
                        if(!USE_DLBTN && !USE_JUMPBTN && !USE_EXCLBTN) {
                            const divEl = document.createElement("div");
                            divEl.classList.add("add");
                            divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                            el.after(divEl);
                        }
                        //マーク
                        const divEl = document.createElement("div");
                        divEl.classList.add("vmark", "up");
                        smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                        divEl.style.alignContent = "center";
                        divEl.title = "右クリでサムネの再描写";
                        if(el.href.includes("mp4")) divEl.textContent = "MP4";
                        if(el.href.includes("webm")) divEl.textContent = "WEBM";
                        divEl.addEventListener("click", vMarkClick);
                        divEl.addEventListener("contextmenu", redrawThumb); //右クリックでサムネを再描写する
                        el.nextElementSibling.appendChild(divEl);
                    }
                }
            }
            if(USE_JUMPBTN || USE_DLBTN || USE_EXCLBTN) {
                //マークにマウス乗せたら
                container.addEventListener("mouseover", event => {
                    if(event.target.closest(".vmark")) {
                        //まず表示されてるボタン隠す
                        for(const el of [...container.querySelectorAll(".excl, .tores, .DLB")].filter(el => el.style.opacity != 0)) {
                            el.style.opacity = "";
                            event.target.style.background = "";
                        }
                        if(USE_JUMPBTN) { //戻るボタンの半透明維持
                            event.target.closest(".add").querySelector(".tores").style.opacity = 0.5;
                        }
                        if(USE_DLBTN) { //DLボタンの半透明維持
                            event.target.closest(".add").querySelector(".DLB").style.opacity = 0.5;
                        }
                        if(USE_EXCLBTN) { //除外ボタンの表示維持
                            event.target.closest(".add").querySelector(".excl").style.opacity = 1;
                        }
                    }
                });
            }
        }

        //非IDスレでIDが付いたレスの画像を加工
        function decoIDRes() {
            for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a[data-id]")) {
                if(el.style.filter) continue;
                //枠にフィルターをかける
                el.style.filter = "blur(5px) opacity(0.3) grayscale(1)";
                //属性変更
                el.setAttribute("data-list", "");

                //後ろに追加ボタン用のタグが無かったら作る
                if(el.nextElementSibling?.className !== "add") {
                    const divEl = document.createElement("div");
                    divEl.classList.add("add");
                    divEl.setAttribute("data-no", el.dataset.no); //aタグとセットで使う用にレス番付ける
                    el.after(divEl);
                }
                //IDマーク
                const divEl = document.createElement("div");
                divEl.classList.add("iddeta");
                smallList ? divEl.classList.add("small") : divEl.classList.add("normal");
                divEl.textContent = "ID";
                divEl.style.cursor= "pointer";
                divEl.addEventListener("click", vMarkClick); //動画マークのクリックイベントを流用
                //マークを挿入
                el.nextElementSibling.append(divEl);
                //追加ボタン用タグに属性付与
                divEl.parentElement.setAttribute("data-id", "");
                //動画マークがあったらフィルターをかける
                if(el.nextElementSibling.querySelector(".vmark")) el.nextElementSibling.querySelector(".vmark").style.filter = "blur(1px) opacity(0.3) grayscale(1)";
            }
        }

        //追加した画像一覧のレスを幅に合わせて省略
        function omitRes() {
            //今一覧にある画像のレス
            const imageListRes = document.querySelectorAll(".futaba_lightbox_image_list_container > a > span.res");
            if(imageListRes.length) {
                //内容だけ
                const innerRes = Array.from(imageListRes, el => {
                    //設定で追加したあぷファイル名はそのまま
                    if(/^あぷ小?<(font|br)/.test(el.innerHTML)) return el.innerHTML;
                    //設定で追加したあぷ用アイコンはそのまま
                    if(/^<svg/.test(el.innerHTML)) return el.innerHTML;
                    //レス枠付けた時の仮レスは元レスをコピーしておいた親タグのデータ属性で置換
                    return el.parentElement.cloneNode(true).dataset.res;
                });

                //略す前の置換
                for(let [i, html] of innerRes.entries()) {
                    // console.log("%d %s", i, html);
                    //ｷﾀｰは飛ばす
                    if(/^ｷﾀ━━━/.test(html)) continue;
                    //一覧に追加されたあぷは飛ばす
                    if(/^あぷ小?<(font|br)/.test(html)) continue;
                    //一覧に追加されたあぷ用アイコンは飛ばす
                    if(/^<svg/.test(html)) continue;
                    //ライトモードなら一覧での引用レスのコントラストを下げる
                    if(!darkMode) html = String(html).replace(/#789922/g, "#6e8c21");
                    //画像一覧にレスを表示する
                    html = String(html)//置換
                        // .replace(/#789922/g, "#6e8c21") //一覧での引用レスのコントラストを下げる
                        .replace(/<a.+?>(.+?)<\/a>(<br>)*/g, `<font style='color:${darkMode ? "#7EB8DA" : "#33E"}'>略 </font>`) //リンク
                        .replace(/gt;<a.+?>(.+?)<\/a><\/font><br>(<font.+?>(&gt;)+)?/g, `gt;<font style='color:${darkMode ? "#7EB8DA" : "#33E"}'>略 </font>`) //引用リンク
                        // .replace(/\[<font color=\"#ff0000\">.+?<\/font>\]<br>/, '<font color="#F00">IP </font>') //ナッパ
                        .replaceAll("&apos;", "'") //タグ壊れ予防してたのを戻す
                        .replaceAll("&quot;", '"')
                        .replaceAll("&colon;", ":")
                        .replace(/<br>.*/, ""); //2行目以降
                    if(html == "" || /^\s+$/.test(html)) html = "[空レス]";
                    innerRes[i] = html;
                    // console.log("%d %s", i, html);
                }

                const bWidth = parseFloat(window.getComputedStyle(imageListRes[0]).width);
                const bFontSize = parseFloat(window.getComputedStyle(imageListRes[0]).fontSize);
                //収める文字数
                const bFontNum = Math.trunc(bWidth / bFontSize) -1;
                //レスの装飾で省略文字数を変える
                const bFontNumR = new RegExp(`(` +
                                             `^(?!<font).{${bFontNum}}` + //普通の省略
                                             `|^<font.+?>略\\s</font>.{${(bFontNum - 2)}}` + //リンク有りの省略
                                             `|^<font.+?>(&gt;)+<font.+?>略\\s</font>.{${(bFontNum - 2)}}` + //引用リンク有りの省略
                                             `|^<font.+?>(&gt;)+(https?://)?((?<!<font).){${(bFontNum - 2)}}(?=.*</font>)` + //引用有りの省略
                                             `|^<font.+?>IP\\s</font>.{${(bFontNum - 2)}}` + //ナッパ
                                             `).*`, "");
                //ｷﾀ━は幅最大に伸ばす
                const ktNum = Math.ceil(((bWidth / bFontSize) - 5) / 2); //左右の━数
                let ktReplace = "";
                for(let i = 0; i < ktNum; i++) ktReplace += "━";
                ktReplace += "(ﾟ∀ﾟ)";
                for(let i = 0; i<ktNum; i++) ktReplace += "━";

                //省略して一覧のレスに
                for(let [i, html] of innerRes.entries()) {
                    if(/^ｷﾀ━━━/.test(html)) {
                        html = ktReplace;
                    } else if(!/^(>No\.\d+|あぷ小?<(font|br)|<svg)/.test(html.replace(/\n/g, ""))) { //レス番引用、あぷは適用外
                        //省略したら...を末に付ける
                        html = html.replace(bFontNumR, "$1<font style='letter-spacing: -0.1em;font-weight: 400;'>...");
                    }
                    if(/^あぷ小?<(font|br)/.test(html.replace(/\n/g, ""))) {
                        //ファイル名が収まらなくなったら略す
                        if(bFontNum < 12) html = html.replace(/(あぷ小?)(<br>)*/, "$1<br><br>");
                        //ファイル名が収まるなら戻す
                        if(bFontNum >= 12) html = html.replace(/(あぷ小?)<br><br>/, "$1");
                    }
                    if(/^<svg/.test(html.replace(/\n/g, ""))) {
                        //ファイル名が収まらなくなったら略す
                        if(bFontNum < 10) html = html.replace(/^(<svg[^>]+width="1rem".+?\/svg>)/, `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="0.9rem" width="0.9rem" viewBox="0 0 512 512"><g><path fill="${darkMode ? "skyblue" : "#800000"}" d="M509.445,113.129c-2.547-13.219-7.047-26.141-13.453-38.359c-6.391-12.203-14.75-23.641-24.938-33.828 c-13.563-13.578-29.406-23.875-46.265-30.719c-25.297-10.219-52.828-12.781-79.266-7.656c-13.219,2.563-26.156,7-38.359,13.422 c-12.172,6.422-23.641,14.75-33.828,24.953l-66.25,66.25c-13.375,13.344-13.375,35.047,0,48.391s35.031,13.344,48.391,0 l66.25-66.281c7.031-7,15.016-12.172,23.594-15.672c12.844-5.203,27.031-6.531,40.547-3.906c6.75,1.313,13.328,3.594,19.531,6.844 c6.188,3.25,12,7.469,17.281,12.734c7.031,7.078,12.187,15.047,15.687,23.609c5.203,12.844,6.531,27.047,3.906,40.547 c-1.313,6.766-3.594,13.344-6.828,19.516c-3.281,6.219-7.484,12.031-12.765,17.313l-66.25,66.234 c-13.359,13.359-13.359,35.047,0,48.391s35.016,13.344,48.375,0l66.25-66.265c13.594-13.563,23.875-29.406,30.703-46.266 C512.008,167.083,514.555,139.551,509.445,113.129z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M256.54,356.426l-66.266,66.266c-7.047,7.016-15.031,12.188-23.594,15.672 c-12.844,5.219-27.047,6.547-40.547,3.938c-6.766-1.328-13.328-3.625-19.531-6.859c-6.188-3.266-12-7.5-17.281-12.75 c-7.031-7.063-12.203-15.031-15.688-23.609c-5.203-12.828-6.531-27.031-3.922-40.563c1.313-6.75,3.609-13.328,6.844-19.516 c3.281-6.188,7.484-12,12.766-17.297l66.266-66.25c13.344-13.344,13.344-35.016,0-48.359c-13.375-13.359-35.031-13.359-48.391,0 l-66.25,66.234c-13.594,13.594-23.875,29.406-30.719,46.297c-10.234,25.266-12.781,52.844-7.672,79.219 c2.547,13.219,7.031,26.156,13.453,38.359c6.406,12.203,14.75,23.672,24.938,33.844c13.594,13.578,29.406,23.891,46.266,30.688 c25.281,10.266,52.844,12.813,79.25,7.703c13.234-2.563,26.156-7.047,38.344-13.453c12.203-6.391,23.672-14.75,33.859-24.938 l66.25-66.266c13.344-13.344,13.344-35.016,0-48.359C291.54,343.066,269.883,343.066,256.54,356.426z"></path><path fill="${darkMode ? "skyblue" : "#800000"}" d="M342.43,169.567c-13.344-13.344-35.016-13.344-48.375,0l-124.516,124.5c-13.344,13.359-13.344,35.016,0,48.359 c13.375,13.375,35.047,13.375,48.391,0l124.5-124.5C355.805,204.567,355.805,182.926,342.43,169.567z"></path></g></svg><br><br>$1`);
                        //ファイル名が収まるなら戻す
                        if(bFontNum >= 10) html = html.replace(/^(<svg.+?\/svg><br><br>)+/, "");
                    }
                    imageListRes[i].innerHTML = html;
                }
            }
        }

        //一覧の画像を数えたい
        function ichiranImageCount(mode = "") {
            const imgs = [...document.querySelectorAll(".thre a[data-list='thread']")];
            //画像数
            const numImg = imgs.length;
            // let isoImg = 0;
            let threBq;
            let threUp = 0;
            // let resUpIso = 0;
            // let resUpDel = 0;
            let resDec = false;
            let upIgnore = 0;
            let threUpErr = 0;
            // let resUpErrIso = 0;
            // let resUpErrDel = 0;
            let excluded = 0;
            let upExcluded = 0;

            if(USE_EXCLBTN && exclFiles.size) { //手動で除外したファイルがあるか
                for(const el of imgs) {
                    if(exclFiles.has(el.pathname)) { //除外したファイルか
                        excluded ++;
                    }
                }
            }

            //一覧にあぷファイル名を含める設定か
            if(ADD_UPFILE_LIST) {
                threBq = [...document.querySelectorAll(".thre blockquote")].map(el => el.cloneNode(true));
                if(threBq.length) {
                    for(const el of threBq) {
                        //動画をインライン再生中にレスを複製すると同時に再生されるから複製した方は止める
                        if(el.querySelector("video")) {
                            for(const videoEl of el.querySelectorAll("video")) {
                                //動画を止めて空にしてリセット
                                videoEl.pause();
                                videoEl.removeAttribute("src");
                                videoEl.load();
                            }
                        }
                        //レス内の引用されてないあぷファイル
                        const files = el.innerHTML.match(/(?<!&gt;(.(?!<br>))*)fu?\d{6,}\.(bmp|jpg|jpeg|gif|png|webp|webm|mp4)(?!['"])/g) || [];
                        //レス内の引用されてないあぷファイル数
                        const filesNum = files.length;
                        //羅列荒らしか
                        if(filesNum >= UP_IGNORE_NUM) {
                            upIgnore ++;
                            continue;
                        }
                        threUp += filesNum;

                        //レス内のエラーあぷファイル数
                        let errFilesNum = 0;
                        if(OMIT_ERROR_UPFILE && mode != "数え直し") {
                            for(const file of files) {
                                if(upErrFiles.has(file)) {
                                    threUpErr ++;
                                    errFilesNum ++;
                                }
                            }
                        }

                        //手動で除外したあぷファイル数
                        if(USE_EXCLBTN && exclUpFiles.size) {
                            for(const file of files) {
                                if(exclUpFiles.has(file)) {
                                    upExcluded ++;
                                }
                            }
                        }
                    }
                }
            }
            if(mode == "数え直し") {
                //数え直した場合に出す
                console.log("数え直し\n画像数\t%d\nあぷ\t%d\n"
                            , numImg, threUp);
                // console.log("荒らし判定 %dレス", upIgnore);
            }
            // console.log("エラーあぷ %d\nエラーDelあぷ %d\nエラー隔離あぷ %d\n", threUpErr, resUpErrDel, resUpErrIso);

            //画像数合計
            let imgCount;
            let upCount;
            imgCount = numImg - excluded;
            upCount = threUp - upExcluded;
            if(OMIT_ERROR_UPFILE) { //エラーだったあぷファイルを除外するか
                upCount -= threUpErr;
            }

            //一覧ボタンに表示
            if(document.querySelector(".ichiran")) {
                if(mode == "数え直し") {
                    //文字を徐々に出す
                    let fontFade = 0;
                    const fadeIn = setInterval(() => {
                        fontFade += 1;
                        if (fontFade >= 16) {
                            fontFade = 16;
                            clearInterval(fadeIn);
                            if(mode == "数え直し") {
                                document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"}`).style.color = "#000" + fontFade.toString(16);
                            } else {
                                document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"} > span`).style.color = "#000" + fontFade.toString(16);
                            }
                        }
                        if(mode == "数え直し") {
                            document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"}`).style.color = "#000" + fontFade.toString(16);
                        } else {
                            document.querySelector(`${SHOW_KOKOBTN ? ".ichiranopn" : ".ichiran"} > span`).style.color = "#000" + fontFade.toString(16);
                        }
                    }, 50);
                }
                if(SHOW_KOKOBTN) {
                    if(ADD_UPFILE_LIST) {
                        document.querySelector(".ichiranopn").innerHTML = `画像一覧(<span>${imgCount}${upCount ? `+${upCount}` : ""}</span>)`;
                    } else {
                        document.querySelector(".ichiranopn").innerHTML = `画像一覧(<span>${imgCount}</span>)`;
                    }

                    //いまココボタンを出すのに必要な画像数(一覧でスクロール要る数)
                    //一覧の表示範囲/枠の高さ*1行の画像の数
                    const normalNum = Math.trunc(window.innerHeight * (listHeight / 100) / aHeight) * IMAGE_NUM;
                    //小さい一覧の配置と表示範囲はCSSの値変えてない前提
                    //containerの高さ=overlayの高さ90%=(ウィンドウの高さ-(margin-top分+padding-top分+margin-bottom分))*0.9
                    const smallNum = Math.trunc((window.innerHeight - (30 + parseFloat(getComputedStyle(document.documentElement).fontSize) + 9 + (window.innerHeight * 0.1))) * 0.9 / aHeightS) * IMAGE_NUM_S;
                    if(normalNum <= smallNum) {
                        needImg = normalNum;
                    } else {
                        needImg = smallNum;
                    }
                    //画像数が足りない時はいまココボタンを非表示
                    if(ADD_UPFILE_LIST) { //あぷファイルを追加するか
                        if(needImg >= (imgCount + upCount)) { //あぷファイルも含めて判定
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 90 : 70}px`;
                            document.querySelector(".ichirankoko").style.display = "none";
                        } else {
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 140 : 100}px`;
                            document.querySelector(".ichirankoko").style.display = "block";
                        }
                    } else {
                        if(needImg >= imgCount) { //画像数だけで判定
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 90 : 70}px`;
                            document.querySelector(".ichirankoko").style.display = "none";
                        } else {
                            document.querySelector(".ichiran").style.width = `${SHOW_IMAGE_COUNT ? 140 : 100}px`;
                            document.querySelector(".ichirankoko").style.display = "block";
                        }
                    }
                } else {
                    if(ADD_UPFILE_LIST) {
                        if(document.querySelector(".ichiran")) document.querySelector(".ichiran").innerHTML = `画像一覧(<span>${imgCount}${upCount ? `+${upCount}` : ""}</span>)`;
                    } else {
                        if(document.querySelector(".ichiran")) document.querySelector(".ichiran").innerHTML = `画像一覧(<span>${imgCount}</span>)`;
                    }
                }
            }
        }

        //画像のページ位置を属性付け
        function ichiranCheckPoint() {
            let sure;
            let res;
            let list;

            if(ADD_UPFILE_LIST && SORT_UPFILE_LIST) {
                //削除されてないそれぞれの画像にあぷファイルも含める
                sure = Array.from(document.querySelectorAll(".thre > div > a > img, .thre div[data-upf] > blockquote"), el => {
                    if(el.tagName == "IMG") return el.parentElement; //画像なら親のaにする
                    if(el.tagName == "A") return el.parentElement.parentElement.querySelector(`a[href="${el.pathname}"]`); //動画ならリンクになってるaにする
                    return el;
                });
                res = Array.from(document.querySelectorAll(".thre table a > img, .thre table video > a, .thre table[data-upf] blockquote"), el => {
                    if(el.tagName == "IMG") return el.parentElement; //画像なら親のaにする
                    if(el.tagName == "A") return el.parentElement.parentElement.querySelector(`a[href="${el.pathname}"]`); //動画ならリンクになってるaにする
                    return el;
                });
            } else {
                //それぞれの画像
                sure = [document.querySelector(".thre > div > a > img").parentElement];
                res = Array.from(document.querySelectorAll(".thre table a > img"), el => el.parentElement);
            }
            //まとめ
            let array = [...sure, ...res].filter(Boolean);
            // console.log(array);

            //属性追加
            ichiranCheckPointEl(array);
        }

        function ichiranCheckPointEl(array) {
            let madadame = false;
            //属性追加
            for(let el of array) {
                //スレ画か
                if(el.parentElement.parentElement.classList.contains("thre")) {
                    if(el.parentElement.offsetTop == "0") {
                        madadame = true;
                        break; //まだページ位置が決まって無かったら止める
                    }
                    //親のページ位置で設定
                    el.setAttribute("data-y", el.parentElement.offsetTop);
                } else {
                    if(el.closest("table") && el.closest("table").offsetTop == "0") {
                        madadame = true;
                        break; //まだページ位置が決まって無かったら止める
                    }
                    //親タグが画像持ちか
                    if(el.parentElement.querySelector("a > img")) {
                        //いまココボタンの見た画像ラインを「画像が半分以上画面外に出てたら」に
                        //親テーブル位置+そこから画像の位置+画像の半分の高さで設定
                        el.setAttribute("data-y", el.closest("table").offsetTop +
                                        el.closest("tr").offsetTop + el.parentElement.querySelector("a > img").offsetTop +
                                        (el.parentElement.querySelector("a > img").height / 2));
                        // console.log("table：%f\ttbody：%f\ttr：%f\ttd：%f\ta：%f\timg：%f\t画像/2：%f", el.closest("table").offsetTop, el.closest("tbody").offsetTop, el.closest("tr").offsetTop, el.parentElement.offsetTop, el.parentElement.querySelector("a > img").parentElement.offsetTop, el.parentElement.querySelector("a > img").offsetTop, (el.parentElement.querySelector("a > img").height / 2));
                    } else {
                        //こっちはあぷファイルだけの想定
                        //親テーブル位置+そこからタグの位置で設定
                        el.setAttribute("data-y", el.closest("table").offsetTop + el.closest("tr").offsetTop + el.offsetTop);
                    }
                }
                // console.log("数 %d/%d\tdata-y：%s", Number(i) + 1, array.length, el.dataset.y);
                // console.log(el);
            }
            //まだダメならやり直す
            if(madadame) {
                // console.log("タグのページ位置がまだ未設定なのでやり直す");
                setTimeout(() => {
                    ichiranCheckPoint();
                }, 1000);
            }
        }

        function yattaka() {
            //一覧の一枠の高さが未設定なら計算
            if(!aHeight || !aHeightS) calcAheight();

            //一覧リセット用
            const ichiranReset = (event) => {
                console.time("おわり");

                console.log("画像一覧リセット %d:%d:%d ", new Date().getHours(), new Date().getMinutes(), new Date().getSeconds());

                //ブラウザで違うスクロールバー幅を取得
                setScrollbarSize();
                console.log("再取得\nスクロールバー幅\t\t%dpx\n細いスクロールバー幅\t%dpx", scrollbar, thinSb);

                //aタグに付けた属性を消す
                let imgA = document.querySelectorAll(".thre a[data-checked]");
                removeAttr(imgA, "checked");

                //aタグ再収集
                imgA = Array.from(document.querySelectorAll(".thre a > img"), el => el.parentElement).filter(el => !el.closest("blockquote"));
                //属性付け
                addAttr(imgA);

                const videoA = Array.from(document.querySelectorAll(".thre video > a")).filter(el => !el.closest("blockquote"));
                if(videoA.length) addAttrV(videoA);

                //あぷファイルを一覧に含めるか
                if(ADD_UPFILE_LIST) {
                    let resBq = document.querySelectorAll(".thre [data-upf] blockquote");
                    removeAttr(resBq);
                    resBq = document.querySelectorAll(".thre blockquote");
                    //属性付け
                    addAttrUp(resBq);
                }

                //手動で除外したファイルを空にする
                if(USE_EXCLBTN && (exclFiles.size || exclUpFiles.size)) {
                    exclFiles.clear();
                    exclUpFiles.clear();
                    console.log("手動で除外したファイルを忘れた");
                }

                if(SHOW_IMAGE_COUNT) ichiranImageCount("数え直し");
                //画像のページ位置保存し直し
                if(SHOW_KOKOBTN) ichiranCheckPoint();

                //エラーあぷファイル名を収納してるupErrFilesを空にする
                if(upErrFiles.size) {
                    upErrFiles.clear();
                    console.log("エラーあぷファイル名を忘れた");
                }
                //あぷファイルのサムネを忘れる
                if(document.querySelector("upthumb") && document.querySelector("upthumb").children.length) {
                    document.querySelector("upthumb").textContent = "";
                    console.log("あぷファイルのサムネを忘れた");
                }
                if(document.querySelector(".futaba_lightbox_image_list_container > a > span[data-file]")) {
                    for(const el of document.querySelectorAll(".futaba_lightbox_image_list_container > a > span[data-file]")) {
                        el.removeAttribute("data-file");
                    }
                    console.log("実行時のあぷファイルのサムネは覚えない");
                }

                //一覧の一枠の高さ再計算
                calcAheight();

                console.timeEnd("おわり");
            };


            //画像一覧ボタンを追加
            if(SHOW_KOKOBTN) { //いまココボタンを表示するか
                //ボタン枠
                const divEl = document.createElement("div");
                divEl.classList.add("ichiran");

                //画像一覧ボタン
                const divEl2 = document.createElement("div");
                divEl2.classList.add("ichiranopn");
                divEl2.title = `画像一覧を開閉\n右クリで別サイズの一覧を開く\n中クリでリセット`;
                divEl2.textContent = "画像一覧";
                divEl2.addEventListener("click", () => {
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        closeImageListView();
                    } else {
                        if(LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl2.addEventListener("contextmenu", event => {
                    event.preventDefault();
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        smallList = !smallList;
                        showImageListView();
                    } else {
                        if(!LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl2.addEventListener("mousedown", event => {
                    if(event.button === 1) { //中クリック
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });
                divEl2.addEventListener("touchstart", event => {
                    if(event.touches.length >= 2) { //マルチタッチ
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });
                divEl.append(divEl2);

                //いまココボタン
                const divEl3 = document.createElement("div");
                divEl3.classList.add("ichirankoko");
                divEl3.title = "画像一覧を見てる位置から開く\n右クリで別サイズの一覧を開く";
                divEl3.innerHTML = "<span>いま<br>ココ</span>";
                divEl3.addEventListener("click", () => {
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        showImageListView("いまココ");
                    } else {
                        if(LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView("いまココ");
                    }
                });
                divEl3.addEventListener("contextmenu", event => {
                    event.preventDefault();
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        smallList = !smallList;
                        showImageListView("いまココ");
                    } else {
                        if(!LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView("いまココ");
                    }
                });
                divEl.append(divEl3);

                //bodyにコンテナ追加
                document.body.append(divEl);

                if(SHOW_IMAGE_COUNT) ichiranImageCount();
                ichiranCheckPoint();
            } else {
                //画像一覧ボタン
                const divEl = document.createElement("div");
                divEl.classList.add("ichiran");
                divEl.title = `画像一覧を開閉\n右クリで別サイズの一覧を開く\n中クリでリセット`;
                divEl.textContent = "画像一覧";
                divEl.addEventListener("click", () => {
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        closeImageListView();
                    } else {
                        if(LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl.addEventListener("contextmenu", event => {
                    event.preventDefault();
                    if(document.querySelector(".futaba_lightbox_image_list_overlay")) {
                        smallList = !smallList;
                        showImageListView();
                    } else {
                        if(!LIST_SIZE) {
                            smallList = true;
                        } else {
                            smallList = false;
                        }
                        showImageListView();
                    }
                });
                divEl.addEventListener("mousedown", event => {
                    if(event.button === 1) { //中クリック
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });
                divEl.addEventListener("touchstart", event => {
                    if(event.touches.length >= 2) { //マルチタッチ
                        event.preventDefault();
                        ichiranReset(event);
                    }
                });

                //bodyに一覧ボタン追加
                document.body.append(divEl);
                if(SHOW_IMAGE_COUNT) ichiranImageCount();
            }
        }

        //ウインドウサイズが変わったら枠の高さ計算(一覧に表示出来る画像数が変わる)
        window.addEventListener("resize", event => {
            calcAheight();
        });

        //いまココボタンを補助するイベント
        if(SHOW_KOKOBTN) {
            let waitCalcKOKO;
            window.addEventListener("resize", event => {
                clearTimeout(waitCalcKOKO);
                waitCalcKOKO = setTimeout(() => {
                    //いまココボタンを出すのに必要な画像数(一覧にきれいに収まる画像数)
                    //一覧の表示範囲/枠の高さ*1行の画像の数
                    const normalNum = Math.trunc(window.innerHeight * (listHeight / 100) / aHeight) * IMAGE_NUM;
                    //小さい一覧の配置と表示範囲はCSSの値変えてない前提
                    //containerの高さ=overlayの高さ90%=(ウィンドウの高さ-(margin-top分+padding-top分+margin-bottom分))*0.9
                    const smallNum = Math.trunc((window.innerHeight - (30 + parseFloat(getComputedStyle(document.documentElement).fontSize) + 9 + (window.innerHeight * 0.1))) * 0.9 / aHeightS) * IMAGE_NUM_S;
                    if(normalNum <= smallNum) {
                        needImg = normalNum;
                    } else {
                        needImg = smallNum;
                    }
                    // console.log("resizeイベント");
                    ichiranCheckPoint();
                }, 100);
            });
            //ページの高さが変わったら画像の位置再計算
            let waitCalcBodyHeight;
            window.addEventListener("scroll", event => {
                clearTimeout(waitCalcBodyHeight);
                waitCalcBodyHeight = setTimeout(() => {
                    //ページの高さが未設定なら保存
                    if(!bodyHeight) bodyHeight = document.body.scrollHeight;
                    // console.log("ページ記録高さ %s\nページ現在高さ %s", bodyHeight, document.body.scrollHeight);
                    //変わってたら画像の位置を再計算する
                    if(bodyHeight && document.body.scrollHeight !== bodyHeight) {
                        bodyHeight = document.body.scrollHeight;
                        ichiranCheckPoint();
                    }
                }, 100);
            }, {passive: true});
        }
    }
})();

/* 改変ログ
aimgで使えるようざっくり整理
動画を手動で除外した時に画像数が減らないのを修正
スタイルシートの調整とダークモードに対応
スタイルシートの調整と動画レスのリンクを纏めて属性付ける際に保存リンクを巻き込んで止まるのを修正
一覧ボタン初期位置の調整と一覧に追加されるレスでリンク部分を修正
aimgが改名したのでスクリプト名の変更
*/