(() => {
    function isUploadMessage(json) {
        return json.type == "upload";
    }
    function isDownloadHtmlMessage(json) {
        return json.type == "downloadHtml";
    }
    var Background = {
        addMessageListeners(listeners) {
            chrome.runtime.onMessage.addListener((message, _, sendMessage) => {
                if (isUploadMessage(message)) {
                    listeners.uploadData(message.origin, message.value).then((responseHtml) => sendMessage(responseHtml));
                }
                else if (isDownloadHtmlMessage(message)) {
                    listeners.downloadHtml(message.origin).then((html) => sendMessage(html));
                }
                return true;
            });
        }
    };
    async function uploadData(data, origin) {
        const formData = new FormData();
        const file = new File([new Uint8Array(data.file)], "tegaki.png");
        const comment = data.comment;
        const pass = data.pass;
        formData.append("MAX_FILE_SIZE", "3000000");
        formData.append("mode", "reg");
        formData.append("up", file);
        formData.append("com", comment);
        formData.append("pass", pass);
        await fetch(`${origin}/up2/up.php`, {
            method: "POST",
            body: formData
        });
    }
    function downloadHtml(origin) {
        return fetch(`${origin}/up2/up.htm`).then((res) => res.text());
    }
    async function run() {
        console.log("Me-Boy Background");
        Background.addMessageListeners({
            uploadData: (origin, data) => uploadData(data, origin),
            downloadHtml: (origin) => downloadHtml(origin)
        });
    }
    run();
})();
